/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.util;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.util.ParsedScheduleExpression;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParserException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.TimeZone;
import javax.ejb.ScheduleExpression;

public class ScheduleExpressionParser {
    private static final TraceComponent tc = Tr.register(ScheduleExpressionParser.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    static final String[] DAYS_OF_WEEK = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] WEEKS_OF_MONTH = new String[]{"1st", "2nd", "3rd", "4th", "5th", "Last"};
    static final int LAST_WEEK_OF_MONTH = 5;
    private static final int ENCODED_WILD_CARD = -1;
    static final int ENCODED_NTH_LAST_DAY_OF_MONTH = 32;
    static final int ENCODED_NTH_DAY_OF_WEEK_IN_MONTH = 40;
    static final int MINIMUM_YEAR = 1000;
    static final int MAXIMUM_YEAR = 9999;
    private Attribute ivAttr;
    private String ivString;
    private int ivPos;

    private ScheduleExpressionParser() {
    }

    public static String toString(ScheduleExpression expr) {
        return Util.identity((Object)expr) + "[start=" + ScheduleExpressionParser.toString(expr.getStart()) + ", end=" + ScheduleExpressionParser.toString(expr.getEnd()) + ", timezone=" + expr.getTimezone() + ", seconds=" + (expr.getSecond() == null ? null : "\"" + expr.getSecond() + "\"") + ", minutes=" + (expr.getMinute() == null ? null : "\"" + expr.getMinute() + "\"") + ", hours=" + (expr.getHour() == null ? null : "\"" + expr.getHour() + "\"") + ", dayOfMonth=" + (expr.getDayOfMonth() == null ? null : "\"" + expr.getDayOfMonth() + "\"") + ", month=" + (expr.getMonth() == null ? null : "\"" + expr.getMonth() + "\"") + ", dayOfWeek=" + (expr.getDayOfWeek() == null ? null : "\"" + expr.getDayOfWeek() + "\"") + ", year=" + (expr.getYear() == null ? null : "\"" + expr.getYear() + "\"") + "]";
    }

    private static String toString(Date date) {
        if (date == null) {
            return null;
        }
        long millis = date.getTime();
        if (millis <= 0L || millis % 1000L == 0L) {
            return date.toString();
        }
        return date + " (" + millis % 1000L + "ms)";
    }

    public static ParsedScheduleExpression parse(ScheduleExpression expr) {
        ParsedScheduleExpression parsedExpr = new ParsedScheduleExpression(expr);
        ScheduleExpressionParser.parse(parsedExpr);
        return parsedExpr;
    }

    static void parse(ParsedScheduleExpression parsedExpr) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("parse: " + ScheduleExpressionParser.toString(parsedExpr.getSchedule())), (Object[])new Object[0]);
        }
        ScheduleExpression expr = parsedExpr.getSchedule();
        ScheduleExpressionParser parser = new ScheduleExpressionParser();
        try {
            parser.parseTimeZone(parsedExpr, expr.getTimezone());
            parser.parseAttribute(parsedExpr, Attribute.SECOND, expr.getSecond());
            parser.parseAttribute(parsedExpr, Attribute.MINUTE, expr.getMinute());
            parser.parseAttribute(parsedExpr, Attribute.HOUR, expr.getHour());
            parser.parseAttribute(parsedExpr, Attribute.DAY_OF_MONTH, expr.getDayOfMonth());
            parser.parseAttribute(parsedExpr, Attribute.MONTH, expr.getMonth());
            parser.parseAttribute(parsedExpr, Attribute.DAY_OF_WEEK, expr.getDayOfWeek());
            parser.parseAttribute(parsedExpr, Attribute.YEAR, expr.getYear());
        }
        catch (IllegalArgumentException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parse", (Object)ex);
            }
            throw ex;
        }
        parsedExpr.start = parser.parseDate(expr.getStart(), 0L);
        parsedExpr.end = parser.parseDate(expr.getEnd(), Long.MAX_VALUE);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parse", (Object)parsedExpr);
        }
    }

    private void parseTimeZone(ParsedScheduleExpression parsedExpr, String string) {
        if (parsedExpr.timeZone == null) {
            if (string == null) {
                parsedExpr.timeZone = TimeZone.getDefault();
            } else {
                parsedExpr.timeZone = TimeZone.getTimeZone(string.trim());
                if (parsedExpr.timeZone.getID().equals("GMT") && !string.equalsIgnoreCase("GMT")) {
                    throw new ScheduleExpressionParserException(ScheduleExpressionParserException.Error.VALUE, "timezone", string);
                }
            }
        }
    }

    private long parseDate(Date date, long defaultValue) {
        long remainder;
        if (date == null) {
            return defaultValue;
        }
        long value = date.getTime();
        if (value > 0L && (remainder = value % 1000L) != 0L) {
            long newValue = value - remainder + 1000L;
            value = newValue > 0L || value < 0L ? newValue : Long.MAX_VALUE;
        }
        return value;
    }

    private void error(ScheduleExpressionParserException.Error error) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parse error in " + (Object)((Object)this.ivAttr) + " at " + this.ivPos), (Object[])new Object[0]);
        }
        throw new ScheduleExpressionParserException(error, this.ivAttr.getDisplayName(), this.ivString);
    }

    private void parseAttribute(ParsedScheduleExpression parsedExpr, Attribute attr, String string) {
        this.ivAttr = attr;
        this.ivString = string;
        this.ivPos = 0;
        if (string == null) {
            this.error(ScheduleExpressionParserException.Error.VALUE);
        }
        boolean inList = false;
        while (true) {
            this.skipWhitespace();
            int value = this.readSingleValue();
            this.skipWhitespace();
            if (this.ivPos < this.ivString.length() && this.ivString.charAt(this.ivPos) == '-') {
                ++this.ivPos;
                this.skipWhitespace();
                int maxValue = this.readSingleValue();
                this.skipWhitespace();
                if (value == -1 || maxValue == -1) {
                    this.error(ScheduleExpressionParserException.Error.RANGE_BOUND);
                }
                attr.addRange(parsedExpr, value, maxValue);
            } else {
                if (this.ivPos < this.ivString.length() && this.ivString.charAt(this.ivPos) == '/') {
                    ++this.ivPos;
                    this.skipWhitespace();
                    int interval = this.readSingleValue();
                    this.skipWhitespace();
                    if (interval == -1) {
                        this.error(ScheduleExpressionParserException.Error.INCREMENT_INTERVAL);
                    }
                    if (inList) {
                        this.error(ScheduleExpressionParserException.Error.LIST_VALUE);
                    }
                    if (!this.ivAttr.isIncrementable()) {
                        this.error(ScheduleExpressionParserException.Error.UNINCREMENTABLE);
                    }
                    if (value == -1) {
                        value = 0;
                    }
                    if (interval == 0) {
                        attr.add(parsedExpr, value);
                        break;
                    }
                    while (value <= this.ivAttr.getMax()) {
                        attr.add(parsedExpr, value);
                        value += interval;
                    }
                    break;
                }
                if (value == -1) {
                    if (inList) {
                        this.error(ScheduleExpressionParserException.Error.LIST_VALUE);
                    }
                    attr.setWildCard(parsedExpr);
                    break;
                }
                attr.add(parsedExpr, value);
            }
            if (this.ivPos >= this.ivString.length() || this.ivString.charAt(this.ivPos) != ',') break;
            ++this.ivPos;
            inList = true;
        }
        this.skipWhitespace();
        if (this.ivPos < this.ivString.length()) {
            this.error(ScheduleExpressionParserException.Error.VALUE);
        }
    }

    private void skipWhitespace() {
        while (this.ivPos < this.ivString.length() && Character.isWhitespace(this.ivString.charAt(this.ivPos))) {
            ++this.ivPos;
        }
    }

    private int readSingleValue() {
        int result;
        if (this.ivPos < this.ivString.length() && this.ivString.charAt(this.ivPos) == '*') {
            ++this.ivPos;
            return -1;
        }
        int begin = this.scanToken();
        String[] namedValues = this.ivAttr.getNamedValues();
        int n = result = namedValues == null ? -1 : this.findNamedValue(begin, namedValues, this.ivAttr.getMin());
        if (result == -1) {
            try {
                result = Integer.valueOf(this.ivString.substring(begin, this.ivPos));
            }
            catch (NumberFormatException ex) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"parse failed", (Object[])new Object[]{ex});
                }
                this.error(ScheduleExpressionParserException.Error.VALUE);
            }
            if (this.ivAttr == Attribute.DAY_OF_MONTH && result >= -7 && result <= -1) {
                result = 32 + -result;
            } else if (result < this.ivAttr.getMin() || result > this.ivAttr.getMax()) {
                this.error(ScheduleExpressionParserException.Error.VALUE_RANGE);
            }
        } else if (this.ivAttr == Attribute.DAY_OF_MONTH) {
            int weekOfMonth = result - this.ivAttr.getMin();
            this.skipWhitespace();
            int savedPos = this.ivPos;
            int dayOfWeek = this.findNamedValue(this.scanToken(), DAYS_OF_WEEK, 0);
            if (dayOfWeek == -1) {
                if (weekOfMonth != 5) {
                    this.error(ScheduleExpressionParserException.Error.MISSING_DAY_OF_WEEK);
                }
                this.ivPos = savedPos;
                result = 32;
            } else {
                result = 40 + weekOfMonth * 7 + dayOfWeek;
            }
        }
        return result;
    }

    private int scanToken() {
        int begin = this.ivPos;
        if (this.ivPos < this.ivString.length()) {
            if (this.ivString.charAt(this.ivPos) == '-') {
                ++this.ivPos;
            }
            while (this.ivPos < this.ivString.length() && this.isTokenChar(this.ivString.charAt(this.ivPos))) {
                ++this.ivPos;
            }
        }
        return begin;
    }

    private boolean isTokenChar(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private int findNamedValue(int begin, String[] namedValues, int min) {
        int length = this.ivPos - begin;
        for (int i = 0; i < namedValues.length; ++i) {
            String namedValue = namedValues[i];
            if (length != namedValue.length() || !this.ivString.regionMatches(true, begin, namedValue, 0, length)) continue;
            return min + i;
        }
        return -1;
    }

    private static enum Attribute {
        SECOND("second", true, 0, 59){

            @Override
            void add(ParsedScheduleExpression parsedExpr, int value) {
                parsedExpr.seconds = 1.addBit(parsedExpr.seconds, value);
            }

            @Override
            void addRangeImpl(ParsedScheduleExpression parsedExpr, int min, int max) {
                parsedExpr.seconds = 1.addBits(parsedExpr.seconds, min, max);
            }

            @Override
            void setWildCard(ParsedScheduleExpression parsedExpr) {
                parsedExpr.seconds = 0L;
            }
        }
        ,
        MINUTE("minute", true, 0, 59){

            @Override
            void add(ParsedScheduleExpression parsedExpr, int value) {
                parsedExpr.minutes = 2.addBit(parsedExpr.minutes, value);
            }

            @Override
            void addRangeImpl(ParsedScheduleExpression parsedExpr, int min, int max) {
                parsedExpr.minutes = 2.addBits(parsedExpr.minutes, min, max);
            }

            @Override
            void setWildCard(ParsedScheduleExpression parsedExpr) {
                parsedExpr.minutes = 0L;
            }
        }
        ,
        HOUR("hour", true, 0, 23){

            @Override
            void add(ParsedScheduleExpression parsedExpr, int value) {
                parsedExpr.hours = 3.addBit(parsedExpr.hours, value);
            }

            @Override
            void addRangeImpl(ParsedScheduleExpression parsedExpr, int min, int max) {
                parsedExpr.hours = 3.addBits(parsedExpr.hours, min, max);
            }

            @Override
            void setWildCard(ParsedScheduleExpression parsedExpr) {
                parsedExpr.hours = 0;
            }
        }
        ,
        DAY_OF_MONTH("dayOfMonth", false, 1, 31, WEEKS_OF_MONTH){

            @Override
            void add(ParsedScheduleExpression parsedExpr, int value) {
                if (value < 32) {
                    parsedExpr.daysOfMonth = 4.addBit(parsedExpr.daysOfMonth, value - 1);
                } else if (value < 40) {
                    parsedExpr.lastDaysOfMonth = 4.addBit(parsedExpr.lastDaysOfMonth, 7 - (value - 32));
                } else {
                    int encoded = value - 40;
                    int weekOfMonth = encoded / 7;
                    int dayOfWeek = encoded % 7;
                    if (weekOfMonth == 5) {
                        parsedExpr.lastDaysOfWeekInMonth = 4.addBit(parsedExpr.lastDaysOfWeekInMonth, dayOfWeek);
                    } else {
                        parsedExpr.daysOfWeekInMonth = 4.addBit(parsedExpr.daysOfWeekInMonth, weekOfMonth * 7 + dayOfWeek);
                    }
                }
            }

            @Override
            void addRange(ParsedScheduleExpression parsedExpr, int min, int max) {
                if (min == max) {
                    this.add(parsedExpr, min);
                } else if (min < 32 && max < 32) {
                    super.addRange(parsedExpr, min, max);
                } else {
                    if (parsedExpr.variableDayOfMonthRanges == null) {
                        parsedExpr.variableDayOfMonthRanges = new ArrayList<ParsedScheduleExpression.VariableDayOfMonthRange>();
                    }
                    parsedExpr.variableDayOfMonthRanges.add(new ParsedScheduleExpression.VariableDayOfMonthRange(min, max));
                }
            }

            @Override
            void addRangeImpl(ParsedScheduleExpression parsedExpr, int min, int max) {
                parsedExpr.daysOfMonth = 4.addBits(parsedExpr.daysOfMonth, min - 1, max - 1);
            }

            @Override
            void setWildCard(ParsedScheduleExpression parsedExpr) {
                parsedExpr.daysOfMonth = 0;
            }
        }
        ,
        MONTH("month", false, 1, 12, MONTHS){

            @Override
            void add(ParsedScheduleExpression parsedExpr, int value) {
                parsedExpr.months = 5.addBit(parsedExpr.months, value - 1);
            }

            @Override
            void addRangeImpl(ParsedScheduleExpression parsedExpr, int min, int max) {
                parsedExpr.months = 5.addBits(parsedExpr.months, min - 1, max - 1);
            }

            @Override
            void setWildCard(ParsedScheduleExpression parsedExpr) {
                parsedExpr.months = 0;
            }
        }
        ,
        DAY_OF_WEEK("dayOfWeek", false, 0, 7, DAYS_OF_WEEK){

            @Override
            void add(ParsedScheduleExpression parsedExpr, int value) {
                parsedExpr.daysOfWeek = 6.addBit(parsedExpr.daysOfWeek, value == 7 ? 0 : value);
            }

            @Override
            void addRange(ParsedScheduleExpression parsedExpr, int min, int max) {
                if (min == 7) {
                    if (max == 7) {
                        this.add(parsedExpr, 0);
                    } else {
                        this.addRangeImpl(parsedExpr, 0, max);
                    }
                } else if (max == 7) {
                    if (min == 0) {
                        this.setWildCard(parsedExpr);
                    } else {
                        this.add(parsedExpr, 0);
                        this.addRangeImpl(parsedExpr, min, 6);
                    }
                } else if (min > max) {
                    this.addRangeImpl(parsedExpr, min, 6);
                    this.addRangeImpl(parsedExpr, 0, max);
                } else {
                    this.addRangeImpl(parsedExpr, min, max);
                }
            }

            @Override
            void addRangeImpl(ParsedScheduleExpression parsedExpr, int min, int max) {
                parsedExpr.daysOfWeek = 6.addBits(parsedExpr.daysOfWeek, min, max);
            }

            @Override
            void setWildCard(ParsedScheduleExpression parsedExpr) {
                parsedExpr.daysOfWeek = 0;
            }
        }
        ,
        YEAR("year", false, 1000, 9999){

            @Override
            void add(ParsedScheduleExpression parsedExpr, int value) {
                this.updateYears(parsedExpr).set(value - 1000);
            }

            @Override
            void addRangeImpl(ParsedScheduleExpression parsedExpr, int min, int max) {
                this.updateYears(parsedExpr).set(min - 1000, max + 1 - 1000);
            }

            private BitSet updateYears(ParsedScheduleExpression parsedExpr) {
                if (parsedExpr.years == null) {
                    parsedExpr.years = new BitSet();
                }
                return parsedExpr.years;
            }

            @Override
            void setWildCard(ParsedScheduleExpression parsedExpr) {
                parsedExpr.years = null;
            }
        };

        private String ivDisplayName;
        private boolean ivIncrementable;
        private int ivMin;
        private int ivMax;
        private String[] ivNamedValues;

        private Attribute(String displayName, boolean incrementable, int min, int max, String[] namedValues) {
            this.ivDisplayName = displayName;
            this.ivIncrementable = incrementable;
            this.ivMin = min;
            this.ivMax = max;
            this.ivNamedValues = namedValues;
        }

        private Attribute(String displayName, boolean incrementable, int min, int max) {
            this(displayName, incrementable, min, max, (String[])null);
        }

        String getDisplayName() {
            return this.ivDisplayName;
        }

        boolean isIncrementable() {
            return this.ivIncrementable;
        }

        int getMin() {
            return this.ivMin;
        }

        int getMax() {
            return this.ivMax;
        }

        String[] getNamedValues() {
            return this.ivNamedValues;
        }

        abstract void add(ParsedScheduleExpression var1, int var2);

        void addRange(ParsedScheduleExpression parsedExpr, int min, int max) {
            if (min > max) {
                this.addRangeImpl(parsedExpr, this.getMin(), max);
                this.addRangeImpl(parsedExpr, min, this.getMax());
            } else {
                this.addRangeImpl(parsedExpr, min, max);
            }
        }

        abstract void addRangeImpl(ParsedScheduleExpression var1, int var2, int var3);

        abstract void setWildCard(ParsedScheduleExpression var1);

        static final int addBit(int bitmask, int value) {
            return (int)Attribute.addBit((long)bitmask, value);
        }

        static final int addBits(int bitmask, int min, int max) {
            return (int)(Attribute.addBits((long)bitmask, min, max) & Integer.MAX_VALUE);
        }

        static final long addBit(long bitmask, int value) {
            return bitmask | 1L << value;
        }

        static final long addBits(long bitmask, int min, int max) {
            long bits = (1L << max + 1) - 1L;
            if (min != 0) {
                bits &= (1L << min) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return bitmask | bits;
        }
    }
}

