/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.runtime;

import com.ibm.ejs.container.BMStatefulBeanOFactory;
import com.ibm.ejs.container.BMStatelessBeanOFactory;
import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.BeanOFactory;
import com.ibm.ejs.container.CMStatefulBeanOFactory;
import com.ibm.ejs.container.CMStatelessBeanOFactory;
import com.ibm.ejs.container.ContainerConfig;
import com.ibm.ejs.container.ContainerEJBException;
import com.ibm.ejs.container.ContainerException;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.HomeOfHomes;
import com.ibm.ejs.container.HomeRecord;
import com.ibm.ejs.container.ManagedBeanOFactory;
import com.ibm.ejs.container.SingletonBeanOFactory;
import com.ibm.ejs.container.TimerNpImpl;
import com.ibm.ejs.container.WrapperManager;
import com.ibm.ejs.container.activator.ActivationStrategy;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.activator.StatefulActivateOnceActivationStrategy;
import com.ibm.ejs.container.activator.StatefulActivateTranActivationStrategy;
import com.ibm.ejs.container.activator.UncachedActivationStrategy;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.csi.EJBApplicationMetaData;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.ejs.csi.UOWControl;
import com.ibm.ejs.csi.UOWHandle;
import com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.SweepLruEvictionStrategy;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.ContainerExtensionFactory;
import com.ibm.websphere.csi.EJBContainerException;
import com.ibm.websphere.csi.EJBModuleConfigData;
import com.ibm.websphere.csi.HomeWrapperSet;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.csi.PassivationPolicy;
import com.ibm.websphere.csi.StatefulSessionKeyFactory;
import com.ibm.websphere.ejbcontainer.EJBContextExtension;
import com.ibm.websphere.ejbcontainer.MessageDrivenContextExtension;
import com.ibm.websphere.ejbcontainer.SessionContextExtension;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.EJBPMICollaboratorFactory;
import com.ibm.ws.ejbcontainer.EJBRequestCollaborator;
import com.ibm.ws.ejbcontainer.EJBSecurityCollaborator;
import com.ibm.ws.ejbcontainer.failover.SfFailoverCache;
import com.ibm.ws.ejbcontainer.injection.factory.EJBContextObjectFactory;
import com.ibm.ws.ejbcontainer.injection.factory.MBLinkReferenceFactoryImpl;
import com.ibm.ws.ejbcontainer.injection.factory.TimerServiceObjectFactory;
import com.ibm.ws.ejbcontainer.runtime.ComponentNameSpaceConfigurationProviderImpl;
import com.ibm.ws.ejbcontainer.runtime.EJBRuntime;
import com.ibm.ws.ejbcontainer.runtime.EJBRuntimeConfig;
import com.ibm.ws.ejbcontainer.runtime.NameSpaceBinder;
import com.ibm.ws.ejbcontainer.util.ParsedScheduleExpression;
import com.ibm.ws.ejbcontainer.util.PoolManager;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParser;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParserException;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ejb.AutomaticTimerBean;
import com.ibm.ws.metadata.ejb.BeanInitData;
import com.ibm.ws.metadata.ejb.EJBMDOrchestrator;
import com.ibm.ws.metadata.ejb.ModuleInitData;
import com.ibm.ws.metadata.ejb.TimerMethodData;
import com.ibm.ws.metadata.ejb.WCCMMetaDataUtil;
import com.ibm.ws.uow.embeddable.SynchronizationRegistryUOWScope;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.ejbcontainer.WSEJBHandlerResolver;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfigurationProvider;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionMetaData;
import com.ibm.wsspi.injectionengine.InjectionMetaDataListener;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import com.ibm.wsspi.injectionengine.factory.MBLinkReferenceFactory;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Resource;
import javax.ejb.CreateException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.MessageDrivenContext;
import javax.ejb.ScheduleExpression;
import javax.ejb.SessionContext;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.UserTransaction;

public abstract class AbstractEJBRuntime
implements EJBRuntime,
InjectionMetaDataListener {
    private static final String CLASS_NAME = AbstractEJBRuntime.class.getName();
    private static TraceComponent tc = Tr.register(AbstractEJBRuntime.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final ThreadContextAccessor svThreadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    protected EJSContainer ivContainer;
    protected boolean ivInitAtStartup;
    private boolean ivInitAtStartupSet;
    private String ivDefaultDataSourceJNDIName;
    private UOWControl ivUOWControl;
    protected SfFailoverCache ivSfFailoverCache;
    protected EJBMDOrchestrator ivEJBMDOrchestrator;
    private volatile WSEJBHandlerResolver ivWebServicesHandlerResolver = null;
    private BeanOFactory ivCMStatelessBeanOFactory;
    private BeanOFactory ivBMStatelessBeanOFactory;
    private BeanOFactory ivCMStatefulBeanOFactory;
    private BeanOFactory ivBMStatefulBeanOFactory;
    private BeanOFactory ivSingletonBeanOFactory;
    private BeanOFactory ivManagedBeanOFactory;

    public abstract boolean isStopping();

    protected abstract EJBModuleConfigData createEJBModuleConfigData(ModuleInitData var1);

    protected abstract NameSpaceBinder<?> createNameSpaceBinder(EJBModuleMetaDataImpl var1);

    protected abstract void initializeTimerService(boolean var1) throws EJBContainerException, ContainerException;

    protected abstract void registerMBeans(ModuleInitData var1, EJBModuleMetaDataImpl var2);

    protected abstract void deregisterMBeans(EJBModuleMetaDataImpl var1);

    protected abstract void startMDBs(ModuleInitData var1, EJBModuleMetaDataImpl var2) throws RuntimeWarning;

    protected abstract boolean isReferenceProcessingNeededAtStart(BeanMetaData var1) throws RuntimeWarning;

    protected abstract void fireMetaDataCreated(EJBModuleMetaDataImpl var1) throws RuntimeWarning;

    protected abstract void fireMetaDataCreated(BeanMetaData var1) throws RuntimeWarning;

    protected abstract void fireMetaDataDestroyed(BeanMetaData var1) throws RuntimeWarning;

    protected abstract UserTransaction getUserTransaction();

    protected AbstractEJBRuntime() {
    }

    public void start(EJBRuntimeConfig config) throws CSIException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object[])new Object[0]);
        }
        this.ivContainer = config.getContainer();
        this.ivEJBMDOrchestrator = config.getEJBMDOrchestrator();
        String ias = ContainerProperties.InitializeEJBsAtStartup;
        if (ias != null) {
            this.ivInitAtStartupSet = true;
            this.ivInitAtStartup = ias.equalsIgnoreCase("true");
        } else {
            this.ivInitAtStartupSet = false;
            this.ivInitAtStartup = this.isCheckpointApplications() || this.isCheckpointDeployment();
        }
        ContainerExtensionFactory cef = config.getContainerExtensionFactory();
        this.ivUOWControl = cef.getUOWControl(this.getUserTransaction());
        EJBSecurityCollaborator<?> securityCollaborator = config.getSecurityCollaborator();
        StatefulPassivator statefulPassivator = config.getStatefulPassivator();
        EJBPMICollaboratorFactory pmiFactory = config.getPmiBeanFactory();
        PassivationPolicy passivationpolicy = config.getPassivationPolicy();
        this.ivSfFailoverCache = config.getSfFailoverCache();
        this.ivDefaultDataSourceJNDIName = config.getDefaultDataSourceJNDIName();
        long cacheSize = config.getCacheSize();
        long cacheSweepInterval = config.getCacheSweepInterval();
        ScheduledExecutorService ivScheduledExecutorService = this.getScheduledExecutorService();
        ScheduledExecutorService deferrableScheduledExecutorService = this.getDeferrableScheduledExecutorService();
        PoolManager poolMgr = PoolManager.newInstance();
        poolMgr.setDrainInterval(config.getInactivePoolCleanupInterval());
        poolMgr.setScheduledExecutorService(ivScheduledExecutorService);
        Cache ejbCache = new Cache("EJB Cache", cacheSize, false);
        BackgroundLruEvictionStrategy evictor = new BackgroundLruEvictionStrategy(ejbCache, (int)cacheSize, cacheSweepInterval, ivScheduledExecutorService, deferrableScheduledExecutorService);
        ejbCache.setEvictionStrategy(evictor);
        evictor.start();
        Cache wrapperCache = new Cache("Wrapper Cache", 2L * cacheSize, true);
        SweepLruEvictionStrategy wrapperEvictor = new SweepLruEvictionStrategy(wrapperCache, (int)(2L * cacheSize), 3L * cacheSweepInterval, ivScheduledExecutorService, deferrableScheduledExecutorService);
        wrapperCache.setEvictionStrategy(wrapperEvictor);
        wrapperEvictor.start();
        WrapperManager wrapperManager = config.getWrapperManager();
        wrapperManager.initialize(wrapperCache);
        EJBRequestCollaborator<?>[] afterActivationCollaborators = config.getAfterActivationCollaborators();
        EJBRequestCollaborator<?>[] beforeActivationCollaborators = config.getBeforeActivationCollaborators();
        EJBRequestCollaborator<?>[] beforeActivationAfterCompletionCollaborators = config.getBeforeActivationAfterCompletionCollaborators();
        J2EENameFactory j2eeNameFactory = config.getJ2EENameFactory();
        StatefulSessionKeyFactory sessionKeyFactory = config.getStatefulSessionKeyFactory();
        this.ivWebServicesHandlerResolver = config.getWSEJBHandlerResolver();
        ContainerConfig containerConfig = new ContainerConfig(this, null, config.getName(), ejbCache, wrapperManager, passivationpolicy, config.getPersisterFactory(), config.getEntityHelper(), pmiFactory, securityCollaborator, statefulPassivator, sessionKeyFactory, config.getStatefulSessionHandleFactory(), poolMgr, j2eeNameFactory, config.getObjectCopier(), config.getOrbUtils(), this.ivUOWControl, afterActivationCollaborators, beforeActivationCollaborators, beforeActivationAfterCompletionCollaborators, cef, config.getStatefulBeanEnqDeq(), config.getDispatchEventListenerManager(), this.ivSfFailoverCache, config.isSFSBFailoverEnabled());
        this.ivContainer.initialize(containerConfig);
        InjectionEngine injectionEngine = this.getInjectionEngine();
        try {
            injectionEngine.registerObjectFactory(Resource.class, EntityContext.class, EJBContextObjectFactory.class, false, null, false);
            injectionEngine.registerObjectFactory(Resource.class, EJBContext.class, EJBContextObjectFactory.class, false, null, false);
            injectionEngine.registerObjectFactory(Resource.class, EJBContextExtension.class, EJBContextObjectFactory.class, false, null, false);
            injectionEngine.registerObjectFactory(Resource.class, SessionContext.class, EJBContextObjectFactory.class, false, null, false);
            injectionEngine.registerObjectFactory(Resource.class, SessionContextExtension.class, EJBContextObjectFactory.class, false, null, false);
            injectionEngine.registerObjectFactory(Resource.class, MessageDrivenContext.class, EJBContextObjectFactory.class, false, null, false);
            injectionEngine.registerObjectFactory(Resource.class, MessageDrivenContextExtension.class, EJBContextObjectFactory.class, false, null, false);
            injectionEngine.registerObjectFactory(Resource.class, TimerService.class, TimerServiceObjectFactory.class, false, null, false);
        }
        catch (InjectionException ex) {
            throw new CSIException("Failed to register injection engine object factories", ex);
        }
        injectionEngine.registerInjectionMetaDataListener((InjectionMetaDataListener)this);
        injectionEngine.registerManagedBeanReferenceFactory((MBLinkReferenceFactory)new MBLinkReferenceFactoryImpl());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (this.ivContainer != null) {
            this.ivContainer.terminate();
        }
    }

    protected void updateStartEjbsAtAppStart(Boolean startEjbsAtAppStart) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateStartEjbsAtAppStart : " + (ContainerProperties.InitializeEJBsAtStartup == null ? "Update : " : "Ignore : ") + startEjbsAtAppStart), (Object[])new Object[0]);
        }
        if (ContainerProperties.InitializeEJBsAtStartup == null) {
            if (startEjbsAtAppStart != null) {
                this.ivInitAtStartupSet = true;
                this.ivInitAtStartup = startEjbsAtAppStart;
            } else {
                this.ivInitAtStartupSet = false;
                this.ivInitAtStartup = this.isCheckpointApplications() || this.isCheckpointDeployment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startModule(EJBModuleMetaDataImpl mmd) throws RuntimeError {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startModule", (Object[])new Object[]{mmd.getJ2EEName()});
        }
        String jarName = null;
        String appJarName = null;
        RuntimeError error = null;
        Object origCL = ThreadContextAccessor.UNCHANGED;
        NameSpaceBinder<?> binder = null;
        boolean postInvokeNeeded = false;
        try {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Fire Module Metadata created event to listeners for module: " + mmd.getJ2EEName()), (Object[])new Object[0]);
            }
            mmd.ivMetaDataDestroyRequired = true;
            this.fireMetaDataCreated(mmd);
            ModuleInitData mid = mmd.ivInitData;
            mmd.ivInitData = null;
            jarName = mmd.getName();
            EJBModuleConfigData moduleConfig = this.createEJBModuleConfigData(mid);
            this.preInvokeStartModule(mmd, moduleConfig);
            postInvokeNeeded = true;
            if (mid.ivHasTimers == null) {
                this.initializeTimerService(true);
            } else if (mid.ivHasTimers.booleanValue()) {
                this.initializeTimerService(false);
            }
            binder = this.createNameSpaceBinder(mmd);
            binder.beginBind();
            boolean hasEJB = false;
            for (BeanInitData beanInitData : mid.ivBeans) {
                BeanMetaData bmd = mmd.ivBeanMetaDatas.get(beanInitData.ivName);
                if (bmd == null) {
                    bmd = this.createBeanMetaData(beanInitData, mmd);
                }
                hasEJB |= bmd.type != 8;
                if (!bmd.isSingletonSessionBean()) continue;
                mmd.getEJBApplicationMetaData().addSingleton(bmd, beanInitData.ivStartup, beanInitData.ivDependsOn);
            }
            if (!hasEJB && !mmd.ivManagedBeansOnly) {
                Tr.error((TraceComponent)tc, (String)"NO_BEANS_IN_MODULE_CNTR9269W", (Object[])new Object[]{jarName});
                throw new EJBConfigurationException("The " + jarName + " Enterprise JavaBeans (EJB) module does not have any enterprise beans configured.");
            }
            WCCMMetaDataUtil.validateMergedXML(mid);
            this.ivEJBMDOrchestrator.processEJBJarBindings(mid, mmd);
            Collection<BeanMetaData> bmds = mmd.ivBeanMetaDatas.values();
            for (BeanMetaData bmd : bmds) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    bmd.dump();
                }
                WCCMMetaDataUtil.validateMergedXML(bmd);
                this.beanInstall(bmd);
                if (bmd.fullyInitialized) continue;
                this.initializeBMD(bmd);
            }
            origCL = svThreadContextAccessor.pushContextClassLoader(mid.getContextClassLoader());
            for (BeanMetaData bmd : bmds) {
                if (bmd.ivDeferEJBInitialization) continue;
                this.fireMetaDataCreatedAndStartBean(bmd);
            }
            for (BeanMetaData bmd : bmds) {
                this.addHome(bmd);
                if (bmd.type == 7) continue;
                try {
                    this.bindInterfaces(binder, bmd);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".install"), (String)"950", (Object)this);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"startModule: exception", (Object[])new Object[]{e});
                    }
                    error = new RuntimeError((Throwable)e);
                }
            }
            if (error == null) {
                binder.bindEJBFactory();
                this.startMDBs(mid, mmd);
                if (mmd.ivAutomaticTimerBeans != null) {
                    if (!EJSPlatformHelper.isZOSCRA()) {
                        int n;
                        boolean bl = false;
                        int numNonPersistentCreated = 0;
                        if (mmd.ivHasNonPersistentAutomaticTimers) {
                            numNonPersistentCreated = this.createNonPersistentAutomaticTimers(mmd.ivJ2EEName.getApplication(), mmd.getName(), mmd.ivAutomaticTimerBeans);
                        }
                        if (mmd.ivHasPersistentAutomaticTimers) {
                            n = this.createPersistentAutomaticTimers(mmd.ivJ2EEName.getApplication(), mmd.getName(), mmd.ivAutomaticTimerBeans);
                        }
                        Tr.info((TraceComponent)tc, (String)"AUTOMATIC_TIMER_CREATION_CNTR0219I", (Object[])new Object[]{n, numNonPersistentCreated, mmd.getName()});
                    }
                    mmd.ivAutomaticTimerBeans = null;
                }
                if (!mmd.ivManagedBeansOnly) {
                    this.registerMBeans(mid, mmd);
                }
            }
            this.ivEJBMDOrchestrator.processGeneralizations(moduleConfig, mmd);
            postInvokeNeeded = false;
            this.postInvokeStartModule(mmd, appJarName);
            mid.unload();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".install"), (String)"982", (Object)this);
            error = new RuntimeError(t);
        }
        finally {
            block51: {
                if (postInvokeNeeded) {
                    try {
                        this.postInvokeStartModule(mmd, appJarName);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".startModule"), (String)"761", (Object)this);
                    }
                }
                if (binder != null) {
                    try {
                        binder.end();
                    }
                    catch (Throwable t) {
                        if (error != null) break block51;
                        error = new RuntimeError(t);
                    }
                }
            }
            svThreadContextAccessor.popContextClassLoader(origCL);
            if (error != null) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("startModule: " + error), (Object[])new Object[0]);
                }
                try {
                    mmd.getEJBApplicationMetaData().stoppingModule(mmd);
                    this.uninstall(mmd, true);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".startModule"), (String)"980", (Object)this);
                }
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("startModule: " + error));
                }
                throw error;
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startModule");
            }
        }
    }

    protected void preInvokeStartModule(EJBModuleMetaDataImpl mmd, EJBModuleConfigData moduleConfig) {
    }

    protected void postInvokeStartModule(EJBModuleMetaDataImpl mmd, String appJarName) {
    }

    protected void beanInstall(BeanMetaData bmd) throws RemoteException {
    }

    public void stopModule(EJBModuleMetaDataImpl mmd) {
        try {
            this.uninstall(mmd, false);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".stop"), (String)"3059", (Object)this);
            throw new ContainerEJBException("Failed to stop - caught Throwable", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstall(EJBModuleMetaDataImpl mmd, boolean unbindNow) throws RuntimeWarning {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uninstall", (Object[])new Object[]{mmd.getJ2EEName()});
        }
        RuntimeWarning warning = null;
        EJBApplicationMetaData ejbAMD = mmd.getEJBApplicationMetaData();
        String appName = mmd.ivAppName;
        NameSpaceBinder<?> binder = this.createNameSpaceBinder(mmd);
        try {
            block48: {
                block43: {
                    binder.beginUnbind(unbindNow);
                    try {
                        this.deregisterMBeans(mmd);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".uninstall"), (String)"2623", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception caught during uninstall (deregisterMBeans).  Uninstall continues:  ", (Object[])new Object[]{t});
                        }
                        if (warning != null) break block43;
                        warning = new RuntimeWarning(t);
                    }
                }
                for (BeanMetaData bmd : mmd.ivBeanMetaDatas.values()) {
                    J2EEName j2eeName;
                    block47: {
                        HomeRecord hr;
                        block46: {
                            block45: {
                                block44: {
                                    j2eeName = bmd.j2eeName;
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("stopping bean " + j2eeName), (Object[])new Object[0]);
                                    }
                                    try {
                                        this.stopBean(bmd);
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Bean stopped; no exceptions thrown", (Object[])new Object[0]);
                                        }
                                    }
                                    catch (Throwable e) {
                                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".uninstall"), (String)"1039", (Object)this);
                                        Throwable nestedExc = AbstractEJBRuntime.getNestedException(e);
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Exception:", (Object[])new Object[]{e});
                                        }
                                        if (warning != null) break block44;
                                        warning = new RuntimeWarning(nestedExc);
                                    }
                                }
                                hr = bmd.homeRecord;
                                if (hr.ivJavaGlobalBindings != null) {
                                    try {
                                        binder.unbindJavaGlobal(hr.ivJavaGlobalBindings);
                                    }
                                    catch (NamingException ex) {
                                        FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".uninstall"), (String)"1006", (Object)this);
                                        if (warning != null) break block45;
                                        warning = new RuntimeWarning((Throwable)ex);
                                    }
                                }
                            }
                            if (hr.ivJavaAppBindings != null && !ejbAMD.isStopping()) {
                                try {
                                    binder.unbindJavaApp(hr.ivJavaAppBindings);
                                }
                                catch (NamingException ex) {
                                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".uninstall"), (String)"1066", (Object)this);
                                    if (warning != null) break block46;
                                    warning = new RuntimeWarning((Throwable)ex);
                                }
                            }
                        }
                        try {
                            binder.unbindBindings(hr);
                        }
                        catch (NamingException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".uninstall"), (String)"2613", (Object)this);
                            if (warning != null) break block47;
                            warning = new RuntimeWarning((Throwable)ex);
                        }
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Bean uninstall sequence ending for: ", (Object[])new Object[]{j2eeName});
                }
                Map appMap = (Map)InjectionEngineAccessor.getMessageDestinationLinkInstance().getMessageDestinationLinks().get(appName);
                if (appMap != null) {
                    String moduleName = mmd.getJ2EEName().getModule();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Remove module from appMap of MessageDestinationLinks : " + mmd.getJ2EEName()), (Object[])new Object[0]);
                    }
                    appMap.remove(moduleName);
                    if (appMap.size() == 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Remove appMap from MessageDestinationLinks : " + appName), (Object[])new Object[0]);
                        }
                        InjectionEngineAccessor.getMessageDestinationLinkInstance().getMessageDestinationLinks().remove(appName);
                    }
                }
                try {
                    binder.unbindEJBFactory();
                }
                catch (NamingException ex) {
                    if (warning != null) break block48;
                    warning = new RuntimeWarning((Throwable)ex);
                }
            }
            try {
                this.postInvokeStopModule(mmd);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".uninstall"), (String)"2730", (Object)this);
                Throwable t2 = AbstractEJBRuntime.getNestedException(t);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during uninstall (moduleUninstalPostInvoke).  Uninstall continues:  ", (Object[])new Object[]{t2});
                }
                if (warning == null) {
                    warning = new RuntimeWarning(t2);
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".uninstall"), (String)"1069", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception:", (Object[])new Object[]{t});
            }
            warning = new RuntimeWarning(t);
        }
        finally {
            block50: {
                try {
                    binder.end();
                }
                catch (NamingException ex) {
                    if (warning != null) break block50;
                    warning = new RuntimeWarning((Throwable)ex);
                }
            }
        }
        if (warning != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("uninstall: " + (Object)((Object)warning)));
            }
            throw warning;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uninstall");
        }
    }

    protected void postInvokeStopModule(EJBModuleMetaDataImpl mmd) {
    }

    protected void bindInterfaces(NameSpaceBinder<?> binder, BeanMetaData bmd) throws Exception {
        int numLocalInterfaces;
        int numRemoteInterfaces;
        HomeWrapperSet homeSet = null;
        EJSHome home = bmd.homeRecord.getHome();
        if (home != null) {
            homeSet = home.getWrapperSet();
        }
        boolean singleGlobalInterface = (numRemoteInterfaces = this.countInterfaces(bmd, false)) + (numLocalInterfaces = this.countInterfaces(bmd, true)) == 1;
        this.bindInterfaces(binder, bmd, homeSet, false, numRemoteInterfaces, singleGlobalInterface);
        this.bindInterfaces(binder, bmd, homeSet, true, numLocalInterfaces, singleGlobalInterface);
    }

    private int countInterfaces(BeanMetaData bmd, boolean local) {
        String homeInterfaceClassName = local ? bmd.localHomeInterfaceClassName : bmd.homeInterfaceClassName;
        boolean hasLocalBean = local && bmd.ivLocalBean;
        String[] businessInterfaceNames = local ? bmd.ivBusinessLocalInterfaceClassNames : bmd.ivBusinessRemoteInterfaceClassNames;
        int result = (homeInterfaceClassName == null ? 0 : 1) + (hasLocalBean ? 1 : 0) + (businessInterfaceNames == null ? 0 : businessInterfaceNames.length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("countInterfaces: " + bmd.j2eeName + ", local=" + local + ", result=" + result), (Object[])new Object[0]);
        }
        return result;
    }

    private void bindInterfaces(NameSpaceBinder<?> binder, BeanMetaData bmd, HomeWrapperSet homeSet, boolean local, int numInterfaces, boolean singleGlobalInterface) throws NamingException, RemoteException, CreateException {
        String[] businessInterfaceNames;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bindInterfaces: " + bmd.j2eeName + ", deferred=" + (homeSet == null) + ", local=" + local), (Object[])new Object[0]);
        }
        String homeInterfaceClassName = local ? bmd.localHomeInterfaceClassName : bmd.homeInterfaceClassName;
        boolean hasLocalBean = local && bmd.ivLocalBean;
        String[] stringArray = businessInterfaceNames = local ? bmd.ivBusinessLocalInterfaceClassNames : bmd.ivBusinessRemoteInterfaceClassNames;
        if (numInterfaces > 1 && bmd.simpleJndiBindingName != null) {
            Tr.warning((TraceComponent)tc, (String)"SIMPLE_BINDING_NAME_MISSUSED_CNTR0168W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bmd._moduleMetaData.ivAppName});
        }
        HomeRecord hr = bmd.homeRecord;
        if (homeInterfaceClassName != null) {
            this.bindInterface(binder, hr, homeSet, numInterfaces, singleGlobalInterface, homeInterfaceClassName, -1, local);
        }
        int interfaceIndex = 0;
        if (hasLocalBean) {
            this.bindInterface(binder, hr, homeSet, numInterfaces, singleGlobalInterface, bmd.enterpriseBeanClassName, interfaceIndex, local);
            ++interfaceIndex;
        }
        if (businessInterfaceNames != null) {
            for (String businessInterfaceName : businessInterfaceNames) {
                this.bindInterface(binder, hr, homeSet, numInterfaces, singleGlobalInterface, businessInterfaceName, interfaceIndex, local);
                ++interfaceIndex;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bindInterfaces");
        }
    }

    private <T> void bindInterface(NameSpaceBinder<T> binder, HomeRecord hr, HomeWrapperSet homeSet, int numInterfaces, boolean singleGlobalInterface, String interfaceName, int interfaceIndex, boolean local) throws NamingException, RemoteException, CreateException {
        boolean deferred;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bindInterface: " + hr.getJ2EEName() + ", " + interfaceIndex + ", " + interfaceName + ", local=" + local), (Object[])new Object[0]);
        }
        T bindingObject = binder.createBindingObject(hr, homeSet, interfaceName, interfaceIndex, local);
        boolean bl = deferred = homeSet == null;
        if (hr.bindToContextRoot()) {
            binder.bindBindings(bindingObject, hr, numInterfaces, singleGlobalInterface, interfaceIndex, interfaceName, local, deferred);
        }
        if (hr.bindToJavaNameSpaces()) {
            T javaBindingObject = binder.createJavaBindingObject(hr, homeSet, interfaceName, interfaceIndex, local, bindingObject);
            this.bindObjectToJavaNameSpaces(binder, javaBindingObject, hr, singleGlobalInterface, interfaceName, interfaceIndex, local);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bindInterface");
        }
    }

    protected void bindAllRemoteInterfacesToContextRoot() {
        HomeOfHomes homeOfHomes;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bindAllRemoteInterfacesToContextRoot", (Object[])new Object[0]);
        }
        HashMap binders = new HashMap();
        HomeOfHomes homeOfHomes2 = homeOfHomes = this.ivContainer != null ? this.ivContainer.getHomeOfHomes() : null;
        if (homeOfHomes != null) {
            List<HomeRecord> hrs = this.ivContainer.getHomeOfHomes().getAllHomeRecords();
            for (HomeRecord hr : hrs) {
                if (!hr.bindToContextRoot()) continue;
                BeanMetaData bmd = hr.getBeanMetaData();
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processing bindings for " + bmd.j2eeName), (Object[])new Object[0]);
                }
                if (bmd.homeInterfaceClassName != null) {
                    this.bindRemoteInterfaceToContextRoot(binders, hr, bmd.homeInterfaceClassName, -1);
                }
                if (bmd.ivBusinessRemoteInterfaceClassNames == null) continue;
                int interfaceIndex = 0;
                for (String remoteInterfaceName : bmd.ivBusinessRemoteInterfaceClassNames) {
                    this.bindRemoteInterfaceToContextRoot(binders, hr, remoteInterfaceName, interfaceIndex++);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bindAllRemoteInterfacesToContextRoot");
        }
    }

    private <T> void bindRemoteInterfaceToContextRoot(Map<EJBModuleMetaDataImpl, NameSpaceBinder<?>> binders, HomeRecord hr, String interfaceName, int interfaceIndex) {
        boolean isTraceOn;
        block5: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("bindRemoteInterfaceToContextRoot : " + interfaceName), (Object[])new Object[0]);
            }
            BeanMetaData bmd = hr.getBeanMetaData();
            EJBModuleMetaDataImpl mmd = hr.getEJBModuleMetaData();
            NameSpaceBinder<?> binder = binders.get(mmd);
            if (binder == null) {
                binder = this.createNameSpaceBinder(mmd);
                binders.put(mmd, binder);
            }
            EJSHome home = hr.getHome();
            try {
                HomeWrapperSet homeSet = home != null ? home.getWrapperSet() : null;
                int numRemoteInterfaces = this.countInterfaces(bmd, false);
                int numLocalInterfaces = this.countInterfaces(bmd, true);
                boolean singleGlobalInterface = numRemoteInterfaces + numLocalInterfaces == 1;
                Object bindingObject = binder.createBindingObject(hr, homeSet, interfaceName, interfaceIndex, false);
                binder.bindBindings(bindingObject, hr, numRemoteInterfaces, singleGlobalInterface, interfaceIndex, interfaceName, false, homeSet == null);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".bindRemoteInterfaceToContextRoot"), (String)"1187", (Object)this);
                if (!isTraceOn || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Ignoring bind failure : " + ex), (Object[])new Object[]{ex});
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bindRemoteInterfaceToContextRoot");
        }
    }

    private <T> void bindObjectToJavaNameSpaces(NameSpaceBinder<T> binder, T bindingObject, HomeRecord hr, boolean singleGlobalInterface, String interfaceName, int interfaceIndex, boolean local) throws NamingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bindObjectToJavaNameSpaces", (Object[])new Object[0]);
        }
        BeanMetaData bmd = hr.getBeanMetaData();
        J2EEName j2eeName = bmd.j2eeName;
        String beanName = j2eeName.getComponent();
        ArrayList<String> jndiNames = new ArrayList<String>();
        if (hr.bindInterfaceNames()) {
            jndiNames.add(beanName + '!' + interfaceName);
        }
        if (singleGlobalInterface) {
            jndiNames.add(beanName);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("names=" + jndiNames + ", global=" + hr.bindToJavaGlobalNameSpace()), (Object[])new Object[0]);
        }
        if (hr.bindToJavaGlobalNameSpace()) {
            if (bindingObject != null) {
                this.sendBindingMessage(bmd, beanName, interfaceName, interfaceIndex, local);
            }
            for (String jndiName : jndiNames) {
                if (bindingObject != null) {
                    binder.bindJavaGlobal(jndiName, bindingObject);
                }
                hr.ivJavaGlobalBindings.add(jndiName);
            }
        }
        for (String jndiName : jndiNames) {
            if (bindingObject != null) {
                binder.bindJavaApp(jndiName, bindingObject);
            }
            hr.ivJavaAppBindings.add(jndiName);
        }
        if (bindingObject != null) {
            for (String jndiName : jndiNames) {
                binder.bindJavaModule(jndiName, bindingObject);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bindObjectToJavaNameSpaces");
        }
    }

    protected void sendBindingMessage(BeanMetaData bmd, String beanName, String interfaceName, int interfaceIndex, boolean local) {
        EJBModuleMetaDataImpl mmd = bmd._moduleMetaData;
        String logicalAppName = mmd.getEJBApplicationMetaData().getLogicalName();
        String logicalModuleName = mmd.ivLogicalName;
        String jndiName = logicalAppName == null ? "java:global/" + logicalModuleName + '/' + beanName + '!' + interfaceName : "java:global/" + logicalAppName + '/' + logicalModuleName + '/' + beanName + '!' + interfaceName;
        Tr.info((TraceComponent)tc, (String)"JNDI_BINDING_LOCATION_INFO_CNTR0167I", (Object[])new Object[]{interfaceName, bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), jndiName});
    }

    public void sendMDBBindingMessage(BeanMetaData bmd) {
        if (bmd.ivActivationSpecJndiName != null) {
            Tr.info((TraceComponent)tc, (String)"MDB_ACTIVATION_SPEC_INFO_CNTR0180I", (Object[])new Object[]{bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), bmd.ivActivationSpecJndiName});
        }
    }

    protected static Throwable getNestedException(Throwable t) {
        Throwable cause;
        Throwable root = t;
        while ((cause = root.getCause()) != null) {
            root = cause;
        }
        return root;
    }

    public BeanMetaData createBeanMetaData(BeanInitData bid, EJBModuleMetaDataImpl mmd) throws EJBConfigurationException, ContainerException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createBeanMetaData: " + bid.ivJ2EEName), (Object[])new Object[0]);
        }
        BeanMetaData bmd = this.ivEJBMDOrchestrator.createBeanMetaData(bid, mmd, this.ivContainer, this.ivInitAtStartup, this.ivInitAtStartupSet);
        this.ivEJBMDOrchestrator.validateMergedMetaData(bmd);
        bmd.homeRecord = this.createHomeRecord(bmd, this.ivContainer.getHomeOfHomes());
        mmd.ivBeanMetaDatas.put(bmd.enterpriseBeanName, bmd);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createBeanMetaData");
        }
        return bmd;
    }

    protected HomeRecord createHomeRecord(BeanMetaData bmd, HomeOfHomes homeOfHomes) {
        return new HomeRecord(bmd, homeOfHomes);
    }

    protected void addHome(BeanMetaData bmd) throws ContainerException {
        try {
            EJSContainer.homeOfHomes.addHome(bmd);
        }
        catch (Throwable ex) {
            ContainerException ex2 = new ContainerException(ex);
            Tr.error((TraceComponent)tc, (String)"CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", (Object[])new Object[]{ex, ex2.toString()});
            throw ex2;
        }
    }

    @Override
    public ActivationStrategy createActivationStrategy(Activator activator, int type, PassivationPolicy passivationPolicy) {
        switch (type) {
            case 0: {
                return new UncachedActivationStrategy(activator);
            }
            case 1: {
                return new StatefulActivateOnceActivationStrategy(activator, passivationPolicy);
            }
            case 2: {
                return new StatefulActivateTranActivationStrategy(activator, passivationPolicy, this.ivContainer.getSfFailoverCache());
            }
        }
        return null;
    }

    @Override
    public final EJSHome initializeDeferredEJB(final HomeRecord hr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initializeDeferredEJB: " + hr.getJ2EEName()), (Object[])new Object[0]);
        }
        EJSHome result = AccessController.doPrivileged(new PrivilegedAction<EJSHome>(){

            @Override
            public EJSHome run() {
                Object credentialToken = AbstractEJBRuntime.this.pushServerIdentity();
                UOWHandle handle = null;
                try {
                    handle = AbstractEJBRuntime.this.ivUOWControl.suspend();
                    EJSHome eJSHome = AbstractEJBRuntime.this.runAsSystem(new PrivilegedExceptionAction<EJSHome>(){

                        @Override
                        public EJSHome run() throws CSIException, ContainerException, EJBConfigurationException {
                            return AbstractEJBRuntime.this.initializeDeferredEJBImpl(hr);
                        }
                    });
                    return eJSHome;
                }
                catch (Throwable ex) {
                    if (ex instanceof PrivilegedActionException) {
                        ex = ((PrivilegedActionException)ex).getCause();
                    }
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".initializeDeferredEJB"), (String)"3233", (Object)this);
                    BeanMetaData bmd = hr.getBeanMetaData();
                    if (bmd.ivMetaDataDestroyRequired) {
                        bmd.ivMetaDataDestroyRequired = false;
                        try {
                            AbstractEJBRuntime.this.fireMetaDataDestroyed(bmd);
                        }
                        catch (RuntimeWarning cex) {
                            // empty catch block
                        }
                    }
                    ContainerEJBException cex = new ContainerEJBException("Unable to initialize deferred EJB.", ex);
                    throw cex;
                }
                finally {
                    if (credentialToken != null) {
                        AbstractEJBRuntime.this.popServerIdentity(credentialToken);
                    }
                    try {
                        AbstractEJBRuntime.this.ivUOWControl.resume(handle);
                    }
                    catch (Throwable e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".initializeDeferredEJB"), (String)"4420", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"initializeDeferredEJB", (Object)("Unexpected exception in initializeDeferredEJB when trying to resume the previously suspended UOW: " + e));
                        }
                        ContainerEJBException cex = new ContainerEJBException("Unexpected exception in initializeDeferredEJB when trying to resume the previously suspended UOW.");
                        throw cex;
                    }
                }
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeDeferredEJB");
        }
        return result;
    }

    protected abstract <T> T runAsSystem(PrivilegedExceptionAction<T> var1) throws PrivilegedActionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EJSHome initializeDeferredEJBImpl(HomeRecord hr) throws ContainerException, EJBConfigurationException {
        BeanMetaData bmd = hr.getBeanMetaData();
        Object originalLoader = ThreadContextAccessor.UNCHANGED;
        try {
            if (!bmd.fullyInitialized) {
                originalLoader = svThreadContextAccessor.pushContextClassLoader(this.getServerClassLoader());
                bmd.wccm.reload();
                this.finishBMDInit(bmd);
            }
            originalLoader = svThreadContextAccessor.repushContextClassLoader(originalLoader, hr.getClassLoader());
            EJSHome eJSHome = this.fireMetaDataCreatedAndStartBean(bmd);
            return eJSHome;
        }
        finally {
            svThreadContextAccessor.popContextClassLoader(originalLoader);
            if (bmd.wccm != null) {
                bmd.wccm.unload();
            }
        }
    }

    protected ReferenceContext createReferenceContext(BeanMetaData bmd) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createReferenceContext: " + bmd.j2eeName), (Object[])new Object[0]);
        }
        if (bmd.ivReferenceContext == null) {
            bmd.ivReferenceContext = this.getInjectionEngine().createReferenceContext();
            bmd.ivReferenceContext.add((ComponentNameSpaceConfigurationProvider)new ComponentNameSpaceConfigurationProviderImpl(bmd, this));
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createReferenceContext", (Object)bmd.ivReferenceContext);
        }
        return bmd.ivReferenceContext;
    }

    protected void initializeBMD(BeanMetaData bmd) throws Exception {
        if (bmd.ivDeferEJBInitialization) {
            if (this.isReferenceProcessingNeededAtStart(bmd)) {
                ReferenceContext rc = this.createReferenceContext(bmd);
                rc.process();
            }
            this.ivEJBMDOrchestrator.processDeferredBMD(bmd);
        } else {
            this.finishBMDInit(bmd);
        }
    }

    private void finishBMDInit(BeanMetaData bmd) throws ContainerException, EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("finishBMDInit: " + bmd.j2eeName), (Object[])new Object[0]);
        }
        this.createReferenceContext(bmd);
        this.ivEJBMDOrchestrator.finishBMDInitWithReferenceContext(bmd);
        bmd._moduleMetaData.freeResourcesAfterAllBeansInitialized(bmd);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishBMDInit");
        }
    }

    public ComponentNameSpaceConfiguration finishBMDInitForReferenceContext(BeanMetaData bmd) throws EJBConfigurationException, ContainerException {
        return this.ivEJBMDOrchestrator.finishBMDInitForReferenceContext(bmd, this.ivDefaultDataSourceJNDIName, this.ivWebServicesHandlerResolver);
    }

    private EJSHome fireMetaDataCreatedAndStartBean(BeanMetaData bmd) throws ContainerException {
        if (!bmd.isManagedBean()) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("startBean: Fire Component Metadata created event to listeners for: " + bmd.j2eeName), (Object[])new Object[0]);
                }
                bmd.ivMetaDataDestroyRequired = true;
                this.fireMetaDataCreated(bmd);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + "startBean"), (String)"445", (Object)this);
                throw new ContainerException("Failed to start " + bmd.j2eeName, t);
            }
        }
        return this.startBean(bmd);
    }

    protected EJSHome startBean(BeanMetaData bmd) throws ContainerException {
        return this.ivContainer.startBean(bmd);
    }

    protected void stopBean(BeanMetaData bmd) throws CSIException {
        this.ivContainer.stopBean(bmd);
    }

    public final void setWebServiceHandlerResolver(WSEJBHandlerResolver resolver) {
        this.ivWebServicesHandlerResolver = resolver;
    }

    public void injectionMetaDataCreated(InjectionMetaData injectionMetaData) throws InjectionException {
        ComponentNameSpaceConfiguration compNSConfig = injectionMetaData.getComponentNameSpaceConfiguration();
        ComponentNameSpaceConfiguration.ReferenceFlowKind flow = compNSConfig.getOwningFlow();
        if (flow == ComponentNameSpaceConfiguration.ReferenceFlowKind.EJB || flow == ComponentNameSpaceConfiguration.ReferenceFlowKind.HYBRID) {
            injectionMetaData.bindJavaComp("EJBContext", (Object)new Reference(EJBContext.class.getName(), EJBContextObjectFactory.class.getName(), null));
            injectionMetaData.bindJavaComp("TimerService", (Object)new Reference(EJBContext.class.getName(), TimerServiceObjectFactory.class.getName(), null));
        }
    }

    @Override
    public ContainerTx createContainerTx(EJSContainer ejsContainer, boolean isLocal, SynchronizationRegistryUOWScope currTxKey, UOWControl uowCtrl) {
        return new ContainerTx(ejsContainer, isLocal, currTxKey, uowCtrl);
    }

    @Override
    public BeanOFactory getBeanOFactory(BeanOFactory.BeanOFactoryType type, BeanMetaData bmd) {
        BeanOFactory factory = null;
        switch (type) {
            case CM_STATELESS_BEANO_FACTORY: {
                factory = this.ivCMStatelessBeanOFactory;
                if (factory != null) break;
                this.ivCMStatelessBeanOFactory = factory = new CMStatelessBeanOFactory();
                break;
            }
            case BM_STATELESS_BEANO_FACTORY: {
                factory = this.ivBMStatelessBeanOFactory;
                if (factory != null) break;
                this.ivBMStatelessBeanOFactory = factory = new BMStatelessBeanOFactory();
                break;
            }
            case CM_STATEFUL_BEANO_FACTORY: {
                factory = this.ivCMStatefulBeanOFactory;
                if (factory != null) break;
                this.ivCMStatefulBeanOFactory = factory = new CMStatefulBeanOFactory();
                break;
            }
            case BM_STATEFUL_BEANO_FACTORY: {
                factory = this.ivBMStatefulBeanOFactory;
                if (factory != null) break;
                this.ivBMStatefulBeanOFactory = factory = new BMStatefulBeanOFactory();
                break;
            }
            case SINGLETON_BEANO_FACTORY: {
                factory = this.ivSingletonBeanOFactory;
                if (factory != null) break;
                this.ivSingletonBeanOFactory = factory = new SingletonBeanOFactory();
                break;
            }
            case MANAGED_BEANO_FACTORY: {
                factory = this.ivManagedBeanOFactory;
                if (factory != null) break;
                this.ivManagedBeanOFactory = factory = new ManagedBeanOFactory();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Bean type not supported in current environment: " + (Object)((Object)type));
            }
        }
        return factory;
    }

    @Override
    public Class<?> getMessageEndpointFactoryImplClass(BeanMetaData bmd) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Message-Driven beans are not supported in the current environment : " + bmd.getName());
    }

    @Override
    public Class<?> getMessageEndpointImplClass(BeanMetaData bmd) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Message-Driven beans are not supported in the current environment : " + bmd.getName());
    }

    @Override
    public void resolveMessageDestinationJndiName(BeanMetaData bmd) {
        throw new UnsupportedOperationException("Message-Driven beans are not supported in the current environment : " + bmd.getName());
    }

    protected int createNonPersistentAutomaticTimers(String appName, String moduleName, List<AutomaticTimerBean> timerBeans) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createNonPersistentAutomaticTimers: " + moduleName), (Object[])new Object[0]);
        }
        int numCreated = 0;
        for (AutomaticTimerBean timerBean : timerBeans) {
            if (timerBean.getNumNonPersistentTimers() == 0) continue;
            for (TimerMethodData timerMethod : timerBean.getMethods()) {
                for (TimerMethodData.AutomaticTimer timer : timerMethod.getAutomaticTimers()) {
                    if (timer.isPersistent()) continue;
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("creating non-persistent automatic timer " + timer), (Object[])new Object[0]);
                    }
                    this.createNonPersistentAutomaticTimer(timerBean, timer, timerMethod);
                    ++numCreated;
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createNonPersistentAutomaticTimers: " + numCreated));
        }
        return numCreated;
    }

    protected void createNonPersistentAutomaticTimer(AutomaticTimerBean timerBean, TimerMethodData.AutomaticTimer timer, TimerMethodData timerMethod) {
        BeanMetaData bmd = timerBean.getBeanMetaData();
        ParsedScheduleExpression parsedSchedule = timerBean.parseScheduleExpression(timer);
        TimerNpImpl ejbTimer = new TimerNpImpl(bmd.container, bmd, timerBean.getBeanId(), timerMethod.getMethodId(), parsedSchedule, timer.getInfo());
        ejbTimer.start();
    }

    protected int createPersistentAutomaticTimers(String appName, String moduleName, List<AutomaticTimerBean> timerBeans) throws RuntimeWarning {
        for (AutomaticTimerBean timerBean : timerBeans) {
            if (timerBean.getNumPersistentTimers() == 0) continue;
            Tr.warning((TraceComponent)tc, (String)"AUTOMATIC_PERSISTENT_TIMERS_NOT_SUPPORTED_CNTR0330W", (Object[])new Object[]{timerBean.getBeanMetaData().getName(), moduleName, appName});
        }
        return 0;
    }

    @Override
    public Timer createTimer(BeanO beanO, Date expiration, long interval, ScheduleExpression schedule, Serializable info, boolean persistent) {
        Timer timer;
        boolean isTraceOn;
        boolean bl = isTraceOn = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTimer : " + beanO), (Object[])new Object[0]);
        }
        if (schedule == null) {
            timer = persistent ? this.createPersistentExpirationTimer(beanO.getId(), expiration, interval, info) : this.createNonPersistentExpirationTimer(beanO, expiration, interval, info);
        } else {
            ParsedScheduleExpression parsedExpr;
            try {
                parsedExpr = ScheduleExpressionParser.parse(this.ivContainer.ivObjectCopier.copy(schedule));
            }
            catch (ScheduleExpressionParserException ex) {
                IllegalArgumentException ise = new IllegalArgumentException("TimerService: schedule is not valid: " + ex.getMessage());
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("createTimer: " + ise));
                }
                throw ise;
            }
            timer = persistent ? this.createPersistentCalendarTimer(beanO.getId(), parsedExpr, info) : this.createNonPersistentCalendarTimer(beanO, parsedExpr, info);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTimer :" + timer));
        }
        return timer;
    }

    protected abstract Timer createPersistentExpirationTimer(BeanId var1, Date var2, long var3, Serializable var5);

    protected abstract Timer createPersistentCalendarTimer(BeanId var1, ParsedScheduleExpression var2, Serializable var3);

    protected Timer createNonPersistentExpirationTimer(BeanO beanO, Date expiration, long interval, Serializable info) {
        boolean isTraceOn;
        boolean bl = isTraceOn = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createNonPersistentExpirationTimer : " + beanO), (Object[])new Object[0]);
        }
        if (beanO.getHome().getBeanMetaData().isEntityBean()) {
            IllegalStateException ise = new IllegalStateException("Timer Service: Entity beans cannot use non-persistent timers : " + beanO.getId().getJ2EEName());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("createNonPersistentExpirationTimer : " + ise));
            }
            throw ise;
        }
        TimerNpImpl timer = new TimerNpImpl(beanO.getId(), expiration, interval, info);
        this.queueOrStartNpTimer(beanO, timer);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createNonPersistentExpirationTimer : " + timer));
        }
        return timer;
    }

    protected Timer createNonPersistentCalendarTimer(BeanO beanO, ParsedScheduleExpression parsedExpr, Serializable info) {
        boolean isTraceOn;
        boolean bl = isTraceOn = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createNonPersistentCalendarTimer : " + beanO), (Object[])new Object[0]);
        }
        TimerNpImpl timer = new TimerNpImpl(beanO.getId(), parsedExpr, info);
        this.queueOrStartNpTimer(beanO, timer);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createNonPersistentCalendarTimer : " + timer));
        }
        return timer;
    }

    private void queueOrStartNpTimer(BeanO beanO, TimerNpImpl timer) throws EJBException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        try {
            EJBModuleMetaDataImpl mmd = beanO.getHome().getBeanMetaData()._moduleMetaData;
            mmd.getEJBApplicationMetaData().checkIfCreateNonPersistentTimerAllowed(mmd);
            ContainerTx tx = beanO.getContainerTx();
            if (tx == null) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"queueOrStartNpTimer found ivContainerTx null.  Calling getCurrentTx(false)", (Object[])new Object[0]);
                }
                tx = beanO.getContainer().getCurrentContainerTx();
            }
            if (tx != null) {
                tx.queueTimerToStart(timer);
            } else {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Container Tx not found; starting timer immediately.", (Object[])new Object[0]);
                }
                timer.start();
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.EJBException(e);
        }
    }

    @Override
    public void checkLateTimerThreshold(Date scheduledRunTime, String timerId, J2EEName j2eeName) {
        long currentTime;
        long lateTime;
        long lateTimerThreshold;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checkLateTimerThreshold : " + scheduledRunTime + ", " + timerId + ", " + j2eeName), (Object[])new Object[0]);
        }
        if ((lateTimerThreshold = this.getLateTimerThreshold()) > 0L && (lateTime = (currentTime = System.currentTimeMillis()) - scheduledRunTime.getTime()) > lateTimerThreshold) {
            long secondsLate = lateTime / 1000L;
            Tr.warning((TraceComponent)tc, (String)"TIMER_FIRING_LATE_CNTR0333W", (Object[])new Object[]{timerId, j2eeName.getComponent(), j2eeName.getModule(), j2eeName.getApplication(), scheduledRunTime, new Date(currentTime), secondsLate});
        }
    }

    protected abstract long getLateTimerThreshold();
}

