/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.container.util.locking.LockTable;
import com.ibm.ejs.util.MathUtil;
import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.BucketImpl;
import com.ibm.ejs.util.cache.CacheElementEnumerator;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.EvictionStrategy;
import com.ibm.ejs.util.cache.IllegalOperationException;
import com.ibm.ejs.util.cache.NoSuchObjectException;
import com.ibm.ejs.util.cache.WrapperBucket;
import com.ibm.websphere.csi.CacheElement;
import com.ibm.websphere.csi.DiscardException;
import com.ibm.websphere.csi.DiscardStrategy;
import com.ibm.websphere.csi.EJBCache;
import com.ibm.websphere.csi.FaultException;
import com.ibm.websphere.csi.FaultStrategy;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.diagnostics.IntrospectionWriter;
import com.ibm.ws.ejbcontainer.diagnostics.TrDumpWriter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.cache.DiscardWithLockStrategy;
import java.util.Enumeration;

public final class Cache
implements EJBCache {
    protected FaultStrategy faultStrategy = null;
    protected EvictionStrategy evictionStrategy = null;
    protected DiscardStrategy discardStrategy = null;
    protected LockTable ivEvictionLocks = null;
    protected String ivName;
    private final boolean wrappers;
    private final Bucket[] buckets;
    private final Object bucketLock = new BucketLock();
    protected final int numBuckets;
    protected int numObjects = 0;
    private int numEvictionAttempts = 0;
    private int numEvictions = 0;
    protected long numSweeps = 0L;
    protected boolean dumped = false;
    private static final TraceComponent tc = Tr.register(Cache.class, (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.cache.Cache";

    public Cache(String name, int numBuckets, boolean wrappers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> (" + name + ", numBuckets = " + numBuckets + ", wrappers = " + wrappers + ")"), (Object[])new Object[0]);
        }
        numBuckets = MathUtil.findNextPrime((int)numBuckets);
        this.ivName = name;
        this.numBuckets = numBuckets;
        this.wrappers = wrappers;
        this.buckets = new Bucket[numBuckets];
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> (" + name + ", numBuckets = " + this.numBuckets + ")"));
        }
    }

    public Cache(String name, long numBuckets, boolean wrappers) {
        this(name, (int)numBuckets, wrappers);
    }

    @Override
    public final int getSize() {
        return this.numObjects;
    }

    @Override
    public final int getNumBuckets() {
        return this.numBuckets;
    }

    @Override
    public String getName() {
        return this.ivName;
    }

    @Override
    public final void setFaultStrategy(FaultStrategy strategy) {
        this.faultStrategy = strategy;
    }

    public final void setEvictionStrategy(EvictionStrategy strategy) {
        this.evictionStrategy = strategy;
    }

    @Override
    public final void setDiscardStrategy(DiscardStrategy strategy) {
        this.discardStrategy = strategy;
        if (strategy instanceof DiscardWithLockStrategy) {
            this.ivEvictionLocks = ((DiscardWithLockStrategy)strategy).getEvictionLockTable();
        }
    }

    @Override
    public void setSweepInterval(long sweepInterval) {
        this.evictionStrategy.setSweepInterval(sweepInterval);
    }

    @Override
    public void setCachePreferredMaxSize(int maxSize) {
        this.evictionStrategy.setPreferredMaxSize(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contains", (Object[])new Object[]{key});
        }
        Bucket bucket = this.getBucketForKey(key);
        Element element = null;
        if (bucket != null) {
            Bucket bucket2 = bucket;
            synchronized (bucket2) {
                element = bucket.findByKey(key);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contains", (Object)new Boolean(element != null));
        }
        return element != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object find(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"find", (Object[])new Object[]{key});
        }
        Bucket bucket = this.getBucketForKey(key);
        Object object = null;
        if (bucket != null) {
            Bucket bucket2 = bucket;
            synchronized (bucket2) {
                Element element = bucket.findByKey(key);
                if (element != null) {
                    ++element.pinned;
                    object = element.object;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"find", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findDontPinNAdjustPinCount(Object key, int adjustPinCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findDontPinNAdjustPinCount", (Object[])new Object[]{key + ", adujust pin count=" + adjustPinCount});
        }
        Bucket bucket = this.getBucketForKey(key);
        Object object = null;
        if (bucket != null) {
            Bucket bucket2 = bucket;
            synchronized (bucket2) {
                Element element = bucket.findByKey(key);
                if (element != null) {
                    element.accessedSweep = this.numSweeps;
                    object = element.object;
                    element.pinned += adjustPinCount;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findDontPinNAdjustPinCount", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findAndFault(Object key) throws FaultException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findAndFault", (Object[])new Object[]{key});
        }
        Bucket bucket = this.getOrCreateBucketForKey(key);
        Object object = null;
        Object object2 = bucket;
        synchronized (object2) {
            Element element = bucket.findByKey(key);
            if (element != null) {
                element.accessedSweep = this.numSweeps;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findAndFault : found in cache");
                }
                return element.object;
            }
            if (this.faultStrategy == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findAndFault : not in cache : no FaultStrategy");
                }
                return null;
            }
            try {
                object = this.faultStrategy.faultOnKey(this, key);
                if (object != null) {
                    element = bucket.insertByKey(key, object);
                    element.accessedSweep = this.numSweeps;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.Cache.findAndFault", (String)"417", (Object)this);
                throw new FaultException(e, key.toString());
            }
        }
        if (object != null) {
            object2 = this;
            synchronized (object2) {
                ++this.numObjects;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findAndFault : not in cache : faulted");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key, boolean dropRef) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object[])new Object[]{key, new Boolean(dropRef)});
        }
        Bucket bucket = this.getBucketForKey(key);
        Object object = null;
        if (bucket != null) {
            Object object2 = bucket;
            synchronized (object2) {
                Element element = bucket.removeByKey(key, dropRef);
                object = element != null ? element.object : null;
            }
            if (object != null) {
                object2 = this;
                synchronized (object2) {
                    --this.numObjects;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElement(CacheElement cacheElement, boolean dropRef) {
        Element element = (Element)cacheElement;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object[])new Object[]{element.key, dropRef});
        }
        Bucket bucket = element.ivBucket;
        Object object = bucket;
        synchronized (object) {
            bucket.removeByKey(element.key, dropRef);
        }
        object = this;
        synchronized (object) {
            --this.numObjects;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove", (Object)element.object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeAndDiscard(Object key, boolean dropRef) throws DiscardException {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAndDiscard", (Object[])new Object[]{key, new Boolean(dropRef)});
        }
        Bucket bucket = this.getOrCreateBucketForKey(key);
        Object object2 = null;
        try {
            object = bucket;
            synchronized (object) {
                Element element = bucket.removeByKey(key, dropRef);
                Object object3 = object2 = element != null ? element.object : null;
                if (object2 != null && this.discardStrategy != null) {
                    try {
                        this.discardStrategy.discardObject(this, element.key, element.object);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.util.cache.Cache.removeAndDiscard", (String)"540", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"EXCEPTION_THROWN_BY_DISCARD_STRATEGY_CNTR0054W", (Object[])new Object[]{element, ex});
                        element = null;
                        throw new DiscardException(ex, key);
                    }
                }
            }
        }
        finally {
            if (object2 != null) {
                object = this;
                synchronized (object) {
                    --this.numObjects;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAndDiscard", (Object)object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheElement insert(Object key, Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"insert", (Object[])new Object[]{key, object});
        }
        try {
            Element element;
            Bucket bucket = this.getOrCreateBucketForKey(key);
            Object object2 = bucket;
            synchronized (object2) {
                element = bucket.insertByKey(key, object);
                ++element.pinned;
            }
            object2 = this;
            synchronized (object2) {
                ++this.numObjects;
            }
            object2 = element;
            return object2;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"insert");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheElement insertUnpinned(Object key, Object object) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"insertUnpinned", (Object[])new Object[]{key, object});
        }
        try {
            Element element;
            Bucket bucket = this.getOrCreateBucketForKey(key);
            Object object2 = bucket;
            synchronized (object2) {
                element = bucket.insertByKey(key, object);
                element.accessedSweep = this.numSweeps;
            }
            object2 = this;
            synchronized (object2) {
                ++this.numObjects;
            }
            object2 = element;
            return object2;
        }
        finally {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"insertUnpinned");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pin(Object key) {
        int pinCount;
        Bucket bucket;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pin", (Object[])new Object[]{key});
        }
        Bucket bucket2 = bucket = this.getOrCreateBucketForKey(key);
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            if (element == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"pin - throw NoSuchObjectException");
                }
                throw new NoSuchObjectException(key);
            }
            ++element.pinned;
            pinCount = element.pinned;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("pin:" + pinCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pinElement(CacheElement cacheElement) {
        int pinCount;
        Element element = (Element)cacheElement;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pin", (Object[])new Object[]{element.key});
        }
        Bucket bucket = element.ivBucket;
        synchronized (bucket) {
            ++element.pinned;
            pinCount = element.pinned;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("pin:" + pinCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markElementEvictionIneligible(CacheElement cacheElement) {
        Element element = (Element)cacheElement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"markEvictionIneligible", (Object[])new Object[]{element.key});
        }
        Bucket bucket = element.ivBucket;
        synchronized (bucket) {
            element.ivEvictionIneligible = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"markEvictionIneligible");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unpin(Object key) {
        Bucket bucket;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unpin", (Object[])new Object[]{key});
        }
        int remaining = 0;
        Bucket bucket2 = bucket = this.getOrCreateBucketForKey(key);
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            if (element == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"unpin - throw NoSuchObjectException");
                }
                throw new NoSuchObjectException(key);
            }
            if (element.pinned < 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"unpin - throw IllegalOperationException");
                }
                throw new IllegalOperationException(key, element.pinned);
            }
            --element.pinned;
            remaining = element.pinned;
            element.accessedSweep = this.numSweeps;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("unpin:" + remaining));
        }
        return remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unpinElement(CacheElement cacheElement) {
        Bucket bucket;
        Element element = (Element)cacheElement;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unpin", (Object[])new Object[]{element.key});
        }
        int remaining = 0;
        Bucket bucket2 = bucket = element.ivBucket;
        synchronized (bucket2) {
            if (element.pinned < 1) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"unpin - throw IllegalOperationException");
                }
                throw new IllegalOperationException(element.key, element.pinned);
            }
            --element.pinned;
            remaining = element.pinned;
            element.accessedSweep = this.numSweeps;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("unpin:" + remaining));
        }
        return remaining;
    }

    public void touch(Element element) {
        element.accessedSweep = this.numSweeps;
    }

    public final Enumeration<Element> enumerateElements() {
        return new CacheElementEnumerator(this);
    }

    private int getBucketIndexForKey(Object key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.buckets.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bucket getBucketForKey(Object key) {
        int index = this.getBucketIndexForKey(key);
        Bucket bucket = this.buckets[index];
        if (bucket == null) {
            Object object = this.bucketLock;
            synchronized (object) {
                bucket = this.buckets[index];
            }
        }
        return bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket getOrCreateBucketForKey(Object key) {
        int index = this.getBucketIndexForKey(key);
        Bucket bucket = this.buckets[index];
        if (bucket == null) {
            Object object = this.bucketLock;
            synchronized (object) {
                bucket = this.buckets[index];
                if (bucket == null) {
                    this.buckets[index] = bucket = this.wrappers ? new WrapperBucket(this) : new BucketImpl();
                }
            }
        }
        return bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean evictObject(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"evictObject", (Object[])new Object[]{key});
        }
        Bucket bucket = this.getOrCreateBucketForKey(key);
        Element element = null;
        Object object = this;
        synchronized (object) {
            ++this.numEvictionAttempts;
        }
        try {
            object = bucket;
            synchronized (object) {
                element = bucket.findByKey(key);
                if (element != null && this.evictionStrategy.canBeDiscarded(element)) {
                    element = bucket.discardByKey(key);
                    if (element != null) {
                        Cache cache = this;
                        synchronized (cache) {
                            --this.numObjects;
                            ++this.numEvictions;
                        }
                        if (this.discardStrategy != null) {
                            try {
                                this.discardStrategy.discardObject(this, element.key, element.object);
                            }
                            catch (Exception ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.util.cache.Cache.evictObject", (String)"863", (Object)this);
                                Tr.warning((TraceComponent)tc, (String)"EXCEPTION_THROWN_BY_DISCARD_STRATEGY_CNTR0054W", (Object[])new Object[]{element, ex});
                                element = null;
                            }
                        }
                    }
                } else {
                    element = null;
                }
            }
        }
        catch (IllegalOperationException ex) {
            try {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.util.cache.Cache.evictObject", (String)"878", (Object)this);
                element = null;
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"evictObject", (Object)new Boolean(element != null));
                }
                throw throwable;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"evictObject", (Object)new Boolean(element != null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"evictObject", (Object)new Boolean(element != null));
        }
        return element != null;
    }

    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            this.introspect(new TrDumpWriter(tc));
        }
        finally {
            this.dumped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(IntrospectionWriter writer) {
        writer.begin("Cache : " + this);
        writer.println("Name of Cache: " + this.ivName);
        writer.println("Number of buckets: " + this.numBuckets);
        Cache cache = this;
        synchronized (cache) {
            writer.println("Number of objects currently in cache: " + this.numObjects);
            writer.println("Number of evictions attempted (since last dump): " + this.numEvictionAttempts);
            writer.println("Number of evictions (since last dump): " + this.numEvictions);
            this.numEvictionAttempts = 0;
            this.numEvictions = 0;
        }
        writer.end();
    }

    public void resetDump() {
        this.dumped = false;
    }

    @Override
    public void terminate() {
        if (this.evictionStrategy != null) {
            this.evictionStrategy.cancel();
            this.evictionStrategy = null;
        }
    }

    private static class BucketLock {
        private BucketLock() {
        }
    }
}

