/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.persistence.EnhancedEnumeration;
import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.persistence.RemoteEnumerator;
import com.ibm.ws.ejb.portable.Constants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import javax.ejb.EJBObject;

public class PortableFinderEnumerator
implements EnhancedEnumeration,
Serializable {
    static final int PREFETCH_COUNT = 25;
    static final byte[] eyecatcher = Constants.FINDER_ENUMERATOR_EYE_CATCHER;
    static final short platform = 1;
    static final short versionID = 1;
    private transient RemoteEnumerator vEnum = null;
    private transient EJBObject[] elements = null;
    private transient int index = 0;
    private transient boolean exhausted = false;
    private static final long serialVersionUID = 4603100038030697154L;

    PortableFinderEnumerator(EJBObject[] elements) {
        this.elements = elements;
        this.exhausted = true;
    }

    PortableFinderEnumerator(EJBObject[] prefetchElements, boolean exhausted, RemoteEnumerator vEnum) {
        this.elements = prefetchElements;
        this.exhausted = exhausted;
        this.vEnum = vEnum;
    }

    public Object nextElement() {
        try {
            return this.nextElementR();
        }
        catch (NoMoreElementsException e) {
            throw new NoSuchElementException();
        }
        catch (EnumeratorException e) {
            throw new RuntimeException(e.toString());
        }
        catch (NoSuchObjectException e) {
            throw new IllegalStateException("Cannot access finder result outside transaction");
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public boolean hasMoreElements() {
        try {
            return this.hasMoreElementsR();
        }
        catch (NoMoreElementsException e) {
            return false;
        }
        catch (EnumeratorException e) {
            throw new RuntimeException(e.toString());
        }
        catch (NoSuchObjectException e) {
            throw new IllegalStateException("Cannot access finder result outside transaction");
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public synchronized boolean hasMoreElementsR() throws RemoteException, EnumeratorException {
        if (this.elements != null && this.index < this.elements.length) {
            return true;
        }
        if (!this.exhausted) {
            try {
                this.elements = null;
                this.index = 0;
                this.elements = this.fetchElements(25);
                return true;
            }
            catch (NoMoreElementsException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public synchronized Object nextElementR() throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        return this.elements[this.index++];
    }

    @Override
    public synchronized Object[] nextNElements(int n) throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        EJBObject[] remainder = null;
        int numCached = this.elements.length - this.index;
        if (!this.exhausted && numCached < n) {
            try {
                remainder = this.fetchElements(n - numCached);
            }
            catch (NoMoreElementsException noMoreElementsException) {
                // empty catch block
            }
        }
        int numRemaining = remainder != null ? remainder.length : 0;
        int totalAvail = numCached + numRemaining;
        int numToReturn = Math.min(n, totalAvail);
        Object[] result = new EJBObject[numToReturn];
        int numFromCache = Math.min(numToReturn, numCached);
        System.arraycopy(this.elements, this.index, result, 0, numFromCache);
        this.index += numFromCache;
        if (remainder != null) {
            System.arraycopy(remainder, 0, result, numFromCache, numRemaining);
        }
        return result;
    }

    public int size() {
        this.loadEntireCollection();
        if (this.elements == null) {
            return 0;
        }
        return this.elements.length;
    }

    public EJBObject[] loadEntireCollection() {
        EJBObject[] result = null;
        try {
            result = (EJBObject[])this.allRemainingElements();
        }
        catch (NoMoreElementsException e) {
            return this.elements;
        }
        catch (EnumeratorException e) {
            throw new RuntimeException(e.toString());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
        this.elements = result;
        return result;
    }

    @Override
    public synchronized Object[] allRemainingElements() throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        EJBObject[] remainder = null;
        if (!this.exhausted) {
            try {
                remainder = this.vEnum.allRemainingElements();
            }
            catch (NoMoreElementsException noMoreElementsException) {
            }
            catch (NoSuchObjectException exc) {
                throw new CollectionCannotBeFurtherAccessedException("Cannot access finder result outside transaction");
            }
            finally {
                this.exhausted = true;
                this.vEnum = null;
            }
        }
        int numCached = this.elements.length - this.index;
        int numRemaining = remainder != null ? remainder.length : 0;
        Object[] result = new EJBObject[numCached + numRemaining];
        System.arraycopy(this.elements, this.index, result, 0, numCached);
        if (remainder != null) {
            System.arraycopy(remainder, 0, result, numCached, numRemaining);
        }
        this.elements = null;
        return result;
    }

    private final EJBObject[] fetchElements(int count) throws RemoteException, EnumeratorException {
        EJBObject[] batch = null;
        try {
            if (this.vEnum != null) {
                batch = this.vEnum.nextNElements(count);
            }
            EJBObject[] eJBObjectArray = batch;
            return eJBObjectArray;
        }
        catch (NoMoreElementsException ex) {
            throw ex;
        }
        catch (NoSuchObjectException exc) {
            throw new CollectionCannotBeFurtherAccessedException("Cannot access finder result outside transaction");
        }
        finally {
            if (batch == null || batch.length < count) {
                this.exhausted = true;
                this.vEnum = null;
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.write(eyecatcher);
        out.writeShort(1);
        out.writeShort(1);
        try {
            out.writeObject(this.vEnum);
        }
        catch (Throwable exc) {
            throw new CollectionCannotBeFurtherAccessedException(exc.toString());
        }
        out.writeObject(this.elements);
        out.writeInt(this.index);
        out.writeBoolean(this.exhausted);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] ec = new byte[4];
        int bytesRead = 0;
        for (int offset = 0; offset < 4; offset += bytesRead) {
            bytesRead = in.read(ec, offset, 4 - offset);
            if (bytesRead != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (int i = 0; i < eyecatcher.length; ++i) {
            if (eyecatcher[i] == ec[i]) continue;
            throw new IOException();
        }
        in.readShort();
        in.readShort();
        try {
            this.vEnum = (RemoteEnumerator)in.readObject();
        }
        catch (Throwable exc) {
            throw new CollectionCannotBeFurtherAccessedException(exc.toString());
        }
        this.elements = (EJBObject[])in.readObject();
        this.index = in.readInt();
        this.exhausted = in.readBoolean();
    }
}

