/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.container.LocalBeanWrapper;
import com.ibm.ejs.container.LocalBeanWrapperProxy;
import com.ibm.ejs.container.WrapperId;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.container.WrapperManager;
import com.ibm.ejs.container.WrapperProxy;
import com.ibm.ejs.container.WrapperProxyState;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.util.EJBSerializer;
import java.io.IOException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.rmi.CORBA.Stub;

public class EJBSerializerImpl
extends EJBSerializer {
    private static final TraceComponent tc = Tr.register(EJBSerializerImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");

    @Override
    public Object deserialize(byte[] idBytes) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deserialize", (Object[])new Object[0]);
        }
        EJSContainer container2 = EJSContainer.getDefaultContainer();
        Object retObj = null;
        WrapperManager wm = container2.getWrapperManager();
        if (idBytes[0] == -84) {
            ByteArray byteArray = new ByteArray(idBytes);
            BeanId beanId = BeanId.getBeanId(byteArray, container2);
            retObj = wm.getWrapper(beanId).getLocalObject();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("deserialized a BeanId = " + beanId + ", component wrapper = " + retObj), (Object[])new Object[0]);
            }
        } else if (idBytes[0] == -83) {
            WrapperId wrapperId = new WrapperId(idBytes);
            int index = wrapperId.ivInterfaceIndex;
            String interfaceName = wrapperId.ivInterfaceClassName;
            ByteArray byteArray = wrapperId.getBeanIdArray();
            BeanId beanId = BeanId.getBeanId(byteArray, container2);
            BeanMetaData bmd = beanId.getBeanMetaData();
            Tr.debug((TraceComponent)tc, (String)("deserialized a WrapperId for BeanId = " + beanId + ", primary key = " + beanId.getPrimaryKey()), (Object[])new Object[0]);
            if (index == -2) {
                EJSHome home = bmd.getHome();
                EJSWrapperCommon wc = home.internalCreateWrapper(beanId);
                retObj = wc.getAggregateLocalWrapper();
            } else {
                Class<?>[] bInterfaces = bmd.ivBusinessLocalInterfaceClasses;
                int numberOfLocalInterfaces = bInterfaces.length;
                String wrapperInterfaceName = null;
                if (index < numberOfLocalInterfaces) {
                    wrapperInterfaceName = bInterfaces[index].getName();
                }
                if (wrapperInterfaceName == null || !wrapperInterfaceName.equals(interfaceName)) {
                    index = bmd.getRequiredLocalBusinessInterfaceIndex(interfaceName);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("deserialized a BusinessLocalWrapper, WrapperId = " + (Object)((Object)wrapperId)), (Object[])new Object[0]);
                }
                EJSHome home = bmd.getHome();
                EJSWrapperCommon wc = home.internalCreateWrapper(beanId);
                retObj = wc.getLocalBusinessObject(index);
            }
        } else {
            throw new IOException("First byte of header not recognized");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("deserialize returning: " + retObj));
        }
        return retObj;
    }

    @Override
    public EJBSerializer.ObjectType getObjectType(Object theObject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectType: " + theObject.getClass()), (Object[])new Object[0]);
        }
        EJBSerializer.ObjectType objectType = EJBSerializer.ObjectType.NOT_AN_EJB;
        if (theObject instanceof Stub) {
            objectType = theObject instanceof EJBObject ? EJBSerializer.ObjectType.EJB_OBJECT : (theObject instanceof EJBHome ? EJBSerializer.ObjectType.EJB_HOME : EJBSerializer.ObjectType.CORBA_STUB);
        } else if (theObject instanceof WrapperProxy) {
            objectType = theObject instanceof LocalBeanWrapperProxy ? EJBSerializer.ObjectType.EJB_LOCAL_BEAN : WrapperProxyState.getWrapperProxyState(theObject).getSerializerObjectType();
        } else if (theObject instanceof EJSWrapperBase) {
            EJSWrapperBase wrapper = (EJSWrapperBase)theObject;
            WrapperInterface wInterface = wrapper.ivInterface;
            if (wInterface == WrapperInterface.BUSINESS_LOCAL) {
                objectType = EJBSerializer.ObjectType.EJB_BUSINESS_LOCAL;
            } else if (wInterface == WrapperInterface.LOCAL) {
                objectType = EJBSerializer.ObjectType.EJB_LOCAL_OBJECT;
            } else if (wInterface == WrapperInterface.LOCAL_HOME) {
                objectType = EJBSerializer.ObjectType.EJB_LOCAL_HOME;
            } else if (wInterface == WrapperInterface.BUSINESS_REMOTE) {
                objectType = EJBSerializer.ObjectType.EJB3_BUSINESS_REMOTE;
            } else if (wInterface == WrapperInterface.BUSINESS_RMI_REMOTE) {
                objectType = EJBSerializer.ObjectType.EJB3_BUSINESS_REMOTE;
            }
        } else if (theObject instanceof LocalBeanWrapper) {
            objectType = EJBSerializer.ObjectType.EJB_LOCAL_BEAN;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("ObjectType = " + (Object)((Object)objectType)));
        }
        return objectType;
    }

    @Override
    public byte[] serialize(Object theObject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("serialize = " + theObject.getClass()), (Object[])new Object[0]);
        }
        byte[] idBytes = null;
        if (theObject instanceof WrapperProxy) {
            WrapperProxyState state = WrapperProxyState.getWrapperProxyState(theObject);
            idBytes = state.getSerializerBytes();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("serialized a WrapperProxy for " + state), (Object[])new Object[0]);
            }
        } else {
            EJSWrapperBase wrapper = null;
            if (theObject instanceof EJSWrapperBase) {
                wrapper = (EJSWrapperBase)theObject;
            } else if (theObject instanceof LocalBeanWrapper) {
                wrapper = EJSWrapperCommon.getLocalBeanWrapperBase((LocalBeanWrapper)theObject);
            } else {
                throw new IllegalArgumentException(" theObject parameter must be a EJB_LOCAL, EJB_LOCAL_HOME, EJB_BUSINESS_LOCAL, or EJB_BUSINESS_REMOTE ObjectType. Use the getObjectType to obtain the ObjectType.");
            }
            BeanId beanId = wrapper.beanId;
            WrapperInterface wrapperInterface = wrapper.ivInterface;
            BeanMetaData bmd = wrapper.bmd;
            if (wrapperInterface == WrapperInterface.BUSINESS_LOCAL) {
                String interfaceName;
                int interfaceIndex = wrapper.ivBusinessInterfaceIndex;
                if (interfaceIndex == -2) {
                    interfaceName = "AGGREGATE";
                } else {
                    Class<?> biClass = bmd.ivBusinessLocalInterfaceClasses[interfaceIndex];
                    interfaceName = biClass.getName();
                }
                WrapperId wrapperId = new WrapperId(beanId.getByteArrayBytes(), interfaceName, interfaceIndex);
                idBytes = wrapperId.getBytes();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("serialized a WrapperId for BeanId = " + beanId + ", local business interface = " + interfaceName), (Object[])new Object[0]);
                }
            } else if (wrapperInterface == WrapperInterface.BUSINESS_REMOTE) {
                int interfaceIndex = wrapper.ivBusinessInterfaceIndex;
                Class<?> biClass = bmd.ivBusinessRemoteInterfaceClasses[interfaceIndex];
                String interfaceName = biClass.getName();
                WrapperId wrapperId = new WrapperId(beanId.getByteArrayBytes(), interfaceName, interfaceIndex);
                idBytes = wrapperId.getBytes();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("serialized a WrapperId for BeanId = " + beanId + ", remote business interface = " + interfaceName), (Object[])new Object[0]);
                }
            } else if (wrapperInterface == WrapperInterface.BUSINESS_RMI_REMOTE) {
                int interfaceIndex = wrapper.ivBusinessInterfaceIndex;
                Class<?> biClass = bmd.ivBusinessRemoteInterfaceClasses[interfaceIndex];
                String interfaceName = biClass.getName();
                WrapperId wrapperId = new WrapperId(beanId.getByteArrayBytes(), interfaceName, interfaceIndex);
                idBytes = wrapperId.getBytes();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("serialized a WrapperId for BeanId = " + beanId + ", RMI remote business interface = " + interfaceName), (Object[])new Object[0]);
                }
            } else {
                idBytes = beanId.getByteArrayBytes();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("serialized a BeanId = " + beanId), (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serialize");
        }
        return idBytes;
    }
}

