/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.Date;

public class TimeoutElement {
    private static final TraceComponent tc = Tr.register(TimeoutElement.class, (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    public final BeanId beanId;
    public final long timeout;
    public volatile long lastAccessTime;
    public volatile boolean passivated;

    TimeoutElement(BeanId beanId, long timeoutVal) {
        this.beanId = beanId;
        this.timeout = timeoutVal;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public String toString() {
        return "Bean ID = " + this.beanId + " : Timeout = " + this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTimedOut() {
        if (this.timeout > 0L) {
            TimeoutElement timeoutElement = this;
            synchronized (timeoutElement) {
                long now = System.currentTimeMillis();
                if (now - this.lastAccessTime >= this.timeout) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Session bean timed out", (Object[])new Object[]{"Current Time: " + new Date(now) + " Last Access Time: " + new Date(this.lastAccessTime) + " Timeout: " + this.timeout + " ms"});
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

