/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.wim.ConfigConstants;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.websphere.security.wim.ras.WIMTraceHelper;
import com.ibm.ws.config.xml.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.kerberos.auth.KerberosService;
import com.ibm.ws.security.wim.FactoryManager;
import com.ibm.ws.security.wim.adapter.ldap.CachedNamingEnumeration;
import com.ibm.ws.security.wim.adapter.ldap.LdapAttribute;
import com.ibm.ws.security.wim.adapter.ldap.LdapConfigManager;
import com.ibm.ws.security.wim.adapter.ldap.LdapEntity;
import com.ibm.ws.security.wim.adapter.ldap.LdapEntry;
import com.ibm.ws.security.wim.adapter.ldap.LdapHelper;
import com.ibm.ws.security.wim.adapter.ldap.LdapURL;
import com.ibm.ws.security.wim.adapter.ldap.context.ContextManager;
import com.ibm.ws.security.wim.adapter.ldap.context.TimedDirContext;
import com.ibm.ws.security.wim.env.ICacheUtil;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.MissingInitPropertyException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.exception.WIMSystemException;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LdapConnection {
    private static final String SERVER2 = "server";
    private static final String FAILOVER_SERVERS = "failoverServers";
    private static final TraceComponent tc = Tr.register(LdapConnection.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
    private String iReposId = null;
    private static final String KEY_ID = "config.id";
    private boolean iSearchResultsCacheEnabled = true;
    private String iSearchResultsCacheName = "SearchResultsCache";
    private ICacheUtil iSearchResultsCache = null;
    private int iSearchResultsCacheSize = 2000;
    private long iSearchResultsCacheTimeOut = 1200000L;
    private int iSearchResultSizeLmit = 2000;
    private boolean iAttrsCacheEnabled = true;
    private String iAttrsCacheName = "AttributesCache";
    private ICacheUtil iAttrsCache = null;
    private int iAttrsCacheSize = 4000;
    private long iAttrsCacheTimeOut = 1200000L;
    private int iAttrsSizeLmit = 2000;
    private int iCountLimit = 1000;
    private int iTimeLimit = 60000;
    private LdapConfigManager iLdapConfigMgr = null;
    private int iAttrRangeStep;
    private static final String ATTR_RANGE_KEYWORD = ";range=";
    private static final String ATTR_RANGE_QUERY = ";range={0}-{1}";
    private static final String ATTR_RANGE_LAST_QUERY = ";range={0}-*";
    private static final String LDAP_DN = "distinguishedName";
    private int iPageSize = 0;
    private NameParser iNameParser = null;
    protected String iSSLFactory = null;
    private boolean ignoreDNCase = true;
    private ContextManager iContextManager;
    private KerberosService kerberosService = null;
    private ConfigurationAdmin configAdmin = null;
    static final long serialVersionUID = -6280028580588483274L;

    @Trivial
    private static String toKey(String name, String filter, SearchControls cons) {
        int length = name.length() + filter.length() + 100;
        StringBuffer key = new StringBuffer(length);
        key.append(name);
        key.append("|");
        key.append(filter);
        key.append("|");
        key.append(cons.getSearchScope());
        key.append("|");
        key.append(cons.getCountLimit());
        key.append("|");
        key.append(cons.getTimeLimit());
        String[] attrIds = cons.getReturningAttributes();
        if (attrIds != null) {
            for (int i = 0; i < attrIds.length; ++i) {
                key.append("|");
                key.append(attrIds[i]);
            }
        }
        return key.toString();
    }

    @Trivial
    private static String toKey(String name, String filterExpr, Object[] filterArgs, SearchControls cons) {
        int i;
        int length = name.length() + filterExpr.length() + filterArgs.length + 200;
        StringBuffer key = new StringBuffer(length);
        key.append(name);
        key.append("|");
        key.append(filterExpr);
        String[] attrIds = cons.getReturningAttributes();
        for (i = 0; i < filterArgs.length; ++i) {
            key.append("|");
            key.append(filterArgs[i]);
        }
        if (attrIds != null) {
            for (i = 0; i < attrIds.length; ++i) {
                key.append("|");
                key.append(attrIds[i]);
            }
        }
        return key.toString();
    }

    /*
     * WARNING - void declaration
     */
    public NameParser getNameParser() throws WIMException {
        if (this.iNameParser == null) {
            TimedDirContext ctx = this.iContextManager.getDirContext();
            try {
                try {
                    this.iNameParser = ctx.getNameParser("");
                }
                catch (NamingException namingException) {
                    void e;
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"287", (Object)this, (Object[])new Object[0]);
                    if (!ContextManager.isConnectionException((NamingException)e)) {
                        throw e;
                    }
                    ctx = this.iContextManager.reCreateDirContext(ctx, e.toString());
                    this.iNameParser = ctx.getNameParser("");
                }
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"294", (Object)this, (Object[])new Object[0]);
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])new Object[]{WIMMessageHelper.generateMsgParms((Object)e.toString(true)), e});
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
            finally {
                this.iContextManager.releaseDirContext(ctx);
            }
        }
        return this.iNameParser;
    }

    public LdapConnection(LdapConfigManager ldapConfigMgr, KerberosService ks, ConfigurationAdmin configAdminRef) {
        this.iLdapConfigMgr = ldapConfigMgr;
        this.kerberosService = ks;
        this.configAdmin = configAdminRef;
    }

    public void initialize(Map<String, Object> configProps) throws WIMException {
        this.iReposId = (String)configProps.get(KEY_ID);
        if (configProps.containsKey("searchTimeout")) {
            long val = Long.parseLong(String.valueOf(configProps.get("searchTimeout")));
            this.iTimeLimit = (int)val;
        }
        if (configProps.containsKey("searchCountLimit")) {
            this.iCountLimit = (Integer)configProps.get("searchCountLimit");
        }
        if (configProps.containsKey("searchPageSize")) {
            this.iPageSize = (Integer)configProps.get("searchPageSize");
        } else if ("MICROSOFT ACTIVE DIRECTORY".equalsIgnoreCase(this.iLdapConfigMgr.getLdapType())) {
            this.iPageSize = 1000;
        }
        if (configProps.containsKey("attributeRangeStep")) {
            this.iAttrRangeStep = Integer.parseInt((String)configProps.get("attributeRangeStep"));
        } else if ("MICROSOFT ACTIVE DIRECTORY".equalsIgnoreCase(this.iLdapConfigMgr.getLdapType())) {
            this.iAttrRangeStep = 1000;
        }
        this.ignoreDNCase = (Boolean)configProps.get(ConfigConstants.CONFIG_IGNORE_CASE);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set ignoreDNCase as [" + this.ignoreDNCase + "]"), (Object[])new Object[0]);
        }
        this.initializeContextManager(configProps);
        this.initializeCaches(configProps);
    }

    private void initializeContextManager(Map<String, Object> configProps) throws WIMException {
        this.iContextManager = new ContextManager();
        this.iContextManager.setSSLAlias((String)configProps.get("sslRef"));
        this.iContextManager.setSSLEnabled((Boolean)configProps.get("sslEnabled"));
        this.iContextManager.setPrimaryServer((String)configProps.get("host"), (Integer)configProps.get("port"));
        for (Map serverConfig : Nester.nest((String)FAILOVER_SERVERS, configProps)) {
            List servers = Nester.nest((String)SERVER2, (Map)serverConfig);
            for (Map server : servers) {
                this.iContextManager.addFailoverServer((String)server.get("host"), (Integer)server.get("port"));
            }
        }
        this.iContextManager.setWriteToSecondary((Boolean)configProps.get("allowWriteToSecondaryServers"));
        this.iContextManager.setReturnToPrimary((Boolean)configProps.get("returnToPrimaryServer"));
        this.iContextManager.setQueryInterval((Integer)configProps.get("primaryServerQueryTimeInterval") * 60);
        String bindAuthMech = (String)configProps.get("bindAuthMechanism");
        if (bindAuthMech != null) {
            this.iContextManager.setBindAuthMechanism(bindAuthMech);
        }
        if (bindAuthMech == null || !bindAuthMech.equals("GSSAPI")) {
            this.iContextManager.setSimpleCredentials((String)configProps.get("bindDN"), (SerializableProtectedString)configProps.get("bindPassword"));
        } else {
            this.iContextManager.setKerberosCredentials(this.iReposId, this.kerberosService, (String)configProps.get("krb5Principal"), (String)configProps.get("krb5TicketCache"), this.configAdmin);
        }
        this.iContextManager.setConnectTimeout((Long)configProps.get("connectTimeout"));
        this.iContextManager.setReadTimeout((Long)configProps.get("readTimeout"));
        this.iContextManager.setJndiOutputEnabled((Boolean)configProps.get("jndiOutputEnabled"));
        String referal = (String)configProps.get("referal");
        String referral = (String)configProps.get("referral");
        referral = referal != null ? referal : referral;
        this.iContextManager.setReferral(referral.toLowerCase());
        this.iContextManager.setDerefAliases((String)configProps.get("derefAliases"));
        this.iContextManager.setBinaryAttributeNames(this.getBinaryAttributes());
        boolean enableContextPool = true;
        List poolConfigs = Nester.nest((String)"contextPool", configProps);
        Map poolConfig = null;
        if (!poolConfigs.isEmpty()) {
            poolConfig = (Map)poolConfigs.get(0);
        }
        boolean reuseConn = (Boolean)configProps.get("reuseConnection");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set reuseConnection as [" + reuseConn + "]"), (Object[])new Object[0]);
        }
        if (poolConfig != null) {
            enableContextPool = (Boolean)poolConfig.get("enabled");
        }
        if (!reuseConn) {
            enableContextPool = false;
        }
        Integer initPoolSize = null;
        Integer maxPoolSize = null;
        Integer prefPoolSize = null;
        Long poolTimeOut = null;
        Long poolWaitTime = null;
        if (enableContextPool && poolConfig != null) {
            if (poolConfig.get("initialSize") != null) {
                initPoolSize = (Integer)poolConfig.get("initialSize");
            }
            if (poolConfig.get("maxSize") != null) {
                maxPoolSize = (Integer)poolConfig.get("maxSize");
            }
            if (poolConfig.get("preferredSize") != null) {
                prefPoolSize = (Integer)poolConfig.get("preferredSize");
            }
            if (poolConfig.get("timeout") != null) {
                poolTimeOut = (Long)poolConfig.get("timeout");
                poolTimeOut = poolTimeOut > 0L && poolTimeOut <= 1000L ? Long.valueOf(1L) : Long.valueOf(this.roundToSeconds(poolTimeOut));
            }
            if (poolConfig.get("waitTime") != null) {
                poolWaitTime = (Long)poolConfig.get("waitTime");
            }
        }
        this.iContextManager.setContextPool(enableContextPool, initPoolSize, prefPoolSize, maxPoolSize, poolTimeOut, poolWaitTime);
        ContextManager.InitializeResult result = this.iContextManager.initialize();
        if (result == ContextManager.InitializeResult.MISSING_PASSWORD) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"MISSING_INI_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms((Object)"bindPassword"));
            throw new MissingInitPropertyException("MISSING_INI_PROPERTY", msg);
        }
        if (result == ContextManager.InitializeResult.MISSING_KRB5_PRINCIPAL_NAME) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"MISSING_INI_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms((Object)"krb5Principal"));
            throw new MissingInitPropertyException("MISSING_INI_PROPERTY", msg);
        }
    }

    private void initializeCaches(Map<String, Object> configProps) {
        String METHODNAME = "initializeCaches(DataObject)";
        this.iAttrsCacheName = this.iReposId + "/" + this.iAttrsCacheName;
        this.iSearchResultsCacheName = this.iReposId + "/" + this.iSearchResultsCacheName;
        List cacheConfigs = Nester.nest((String)"ldapCache", configProps);
        Map attrCacheConfig = null;
        Map searchResultsCacheConfig = null;
        if (!cacheConfigs.isEmpty()) {
            List searchList;
            Map cacheConfig = (Map)cacheConfigs.get(0);
            Map cacheInfo = Nester.nest((Map)cacheConfig, (String[])new String[]{"attributesCache", "searchResultsCache"});
            List attrList = (List)cacheInfo.get("attributesCache");
            if (!attrList.isEmpty()) {
                attrCacheConfig = (Map)attrList.get(0);
            }
            if (!(searchList = (List)cacheInfo.get("searchResultsCache")).isEmpty()) {
                searchResultsCacheConfig = (Map)searchList.get(0);
            }
            if (attrCacheConfig != null) {
                this.iAttrsCacheEnabled = (Boolean)attrCacheConfig.get("enabled");
                if (this.iAttrsCacheEnabled) {
                    this.iAttrsCacheSize = (Integer)attrCacheConfig.get("size");
                    this.iAttrsCacheTimeOut = (Long)attrCacheConfig.get("timeout");
                    this.iAttrsSizeLmit = (Integer)attrCacheConfig.get("sizeLimit");
                }
            }
            if (searchResultsCacheConfig != null) {
                this.iSearchResultsCacheEnabled = (Boolean)searchResultsCacheConfig.get("enabled");
                if (this.iSearchResultsCacheEnabled) {
                    this.iSearchResultsCacheSize = (Integer)searchResultsCacheConfig.get("size");
                    this.iSearchResultsCacheTimeOut = (Long)searchResultsCacheConfig.get("timeout");
                    this.iSearchResultSizeLmit = (Integer)searchResultsCacheConfig.get("resultsSizeLimit");
                }
            }
        }
        if (this.iAttrsCacheEnabled) {
            this.createAttributesCache();
            if (this.iAttrsCache == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("initializeCaches(DataObject) Attributes Cache: " + this.iAttrsCacheName + " is not available because cache is not available yet."), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initializeCaches(DataObject) Attributes Cache: " + this.iAttrsCacheName + " is disabled."), (Object[])new Object[0]);
        }
        if (this.iSearchResultsCacheEnabled) {
            this.createSearchResultsCache();
            if (this.iSearchResultsCache == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("initializeCaches(DataObject) Search Results Cache: " + this.iSearchResultsCacheName + " is not available because cache is not available yet."), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initializeCaches(DataObject) Search Results Cache: " + this.iSearchResultsCacheName + " is disabled."), (Object[])new Object[0]);
        }
    }

    private void createSearchResultsCache() {
        String METHODNAME = "createSearchResultsCache";
        if (this.iSearchResultsCacheEnabled && FactoryManager.getCacheUtil().isCacheAvailable()) {
            this.iSearchResultsCache = FactoryManager.getCacheUtil().initialize("SearchResultsCache", this.iSearchResultsCacheSize, this.iSearchResultsCacheSize, this.iSearchResultsCacheTimeOut);
            if (this.iSearchResultsCache != null && tc.isDebugEnabled()) {
                StringBuilder strBuf = new StringBuilder("createSearchResultsCache");
                strBuf.append(" \nSearch Results Cache: ").append(this.iSearchResultsCacheName).append(" is enabled:\n");
                strBuf.append("\tCacheSize: ").append(this.iSearchResultsCacheSize).append("\n");
                strBuf.append("\tCacheTimeOut: ").append(this.iSearchResultsCacheTimeOut).append("\n");
                strBuf.append("\tCacheResultSizeLimit: ").append(this.iSearchResultSizeLmit).append("\n");
                Tr.debug((TraceComponent)tc, (String)strBuf.toString(), (Object[])new Object[0]);
            }
        }
    }

    private void createAttributesCache() {
        String METHODNAME = "createAttributesCache";
        if (this.iAttrsCacheEnabled && FactoryManager.getCacheUtil().isCacheAvailable()) {
            this.iAttrsCache = FactoryManager.getCacheUtil().initialize("AttributesCache", this.iAttrsCacheSize, this.iAttrsCacheSize, this.iAttrsCacheTimeOut);
            if (this.iAttrsCache != null && tc.isDebugEnabled()) {
                StringBuilder strBuf = new StringBuilder("createAttributesCache");
                strBuf.append(" \nAttributes Cache: ").append(this.iAttrsCacheName).append(" is enabled:\n");
                strBuf.append("\tCacheSize: ").append(this.iAttrsCacheSize).append("\n");
                strBuf.append("\tCacheTimeOut: ").append(this.iAttrsCacheTimeOut).append("\n");
                strBuf.append("\tCacheSizeLimit: ").append(this.iAttrsSizeLmit).append("\n");
                Tr.debug((TraceComponent)tc, (String)strBuf.toString(), (Object[])new Object[0]);
            }
        }
    }

    private ICacheUtil getSearchResultsCache() {
        if (this.iSearchResultsCache == null) {
            this.createSearchResultsCache();
        }
        return this.iSearchResultsCache;
    }

    private ICacheUtil getAttributesCache() {
        if (this.iAttrsCache == null) {
            this.createAttributesCache();
        }
        return this.iAttrsCache;
    }

    /*
     * WARNING - void declaration
     */
    public void clearCaches() {
        block4: {
            try {
                if (this.iSearchResultsCache != null) {
                    this.iSearchResultsCache.clear();
                }
                if (this.iAttrsCache != null) {
                    this.iAttrsCache.clear();
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"725", (Object)this, (Object[])new Object[0]);
                if (!tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"clearCaches Unexpected exception occurred while clearing the search and attributes cache", (Object[])new Object[]{e});
            }
        }
    }

    public void invalidateAttributes(String DN, String extId, String uniqueName) {
        String METHODNAME = "invalidateAttributes(String, String, String)";
        if (this.getAttributesCache() != null) {
            if (DN != null) {
                this.getAttributesCache().invalidate((Object)this.toKey(DN));
            }
            if (extId != null) {
                this.getAttributesCache().invalidate((Object)extId);
            }
            if (uniqueName != null) {
                this.getAttributesCache().invalidate((Object)this.toKey(uniqueName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invalidateAttributes(String, String, String) " + this.iAttrsCacheName + " size: " + this.getAttributesCache().size()), (Object[])new Object[0]);
            }
        }
    }

    public void invalidateSearchCache() {
        if (this.getSearchResultsCache() != null) {
            this.getSearchResultsCache().clear();
        }
    }

    public void invalidateAttributeCache() {
        if (this.getAttributesCache() != null) {
            this.getAttributesCache().clear();
        }
    }

    @Trivial
    private String toKey(String name) {
        if (this.ignoreDNCase) {
            return name.toLowerCase();
        }
        return name;
    }

    @Trivial
    public boolean isIgnoreCase() {
        return this.ignoreDNCase;
    }

    public LdapEntry getEntityByIdentifier(IdentifierType id, List<String> inEntityTypes, List<String> propNames, boolean getMbrshipAttr, boolean getMbrAttr) throws WIMException {
        return this.getEntityByIdentifier(id.getExternalName(), id.getExternalId(), id.getUniqueName(), inEntityTypes, propNames, getMbrshipAttr, getMbrAttr);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LdapEntry getEntityByIdentifier(String dn, String extId, String uniqueName, List<String> inEntityTypes, List<String> propNames, boolean getMbrshipAttr, boolean getMbrAttr) throws WIMException {
        Attributes attrs;
        block7: {
            String[] attrIds;
            block9: {
                block8: {
                    attrIds = this.iLdapConfigMgr.getAttributeNames(inEntityTypes, propNames, getMbrshipAttr, getMbrAttr);
                    attrs = null;
                    if (dn == null && !this.iLdapConfigMgr.needTranslateRDN()) {
                        dn = this.iLdapConfigMgr.switchToLdapNode(uniqueName);
                    }
                    if (dn == null) break block8;
                    attrs = this.checkAttributesCache(dn, attrIds);
                    break block7;
                }
                if (extId == null) break block9;
                if (this.iLdapConfigMgr.isAnyExtIdDN()) {
                    dn = LdapHelper.getValidDN(extId);
                    if (dn != null) {
                        attrs = this.checkAttributesCache(dn, attrIds);
                        break block7;
                    } else {
                        if (uniqueName == null) {
                            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms(null));
                            throw new EntityNotFoundException("ENTITY_NOT_FOUND", msg);
                        }
                        attrs = this.getAttributesByUniqueName(uniqueName, attrIds, inEntityTypes);
                        dn = LdapHelper.getDNFromAttributes(attrs);
                    }
                    break block7;
                } else {
                    attrs = this.getAttributesByUniqueName(extId, attrIds, inEntityTypes);
                    dn = LdapHelper.getDNFromAttributes(attrs);
                }
                break block7;
            }
            if (uniqueName == null) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms(null));
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", msg);
            }
            attrs = this.getAttributesByUniqueName(uniqueName, attrIds, inEntityTypes);
            dn = LdapHelper.getDNFromAttributes(attrs);
        }
        String entityType = this.iLdapConfigMgr.getEntityType(attrs, uniqueName, dn, extId, inEntityTypes);
        uniqueName = this.getUniqueName(dn, entityType, attrs);
        if (extId != null) return new LdapEntry(dn, extId, uniqueName, entityType, attrs);
        extId = this.iLdapConfigMgr.getExtIdFromAttributes(dn, entityType, attrs);
        return new LdapEntry(dn, extId, uniqueName, entityType, attrs);
    }

    /*
     * WARNING - void declaration
     */
    private String getUniqueName(String dn, String entityType, Attributes attrs) throws WIMException {
        String METHODNAME = "getUniqueName";
        String uniqueName = null;
        dn = this.iLdapConfigMgr.switchToNode(dn);
        if (this.iLdapConfigMgr.needTranslateRDN() && this.iLdapConfigMgr.needTranslateRDN(entityType)) {
            try {
                LdapEntity ldapEntity;
                if (entityType != null && (ldapEntity = this.iLdapConfigMgr.getLdapEntity(entityType)) != null) {
                    String[] rdnName = LdapHelper.getRDNAttributes(dn);
                    String[][] rdnWIMProps = ldapEntity.getWIMRDNProperties();
                    String[][] rdnWIMAttrs = ldapEntity.getWIMRDNAttributes();
                    String[][] rdnAttrs = ldapEntity.getRDNAttributes();
                    Attribute[] rdnAttributes = new Attribute[rdnWIMProps.length];
                    String[] rdnAttrValues = new String[rdnWIMProps.length];
                    for (int i = 0; i < rdnAttrs.length; ++i) {
                        int k;
                        String[] rdnAttr = rdnAttrs[i];
                        boolean isRDN = false;
                        block3: for (int j = 0; j < rdnAttr.length; ++j) {
                            for (int k2 = 0; k2 < rdnName.length; ++k2) {
                                if (!rdnAttr[j].equalsIgnoreCase(rdnName[k2])) continue;
                                isRDN = true;
                                continue block3;
                            }
                        }
                        if (!isRDN) continue;
                        String[] rdnWIMProp = rdnWIMProps[i];
                        String[] rdnWIMAttr = rdnWIMAttrs[i];
                        boolean retrieveRDNs = false;
                        if (attrs == null) {
                            retrieveRDNs = true;
                        } else {
                            for (k = 0; k < rdnWIMAttr.length; ++k) {
                                if (attrs.get(rdnWIMAttr[k]) != null) continue;
                                retrieveRDNs = true;
                                break;
                            }
                        }
                        if (retrieveRDNs) {
                            attrs = this.getAttributes(dn, rdnWIMAttr);
                        }
                        for (k = 0; k < rdnWIMAttr.length; ++k) {
                            rdnAttributes[k] = attrs.get(rdnWIMAttr[k]);
                            if (rdnAttributes[k] == null) continue;
                            rdnAttrValues[k] = (String)rdnAttributes[k].get();
                        }
                        uniqueName = LdapHelper.replaceRDN(dn, rdnWIMProp, rdnAttrValues);
                    }
                }
            }
            catch (NamingException ldapEntity) {
                void e;
                FFDCFilter.processException((Throwable)ldapEntity, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"946", (Object)this, (Object[])new Object[]{dn, entityType, attrs});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
        }
        if (uniqueName == null) {
            uniqueName = dn;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getUniqueName Translated uniqueName: " + uniqueName), (Object[])new Object[0]);
        }
        return uniqueName;
    }

    @FFDCIgnore(value={NamingException.class, NameNotFoundException.class})
    private Attributes getAttributes(String name, String[] attrIds) throws WIMException {
        Attributes attributes;
        block14: {
            attributes = null;
            if (this.iLdapConfigMgr.getUseEncodingInSearchExpression() != null) {
                name = LdapHelper.encodeAttribute(name, this.iLdapConfigMgr.getUseEncodingInSearchExpression());
            }
            if (this.iAttrRangeStep > 0) {
                attributes = this.getRangeAttributes(name, attrIds);
            } else {
                TimedDirContext ctx = this.iContextManager.getDirContext();
                try {
                    try {
                        if (attrIds.length > 0) {
                            attributes = ctx.getAttributes(new LdapName(name), attrIds);
                            break block14;
                        }
                        attributes = new BasicAttributes();
                    }
                    catch (NamingException e) {
                        if (!ContextManager.isConnectionException(e)) {
                            throw e;
                        }
                        ctx = this.iContextManager.reCreateDirContext(ctx, e.toString());
                        if (attrIds.length > 0) {
                            attributes = ctx.getAttributes(new LdapName(name), attrIds);
                            break block14;
                        }
                        attributes = new BasicAttributes();
                    }
                }
                catch (NameNotFoundException e) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_ENTRY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)name, (Object)e.toString(true)));
                    throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", msg, (Throwable)e);
                }
                catch (NamingException e) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                    throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                }
                finally {
                    this.iContextManager.releaseDirContext(ctx);
                }
            }
        }
        return attributes;
    }

    @FFDCIgnore(value={NameNotFoundException.class, NamingException.class})
    private Attributes getRangeAttributes(String name, String[] attrIds) throws WIMException {
        Attributes attributes = null;
        TimedDirContext ctx = this.iContextManager.getDirContext();
        try {
            try {
                attributes = ctx.getAttributes(new LdapName(name), attrIds);
            }
            catch (NamingException e) {
                if (!ContextManager.isConnectionException(e)) {
                    throw e;
                }
                ctx = this.iContextManager.reCreateDirContext(ctx, e.toString());
                attributes = ctx.getAttributes(new LdapName(name), attrIds);
            }
            this.supportRangeAttributes(attributes, name, ctx);
        }
        catch (NameNotFoundException e) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_ENTRY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)name, (Object)e.toString(true)));
            throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", msg, (Throwable)e);
        }
        catch (NamingException e) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        finally {
            this.iContextManager.releaseDirContext(ctx);
        }
        return attributes;
    }

    public Attributes checkAttributesCache(String name, String[] attrIds) throws WIMException {
        String METHODNAME = "checkAttributesCache";
        Attributes attributes = null;
        if (this.getAttributesCache() != null) {
            String key = this.toKey(name);
            Object cached = this.getAttributesCache().get((Object)key);
            if (cached != null && cached instanceof Attributes) {
                ArrayList<String> missAttrIdList = new ArrayList<String>(attrIds.length);
                Attributes cachedAttrs = (Attributes)cached;
                attributes = new BasicAttributes(true);
                for (int i = 0; i < attrIds.length; ++i) {
                    Attribute attr = LdapHelper.getIngoreCaseAttribute(cachedAttrs, attrIds[i]);
                    if (attr != null) {
                        attributes.put(attr);
                        continue;
                    }
                    missAttrIdList.add(attrIds[i]);
                }
                if (missAttrIdList.size() > 0) {
                    Object[] missAttrIds = missAttrIdList.toArray(new String[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("checkAttributesCache Miss cache: " + key + " " + WIMTraceHelper.printObjectArray((Object[])missAttrIds)), (Object[])new Object[0]);
                    }
                    Attributes missAttrs = this.getAttributes(name, (String[])missAttrIds);
                    this.addAttributes(missAttrs, attributes);
                    this.updateAttributesCache(key, missAttrs, cachedAttrs, (String[])missAttrIds);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkAttributesCache Hit cache: " + key), (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkAttributesCache Miss cache: " + key), (Object[])new Object[0]);
                }
                attributes = this.getAttributes(name, attrIds);
                this.updateAttributesCache(key, attributes, null, attrIds);
            }
        } else {
            attributes = this.getAttributes(name, attrIds);
        }
        return attributes;
    }

    @Trivial
    private void addAttributes(Attributes sourceAttrs, Attributes descAttrs) {
        NamingEnumeration<? extends Attribute> neu = sourceAttrs.getAll();
        while (neu.hasMoreElements()) {
            descAttrs.put((Attribute)neu.nextElement());
        }
    }

    private void updateAttributesCache(String uniqueNameKey, String dn, Attributes newAttrs, String[] attrIds) {
        String METHODNAME = "updateAttributesCache(key,dn,newAttrs)";
        this.getAttributesCache().put((Object)uniqueNameKey, (Object)dn, 1, this.iAttrsCacheTimeOut, 0, null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateAttributesCache(key,dn,newAttrs) Update " + this.iAttrsCacheName + "(size: " + this.getAttributesCache().size() + ")\n" + uniqueNameKey + ": " + dn), (Object[])new Object[0]);
        }
        String dnKey = this.toKey(dn);
        Object cached = this.getAttributesCache().get((Object)dnKey);
        Attributes cachedAttrs = null;
        if (cached != null && cached instanceof Attributes) {
            cachedAttrs = (Attributes)cached;
        }
        this.updateAttributesCache(dnKey, newAttrs, cachedAttrs, attrIds);
    }

    private void updateAttributesCache(String key, Attributes missAttrs, Attributes cachedAttrs, String[] missAttrIds) {
        String METHODNAME = "updateAttributesCache(key,missAttrs,cachedAttrs,missAttrIds)";
        if (missAttrIds != null) {
            boolean newattr = false;
            if (missAttrIds.length > 0) {
                if (cachedAttrs != null) {
                    cachedAttrs = (Attributes)cachedAttrs.clone();
                } else {
                    cachedAttrs = new BasicAttributes(true);
                    newattr = true;
                }
                for (int i = 0; i < missAttrIds.length; ++i) {
                    boolean findAttr = false;
                    NamingEnumeration<? extends Attribute> neu = missAttrs.getAll();
                    while (neu.hasMoreElements()) {
                        Attribute attr = (Attribute)neu.nextElement();
                        if (attr.getID().equalsIgnoreCase(missAttrIds[i])) {
                            findAttr = true;
                            if (this.iAttrsSizeLmit > 0 && attr.size() > this.iAttrsSizeLmit) break;
                            cachedAttrs.put(attr);
                            break;
                        }
                        int pos = attr.getID().indexOf(";");
                        if (pos <= 0 || !missAttrIds[i].equalsIgnoreCase(attr.getID().substring(0, pos))) continue;
                        findAttr = true;
                        if (this.iAttrsSizeLmit > 0 && attr.size() > this.iAttrsSizeLmit) break;
                        cachedAttrs.put(attr);
                        break;
                    }
                    if (findAttr) continue;
                    BasicAttribute nullAttr = new BasicAttribute(missAttrIds[i], null);
                    cachedAttrs.put(nullAttr);
                }
                if (newattr) {
                    this.getAttributesCache().put((Object)key, (Object)cachedAttrs, 1, this.iAttrsCacheTimeOut, 0, null);
                } else {
                    this.getAttributesCache().put(key, (Object)cachedAttrs);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updateAttributesCache(key,missAttrs,cachedAttrs,missAttrIds) Update " + this.iAttrsCacheName + "(size: " + this.getAttributesCache().size() + " newEntry: " + newattr + ")\n" + key + ": " + cachedAttrs), (Object[])new Object[0]);
                }
            }
        } else {
            this.updateAttributesCache(key, missAttrs, cachedAttrs);
        }
    }

    private void updateAttributesCache(String key, Attributes missAttrs, Attributes cachedAttrs) {
        String METHODNAME = "updateAttributeCache(key,missAttrs,cachedAttrs)";
        if (missAttrs.size() > 0) {
            boolean newAttr = false;
            if (cachedAttrs != null) {
                cachedAttrs = (Attributes)cachedAttrs.clone();
            } else {
                cachedAttrs = new BasicAttributes(true);
                newAttr = true;
            }
            NamingEnumeration<? extends Attribute> neu = missAttrs.getAll();
            while (neu.hasMoreElements()) {
                Attribute attr = (Attribute)neu.nextElement();
                if (this.iAttrsSizeLmit > 0 && attr.size() > this.iAttrsSizeLmit) continue;
                cachedAttrs.put(attr);
            }
            if (newAttr) {
                this.getAttributesCache().put((Object)key, (Object)cachedAttrs, 1, this.iAttrsCacheTimeOut, 0, null);
            } else {
                this.getAttributesCache().put(key, (Object)cachedAttrs);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updateAttributeCache(key,missAttrs,cachedAttrs) Update " + this.iAttrsCacheName + "(size: " + this.getAttributesCache().size() + " newEntry: " + newAttr + ")\n" + key + ": " + cachedAttrs), (Object[])new Object[0]);
            }
        }
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, int scope, String[] attrIds) throws WIMException {
        SearchControls controls = new SearchControls(scope, this.iCountLimit, this.iTimeLimit, attrIds, false, false);
        return this.checkSearchCache(name, filter, null, controls);
    }

    private NamingEnumeration<SearchResult> checkSearchCache(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws WIMException {
        String METHODNAME = "checkSearchCache";
        NamingEnumeration<SearchResult> neu = null;
        if (this.getSearchResultsCache() != null) {
            String key = null;
            key = filterArgs == null ? LdapConnection.toKey(name, filterExpr, cons) : LdapConnection.toKey(name, filterExpr, filterArgs, cons);
            CachedNamingEnumeration cached = (CachedNamingEnumeration)this.getSearchResultsCache().get((Object)key);
            if (cached == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkSearchCache Miss cache: " + key), (Object[])new Object[0]);
                }
                neu = this.search(name, filterExpr, filterArgs, cons, null);
                String[] reqAttrIds = cons.getReturningAttributes();
                neu = this.updateSearchCache(name, key, neu, reqAttrIds);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkSearchCache Hit cache: " + key), (Object[])new Object[0]);
                }
                neu = (CachedNamingEnumeration)cached.clone();
            }
        } else {
            neu = this.search(name, filterExpr, filterArgs, cons, null);
        }
        return neu;
    }

    @FFDCIgnore(value={NamingException.class})
    private NamingEnumeration<SearchResult> updateSearchCache(String searchBase, String key, NamingEnumeration<SearchResult> neu, String[] reqAttrIds) throws WIMSystemException {
        String METHODNAME = "updateSearchCache";
        CachedNamingEnumeration clone1 = new CachedNamingEnumeration();
        CachedNamingEnumeration clone2 = new CachedNamingEnumeration();
        int count = LdapConnection.cloneSearchResults(neu, clone1, clone2);
        if (this.iSearchResultSizeLmit == 0 || count < this.iSearchResultSizeLmit) {
            this.getSearchResultsCache().put((Object)key, (Object)clone2, 1, this.iSearchResultsCacheTimeOut, 0, null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updateSearchCache Update " + this.iSearchResultsCacheName + "(size: " + this.getSearchResultsCache().size() + ")\n" + key), (Object[])new Object[0]);
            }
            if (this.getAttributesCache() != null) {
                try {
                    count = 0;
                    while (clone2.hasMore()) {
                        SearchResult result = clone2.nextElement();
                        String dnKey = LdapHelper.prepareDN(result.getName(), searchBase);
                        Object cached = this.getAttributesCache().get((Object)dnKey);
                        Attributes cachedAttrs = null;
                        if (cached != null && cached instanceof Attributes) {
                            cachedAttrs = (Attributes)cached;
                        }
                        this.updateAttributesCache(dnKey, result.getAttributes(), cachedAttrs, reqAttrIds);
                        if (++count <= 20) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("updateSearchCache attribute cache updated with " + (count - 1) + " entries. skipping rest."), (Object[])new Object[0]);
                        }
                        break;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return clone1;
    }

    @FFDCIgnore(value={SizeLimitExceededException.class})
    private static int cloneSearchResults(NamingEnumeration<SearchResult> results, CachedNamingEnumeration clone1, CachedNamingEnumeration clone2) throws WIMSystemException {
        String METHODNAME = "cloneSearchResults(NamingEnumeration, CachedNamingEnumeration, CachedNamingEnumeration)";
        int count = 0;
        try {
            while (results.hasMore()) {
                SearchResult result = (SearchResult)results.nextElement();
                Attributes attrs = (Attributes)result.getAttributes().clone();
                SearchResult cachedResult = new SearchResult(result.getName(), null, null, attrs);
                clone1.add(result);
                clone2.add(cachedResult);
                ++count;
            }
        }
        catch (SizeLimitExceededException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cloneSearchResults(NamingEnumeration, CachedNamingEnumeration, CachedNamingEnumeration) " + e.toString(true)), (Object[])new Object[]{e});
            }
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1410", null, (Object[])new Object[]{results, clone1, clone2});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        return count;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons, Control[] requestControls) throws WIMException {
        CachedNamingEnumeration cachedNamingEnumeration;
        TimedDirContext ctx;
        block33: {
            String METHODNAME = "search(String, String, Object[], SearchControls)";
            if (this.iPageSize == 0) {
                TimedDirContext ctx2 = this.iContextManager.getDirContext();
                NamingEnumeration<SearchResult> neu = null;
                try {
                    try {
                        if (filterArgs == null) {
                            neu = ctx2.search(new LdapName(name), filterExpr, cons);
                            return neu;
                        }
                        neu = ctx2.search(new LdapName(name), filterExpr, filterArgs, cons);
                        return neu;
                    }
                    catch (NamingException namingException) {
                        void e;
                        FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1448", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                        if (!ContextManager.isConnectionException((NamingException)e)) {
                            throw e;
                        }
                        ctx2 = this.iContextManager.reCreateDirContext(ctx2, e.toString());
                        if (filterArgs == null) {
                            neu = ctx2.search(new LdapName(name), filterExpr, cons);
                            return neu;
                        }
                        neu = ctx2.search(new LdapName(name), filterExpr, filterArgs, cons);
                        return neu;
                    }
                }
                catch (NameNotFoundException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1459", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_ENTRY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)name, (Object)e.toString(true)));
                    throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", msg, (Throwable)e);
                }
                catch (NamingException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1462", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                    throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                }
                finally {
                    this.iContextManager.releaseDirContext(ctx2);
                }
            }
            ctx = this.iContextManager.getDirContext();
            try {
                boolean tryAgain;
                if (requestControls != null) {
                    ctx.setRequestControls(new Control[]{requestControls[0], new PagedResultsControl(this.iPageSize, false)});
                } else {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(this.iPageSize, false)});
                }
                byte[] cookie = null;
                int pageCount = 1;
                int count = 0;
                CachedNamingEnumeration allNeu = new CachedNamingEnumeration();
                int retries = 0;
                do {
                    tryAgain = false;
                    NamingEnumeration<SearchResult> neu = null;
                    try {
                        PagedResultsResponseControl resCtrl;
                        Control[] resCtrls;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("search(String, String, Object[], SearchControls) Search page: " + pageCount + ", Retries: " + retries), (Object[])new Object[0]);
                        }
                        if ((neu = filterArgs == null ? ctx.search(new LdapName(name), filterExpr, cons) : ctx.search(new LdapName(name), filterExpr, filterArgs, cons)) == null) continue;
                        ++pageCount;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"search(String, String, Object[], SearchControls) Received search results, looping through elements. May include referral chasing.", (Object[])new Object[0]);
                        }
                        while (neu.hasMoreElements()) {
                            SearchResult sr = (SearchResult)neu.nextElement();
                            if (this.iAttrRangeStep > 0) {
                                this.supportRangeAttributes(sr.getAttributes(), name, ctx);
                            }
                            allNeu.add(sr);
                            ++count;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("search(String, String, Object[], SearchControls) Received search results, looped through elements. Num of elements retrieved: " + count), (Object[])new Object[0]);
                        }
                        if ((resCtrls = ctx.getResponseControls()) == null || resCtrls.length <= 0 || (cookie = (resCtrl = (PagedResultsResponseControl)resCtrls[0]).getCookie()) == null || cookie.length <= 0) continue;
                        ctx.setRequestControls(new Control[]{new PagedResultsControl(this.iPageSize, cookie, false)});
                    }
                    catch (NamingException resCtrls) {
                        void e;
                        FFDCFilter.processException((Throwable)resCtrls, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1535", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                        if (!ContextManager.isConnectionException((NamingException)e)) throw e;
                        if (retries != 0) throw e;
                        tryAgain = true;
                        ++retries;
                        pageCount = 1;
                        cookie = null;
                        allNeu = new CachedNamingEnumeration();
                        count = 0;
                        ctx = this.iContextManager.reCreateDirContext(ctx, e.toString());
                        if (requestControls != null) {
                            ctx.setRequestControls(new Control[]{requestControls[0], new PagedResultsControl(this.iPageSize, false)});
                            continue;
                        }
                        ctx.setRequestControls(new Control[]{new PagedResultsControl(this.iPageSize, false)});
                    }
                } while (tryAgain || cookie != null && cookie.length > 0 && (long)count < cons.getCountLimit());
                cachedNamingEnumeration = allNeu;
            }
            catch (NamingException cookie) {
                try {
                    void e23333332;
                    FFDCFilter.processException((Throwable)cookie, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1570", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e23333332.toString(true)));
                    throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e23333332);
                    catch (IOException e23333332) {
                        FFDCFilter.processException((Throwable)e23333332, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1573", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                        msg = Tr.formatMessage((TraceComponent)tc, (String)"GENERIC", (Object[])WIMMessageHelper.generateMsgParms((Object)e23333332.toString()));
                        throw new WIMSystemException("GENERIC", msg, (Throwable)e23333332);
                    }
                }
                catch (Throwable throwable) {
                    block32: {
                        try {
                            ctx.setRequestControls(null);
                        }
                        catch (NamingException namingException) {
                            void e;
                            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1579", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                            if (!tc.isDebugEnabled()) break block32;
                            Tr.debug((TraceComponent)tc, (String)("search(String, String, Object[], SearchControls)" + e.toString(true)), (Object[])new Object[0]);
                        }
                    }
                    this.iContextManager.releaseDirContext(ctx);
                    throw throwable;
                }
            }
            try {
                ctx.setRequestControls(null);
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1579", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                if (!tc.isDebugEnabled()) break block33;
                Tr.debug((TraceComponent)tc, (String)("search(String, String, Object[], SearchControls)" + e.toString(true)), (Object[])new Object[0]);
            }
        }
        this.iContextManager.releaseDirContext(ctx);
        return cachedNamingEnumeration;
    }

    /*
     * WARNING - void declaration
     */
    public Attributes getAttributesByUniqueName(String uniqueName, String[] attrIds, List<String> entityTypes) throws WIMException {
        String DN = null;
        Attributes attributes = null;
        uniqueName = this.iLdapConfigMgr.switchToLdapNode(uniqueName);
        boolean needTranslate = false;
        if (this.iLdapConfigMgr.needTranslateRDN()) {
            if (entityTypes != null && entityTypes.size() > 0) {
                for (int i = 0; i < entityTypes.size(); ++i) {
                    if (!this.iLdapConfigMgr.needTranslateRDN(entityTypes.get(i))) continue;
                    needTranslate = true;
                    break;
                }
            } else {
                needTranslate = true;
            }
        }
        if (!needTranslate) {
            DN = uniqueName;
            attributes = this.checkAttributesCache(DN, attrIds);
            attributes.put(LDAP_DN, DN);
            return attributes;
        }
        boolean readFromCache = false;
        String uniqueNameKey = "UNIQUENAME::" + this.toKey(uniqueName);
        if (this.getAttributesCache() != null) {
            readFromCache = true;
            Object cached = this.getAttributesCache().get((Object)uniqueNameKey);
            if (cached != null && cached instanceof String) {
                DN = (String)cached;
                try {
                    attributes = this.checkAttributesCache(DN, attrIds);
                    attributes.put(LDAP_DN, DN);
                    return attributes;
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    FFDCFilter.processException((Throwable)entityNotFoundException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1641", (Object)this, (Object[])new Object[]{uniqueName, attrIds, entityTypes});
                    this.getAttributesCache().invalidate((Object)uniqueNameKey);
                }
            }
        }
        String filter = "objectclass=*";
        SearchControls controls = new SearchControls();
        controls.setTimeLimit(this.iTimeLimit);
        controls.setCountLimit(this.iCountLimit);
        controls.setSearchScope(0);
        controls.setReturningAttributes(attrIds);
        controls.setReturningObjFlag(false);
        TimedDirContext ctx = this.iContextManager.getDirContext();
        NamingEnumeration<SearchResult> neu = null;
        try {
            SearchResult thisEntry;
            try {
                neu = ctx.search(uniqueName, filter, controls);
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1665", (Object)this, (Object[])new Object[]{uniqueName, attrIds, entityTypes});
                if (!ContextManager.isConnectionException((NamingException)e)) {
                    throw e;
                }
                ctx = this.iContextManager.reCreateDirContext(ctx, e.toString());
                neu = ctx.search(uniqueName, filter, controls);
            }
            if (neu.hasMoreElements() && (thisEntry = (SearchResult)neu.nextElement()) != null) {
                DN = LdapHelper.prepareDN(thisEntry.getNameInNamespace(), null);
                attributes = thisEntry.getAttributes();
                if (this.iAttrRangeStep > 0) {
                    this.supportRangeAttributes(attributes, DN, ctx);
                }
            }
        }
        catch (NameNotFoundException thisEntry) {
            void e;
            FFDCFilter.processException((Throwable)thisEntry, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1683", (Object)this, (Object[])new Object[]{uniqueName, attrIds, entityTypes});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName));
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", msg, (Throwable)e);
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1686", (Object)this, (Object[])new Object[]{uniqueName, attrIds, entityTypes});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        finally {
            this.iContextManager.releaseDirContext(ctx);
        }
        if (attributes != null) {
            if (readFromCache) {
                this.updateAttributesCache(uniqueNameKey, DN, attributes, attrIds);
            }
        } else {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName));
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", msg);
        }
        attributes.put(LDAP_DN, DN);
        return attributes;
    }

    public Map<String, LdapEntry> getDynamicGroups(String[] bases, List<String> propNames, boolean getMbrshipAttr) throws WIMException {
        HashMap<String, LdapEntry> dynaGrps = new HashMap<String, LdapEntry>();
        String[] attrIds = this.iLdapConfigMgr.getAttributeNames(this.iLdapConfigMgr.getGroupTypes(), propNames, getMbrshipAttr, false);
        String[] dynaMbrAttrNames = this.iLdapConfigMgr.getDynamicMemberAttributes();
        String[] temp = attrIds;
        attrIds = new String[temp.length + dynaMbrAttrNames.length];
        System.arraycopy(temp, 0, attrIds, 0, temp.length);
        System.arraycopy(dynaMbrAttrNames, 0, attrIds, temp.length, dynaMbrAttrNames.length);
        String dynaGrpFitler = this.iLdapConfigMgr.getDynamicGroupFilter();
        for (String base : bases) {
            NamingEnumeration<SearchResult> urls = this.search(base, dynaGrpFitler, 2, attrIds);
            while (urls.hasMoreElements()) {
                String entryName;
                SearchResult thisEntry = (SearchResult)urls.nextElement();
                if (thisEntry == null || (entryName = thisEntry.getName()) == null || entryName.trim().length() == 0) continue;
                String dn = LdapHelper.prepareDN(entryName, base);
                Attributes attrs = thisEntry.getAttributes();
                String extId = this.iLdapConfigMgr.getExtIdFromAttributes(dn, "Group", attrs);
                String uniqueName = this.getUniqueName(dn, "Group", attrs);
                LdapEntry ldapEntry = new LdapEntry(dn, extId, uniqueName, "Group", attrs);
                dynaGrps.put(ldapEntry.getDN(), ldapEntry);
            }
        }
        return dynaGrps;
    }

    public boolean isMemberInURLQuery(LdapURL[] urls, String dn) throws WIMException {
        boolean result = false;
        String[] attrIds = new String[]{};
        String rdn = LdapHelper.getRDN(dn);
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                String returnedDN;
                SearchResult thisEntry;
                NamingEnumeration<SearchResult> nenu;
                String searchBase;
                LdapURL ldapURL = urls[i];
                if (!ldapURL.parsedOK() || !LdapHelper.isUnderBases(dn, searchBase = ldapURL.get_dn())) continue;
                int searchScope = ldapURL.get_searchScope();
                String searchFilter = ldapURL.get_filter();
                if (searchScope == 2) {
                    if (searchFilter == null) {
                        result = true;
                        break;
                    }
                    nenu = this.search(dn, searchFilter, 2, attrIds);
                    if (!nenu.hasMoreElements()) continue;
                    result = true;
                    break;
                }
                nenu = this.search(searchBase, searchFilter = searchFilter == null ? rdn : "(&(" + searchFilter + ")(" + rdn + "))", searchScope, attrIds);
                if (!nenu.hasMoreElements() || (thisEntry = (SearchResult)nenu.nextElement()) == null || !dn.equalsIgnoreCase(returnedDN = LdapHelper.prepareDN(thisEntry.getName(), searchBase))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Set<LdapEntry> searchEntities(String name, String filterExpr, Object[] filterArgs, int scope, List<String> inEntityTypes, List<String> propNames, boolean getMbrshipAttr, boolean getMbrAttr) throws WIMException {
        return this.searchEntities(name, filterExpr, filterArgs, scope, inEntityTypes, propNames, getMbrshipAttr, getMbrAttr, this.iCountLimit, this.iTimeLimit);
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, int scope, String[] attrIds, int countLimit, int timeLimit) throws WIMException {
        SearchControls controls = new SearchControls(scope, countLimit, timeLimit, attrIds, false, false);
        return this.checkSearchCache(name, filter, null, controls);
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, Object[] filterArgs, int scope, String[] attrIds, int countLimit, int timeLimit) throws WIMException {
        SearchControls controls = new SearchControls(scope, countLimit, timeLimit, attrIds, false, false);
        return this.checkSearchCache(name, filter, filterArgs, controls);
    }

    public Set<LdapEntry> searchEntities(String name, String filter, Object[] filterArgs, int scope, List<String> inEntityTypes, List<String> propNames, boolean getMbrshipAttr, boolean getMbrAttr, int countLimit, int timeLimit) throws WIMException {
        String inEntityType = null;
        List<String> supportedProps = propNames;
        if (inEntityTypes != null && inEntityTypes.size() > 0) {
            inEntityType = inEntityTypes.get(0);
            supportedProps = this.iLdapConfigMgr.getSupportedProperties(inEntityType, propNames);
        }
        String[] attrIds = this.iLdapConfigMgr.getAttributeNames(inEntityTypes, supportedProps, getMbrshipAttr, getMbrAttr);
        NamingEnumeration<SearchResult> neu = null;
        neu = filterArgs == null ? this.search(name, filter, scope, attrIds, countLimit, timeLimit) : this.search(name, filter, filterArgs, scope, attrIds, countLimit, timeLimit);
        Set<LdapEntry> entities = this.populateResultSet(neu, name, scope, inEntityTypes, attrIds);
        return entities;
    }

    @FFDCIgnore(value={SizeLimitExceededException.class})
    private Set<LdapEntry> populateResultSet(NamingEnumeration<SearchResult> neu, String base, int scope, List<String> inEntityTypes, String[] attrIds) throws WIMException {
        String METHODNAME = "populateResultSet";
        HashSet<LdapEntry> entities = new HashSet<LdapEntry>();
        try {
            while (neu.hasMore()) {
                SearchResult thisEntry = (SearchResult)neu.nextElement();
                if (thisEntry == null) continue;
                String entryName = thisEntry.getName();
                String dn = LdapHelper.prepareDN(entryName, base);
                if (scope != 0 && base.equalsIgnoreCase(dn)) continue;
                Attributes attrs = thisEntry.getAttributes();
                if (this.iLdapConfigMgr.isRacf() && attrs.size() == 0) {
                    attrs = this.getAttributes(dn, attrIds);
                }
                String entityType = this.iLdapConfigMgr.getEntityType(attrs, null, dn, null, inEntityTypes);
                if (this.iLdapConfigMgr.isRacf()) {
                    boolean entityTypeMatches = false;
                    for (String inType : inEntityTypes) {
                        if ("PersonAccount".equals(entityType)) {
                            entityTypeMatches = inType.equals("LoginAccount") || inType.equals("PersonAccount");
                        } else if ("Group".equals(entityType)) {
                            entityTypeMatches = inType.equals("Group");
                        }
                        if (!entityTypeMatches) continue;
                        break;
                    }
                    if (!entityTypeMatches) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("populateResultSet Excluding '" + dn + "' from result since it is unexpected entity type."), (Object[])new Object[0]);
                        continue;
                    }
                }
                String extId = this.iLdapConfigMgr.getExtIdFromAttributes(dn, entityType, attrs);
                String uniqueName = this.getUniqueName(dn, entityType, attrs);
                LdapEntry ldapEntry = new LdapEntry(dn, extId, uniqueName, entityType, attrs);
                entities.add(ldapEntry);
            }
        }
        catch (SizeLimitExceededException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("populateResultSet " + e.toString(true)), (Object[])new Object[0]);
            }
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2007", (Object)this, (Object[])new Object[]{neu, base, scope, inEntityTypes, attrIds});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        return entities;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getAncestorDNs(String DN, int level) throws WIMException {
        if (DN == null || DN.trim().length() == 0) {
            return null;
        }
        try {
            NameParser nameParser = this.getNameParser();
            Name name = nameParser.parse(DN);
            int size = name.size();
            ArrayList<String> ancestorDNs = new ArrayList<String>();
            if (level == 0) {
                level = size;
            }
            for (int i = size - 1; i >= size - level; --i) {
                name.remove(i);
                ancestorDNs.add(name.toString());
            }
            return ancestorDNs;
        }
        catch (NamingException nameParser) {
            void e;
            FFDCFilter.processException((Throwable)nameParser, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2042", (Object)this, (Object[])new Object[]{DN, level});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
    }

    @FFDCIgnore(value={NumberFormatException.class, NamingException.class})
    private void supportRangeAttributes(Attributes attributes, String dn, TimedDirContext ctx) throws WIMException, NamingException {
        String METHODNAME = "supportRangeAttributes";
        NamingEnumeration<? extends Attribute> anu = attributes.getAll();
        while (anu.hasMoreElements()) {
            Attribute attr = (Attribute)anu.nextElement();
            String attrName = attr.getID();
            int pos = attrName.indexOf(ATTR_RANGE_KEYWORD);
            if (pos <= -1) continue;
            String attrId = attrName.substring(0, pos);
            BasicAttribute newAttr = new BasicAttribute(attrId);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("supportRangeAttributes Range attribute retrieved: " + attrName), (Object[])new Object[0]);
            }
            NamingEnumeration<?> neu2 = attr.getAll();
            while (neu2.hasMoreElements()) {
                newAttr.add(neu2.nextElement());
            }
            int rangeLow = this.iAttrRangeStep;
            try {
                rangeLow = Integer.parseInt(attrName.substring(attrName.indexOf(45) + 1)) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int rangeHigh = rangeLow + this.iAttrRangeStep - 1;
            boolean quitLoop = false;
            boolean lastQuery = false;
            do {
                Object[] args;
                String attributeWithRange = null;
                if (!lastQuery) {
                    args = new Object[]{Integer.valueOf(rangeLow).toString(), Integer.valueOf(rangeHigh).toString()};
                    attributeWithRange = attrId + MessageFormat.format(ATTR_RANGE_QUERY, args);
                } else {
                    args = new Object[]{Integer.valueOf(rangeLow).toString()};
                    attributeWithRange = attrId + MessageFormat.format(ATTR_RANGE_LAST_QUERY, args);
                }
                Attributes results = null;
                String[] rAttrIds = new String[]{attributeWithRange};
                try {
                    results = ctx.getAttributes(new LdapName(dn), rAttrIds);
                }
                catch (NamingException e) {
                    if (ContextManager.isConnectionException(e)) {
                        ctx = this.iContextManager.reCreateDirContext(ctx, e.toString());
                        results = ctx.getAttributes(new LdapName(dn), rAttrIds);
                    }
                    throw e;
                }
                Attribute result = results.get(attributeWithRange);
                if (result == null) {
                    Object[] args2 = new Object[]{Integer.valueOf(rangeLow).toString()};
                    attributeWithRange = attrId + MessageFormat.format(ATTR_RANGE_LAST_QUERY, args2);
                    result = results.get(attributeWithRange);
                    lastQuery = true;
                }
                if (result != null) {
                    NamingEnumeration<?> neu22 = result.getAll();
                    while (neu22.hasMoreElements()) {
                        newAttr.add(neu22.nextElement());
                    }
                    if (lastQuery) {
                        quitLoop = true;
                        continue;
                    }
                    rangeLow = rangeHigh + 1;
                    rangeHigh = rangeLow + this.iAttrRangeStep - 1;
                    continue;
                }
                lastQuery = true;
            } while (!quitLoop);
            attributes.put(newAttr);
            attributes.remove(attrName);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SearchResult searchByOperationalAttribute(String dn, String filter, List<String> inEntityTypes, List<String> propNames, String oprAttribute) throws WIMException {
        String inEntityType = null;
        List<String> supportedProps = propNames;
        if (inEntityTypes != null && inEntityTypes.size() > 0) {
            inEntityType = inEntityTypes.get(0);
            supportedProps = this.iLdapConfigMgr.getSupportedProperties(inEntityType, propNames);
        }
        String[] attrIds = this.iLdapConfigMgr.getAttributeNames(inEntityTypes, supportedProps, false, false);
        attrIds = Arrays.copyOf(attrIds, attrIds.length + 1);
        attrIds[attrIds.length - 1] = oprAttribute;
        NamingEnumeration<SearchResult> neu = null;
        neu = this.search(dn, filter, 0, attrIds, this.iCountLimit, this.iTimeLimit);
        if (neu != null) {
            try {
                if (neu.hasMore()) {
                    return neu.next();
                }
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2178", (Object)this, (Object[])new Object[]{dn, filter, inEntityTypes, propNames, oprAttribute});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
        }
        return null;
    }

    private String getBinaryAttributes() {
        StringBuffer binaryAttrNamesBuffer = new StringBuffer();
        Map<String, LdapAttribute> attrMap = this.iLdapConfigMgr.getAttributes();
        for (String attrName : attrMap.keySet()) {
            LdapAttribute attr = attrMap.get(attrName);
            if (!"octetString".equalsIgnoreCase(attr.getSyntax())) continue;
            binaryAttrNamesBuffer.append(attr.getName()).append(" ");
        }
        return binaryAttrNamesBuffer.toString().trim();
    }

    /*
     * WARNING - void declaration
     */
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException, WIMException {
        TimedDirContext ctx = this.iContextManager.getDirContext();
        this.iContextManager.checkWritePermission(ctx);
        try {
            try {
                ctx.modifyAttributes(new LdapName(name), mods);
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2228", (Object)this, (Object[])new Object[]{name, mods});
                if (!ContextManager.isConnectionException((NamingException)e)) {
                    throw e;
                }
                ctx = this.iContextManager.reCreateDirContext(ctx, e.toString());
                ctx.modifyAttributes(new LdapName(name), mods);
            }
        }
        catch (NameNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2235", (Object)this, (Object[])new Object[]{name, mods});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new EntityNotFoundException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2238", (Object)this, (Object[])new Object[]{name, mods});
            throw e;
        }
        finally {
            this.iContextManager.releaseDirContext(ctx);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void modifyAttributes(String dn, int mod_op, Attributes attrs) throws NamingException, WIMException {
        TimedDirContext ctx = this.iContextManager.getDirContext();
        this.iContextManager.checkWritePermission(ctx);
        try {
            try {
                ctx.modifyAttributes(new LdapName(dn), mod_op, attrs);
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2262", (Object)this, (Object[])new Object[]{dn, mod_op, attrs});
                if (!ContextManager.isConnectionException((NamingException)e)) {
                    throw e;
                }
                ctx = this.iContextManager.reCreateDirContext(ctx, e.toString());
                ctx.modifyAttributes(new LdapName(dn), mod_op, attrs);
            }
        }
        catch (NameNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2269", (Object)this, (Object[])new Object[]{dn, mod_op, attrs});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new EntityNotFoundException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2272", (Object)this, (Object[])new Object[]{dn, mod_op, attrs});
            throw e;
        }
        finally {
            this.iContextManager.releaseDirContext(ctx);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void rename(String dn, String newDn) throws WIMException {
        TimedDirContext ctx = this.iContextManager.getDirContext();
        this.iContextManager.checkWritePermission(ctx);
        try {
            try {
                ctx.rename(dn, newDn);
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2296", (Object)this, (Object[])new Object[]{dn, newDn});
                if (!ContextManager.isConnectionException((NamingException)e)) {
                    throw e;
                }
                ctx = this.iContextManager.reCreateDirContext(ctx, e.toString());
                ctx.rename(dn, newDn);
            }
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2303", (Object)this, (Object[])new Object[]{dn, newDn});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        finally {
            this.iContextManager.releaseDirContext(ctx);
        }
    }

    public int getSearchTimeout() {
        return this.iTimeLimit;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(":{");
        sb.append("Repository ID=").append(this.iReposId).append("\n");
        sb.append(", SSL Factory=").append(this.iSSLFactory).append("\n");
        sb.append(", Page Size=").append(this.iPageSize).append("\n");
        sb.append(", Attribute Range Step=").append(this.iAttrRangeStep).append("\n");
        sb.append(", Ignore DN Case=").append(this.ignoreDNCase).append("\n");
        sb.append(", Search Result Count Limit=").append(this.iCountLimit).append("\n");
        sb.append(", Search Result Time Limit=").append(this.iTimeLimit).append("\n");
        sb.append(", Attributes Cache{ Enabled=").append(this.iAttrsCacheEnabled);
        sb.append(", Name=").append(this.iAttrsCacheName);
        sb.append(", Size=").append(this.iAttrsCacheSize);
        sb.append(", Limit=").append(this.iAttrsSizeLmit);
        sb.append(", Timeout=").append(this.iAttrsCacheTimeOut);
        sb.append(" }");
        sb.append(", Search Results Cache{ Enabled=").append(this.iSearchResultsCacheEnabled);
        sb.append(", Name=").append(this.iSearchResultsCacheName);
        sb.append(", Size=").append(this.iSearchResultsCacheSize);
        sb.append(", Limit=").append(this.iSearchResultSizeLmit);
        sb.append(", Timeout=").append(this.iSearchResultsCacheTimeOut);
        sb.append(" }");
        sb.append("}");
        return sb.toString();
    }

    private long roundToSeconds(long timeInMilliseconds) {
        long returnInSeconds = timeInMilliseconds / 1000L;
        if (timeInMilliseconds % 1000L > 499L) {
            ++returnInSeconds;
        }
        return returnInSeconds;
    }

    public ContextManager getContextManager() {
        return this.iContextManager;
    }

    protected void updateKerberosService(KerberosService ks) {
        this.kerberosService = ks;
        this.iContextManager.updateKerberosService(ks, this);
    }
}

