/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.ejb.components;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.WebModuleInfoImpl;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.EJBModuleInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedWebModuleInfo;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.ejbcontainer.EJBEndpoint;
import com.ibm.ws.ejbcontainer.EJBEndpoints;
import com.ibm.ws.ejbcontainer.EJBType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.jaxrs20.api.JaxRsModuleInfoBuilder;
import com.ibm.ws.jaxrs20.ejb.EJBInJarEndpointInfo;
import com.ibm.ws.jaxrs20.ejb.FileUtils;
import com.ibm.ws.jaxrs20.ejb.JaxRsRouterWebApp;
import com.ibm.ws.jaxrs20.metadata.EndpointInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleType;
import com.ibm.ws.jaxrs20.utils.UriEncoder;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.jaxrs20.module.info.ejbbuilder", immediate=true, property={"service.vendor=IBM"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class JaxRsEJBModuleInfoBuilder
implements JaxRsModuleInfoBuilder {
    private static final TraceComponent tc = Tr.register(JaxRsEJBModuleInfoBuilder.class, (String)"JaxRs20EJB", (String)"com.ibm.ws.jaxrs20.ejb.internal.resources.JaxRsEJBMessages");
    private final AtomicServiceReference<ModuleHandler> webModuleHandlerRef = new AtomicServiceReference("webModuleHandler");
    private final AtomicServiceReference<ArtifactContainerFactory> artifactContainerFactoryRef = new AtomicServiceReference("artifactContainerFactory");
    private final AtomicServiceReference<AdaptableModuleFactory> adaptableModuleFactoryRef = new AtomicServiceReference("adaptableModuleFactory");
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("wsLocationAdmin");
    private final Map<J2EEName, File> moduleCacheBaseDirectoryMap = new ConcurrentHashMap<J2EEName, File>();
    private final AtomicServiceReference<FeatureProvisioner> _featureProvisioner = new AtomicServiceReference("featureProvisioner");
    private File cacheBaseDirectory;
    static final long serialVersionUID = -8772004729971541092L;

    @Activate
    protected void activate(ComponentContext cc) {
        this._featureProvisioner.activate(cc);
        this.webModuleHandlerRef.activate(cc);
        this.artifactContainerFactoryRef.activate(cc);
        this.adaptableModuleFactoryRef.activate(cc);
        this.locationAdminRef.activate(cc);
        this.cacheBaseDirectory = ((WsLocationAdmin)this.locationAdminRef.getServiceWithException()).getBundleFile((Object)this, "rs20routermodules");
        if (!FileUtils.ensureDirExists(this.cacheBaseDirectory) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{this.cacheBaseDirectory.getAbsolutePath()});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        for (File moduleCacheBaseDirectory : this.moduleCacheBaseDirectoryMap.values()) {
            FileUtils.recursiveDelete(moduleCacheBaseDirectory);
        }
        this.moduleCacheBaseDirectoryMap.clear();
        this.webModuleHandlerRef.deactivate(cc);
        this.artifactContainerFactoryRef.deactivate(cc);
        this.adaptableModuleFactoryRef.deactivate(cc);
        this.locationAdminRef.deactivate(cc);
        this._featureProvisioner.deactivate(cc);
    }

    @Reference(name="featureProvisioner", service=FeatureProvisioner.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setFeatureProvisioner(ServiceReference<FeatureProvisioner> ref) {
        this._featureProvisioner.setReference(ref);
    }

    protected void unsetFeatureProvisioner(ServiceReference<FeatureProvisioner> ref) {
        this._featureProvisioner.unsetReference(ref);
    }

    @Reference(name="webModuleHandler", service=ModuleHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(type=web)")
    protected void setWebModuleHandler(ServiceReference<ModuleHandler> ref) {
        this.webModuleHandlerRef.setReference(ref);
    }

    protected void unsetWebModuleHandler(ServiceReference<ModuleHandler> ref) {
        this.webModuleHandlerRef.setReference(null);
    }

    @Reference(name="artifactContainerFactory", service=ArtifactContainerFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setArtifactContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.artifactContainerFactoryRef.setReference(ref);
    }

    protected void unsetArtifactContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.artifactContainerFactoryRef.unsetReference(ref);
    }

    @Reference(name="adaptableModuleFactory", service=AdaptableModuleFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactoryRef.setReference(ref);
    }

    protected void unsetAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactoryRef.unsetReference(ref);
    }

    @Reference(name="wsLocationAdmin", service=WsLocationAdmin.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setWsLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetWsLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    private ExtendedWebModuleInfo createWebModuleInfo(ExtendedModuleInfo moduleInfo) throws UnableToAdaptException {
        try {
            ArtifactContainer artifactContainer;
            File dummyWebApplicationDirectory;
            File cacheOverlayDirectory;
            File cacheAdaptDirectory;
            File cacheDirectory;
            File moduleCacheBaseDirectory;
            if (this._featureProvisioner.getService() == null) {
                throw new RuntimeException("service " + FeatureProvisioner.class.getName() + " is not available");
            }
            boolean isJAXWSEnabled = false;
            Set features = ((FeatureProvisioner)this._featureProvisioner.getService()).getInstalledFeatures();
            for (String feature : features) {
                if (!feature.equals("jaxws-2.2")) continue;
                isJAXWSEnabled = true;
                break;
            }
            if (!FileUtils.ensureDirExists(moduleCacheBaseDirectory = new File(this.cacheBaseDirectory, UUID.randomUUID().toString())) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{moduleCacheBaseDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheDirectory = new File(moduleCacheBaseDirectory, "cache")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheAdaptDirectory = new File(moduleCacheBaseDirectory, "cacheAdapt")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheAdaptDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheOverlayDirectory = new File(moduleCacheBaseDirectory, "cacheOverlay")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheOverlayDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(dummyWebApplicationDirectory = new File(moduleCacheBaseDirectory, "router.war")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{dummyWebApplicationDirectory.getAbsolutePath()});
            }
            if ((artifactContainer = ((ArtifactContainerFactory)this.artifactContainerFactoryRef.getServiceWithException()).getContainer(cacheDirectory, (Object)dummyWebApplicationDirectory)) == null) {
                throw new IllegalStateException("");
            }
            Container moduleContainer = ((AdaptableModuleFactory)this.adaptableModuleFactoryRef.getServiceWithException()).getContainer(cacheAdaptDirectory, cacheOverlayDirectory, artifactContainer);
            JaxRsModuleMetaData jaxRsModuleMetaData = JaxRsModuleMetaData.getJaxRsModuleMetaData((ModuleMetaData)moduleInfo.getMetaData());
            if (jaxRsModuleMetaData == null) {
                return null;
            }
            Container appContainer = moduleInfo.getApplicationInfo().getContainer();
            NonPersistentCache appCache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
            ApplicationClassesContainerInfo appCCI = (ApplicationClassesContainerInfo)appCache.getFromCache(ApplicationClassesContainerInfo.class);
            DeployedAppInfo deployedAppInfo = (DeployedAppInfo)appCCI;
            deployedAppInfo.getDeployedModule(moduleInfo);
            NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
            overlayCache.addToCache(JaxRsModuleMetaData.class, (Object)jaxRsModuleMetaData);
            overlayCache.addToCache(WebApp.class, (Object)new JaxRsRouterWebApp(jaxRsModuleMetaData.getJ2EEName().toString() + "-Router-WebModule"));
            JaxRsModuleInfo jaxrsModuleInfo = (JaxRsModuleInfo)moduleInfo.getContainer().adapt(JaxRsModuleInfo.class);
            overlayCache.addToCache(JaxRsModuleInfo.class, (Object)jaxrsModuleInfo);
            ApplicationInfo appInfo = moduleInfo.getApplicationInfo();
            String ejbModuleName = moduleInfo.getName();
            String webModuleName = ejbModuleName + "-RSRouter";
            String defaultContextRoot = jaxrsModuleInfo.isShareEJBJarWithJAXWS() && isJAXWSEnabled ? "/" + ejbModuleName + ".jaxrs" : "/" + ejbModuleName;
            final ClassLoader moduleClassLoader = moduleInfo.getClassLoader();
            ModuleClassLoaderFactory classPathFactory = new ModuleClassLoaderFactory(){
                static final long serialVersionUID = 5368269372159215638L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public ClassLoader createModuleClassLoader(ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesContainers) {
                    return moduleClassLoader;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.ejb.components.JaxRsEJBModuleInfoBuilder$1", 1.class, (String)"JaxRs20EJB", (String)"com.ibm.ws.jaxrs20.ejb.internal.resources.JaxRsEJBMessages");
                }
            };
            WebModuleInfoImpl webModuleInfo = new WebModuleInfoImpl(appInfo, webModuleName, webModuleName, defaultContextRoot, moduleContainer, null, null, classPathFactory);
            ModuleMetaData webModuleMetaData = ((ModuleHandler)this.webModuleHandlerRef.getServiceWithException()).createModuleMetaData((ExtendedModuleInfo)webModuleInfo, deployedAppInfo);
            JaxRsModuleMetaData.setJaxRsModuleMetaData((ModuleMetaData)webModuleMetaData, (JaxRsModuleMetaData)jaxRsModuleMetaData);
            webModuleInfo.setMetaData(webModuleMetaData);
            this.moduleCacheBaseDirectoryMap.put(webModuleMetaData.getJ2EEName(), moduleCacheBaseDirectory);
            return webModuleInfo;
        }
        catch (MetaDataException isJAXWSEnabled) {
            void e;
            FFDCFilter.processException((Throwable)isJAXWSEnabled, (String)"com.ibm.ws.jaxrs20.ejb.components.JaxRsEJBModuleInfoBuilder", (String)"283", (Object)this, (Object[])new Object[]{moduleInfo});
            throw new IllegalStateException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedModuleInfo build(ModuleMetaData moduleMetaData, Container containerToAdapt, JaxRsModuleInfo jaxRsModuleInfo) throws UnableToAdaptException {
        LinkedHashMap<String, EndpointInfo> endpointInfoMap;
        block24: {
            EJBEndpoints ejbEndpoints = (EJBEndpoints)containerToAdapt.adapt(EJBEndpoints.class);
            if (ejbEndpoints == null || ejbEndpoints.getEJBEndpoints().size() == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No possible JAXRS EJB bean is found", (Object[])new Object[0]);
                }
                return null;
            }
            HashSet<String> AllPathProviderClassNames = new HashSet<String>();
            HashSet AllApplicationClasses = new HashSet();
            JaxRsModuleMetaData jaxRsModuleMetaData = JaxRsModuleMetaData.getJaxRsModuleMetaData((ModuleMetaData)moduleMetaData);
            ClassLoader appClassloader = jaxRsModuleMetaData.getAppContextClassLoader();
            String ejbModuleName = jaxRsModuleMetaData.getModuleInfo().getName();
            boolean isShareEJBJarWithJAXWS = false;
            for (EJBEndpoint ejb : ejbEndpoints.getEJBEndpoints()) {
                List interfaces;
                if (ejb.isWebService()) {
                    isShareEJBJarWithJAXWS = true;
                }
                EJBType eJBType = ejb.getEJBType();
                String beanName = ejb.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing bean " + beanName + " of type " + eJBType), (Object[])new Object[0]);
                }
                if (!eJBType.isSession() || !eJBType.equals((Object)EJBType.SINGLETON_SESSION) && !eJBType.equals((Object)EJBType.STATELESS_SESSION)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Processing a singleton or stateless session bean.", (Object[])new Object[0]);
                }
                if ((interfaces = ejb.getLocalBusinessInterfaceNames()).size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"This is a no-interface bean. Checking the bean class directly for annotations", (Object[])new Object[0]);
                    }
                    this.processEJB(ejb, null, appClassloader, AllApplicationClasses, AllPathProviderClassNames);
                    continue;
                }
                for (String ifcName : interfaces) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Processing interface {0} of bean {1}", (Object[])new Object[]{ifcName, beanName});
                    }
                    this.processEJB(ejb, ifcName, appClassloader, AllApplicationClasses, AllPathProviderClassNames);
                }
            }
            if (AllApplicationClasses.size() == 0 && AllPathProviderClassNames.size() == 0) {
                return null;
            }
            jaxRsModuleInfo.setIsShareEJBJarWithJAXWS(isShareEJBJarWithJAXWS);
            endpointInfoMap = new LinkedHashMap<String, EndpointInfo>();
            try {
                if (AllApplicationClasses.size() == 0) {
                    try {
                        JaxRsEJBModuleInfoBuilder.registerEndpointInfo(endpointInfoMap, "javax.ws.rs.core.Application", null, null, "javax.ws.rs.core.Application", "/*", AllPathProviderClassNames, ejbModuleName);
                    }
                    catch (Exception ejb) {
                        FFDCFilter.processException((Throwable)ejb, (String)"com.ibm.ws.jaxrs20.ejb.components.JaxRsEJBModuleInfoBuilder", (String)"382", (Object)this, (Object[])new Object[]{moduleMetaData, containerToAdapt, jaxRsModuleInfo});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            void e;
                            Tr.debug((TraceComponent)tc, (String)"Exception when register endpoint javax.ws.rs.core.Application", (Object[])new Object[]{e});
                        }
                    }
                } else {
                    for (Class clazz : AllApplicationClasses) {
                        String appClassName = clazz.getName();
                        try {
                            String appPath = JaxRsEJBModuleInfoBuilder.getApplicationPathValue(clazz);
                            if (appPath == null) {
                                appPath = "/*";
                            }
                            JaxRsEJBModuleInfoBuilder.registerEndpointInfo(endpointInfoMap, appClassName, null, null, appClassName, appPath, AllPathProviderClassNames, ejbModuleName);
                        }
                        catch (Exception appPath) {
                            void e;
                            FFDCFilter.processException((Throwable)appPath, (String)"com.ibm.ws.jaxrs20.ejb.components.JaxRsEJBModuleInfoBuilder", (String)"405", (Object)this, (Object[])new Object[]{moduleMetaData, containerToAdapt, jaxRsModuleInfo});
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Exception when register endpoint " + appClassName), (Object[])new Object[]{e});
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.ejb.components.JaxRsEJBModuleInfoBuilder", (String)"413", (Object)this, (Object[])new Object[]{moduleMetaData, containerToAdapt, jaxRsModuleInfo});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block24;
                Tr.debug((TraceComponent)tc, (String)"Exception when build endpoint info in jaxrs ejb module: ", (Object[])new Object[]{e});
            }
        }
        for (Map.Entry entry : endpointInfoMap.entrySet()) {
            EndpointInfo endpointInfo = (EndpointInfo)entry.getValue();
            jaxRsModuleInfo.addEndpointInfo(endpointInfo.getAppClassName(), endpointInfo);
        }
        if (jaxRsModuleInfo.getEndpointInfos() != null && jaxRsModuleInfo.getEndpointInfos().size() > 0) {
            return this.startWebRouterModule(containerToAdapt);
        }
        return null;
    }

    protected ExtendedModuleInfo startWebRouterModule(Container containerToAdapt) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)containerToAdapt.adapt(NonPersistentCache.class);
        ExtendedModuleInfo ejbModuleInfo = (ExtendedModuleInfo)overlayCache.getFromCache(EJBModuleInfo.class);
        return this.createWebModuleInfo(ejbModuleInfo);
    }

    private static void registerEndpointInfo(LinkedHashMap<String, EndpointInfo> endpointInfoMap, String servletName, String servletClassName, String servletMappingUrl, String appClassName, String appPath, Set<String> providerAndPathClassNames, String ejbModuleName) throws Exception {
        String key = servletMappingUrl;
        appPath = UriEncoder.decodeString((String)appPath);
        if (key == null) {
            key = appPath;
        }
        if (key == null) {
            throw new Exception("Both servlet mapping url and application path are null.");
        }
        if (endpointInfoMap.containsKey(key)) {
            throw new Exception("Found duplicated servlet mapping url, throw exception to fail application starting.");
        }
        if (servletName == null || appClassName == null || providerAndPathClassNames == null) {
            throw new Exception("invalid values for servletName or appClassName or providerAndPathClassNames");
        }
        EJBInJarEndpointInfo endpointInfo = new EJBInJarEndpointInfo(servletName, servletClassName, servletMappingUrl, appClassName, appPath, providerAndPathClassNames);
        endpointInfo.setEJBModuleName(ejbModuleName);
        endpointInfoMap.put(key, endpointInfo);
    }

    public void processEJB(EJBEndpoint ejb, String ejbInterfaceName, ClassLoader appClassloader, Set<Class<?>> AllApplicationClasses, Set<String> AllPathProviderClassNames) {
        this.getEJBApplicationSubclasses(AllApplicationClasses, ejb, appClassloader);
        this.getEJBWithProviderClasses(AllPathProviderClassNames, ejb, ejbInterfaceName, appClassloader);
        this.getEJBWithPathClasses(AllPathProviderClassNames, ejb, ejbInterfaceName, appClassloader);
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void getEJBApplicationSubclasses(Set<Class<?>> classes, EJBEndpoint ejb, ClassLoader appClassloader) {
        Class<?> c;
        Class<Application> appClass;
        block7: {
            String methodName = "getEJBApplicationSubclasses";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getEJBApplicationSubclasses", (Object[])new Object[0]);
            }
            if (classes == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getEJBApplicationSubclasses", Collections.emptySet());
                }
                return;
            }
            appClass = Application.class;
            String ejbClassName = ejb.getClassName();
            c = null;
            try {
                c = appClassloader.loadClass(ejbClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                void e;
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxrs20.ejb.components.JaxRsEJBModuleInfoBuilder", (String)"529", (Object)this, (Object[])new Object[]{classes, ejb, appClassloader});
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)("getEJBApplicationSubclasses exit - due to Class Not Found for " + ejbClassName + ": " + e), (Object[])new Object[0]);
            }
        }
        if (c != null && appClass.isAssignableFrom(c)) {
            classes.add(c);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEJBApplicationSubclasses", classes);
        }
    }

    @ManualTrace
    private void getEJBWithProviderClasses(Set<String> classeNames, EJBEndpoint ejb, String ejbInterfaceName, ClassLoader appClassloader) {
        String methodName = "getEJBWithProviderClasses";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEJBWithProviderClasses", (Object[])new Object[]{classeNames, ejb, ejbInterfaceName});
        }
        if (classeNames == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getEJBWithProviderClasses", Collections.emptySet());
            }
            return;
        }
        Class<Provider> providerClass = Provider.class;
        String ejbClassName = ejbInterfaceName == null ? ejb.getClassName() : ejbInterfaceName;
        Class<?> c = null;
        try {
            c = appClassloader.loadClass(ejbClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxrs20.ejb.components.JaxRsEJBModuleInfoBuilder", (String)"570", (Object)this, (Object[])new Object[]{classeNames, ejb, ejbInterfaceName, appClassloader});
            Tr.error((TraceComponent)tc, (String)"error.failed.toloadejbclass", (Object[])new Object[]{ejbClassName});
        }
        if (c != null && c.getAnnotation(providerClass) != null) {
            classeNames.add(ejbClassName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEJBWithProviderClasses", classeNames);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void getEJBWithPathClasses(Set<String> classeNames, EJBEndpoint ejb, String ejbInterfaceName, ClassLoader appClassloader) {
        Class<?> c;
        String ejbClassName;
        Class<Path> pathClass;
        block6: {
            String methodName = "getEJBWithPathClasses";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getEJBWithPathClasses", (Object[])new Object[]{classeNames, ejb, ejbInterfaceName});
            }
            if (classeNames == null && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getEJBWithPathClasses", Collections.emptySet());
            }
            pathClass = Path.class;
            ejbClassName = ejbInterfaceName == null ? ejb.getClassName() : ejbInterfaceName;
            c = null;
            try {
                c = appClassloader.loadClass(ejbClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                void e;
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxrs20.ejb.components.JaxRsEJBModuleInfoBuilder", (String)"608", (Object)this, (Object[])new Object[]{classeNames, ejb, ejbInterfaceName, appClassloader});
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)("getEJBWithPathClasses() exit - due to Class Not Found for " + ejbClassName + ": " + e), (Object[])new Object[0]);
            }
        }
        if (c != null && c.getAnnotation(pathClass) != null) {
            classeNames.add(ejbClassName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEJBWithPathClasses", classeNames);
        }
    }

    private static String getApplicationPathValue(Class<?> applicationClassClass) {
        if (applicationClassClass == null) {
            return null;
        }
        ApplicationPath appPath = applicationClassClass.getAnnotation(ApplicationPath.class);
        if (appPath == null) {
            return null;
        }
        String value = appPath.value();
        if (!(value = UriEncoder.encodePath((String)value, (boolean)true)).endsWith("/*")) {
            if (!value.endsWith("/")) {
                value = value + "/";
            }
            if (!value.endsWith("*")) {
                value = value + "*";
            }
        }
        return value;
    }

    public JaxRsModuleType getSupportType() {
        return JaxRsModuleType.EJB;
    }
}

