/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.interrupt.internal;

import com.ibm.websphere.interrupt.InterruptObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InterruptManager
implements Runnable {
    private static final TraceComponent tc = Tr.register(InterruptManager.class, (String)"requestInterrupt");
    private static final int REREGISTER_TIME_SECONDS = 5;
    private static final int EXCEPTION_LIMIT = 3;
    private final String requestId;
    private final InterruptibleThreadObject odiStack;
    private final ScheduledExecutorService scheduledExecutor;
    private boolean cancelled = false;
    private boolean finished = false;
    private int exceptionCount = 0;
    static final long serialVersionUID = 4840755754977307255L;

    public InterruptManager(String requestId, InterruptibleThreadObject odiStack, ScheduledExecutorService ses) {
        this.requestId = requestId;
        this.odiStack = odiStack;
        this.scheduledExecutor = ses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        block19: {
            boolean localFinished = true;
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"run", (Object[])new Object[]{this.requestId});
                }
                if (this.cancelled) {
                    return;
                }
                InterruptObject io = this.odiStack.findNewestUndrivenInterruptObject();
                if (io != null) {
                    block18: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Driving interrupt object", (Object[])new Object[]{this.requestId, io});
                        }
                        try {
                            io.interrupt();
                            if (this.exceptionCount >= 3) break block18;
                            this.scheduledExecutor.schedule(this, 5L, TimeUnit.SECONDS);
                        }
                        catch (Throwable throwable) {
                            block20: {
                                try {
                                    void t;
                                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.request.interrupt.internal.InterruptManager", (String)"112", (Object)this, (Object[])new Object[0]);
                                    FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"95");
                                    ++this.exceptionCount;
                                    if (this.exceptionCount >= 3) break block20;
                                    this.scheduledExecutor.schedule(this, 5L, TimeUnit.SECONDS);
                                }
                                catch (Throwable throwable2) {
                                    if (this.exceptionCount < 3) {
                                        this.scheduledExecutor.schedule(this, 5L, TimeUnit.SECONDS);
                                        localFinished = false;
                                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Disabling InterruptManager due to exception limit", (Object[])new Object[]{this.requestId});
                                    }
                                    throw throwable2;
                                }
                                localFinished = false;
                                break block19;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Disabling InterruptManager due to exception limit", (Object[])new Object[]{this.requestId});
                            }
                            break block19;
                        }
                        localFinished = false;
                        break block19;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Disabling InterruptManager due to exception limit", (Object[])new Object[]{this.requestId});
                    }
                    break block19;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Finished interrupting request", (Object[])new Object[]{this.requestId});
                }
            }
            finally {
                this.finished = localFinished;
            }
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getRequestId() {
        return this.requestId;
    }
}

