/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

@Trivial
public final class URITemplate {
    public static final String TEMPLATE_PARAMETERS = "jaxrs.template.parameters";
    public static final String LIMITED_REGEX_SUFFIX = "(/.*)?";
    public static final String FINAL_MATCH_GROUP = "FINAL_MATCH_GROUP";
    private static final String DEFAULT_PATH_VARIABLE_REGEX = "([^/]+?)";
    private static final Pattern INTEGER_PATH_VARIABLE_REGEX_PATTERN = Pattern.compile("\\-?[0-9]+");
    private static final Pattern DECIMAL_PATH_VARIABLE_REGEX_PATTERN = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?");
    private static final String CHARACTERS_TO_ESCAPE = ".*+$()";
    private static final String SLASH = "/";
    private static final String SLASH_QUOTE = "/;";
    private static final int MAX_URI_TEMPLATE_CACHE_SIZE = Integer.parseInt(SystemPropertyAction.getProperty("org.apache.cxf.jaxrs.max_uri_template_cache_size", "2000"));
    private static final Map<String, URITemplate> URI_TEMPLATE_CACHE = new ConcurrentHashMap<String, URITemplate>();
    private final String template;
    private final List<String> variables = new ArrayList<String>();
    private final List<String> customVariables = new ArrayList<String>();
    private final Pattern templateRegexPattern;
    private final String literals;
    private final List<UriChunk> uriChunks;

    public URITemplate(String theTemplate) {
        this(theTemplate, Collections.emptyList());
    }

    public URITemplate(String theTemplate, List<Parameter> params) {
        boolean endsWithSlash;
        this.template = theTemplate;
        StringBuilder literalChars = new StringBuilder();
        StringBuilder patternBuilder = new StringBuilder();
        CurlyBraceTokenizer tok = new CurlyBraceTokenizer(this.template);
        this.uriChunks = new ArrayList<UriChunk>();
        while (tok.hasNext()) {
            String templatePart = tok.next();
            UriChunk chunk = UriChunk.createUriChunk(templatePart, params);
            this.uriChunks.add(chunk);
            if (chunk instanceof Literal) {
                String encodedValue = HttpUtils.encodePartiallyEncoded(chunk.getValue(), false);
                String substr = URITemplate.escapeCharacters(encodedValue);
                literalChars.append(substr);
                patternBuilder.append(substr);
                continue;
            }
            if (!(chunk instanceof Variable)) continue;
            Variable var = (Variable)chunk;
            this.variables.add(var.getName());
            String pattern = var.getPattern();
            if (pattern != null) {
                this.customVariables.add(var.getName());
                if (pattern.startsWith("(") && pattern.endsWith(")")) {
                    patternBuilder.append(pattern);
                    continue;
                }
                patternBuilder.append('(');
                patternBuilder.append(pattern);
                patternBuilder.append(')');
                continue;
            }
            patternBuilder.append(DEFAULT_PATH_VARIABLE_REGEX);
        }
        this.literals = literalChars.toString();
        int endPos = patternBuilder.length() - 1;
        boolean bl = endPos >= 0 ? patternBuilder.charAt(endPos) == '/' : (endsWithSlash = false);
        if (endsWithSlash) {
            patternBuilder.deleteCharAt(endPos);
        }
        patternBuilder.append(LIMITED_REGEX_SUFFIX);
        this.templateRegexPattern = Pattern.compile(patternBuilder.toString());
    }

    public String getLiteralChars() {
        return this.literals;
    }

    public String getValue() {
        return this.template;
    }

    public String getPatternValue() {
        return this.templateRegexPattern.toString();
    }

    public List<String> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public List<String> getCustomVariables() {
        return Collections.unmodifiableList(this.customVariables);
    }

    private static String escapeCharacters(String expression) {
        int i;
        int length = expression.length();
        char ch = ' ';
        for (i = 0; i < length && !URITemplate.isReservedCharacter(ch = (char)expression.charAt(i)); ++i) {
        }
        if (i == length) {
            return expression;
        }
        StringBuilder sb = new StringBuilder(length + 8);
        sb.append(expression, 0, i);
        sb.append('\\');
        sb.append(ch);
        ++i;
        while (i < length) {
            ch = expression.charAt(i);
            if (URITemplate.isReservedCharacter(ch)) {
                sb.append('\\');
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    private static boolean isReservedCharacter(char ch) {
        return CHARACTERS_TO_ESCAPE.indexOf(ch) != -1;
    }

    public boolean match(String uri, MultivaluedMap<String, String> templateVariableToValue) {
        String finalGroup;
        if (uri == null) {
            return this.templateRegexPattern == null;
        }
        if (this.templateRegexPattern == null) {
            return false;
        }
        Matcher m = this.templateRegexPattern.matcher(uri);
        if (!m.matches() || this.template.equals(SLASH) && uri.startsWith(SLASH_QUOTE)) {
            if (uri.contains(";")) {
                List<PathSegment> pList = JAXRSUtils.getPathSegments(this.template, false);
                List<PathSegment> uList = JAXRSUtils.getPathSegments(uri, false);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < uList.size(); ++i) {
                    String segment = null;
                    segment = pList.size() > i && pList.get(i).getPath().indexOf(123) == -1 ? uList.get(i).getPath() : HttpUtils.fromPathSegment(uList.get(i));
                    if (segment.length() > 0) {
                        sb.append(SLASH);
                    }
                    sb.append(segment);
                }
                uri = sb.toString();
                if (uri.length() == 0) {
                    uri = SLASH;
                }
                if (!(m = this.templateRegexPattern.matcher(uri)).matches()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        int groupCount = m.groupCount();
        int i = 1;
        block1: for (String name : this.variables) {
            while (i <= groupCount) {
                String value;
                if (((value = m.group(i++)) == null || value.length() == 0 && i < groupCount) && this.variables.size() + 1 < groupCount) continue;
                templateVariableToValue.add((Object)name, (Object)value);
                continue block1;
            }
        }
        String string = finalGroup = i > groupCount ? SLASH : m.group(groupCount);
        if (finalGroup == null || finalGroup.startsWith(SLASH_QUOTE)) {
            finalGroup = SLASH;
        }
        templateVariableToValue.putSingle((Object)FINAL_MATCH_GROUP, (Object)finalGroup);
        return true;
    }

    public String substitute(List<String> values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values is null");
        }
        Iterator<String> iter = values.iterator();
        StringBuilder sb = new StringBuilder();
        for (UriChunk chunk : this.uriChunks) {
            if (chunk instanceof Variable) {
                Variable var = (Variable)chunk;
                if (iter.hasNext()) {
                    String value = iter.next();
                    if (!var.matches(value)) {
                        throw new IllegalArgumentException("Value '" + value + "' does not match variable " + var.getName() + " with pattern " + var.getPattern());
                    }
                    sb.append(value);
                    continue;
                }
                sb.append(var);
                continue;
            }
            sb.append(chunk);
        }
        return sb.toString();
    }

    String substitute(Map<String, ? extends Object> valuesMap) throws IllegalArgumentException {
        return this.substitute(valuesMap, Collections.emptySet(), false);
    }

    public String substitute(Map<String, ? extends Object> valuesMap, Set<String> encodePathSlashVars, boolean allowUnresolved) throws IllegalArgumentException {
        if (valuesMap == null) {
            throw new IllegalArgumentException("valuesMap is null");
        }
        StringBuilder sb = new StringBuilder();
        for (UriChunk chunk : this.uriChunks) {
            if (chunk instanceof Variable) {
                Variable var = (Variable)chunk;
                Object value = valuesMap.get(var.getName());
                if (value != null) {
                    String sval = value.toString();
                    if (!var.matches(sval)) {
                        throw new IllegalArgumentException("Value '" + sval + "' does not match variable " + var.getName() + " with pattern " + var.getPattern());
                    }
                    if (encodePathSlashVars.contains(var.getName())) {
                        sval = sval.replaceAll(SLASH, "%2F");
                    }
                    sb.append(sval);
                    continue;
                }
                if (allowUnresolved) {
                    sb.append(chunk);
                    continue;
                }
                throw new IllegalArgumentException("Template variable " + var.getName() + " has no matching value");
            }
            sb.append(chunk);
        }
        return sb.toString();
    }

    public String encodeLiteralCharacters(boolean isQuery) {
        float encodedRatio = 1.5f;
        StringBuilder sb = new StringBuilder((int)(1.5f * (float)this.template.length()));
        for (UriChunk chunk : this.uriChunks) {
            String val = chunk.getValue();
            if (chunk instanceof Literal) {
                sb.append(HttpUtils.encodePartiallyEncoded(val, isQuery));
                continue;
            }
            sb.append(val);
        }
        return sb.toString();
    }

    public static URITemplate createTemplate(Path path, List<Parameter> params, String classNameandPath) {
        return URITemplate.createTemplate(path == null ? null : path.value(), params, classNameandPath);
    }

    public static URITemplate createTemplate(Path path, List<Parameter> params) {
        return URITemplate.createTemplate(path == null ? null : path.value(), params);
    }

    public static URITemplate createTemplate(Path path) {
        return URITemplate.createTemplate(path == null ? null : path.value(), Collections.emptyList());
    }

    public static URITemplate createTemplate(Path path, String classNameandPath) {
        return URITemplate.createTemplate(path == null ? null : path.value(), Collections.emptyList(), classNameandPath);
    }

    public static URITemplate createTemplate(String pathValue) {
        return URITemplate.createTemplate(pathValue, Collections.emptyList(), pathValue);
    }

    public static URITemplate createTemplate(String pathValue, String classNameandPath) {
        return URITemplate.createTemplate(pathValue, Collections.emptyList(), classNameandPath);
    }

    public static URITemplate createTemplate(String pathValue, List<Parameter> params) {
        return URITemplate.createExactTemplate(pathValue, params, pathValue);
    }

    public static URITemplate createTemplate(String pathValue, List<Parameter> params, String classNameandPath) {
        if (pathValue == null) {
            pathValue = SLASH;
        } else if (!pathValue.startsWith(SLASH)) {
            pathValue = SLASH + pathValue;
        }
        return URITemplate.createExactTemplate(pathValue, params, classNameandPath);
    }

    public static URITemplate createExactTemplate(String pathValue) {
        return URITemplate.createExactTemplate(pathValue, Collections.emptyList());
    }

    public static URITemplate createExactTemplate(String pathValue, List<Parameter> params) {
        return URITemplate.createExactTemplate(pathValue, params, pathValue);
    }

    public static URITemplate createExactTemplate(String pathValue, List<Parameter> params, String classNameandPath) {
        URITemplate template = URI_TEMPLATE_CACHE.get(classNameandPath);
        if (template == null) {
            template = new URITemplate(pathValue, params);
            if (URI_TEMPLATE_CACHE.size() >= MAX_URI_TEMPLATE_CACHE_SIZE) {
                URI_TEMPLATE_CACHE.clear();
            }
            URI_TEMPLATE_CACHE.put(classNameandPath, template);
        }
        return template;
    }

    public static int compareTemplates(URITemplate t1, URITemplate t2) {
        int result;
        int l2;
        int l1 = t1.getLiteralChars().length();
        int n = l1 < (l2 = t2.getLiteralChars().length()) ? 1 : (result = l1 > l2 ? -1 : 0);
        if (result == 0) {
            int g2;
            int g1 = t1.getVariables().size();
            int n2 = g1 < (g2 = t2.getVariables().size()) ? 1 : (result = g1 > g2 ? -1 : 0);
            if (result == 0) {
                int gCustom2;
                int gCustom1 = t1.getCustomVariables().size();
                int n3 = gCustom1 < (gCustom2 = t2.getCustomVariables().size()) ? 1 : (result = gCustom1 > gCustom2 ? -1 : 0);
                if (result == 0) {
                    result = t1.getPatternValue().compareTo(t2.getPatternValue());
                }
            }
        }
        return result;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    static class CurlyBraceTokenizer {
        private final List<String> tokens = new ArrayList<String>();
        private int tokenIdx;
        static final long serialVersionUID = 1406654889247353169L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CurlyBraceTokenizer(String string) {
            int idx;
            boolean outside = true;
            int level = 0;
            int lastIdx = 0;
            int length = string.length();
            for (idx = 0; idx < length; ++idx) {
                char c = string.charAt(idx);
                if (c == '{') {
                    if (outside) {
                        if (lastIdx < idx) {
                            this.tokens.add(string.substring(lastIdx, idx));
                        }
                        lastIdx = idx;
                        outside = false;
                        continue;
                    }
                    ++level;
                    continue;
                }
                if (c != '}' || outside) continue;
                if (level > 0) {
                    --level;
                    continue;
                }
                if (lastIdx < idx) {
                    this.tokens.add(lastIdx == 0 && idx + 1 == length ? string : string.substring(lastIdx, idx + 1));
                }
                lastIdx = idx + 1;
                outside = true;
            }
            if (lastIdx < idx) {
                this.tokens.add(lastIdx == 0 ? string : string.substring(lastIdx, idx));
            }
        }

        public static boolean insideBraces(String token) {
            return token.charAt(0) == '{' && token.charAt(token.length() - 1) == '}';
        }

        public static String stripBraces(String token) {
            if (CurlyBraceTokenizer.insideBraces(token)) {
                return token.substring(1, token.length() - 1);
            }
            return token;
        }

        public boolean hasNext() {
            return this.tokens.size() > this.tokenIdx;
        }

        public String next() {
            if (this.hasNext()) {
                return this.tokens.get(this.tokenIdx++);
            }
            throw new IllegalStateException("no more elements");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.URITemplate$CurlyBraceTokenizer", CurlyBraceTokenizer.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static final class Variable
    extends UriChunk {
        private static final Pattern VARIABLE_PATTERN;
        private String name;
        private Pattern pattern;
        static final long serialVersionUID = 8439796020663932706L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Variable() {
        }

        public static Variable create(String uriChunk, List<Parameter> params) {
            Matcher matcher;
            if (uriChunk == null || "".equals(uriChunk)) {
                return null;
            }
            if (CurlyBraceTokenizer.insideBraces(uriChunk) && (matcher = VARIABLE_PATTERN.matcher(uriChunk = CurlyBraceTokenizer.stripBraces(uriChunk).trim())).matches()) {
                Variable newVariable = new Variable();
                newVariable.name = matcher.group(1).trim();
                if (matcher.group(2) != null && matcher.group(3) != null) {
                    String patternExpression = matcher.group(3).trim();
                    newVariable.pattern = Pattern.compile(patternExpression);
                } else {
                    for (Parameter p : params) {
                        if (p.getName() == null || !p.getName().equals(newVariable.name)) continue;
                        Class<?> paramType = p.getJavaType();
                        if (!paramType.isPrimitive()) break;
                        if (Integer.TYPE.equals(paramType) || Short.TYPE.equals(paramType) || Long.TYPE.equals(paramType)) {
                            newVariable.pattern = INTEGER_PATH_VARIABLE_REGEX_PATTERN;
                            break;
                        }
                        if (!Double.TYPE.equals(paramType) && !Float.TYPE.equals(paramType)) break;
                        newVariable.pattern = DECIMAL_PATH_VARIABLE_REGEX_PATTERN;
                        break;
                    }
                }
                return newVariable;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getPattern() {
            return this.pattern != null ? this.pattern.pattern() : null;
        }

        public boolean matches(String value) {
            if (this.pattern == null) {
                return true;
            }
            return this.pattern.matcher(value).matches();
        }

        @Override
        public String getValue() {
            if (this.pattern != null) {
                return "{" + this.name + ":" + this.pattern + "}";
            }
            return "{" + this.name + "}";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.URITemplate$Variable", Variable.class, null, null);
            VARIABLE_PATTERN = Pattern.compile("(\\w[-\\w\\.]*[ ]*)(\\:(.+))?");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static final class Literal
    extends UriChunk {
        private String value;
        static final long serialVersionUID = 855621128581005311L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Literal() {
        }

        public static Literal create(String uriChunk) {
            if (uriChunk == null || "".equals(uriChunk)) {
                throw new IllegalArgumentException("uriChunk is empty");
            }
            Literal literal = new Literal();
            literal.value = uriChunk;
            return literal;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.URITemplate$Literal", Literal.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static abstract class UriChunk {
        static final long serialVersionUID = 2273315319580568564L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private UriChunk() {
        }

        public static UriChunk createUriChunk(String uriChunk, List<Parameter> params) {
            if (uriChunk == null || "".equals(uriChunk)) {
                throw new IllegalArgumentException("uriChunk is empty");
            }
            UriChunk uriChunkRepresentation = Variable.create(uriChunk, params);
            if (uriChunkRepresentation == null) {
                uriChunkRepresentation = Literal.create(uriChunk);
            }
            return uriChunkRepresentation;
        }

        public abstract String getValue();

        public String toString() {
            return this.getValue();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.URITemplate$UriChunk", UriChunk.class, null, null);
        }
    }
}

