/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.List;
import net.jodah.failsafe.function.BiPredicate;
import net.jodah.failsafe.function.Predicate;

final class Predicates {
    Predicates() {
    }

    static BiPredicate<Object, Throwable> resultPredicateFor(final Object result) {
        return new BiPredicate<Object, Throwable>(){

            @Override
            public boolean test(Object t, Throwable u) {
                return result == null ? t == null : result.equals(t);
            }
        };
    }

    static BiPredicate<Object, Throwable> failurePredicateFor(final Predicate<? extends Throwable> failurePredicate) {
        return new BiPredicate<Object, Throwable>(){

            @Override
            public boolean test(Object t, Throwable u) {
                return u != null && failurePredicate.test(u);
            }
        };
    }

    static <T> BiPredicate<Object, Throwable> resultPredicateFor(final Predicate<T> resultPredicate) {
        return new BiPredicate<Object, Throwable>(){

            @Override
            public boolean test(Object t, Throwable u) {
                return resultPredicate.test(t);
            }
        };
    }

    static BiPredicate<Object, Throwable> failurePredicateFor(final List<Class<? extends Throwable>> failures) {
        return new BiPredicate<Object, Throwable>(){

            @Override
            public boolean test(Object t, Throwable u) {
                if (u == null) {
                    return false;
                }
                for (Class failureType : failures) {
                    if (!failureType.isAssignableFrom(u.getClass())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

