/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.helpers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.converter.NotificationRecord;
import com.ibm.ws.jmx.connector.datatypes.JMXServerInfo;
import com.ibm.ws.jmx.connector.datatypes.MBeanInfoWrapper;
import com.ibm.ws.jmx.connector.datatypes.NotificationArea;
import com.ibm.ws.jmx.connector.datatypes.ObjectInstanceWrapper;
import com.ibm.ws.jmx.connector.datatypes.ServerNotificationRegistration;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Writer;
import javax.management.AttributeList;
import javax.management.Notification;
import javax.management.NotificationFilter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OutputHelper {
    static final long serialVersionUID = -9206305501831668106L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public static void getIntegerStreamingOutput(RESTResponse response, Integer value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeInt(outStream, value.intValue());
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"51", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeServerRegistrationStreamingOutput(RESTResponse response, ServerNotificationRegistration value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeServerNotificationRegistration(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"75", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeJMXStreamingOutput(RESTResponse response, JMXServerInfo value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeJMX(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"99", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeStringStreamingOutput(RESTResponse response, String value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeString(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"123", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeStringArrayStreamingOutput(RESTResponse response, String[] value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeStringArray(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"147", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeNotificationFilterArrayStreamingOutput(RESTResponse response, NotificationFilter[] value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeNotificationFilters(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"171", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeObjectInstanceArrayOutput(RESTResponse response, ObjectInstanceWrapper[] value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeObjectInstanceArray(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"195", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeMBeanInfoOutput(RESTResponse response, MBeanInfoWrapper value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeMBeanInfo(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"219", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writePOJOOutput(RESTResponse response, Object value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writePOJO(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"243", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    public static void writeJsonOutput(RESTResponse response, String json) {
        response.setContentType("application/json");
        OutputHelper.writeStringOutput(response, json);
    }

    public static void writeTextOutput(RESTResponse response, String text) {
        response.setContentType("text/plain");
        OutputHelper.writeStringOutput(response, text);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeStringOutput(RESTResponse response, String str) {
        if (str == null) {
            response.setStatus(204);
        } else {
            Writer writer = null;
            try {
                writer = response.getWriter();
                writer.write(str);
                writer.flush();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"269", null, (Object[])new Object[]{response, str});
                throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
            }
            finally {
                FileUtils.tryToClose((Closeable)writer);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeObjectInstanceOutput(RESTResponse response, ObjectInstanceWrapper value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeObjectInstance(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"294", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeAttributeListOutput(RESTResponse response, AttributeList value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeAttributeList(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"318", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeNotificationAreaOutput(RESTResponse response, NotificationArea value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeNotificationArea(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"342", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeNotificationArrayOutput(RESTResponse response, Notification[] value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeNotifications(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"366", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeNotificationArrayOutput(RESTResponse response, NotificationRecord[] value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeNotificationRecords(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"390", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBooleanOutput(RESTResponse response, boolean value, JSONConverter converter) {
        response.setContentType("application/json");
        OutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            converter.writeBoolean(outStream, value);
            JSONConverter.returnConverter((JSONConverter)converter);
            outStream.flush();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper", (String)"414", null, (Object[])new Object[]{response, value, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            FileUtils.tryToClose((Closeable)outStream);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(OutputHelper.class);
    }
}

