/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.helpers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.converter.NotificationTargetInformation;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.MBeanRouterMessageUtil;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.plugins.CollectivePlugin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.util.List;
import javax.management.AttributeList;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={MBeanRouterHelper.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class MBeanRouterHelper {
    private static final TraceComponent tc = Tr.register(MBeanRouterHelper.class);
    private static final String KEY_COLLECTIVE_PLUGIN = "collectivePlugin";
    private static final AtomicServiceReference<CollectivePlugin> collectivePluginRef = new AtomicServiceReference("collectivePlugin");
    static final long serialVersionUID = 768437694499240069L;

    @Activate
    protected void activate(ComponentContext cc) {
        collectivePluginRef.activate(cc);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.getClass().getSimpleName() + " has been activated."), (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.getClass().getSimpleName() + " has been deactivated."), (Object[])new Object[0]);
        }
        collectivePluginRef.deactivate(cc);
    }

    public static NotificationTargetInformation toNotificationTargetInformation(RESTRequest request, String objectName) {
        String[] routingContext = RESTHelper.getRoutingContext(request, false);
        if (routingContext != null) {
            return new NotificationTargetInformation(objectName, routingContext[0], routingContext[2], routingContext[1]);
        }
        return new NotificationTargetInformation(objectName);
    }

    @Reference(name="collectivePlugin", service=CollectivePlugin.class)
    protected void setCollectivePlugin(ServiceReference<CollectivePlugin> ref) {
        collectivePluginRef.setReference(ref);
    }

    protected void unsetCollectivePlugin(ServiceReference<CollectivePlugin> ref) {
        collectivePluginRef.unsetReference(ref);
    }

    protected static CollectivePlugin getReader() throws IOException {
        CollectivePlugin reader = (CollectivePlugin)collectivePluginRef.getService();
        if (reader == null) {
            throw new IOException(MBeanRouterMessageUtil.getMessage("jmx.connector.server.rest.router.collectivePlugin.not.available", new Object[0]));
        }
        return reader;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getCachedAttribute(RESTRequest request, RESTResponse response, String objectName, String attribute, List<String> attributeList) {
        JSONConverter converter = JSONConverter.getConverter();
        boolean dataInCache = true;
        try {
            String[] routingContext = RESTHelper.getRoutingContext(request, true);
            String targetHost = routingContext[0];
            String targetUserDir = routingContext[1];
            String targetServer = routingContext[2];
            if (attribute != null && !attribute.isEmpty()) {
                Object data = MBeanRouterHelper.getReader().getAttribute(targetHost, targetUserDir, targetServer, objectName, attribute);
                if (data != null) {
                    converter.writePOJO(response.getOutputStream(), data);
                    response.getOutputStream().flush();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The MBean attribute could not be loaded", (Object[])new Object[]{targetHost, targetUserDir, targetServer, objectName, attribute});
                    }
                    dataInCache = false;
                }
            } else {
                AttributeList al = MBeanRouterHelper.getReader().getAttributes(targetHost, targetUserDir, targetServer, objectName);
                if (al != null) {
                    if (attributeList != null && !attributeList.isEmpty()) {
                        al.retainAll(attributeList);
                    }
                    converter.writeAttributeList(response.getOutputStream(), al);
                    response.getOutputStream().flush();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The MBean attributes could not be loaded", (Object[])new Object[]{targetHost, targetUserDir, targetServer, objectName});
                    }
                    dataInCache = false;
                }
            }
        }
        catch (Exception routingContext) {
            void e;
            FFDCFilter.processException((Throwable)routingContext, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanRouterHelper", (String)"143", null, (Object[])new Object[]{request, response, objectName, attribute, attributeList});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        finally {
            JSONConverter.returnConverter((JSONConverter)converter);
        }
        return dataInCache;
    }
}

