/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.JMXServerInfo;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.POJOHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.management.ObjectName;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/", "com.ibm.wsspi.rest.handler.root=/mbeanCount", "com.ibm.wsspi.rest.handler.root=/mbeanServer", "com.ibm.wsspi.rest.handler.root=/defaultDomain", "com.ibm.wsspi.rest.handler.root=/domains", "com.ibm.wsspi.rest.handler.root=/api", "com.ibm.wsspi.rest.handler.root=/graph", "com.ibm.wsspi.rest.handler.root=/instanceOf", "com.ibm.wsspi.rest.handler.root=/pojo"})
public class JMXHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(JMXHandler.class);
    static final long serialVersionUID = -9204097041073643068L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    public void handleRequest(RESTRequest request, RESTResponse response) {
        String path = request.getPath();
        String method = request.getMethod();
        if (RESTHelper.isGetMethod(method) && path.endsWith("/mbeanCount")) {
            this.getMBeanCount(request, response);
        } else if (RESTHelper.isGetMethod(method) && path.endsWith("/defaultDomain")) {
            this.getDefaultDomain(request, response);
        } else if (RESTHelper.isGetMethod(method) && path.endsWith("/domains")) {
            this.getDomains(request, response);
        } else if (RESTHelper.isGetMethod(method) && path.endsWith("/mbeanServer")) {
            this.getMBeanServer(request, response);
        } else if (RESTHelper.isGetMethod(method) && path.endsWith("/graph")) {
            this.map(request, response);
        } else if (RESTHelper.isGetMethod(method) && path.endsWith("/api")) {
            this.api(request, response);
        } else if (RESTHelper.isGetMethod(method) && path.endsWith("/instanceOf")) {
            this.instanceOf(request, response);
        } else if (RESTHelper.isGetMethod(method) && path.endsWith("/pojo")) {
            this.getPOJO(request, response);
        } else if (RESTHelper.isGetMethod(method) && path.endsWith("/")) {
            this.getJMX(request, response);
        } else {
            throw new RESTHandlerMethodNotAllowedError("GET");
        }
    }

    private void getJMX(RESTRequest request, RESTResponse response) {
        JMXServerInfo jmxObj = new JMXServerInfo();
        jmxObj.version = 6;
        jmxObj.mbeansURL = "/IBMJMXConnectorREST/mbeans";
        jmxObj.createMBeanURL = "/IBMJMXConnectorREST/mbeans/factory";
        jmxObj.instanceOfURL = "/IBMJMXConnectorREST/instanceOf";
        jmxObj.mbeanCountURL = "/IBMJMXConnectorREST/mbeanCount";
        jmxObj.defaultDomainURL = "/IBMJMXConnectorREST/defaultDomain";
        jmxObj.domainsURL = "/IBMJMXConnectorREST/domains";
        jmxObj.notificationsURL = "/IBMJMXConnectorREST/notifications";
        jmxObj.fileTransferURL = "/IBMJMXConnectorREST/file";
        jmxObj.apiURL = "/IBMJMXConnectorREST/api";
        jmxObj.graphURL = "/IBMJMXConnectorREST/graph";
        OutputHelper.writeJMXStreamingOutput(response, jmxObj, JSONConverter.getConverter());
    }

    private void getMBeanCount(RESTRequest request, RESTResponse response) {
        Integer mbeanCount = MBeanServerHelper.getMBeanCount();
        OutputHelper.getIntegerStreamingOutput(response, mbeanCount, JSONConverter.getConverter());
    }

    private void getDefaultDomain(RESTRequest request, RESTResponse response) {
        String defaultDomain = MBeanServerHelper.getDefaultDomain();
        OutputHelper.writeStringStreamingOutput(response, defaultDomain, JSONConverter.getConverter());
    }

    private void getDomains(RESTRequest request, RESTResponse response) {
        String[] domains = MBeanServerHelper.getDomains();
        OutputHelper.writeStringArrayStreamingOutput(response, domains, JSONConverter.getConverter());
    }

    private void getMBeanServer(RESTRequest request, RESTResponse response) {
        String serverName = MBeanServerHelper.getMBeanServerName();
        OutputHelper.writeTextOutput(response, serverName);
    }

    private void map(RESTRequest request, RESTResponse response) {
        this.writeFileToResponse(response, "/Docs/url_map.jpg");
        response.setContentType("image/jpeg");
    }

    private void api(RESTRequest request, RESTResponse response) {
        this.writeFileToResponse(response, "/Docs/api.html");
        response.setContentType("text/html");
    }

    private void instanceOf(RESTRequest request, RESTResponse response) {
        String objectName = RESTHelper.getQueryParam(request, "objectName");
        String className = RESTHelper.getQueryParam(request, "className");
        ObjectName objectNameObj = RESTHelper.objectNameConverter(objectName, false, null);
        boolean isInstanceOf = MBeanServerHelper.instanceOf(objectNameObj, className, null);
        OutputHelper.writeBooleanOutput(response, isInstanceOf, JSONConverter.getConverter());
    }

    private void getPOJO(RESTRequest request, RESTResponse response) {
        POJOHelper pojoObj = new POJOHelper();
        String pojos = pojoObj.getPOJOObject();
        OutputHelper.writeStringStreamingOutput(response, pojos, JSONConverter.getConverter());
    }

    /*
     * WARNING - void declaration
     */
    private void writeFileToResponse(RESTResponse response, String path) {
        InputStream inputStream = this.getClass().getResourceAsStream(path);
        if (inputStream != null) {
            OutputStream outputStream = null;
            try {
                int len;
                outputStream = response.getOutputStream();
                byte[] buffer = new byte[2048];
                while ((len = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, len);
                }
            }
            catch (IOException buffer) {
                void ioe;
                FFDCFilter.processException((Throwable)buffer, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.JMXHandler", (String)"174", (Object)this, (Object[])new Object[]{response, path});
                throw ErrorHelper.createRESTHandlerJsonException((Throwable)ioe, null, 500);
            }
            finally {
                FileUtils.tryToClose((Closeable)outputStream);
                FileUtils.tryToClose((Closeable)inputStream);
            }
        }
    }
}

