/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.MultipleRoutingHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/file/status", "com.ibm.wsspi.rest.handler.root=/file/status/{taskID}"})
public class FileStatusTaskStatusHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(FileStatusTaskStatusHandler.class);
    public static final String ROOT_URL = "/IBMJMXConnectorREST/file/status";
    private transient MultipleRoutingHelper multipleRoutingHelper;
    private transient ComponentContext componentContext;
    static final long serialVersionUID = -2243255851399307393L;

    @Activate
    protected void activate(ComponentContext context) {
        this.componentContext = context;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.componentContext = null;
    }

    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        boolean foundHandler = false;
        String method = request.getMethod();
        if (request.getPathVariable("taskID") != null) {
            if (RESTHelper.isGetMethod(method)) {
                this.taskStatus(request, response);
                foundHandler = true;
            }
        } else if (RESTHelper.isGetMethod(method)) {
            this.allStatus(request, response);
            foundHandler = true;
        }
        if (!foundHandler) {
            throw new RESTHandlerMethodNotAllowedError("GET");
        }
    }

    private void allStatus(RESTRequest request, RESTResponse response) {
        MultipleRoutingHelper helper = this.getMultipleRoutingHelper();
        HashMap queryParams = new HashMap();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            queryParams.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        String allStatusJson = queryParams == null || queryParams.isEmpty() ? helper.getAllStatus(null) : helper.getAllStatus(queryParams.entrySet());
        OutputHelper.writeJsonOutput(response, allStatusJson);
    }

    private void taskStatus(RESTRequest request, RESTResponse response) {
        String taskID = RESTHelper.getRequiredParam(request, "taskID");
        String taskStatusJson = this.getMultipleRoutingHelper().getStatus(taskID);
        OutputHelper.writeJsonOutput(response, taskStatusJson);
    }

    private synchronized MultipleRoutingHelper getMultipleRoutingHelper() {
        if (this.multipleRoutingHelper == null) {
            BundleContext bc = this.componentContext.getBundleContext();
            ServiceReference multipleRoutingHelperRef = bc.getServiceReference(MultipleRoutingHelper.class);
            MultipleRoutingHelper multipleRoutingHelper = this.multipleRoutingHelper = multipleRoutingHelperRef != null ? (MultipleRoutingHelper)bc.getService(multipleRoutingHelperRef) : null;
            if (this.multipleRoutingHelper == null) {
                IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"MultipleRoutingHelper"}, (String)"CWWKX0122E: OSGi service is not available."));
                throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
            }
        }
        return this.multipleRoutingHelper;
    }
}

