/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.unit.impl;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.unit.impl.DelayedLookupDataSource;
import org.apache.aries.util.tracker.SingleServiceTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactoryDataSource
extends DelayedLookupDataSource
implements SingleServiceTracker.SingleServiceListener {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");
    private AtomicReference<DataSource> ds = new AtomicReference();
    private final String driverName;
    private final Bundle persistenceBundle;
    private final Properties props;
    private final boolean jta;
    private final AtomicReference<SingleServiceTracker<DataSourceFactory>> trackerRef = new AtomicReference();

    public DataSourceFactoryDataSource(Bundle bundle, String driverName, Properties props, boolean jta) {
        this.persistenceBundle = bundle;
        this.driverName = driverName;
        this.props = props;
        this.jta = jta;
    }

    @Override
    protected DataSource getDs() {
        if (this.ds.get() == null) {
            DataSourceFactory dsf;
            SingleServiceTracker<DataSourceFactory> tracker = this.trackerRef.get();
            if (tracker == null) {
                try {
                    tracker = new SingleServiceTracker<DataSourceFactory>(this.persistenceBundle.getBundleContext(), DataSourceFactory.class, "(osgi.jdbc.driver.class=" + this.driverName + ")", (SingleServiceTracker.SingleServiceListener)this);
                }
                catch (InvalidSyntaxException ise) {
                    throw new RuntimeException(ise);
                }
                if (this.trackerRef.compareAndSet(null, tracker)) {
                    tracker.open();
                } else {
                    tracker = this.trackerRef.get();
                }
            }
            if ((dsf = (DataSourceFactory)tracker.getService()) != null) {
                try {
                    if (this.jta) {
                        this.ds.compareAndSet(null, this.wrapXADataSource(dsf.createXADataSource(this.props)));
                    }
                    this.ds.compareAndSet(null, dsf.createDataSource(this.props));
                }
                catch (SQLException e) {
                    String message = NLS.MESSAGES.getMessage("datasourcefactory.sql.exception", new Object[]{this.driverName, this.props, this.persistenceBundle.getSymbolicName(), this.persistenceBundle.getVersion()});
                    _logger.error(message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
            } else {
                _logger.error(NLS.MESSAGES.getMessage("no.datasource.factory", new Object[]{this.driverName, this.props, this.persistenceBundle.getSymbolicName(), this.persistenceBundle.getVersion()}));
            }
        }
        return this.ds.get();
    }

    public void closeTrackers() {
        SingleServiceTracker tracker = this.trackerRef.getAndSet(null);
        if (tracker != null) {
            tracker.close();
        }
    }

    public void serviceFound() {
    }

    public void serviceLost() {
        this.ds.set(null);
    }

    public void serviceReplaced() {
        this.ds.set(null);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

