/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.aries.jpa.container.impl.EntityManagerProxyFactory;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.quiesce.impl.DestroyCallback;
import org.apache.aries.jpa.container.quiesce.impl.NamedCallback;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class QuiesceEMFHandler
implements InvocationHandler,
DestroyCallback {
    private final AtomicLong count = new AtomicLong(0L);
    private final EntityManagerFactory delegate;
    private final String name;
    private final AtomicReference<NamedCallback> callback = new AtomicReference();
    private final AtomicReference<ServiceRegistration> reg = new AtomicReference();
    static final long serialVersionUID = -8690444459866052362L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public QuiesceEMFHandler(EntityManagerFactory delegate, String name) {
        this.delegate = delegate;
        this.name = name;
    }

    @Override
    @FFDCIgnore(value={Throwable.class})
    public Object invoke(@Sensitive Object proxy, Method method, @Sensitive Object[] args) throws Throwable {
        if ("quiesce".equals(method.getName())) {
            this.quiesce((NamedCallback)args[0], (ServiceRegistration)args[1]);
            return null;
        }
        if ("clearQuiesce".equals(method.getName())) {
            this.clearQuiesce();
            return null;
        }
        Object res = null;
        try {
            res = method.invoke((Object)this.delegate, args);
        }
        catch (Throwable t) {
            if (t instanceof IllegalArgumentException) {
                throw new PersistenceException(NLS.MESSAGES.getMessage("wrong.JPA.version", new Object[]{method.getName(), this.delegate}), t);
            }
            while (t != null && t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t != null) {
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                for (Class<?> declaredException : method.getExceptionTypes()) {
                    if (!declaredException.isAssignableFrom(t.getClass())) continue;
                    throw t;
                }
            }
            throw new PersistenceException("Unexpected, checked exception", t);
        }
        if ("createEntityManager".equals(method.getName())) {
            this.count.incrementAndGet();
            return EntityManagerProxyFactory.create((EntityManager)res, this);
        }
        return res;
    }

    public void quiesce(NamedCallback callback, ServiceRegistration reg) {
        this.reg.compareAndSet(null, reg);
        this.callback.compareAndSet(null, callback);
        if (this.count.get() == 0L) {
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.reg.getAndSet(null));
            this.callback.set(null);
            callback.callback(this.name);
        }
    }

    @Override
    public void callback() {
        NamedCallback c;
        if (this.count.decrementAndGet() == 0L && (c = (NamedCallback)this.callback.getAndSet(null)) != null) {
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.reg.getAndSet(null));
            c.callback(this.name);
        }
    }

    public void clearQuiesce() {
        this.reg.set(null);
        NamedCallback c = this.callback.getAndSet(null);
        if (c != null) {
            c.callback(this.name);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(QuiesceEMFHandler.class);
    }
}

