/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.archive.internal;

import com.ibm.ws.kernel.boot.archive.UnixModeHelper;
import com.ibm.ws.kernel.boot.archive.internal.AbstractArchive;
import com.ibm.ws.kernel.boot.archive.internal.UnixModeHelperImpl;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ZipArchive
extends AbstractArchive {
    private final File archiveFile;
    private final ZipArchiveOutputStream zipOutputStream;
    private static UnixModeHelper helper;

    public ZipArchive(File archiveFile) throws IOException {
        this.archiveFile = archiveFile;
        this.zipOutputStream = new ZipArchiveOutputStream(archiveFile);
    }

    public void addFileEntry(String entryPath, File source) throws IOException {
        this.processEntry(entryPath, source);
    }

    public void addDirEntry(String entryPath, File source, List<String> dirContent) throws IOException {
        if (!entryPath.isEmpty()) {
            this.processEntry(entryPath, source);
        }
        for (String relativePath : dirContent) {
            String targetPath = entryPath + relativePath;
            File sourceFile = new File(source, relativePath);
            this.processEntry(targetPath, sourceFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntry(String targetPath, File sourceFile) throws IOException {
        if (sourceFile.isDirectory()) {
            targetPath = FileUtils.normalizeDirPath((String)targetPath);
        }
        if (!this.entryPaths.add(targetPath)) {
            return;
        }
        if (this.archiveFile.getCanonicalFile().equals(sourceFile.getCanonicalFile())) {
            return;
        }
        ZipArchiveEntry entry = (ZipArchiveEntry)this.zipOutputStream.createArchiveEntry(sourceFile, targetPath);
        if (helper != null) {
            entry.setUnixMode(helper.getUnixMode(sourceFile));
        }
        this.zipOutputStream.putArchiveEntry(entry);
        if (sourceFile.isFile()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(sourceFile);
                int bytesIn = 0;
                byte[] readBuffer = new byte[8192];
                bytesIn = fileInputStream.read(readBuffer);
                while (bytesIn != -1) {
                    this.zipOutputStream.write(readBuffer, 0, bytesIn);
                    bytesIn = fileInputStream.read(readBuffer);
                }
            }
            catch (IOException e) {
                try {
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.unableZipFile"), sourceFile.getAbsolutePath(), e));
                }
                catch (Throwable throwable) {
                    Utils.tryToClose(fileInputStream);
                    throw throwable;
                }
                Utils.tryToClose((Closeable)fileInputStream);
            }
            Utils.tryToClose((Closeable)fileInputStream);
        }
        this.zipOutputStream.closeArchiveEntry();
    }

    public void close() throws IOException {
        this.zipOutputStream.close();
    }

    static {
        try {
            Class.forName("java.nio.file.attribute.PosixFilePermission");
            helper = new UnixModeHelperImpl();
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

