/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractUtils;

public class ZipLicenseProvider
implements LicenseProvider {
    private final ZipFile zipFile;
    private final ZipEntry laZipEntry;
    private final ZipEntry liZipEntry;
    private final String pName;
    private final String lName;
    private static LicenseProvider instance;
    private static final String PROGRAM_NAME = "Program Name:";

    private ZipLicenseProvider(ZipFile zipFile, ZipEntry laZipEntry, ZipEntry liZipEntry, String pName, String lName) {
        this.zipFile = zipFile;
        this.laZipEntry = laZipEntry;
        this.liZipEntry = liZipEntry;
        this.pName = pName;
        this.lName = lName;
    }

    public static ReturnCode buildInstance(ZipFile zipFile, String laPrefix, String liPrefix) {
        ZipEntry laZipEntry = null;
        ZipEntry liZipEntry = null;
        ZipEntry liEnglishZipEntry = null;
        try {
            laZipEntry = SelfExtractUtils.getLicenseFile(zipFile, laPrefix);
            liZipEntry = SelfExtractUtils.getLicenseFile(zipFile, liPrefix);
            liEnglishZipEntry = zipFile.getEntry(liPrefix + (liPrefix.endsWith("_") ? "" : "_") + "en");
        }
        catch (Exception e) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        if (zipFile == null || laZipEntry == null || liZipEntry == null || liEnglishZipEntry == null) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        String lName = ZipLicenseProvider.getLicenseName(zipFile, laZipEntry);
        String pName = ZipLicenseProvider.getProgramName(zipFile, liEnglishZipEntry);
        if (pName == null || lName == null) {
            return new ReturnCode(2, "licenseNotFound", new Object[0]);
        }
        instance = new ZipLicenseProvider(zipFile, laZipEntry, liZipEntry, pName, lName);
        return ReturnCode.OK;
    }

    public static LicenseProvider createInstance(ZipFile zipFile, String laPrefix) {
        if (zipFile == null) {
            return null;
        }
        ZipEntry laZipEntry = null;
        try {
            laZipEntry = SelfExtractUtils.getLicenseFile(zipFile, laPrefix);
        }
        catch (Exception e) {
            return null;
        }
        String lName = ZipLicenseProvider.getLicenseName(zipFile, laZipEntry);
        if (lName == null) {
            return null;
        }
        return new ZipLicenseProvider(zipFile, laZipEntry, null, null, lName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getLicenseName(ZipFile zipFile, ZipEntry laZipEntry) {
        BufferedReader r;
        block4: {
            String string;
            r = null;
            try {
                r = new BufferedReader(new InputStreamReader(zipFile.getInputStream(laZipEntry), "UTF-16"));
                String line = r.readLine();
                if (line == null) break block4;
                string = line;
            }
            catch (IOException iOException) {
                SelfExtractUtils.tryToClose(r);
                catch (Throwable throwable) {
                    SelfExtractUtils.tryToClose(r);
                    throw throwable;
                }
            }
            SelfExtractUtils.tryToClose(r);
            return string;
        }
        SelfExtractUtils.tryToClose(r);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getProgramName(ZipFile zipFile, ZipEntry liEnglishZipEntry) {
        r = null;
        line = null;
        try {
            i = 0;
            r = new BufferedReader(new InputStreamReader(zipFile.getInputStream(liEnglishZipEntry), "UTF-16"));
            while (true) {
                line = r.readLine();
                if (line == null || !line.startsWith("Program Name:")) continue;
                var5_6 = line.substring("Program Name:".length() + 1);
                break;
            }
        }
        catch (IOException e) {
            SelfExtractUtils.tryToClose(r);
            return null;
            catch (Throwable var6_7) {
                SelfExtractUtils.tryToClose(r);
                throw var6_7;
            }
        }
        SelfExtractUtils.tryToClose(r);
        return var5_6;
        {
            if (line != null && i++ < 30) ** continue;
        }
        SelfExtractUtils.tryToClose(r);
        return null;
    }

    public static LicenseProvider getInstance() {
        return instance;
    }

    public InputStream getLicenseAgreement() {
        try {
            return this.zipFile.getInputStream(this.laZipEntry);
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream getLicenseInformation() {
        try {
            if (this.liZipEntry != null) {
                return this.zipFile.getInputStream(this.liZipEntry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getProgramName() {
        return this.pName;
    }

    public String getLicenseName() {
        return this.lName;
    }
}

