/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.SelfExtractor;

public class MapBasedSelfExtractor
implements Map {
    private final SelfExtractor extract;
    public static final String INSTALL_BUILD_CODE = "installer.init.code";
    public static final String INSTALL_BUILD_ERROR_MESSAGE = "installer.init.error.message";
    public static final String INSTALL_CODE = "install.code";
    public static final String INSTALL_ERROR_MESSAGE = "install.error.message";
    public static final String INSTALL_DIR = "install.dir";
    public static final String INSTALL_MONITOR = "install.monitor";
    public static final String INSTALL_MONITOR_SIZE = "install.monitor.size";
    public static final String PRODUCT_NAME = "product.name";
    public static final String LICENSE_NAME = "license.name";
    public static final String LICENSE_AGREEMENT = "license.agreement";
    public static final String LICENSE_ACCEPT = "license.accept";
    public static final String LICENSE_INFO = "license.info";
    public static final String INSTALL_VERSION = "install.version";
    public static final String HAS_EXTERNAL_DEPS = "has.external.deps";
    public static final String LIST_EXTERNAL_DEPS = "list.external.deps";
    public static final String EXTERNAL_DEPS_DESCRIPTION = "external.deps.description";
    public static final String ARCHIVE_CONTENT_TYPE = "archive.content.type";
    public static final String PROVIDED_FEATURES = "provided.features";
    public static final String TARGET_USER_DIR = "target.user.directory";
    public static final String DOWNLOAD_DEPS = "download.deps";
    public static final String DOWNLOAD_MONITOR = "download.monitor";
    public static final String DOWNLOAD_MONITOR_SIZE = "download.monitor.size";
    public static final String DOWNLOAD_FILE_MONITOR = "download.file.monitor";
    public static final String LICENSE_PRESENT = "license.present";
    public static final Integer INSTALL_VERSION_ONE = new Integer(1);
    public static final String PRODUCT_INSTALL_TYPE = "product.install.type";
    public static final String ALLOW_NON_EMPTY_INSTALL_DIR = "allow.non.empty.install.directory";
    private final Map data = new HashMap();
    private File installDir;
    private final ListBasedExtractProgress monitor = new ListBasedExtractProgress();
    private Boolean licenseAccepted = Boolean.FALSE;
    private Boolean downloadDependencies = Boolean.FALSE;

    public MapBasedSelfExtractor() {
        ReturnCode rc = SelfExtractor.buildInstance();
        this.data.put(INSTALL_BUILD_CODE, new Integer(rc.getCode()));
        this.data.put(INSTALL_BUILD_ERROR_MESSAGE, rc.getErrorMessage());
        this.extract = SelfExtractor.getInstance();
        if (this.extract != null) {
            this.data.put(INSTALL_MONITOR_SIZE, new Integer(this.extract.getSize()));
            if (this.extract.hasLicense()) {
                this.data.put(PRODUCT_NAME, this.extract.getProgramName());
                this.data.put(LICENSE_NAME, this.extract.getLicenseName());
            }
        }
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object arg0) {
        return this.data.containsKey(arg0);
    }

    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object arg0) {
        if (INSTALL_CODE.equals(arg0) && this.extract != null && this.installDir != null && (!this.extract.hasLicense() || this.licenseAccepted.booleanValue())) {
            ReturnCode rc = this.extract.validate(this.installDir);
            if (rc == ReturnCode.OK) {
                rc = this.extract.extract(this.installDir, this.monitor);
            }
            this.data.put(INSTALL_CODE, new Integer(rc.getCode()));
            this.data.put(INSTALL_ERROR_MESSAGE, rc.getErrorMessage());
        } else {
            if (LICENSE_AGREEMENT.equals(arg0)) {
                try {
                    return this.extract.hasLicense() ? new InputStreamReader(this.extract.getLicenseAgreement(), "UTF-16") : null;
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }
            if (LICENSE_INFO.equals(arg0)) {
                try {
                    return this.extract.hasLicense() ? new InputStreamReader(this.extract.getLicenseInformation(), "UTF-16") : null;
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }
            if (LICENSE_PRESENT.equals(arg0)) {
                return this.extract.hasLicense();
            }
            if (HAS_EXTERNAL_DEPS.equals(arg0)) {
                return this.extract.hasExternalDepsFile();
            }
            if (LIST_EXTERNAL_DEPS.equals(arg0)) {
                try {
                    return SelfExtractUtils.convertDependenciesListToMapsList(this.extract.getExternalDependencies());
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (ARCHIVE_CONTENT_TYPE.equals(arg0)) {
                return this.extract.getArchiveContentType();
            }
            if (PROVIDED_FEATURES.equals(arg0)) {
                return this.extract.getProvidedFeatures();
            }
            if (EXTERNAL_DEPS_DESCRIPTION.equals(arg0)) {
                try {
                    return this.extract.getExternalDependencies().getDescription();
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (DOWNLOAD_MONITOR_SIZE.equals(arg0)) {
                return new Integer(this.extract.getTotalDepsSize());
            }
        }
        return this.data.get(arg0);
    }

    public boolean isEmpty() {
        return false;
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object arg0, Object arg1) {
        Object old = null;
        if (INSTALL_DIR.equals(arg0)) {
            if (!(arg1 instanceof File)) throw new IllegalArgumentException();
            old = this.installDir;
            this.installDir = (File)arg1;
            return old;
        } else if (INSTALL_MONITOR.equals(arg0)) {
            if (!(arg1 instanceof List)) throw new IllegalArgumentException();
            if (this.monitor.extractedFiles != null) {
                old = this.monitor.extractedFiles;
            }
            this.monitor.extractedFiles = (List)arg1;
            return old;
        } else if (DOWNLOAD_FILE_MONITOR.equals(arg0)) {
            if (!(arg1 instanceof List)) throw new IllegalArgumentException();
            if (this.monitor.downloadedFiles != null) {
                old = this.monitor.downloadedFiles;
            }
            this.monitor.downloadedFiles = (List)arg1;
            return old;
        } else if (DOWNLOAD_MONITOR.equals(arg0)) {
            if (!(arg1 instanceof List)) throw new IllegalArgumentException();
            if (this.monitor.downloadSizeMonitor != null) {
                old = this.monitor.downloadSizeMonitor;
            }
            this.monitor.downloadSizeMonitor = (List)arg1;
            return old;
        } else {
            if (INSTALL_VERSION.equals(arg0)) {
                Object val;
                if (arg1 instanceof Integer) {
                    if (!INSTALL_VERSION_ONE.equals(arg1)) return old;
                    return arg1;
                }
                if (!(arg1 instanceof List)) return old;
                Iterator it = ((List)arg1).iterator();
                do {
                    if (!it.hasNext()) return old;
                } while (!INSTALL_VERSION_ONE.equals(val = it.next()));
                return val;
            }
            if (LICENSE_ACCEPT.equals(arg0)) {
                if (!(arg1 instanceof Boolean)) throw new IllegalArgumentException();
                this.licenseAccepted = (Boolean)arg1;
                return old;
            } else if (DOWNLOAD_DEPS.equals(arg0)) {
                if (!(arg1 instanceof Boolean)) throw new IllegalArgumentException();
                this.downloadDependencies = (Boolean)arg1;
                this.extract.setDoExternalDepsDownload(this.downloadDependencies);
                return old;
            } else if (TARGET_USER_DIR.equals(arg0)) {
                if (!(arg1 instanceof File)) throw new IllegalArgumentException();
                this.extract.setUserDirOverride((File)arg1);
                return old;
            } else if (PRODUCT_INSTALL_TYPE.equals(arg0)) {
                if (!(arg1 instanceof String)) throw new IllegalArgumentException();
                this.extract.setProductInstallTypeOveride((String)arg1);
                return old;
            } else {
                if (!ALLOW_NON_EMPTY_INSTALL_DIR.equals(arg0)) return old;
                if (!(arg1 instanceof Boolean)) throw new IllegalArgumentException();
                this.extract.allowNonEmptyInstallDirectory((Boolean)arg1);
            }
        }
        return old;
    }

    public void putAll(Map arg0) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    private static class ListBasedExtractProgress
    implements ExtractProgress {
        private List extractedFiles;
        private List downloadedFiles;
        private List downloadSizeMonitor;
        private boolean canceled;

        private ListBasedExtractProgress() {
        }

        public void downloadingFile(URL sourceUrl, File targetFile) {
            if (this.downloadedFiles != null) {
                HashMap<String, Serializable> downloadInformation = new HashMap<String, Serializable>();
                downloadInformation.put("download.url", sourceUrl);
                downloadInformation.put("download.target.file", targetFile);
                this.canceled = !this.downloadedFiles.add(downloadInformation);
            }
        }

        public void dataDownloaded(int numBytes) {
            if (this.downloadSizeMonitor != null) {
                this.downloadSizeMonitor.add(numBytes);
            }
        }

        public void extractedFile(String f) {
            if (this.extractedFiles != null) {
                this.canceled = !this.extractedFiles.add(f);
            }
        }

        public void setFilesToExtract(int count) {
        }

        public void commandRun(List args) {
        }

        public void commandsToRun(int count) {
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void skippedFile() {
            if (this.extractedFiles != null) {
                this.canceled = !this.extractedFiles.add(INSTALL_VERSION_ONE);
            }
        }
    }
}

