/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import wlp.lib.extract.ChangeHistory;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ProductMatch;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.SelfExtractor;

public class LicenseSelfExtractor
extends SelfExtractor {
    private static final String LA_FILES_PREFIX = "lafiles/";
    private static final String FEATURES_PREFIX = "lib/features";
    private static final String TAG_FILES_PREFIX = "lib/versions/tags/";
    private static final String WAS_PROPERTIES_FILE = "lib/versions/WebSphereApplicationServer.properties";
    private static final String FIX_NAME_FRAGMENT_FIX_PACK = " Fix Pack ";
    private static final Pattern validNumericVersion = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)$");
    private final LicenseArchive licenseArchive = new LicenseArchive();

    protected LicenseSelfExtractor(JarFile jar, LicenseProvider licenseProvider, Attributes attributes) throws IOException {
        super(jar, licenseProvider, attributes);
    }

    public String getExtractSuccessMessageKey() {
        return "extractLicenseSuccess";
    }

    public String getExtractInstructionMessageKey() {
        return "extractLicenseInstruction";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnCode extract(File wlpInstallDir, ExtractProgress ep) {
        ChangeHistory history = new ChangeHistory();
        if (ep == null) {
            ep = new SelfExtractor.NullExtractProgress();
        }
        File libertyPropsFile = new File(wlpInstallDir, WAS_PROPERTIES_FILE);
        Properties libertyProps = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(libertyPropsFile);
            libertyProps.load(is);
        }
        catch (IOException ioe) {
            ReturnCode returnCode;
            try {
                returnCode = new ReturnCode(4, "extractFileError", ioe.getMessage());
            }
            catch (Throwable throwable) {
                SelfExtractUtils.tryToClose(is);
                throw throwable;
            }
            SelfExtractUtils.tryToClose(is);
            return returnCode;
        }
        SelfExtractUtils.tryToClose(is);
        try {
            WASProperties _libertyProps = new WASProperties(libertyProps, libertyPropsFile, history);
            _libertyProps.setProductEdition(this.licenseArchive.getWASProperties().getProductEdition());
            _libertyProps.setProductLicenseType(this.licenseArchive.getWASProperties().getProductLicenseType());
            _libertyProps.store();
            File libertyLicenseDir = new File(wlpInstallDir, LA_FILES_PREFIX);
            LicenseSelfExtractor.cleanDirectory(libertyLicenseDir, history);
            this.writeLicenseFiles(this.licenseArchive, libertyLicenseDir, history, ep);
            File libertyTagsDir = new File(wlpInstallDir, TAG_FILES_PREFIX);
            String fixpackVersion = LicenseSelfExtractor.getFixpackVersionFromFxtagFile(libertyTagsDir);
            boolean is855Tags = _libertyProps.getProductVersion().startsWith("8.5");
            LicenseSelfExtractor.cleanDirectory(libertyTagsDir, history);
            this.writeTagFiles(this.licenseArchive, libertyTagsDir, history, ep, is855Tags);
            if (fixpackVersion != null) {
                LicenseSelfExtractor.updateFixPackVersion(libertyTagsDir, fixpackVersion);
            } else {
                LicenseSelfExtractor.updateFixPackVersion(libertyTagsDir, _libertyProps.getProductVersion());
            }
        }
        catch (IOException ioe) {
            history.rollback();
            return new ReturnCode(4, "extractFileError", ioe.getMessage());
        }
        return ReturnCode.OK;
    }

    private static String getFixpackVersionFromFxtagFile(File libertyTagsDir) throws IOException {
        File fxtagFile = LicenseSelfExtractor.findFxtagFile(libertyTagsDir);
        if (fxtagFile == null) {
            return null;
        }
        Document doc = LicenseSelfExtractor.toDOM(fxtagFile);
        if (fxtagFile.getName().endsWith(".fxtag")) {
            for (Node n = doc.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
                if (1 != n.getNodeType() || !"FixVersion".equals(n.getNodeName())) continue;
                if ((n = n.getFirstChild()) != null && 3 == n.getNodeType()) {
                    return n.getNodeValue();
                }
                return null;
            }
        } else {
            for (Node n = doc.getDocumentElement().getOwnerDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"SoftwareIdentity".equals(n.getNodeName())) continue;
                Element e = (Element)n;
                return e.getAttribute("version");
            }
        }
        return null;
    }

    private static void updateFixPackVersion(File libertyTagsDir, String version) throws IOException {
        File fxtagFile = LicenseSelfExtractor.findFxtagFile(libertyTagsDir);
        if (fxtagFile == null) {
            return;
        }
        if (fxtagFile.getName().endsWith(".fxtag")) {
            LicenseSelfExtractor.updateFixpackVersionInFxtagFile(fxtagFile, version);
        } else {
            LicenseSelfExtractor.updateFixpackVersionInISOTagFile(fxtagFile, version);
        }
    }

    private static void updateFixpackVersionInFxtagFile(File fxtagFile, String version) throws IOException {
        Document doc = LicenseSelfExtractor.toDOM(fxtagFile);
        for (Node n = doc.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
            String s;
            int index;
            Node child;
            if (1 != n.getNodeType()) continue;
            String nodeName = n.getNodeName();
            if ("FixName".equals(nodeName)) {
                int index2;
                child = n.getFirstChild();
                if (child == null || 3 != child.getNodeType() || (index2 = version.lastIndexOf(46)) == 1) continue;
                String baseVersion = version.substring(0, index2);
                String fixpackNumber = version.substring(index2 + 1);
                String s2 = child.getNodeValue();
                index2 = s2.lastIndexOf(FIX_NAME_FRAGMENT_FIX_PACK);
                if (index2 == -1 || (index2 = (s2 = s2.substring(0, index2)).lastIndexOf(118)) == -1) continue;
                StringBuffer buffer = new StringBuffer();
                buffer.append(s2.substring(0, index2 + 1));
                buffer.append(baseVersion);
                buffer.append(FIX_NAME_FRAGMENT_FIX_PACK);
                buffer.append(fixpackNumber);
                n.replaceChild(doc.createTextNode(buffer.toString()), child);
                continue;
            }
            if ("FixVersion".equals(nodeName)) {
                child = n.getFirstChild();
                Text fixVersionText = doc.createTextNode(version);
                if (child == null) {
                    n.appendChild(fixVersionText);
                    continue;
                }
                if (3 != child.getNodeType()) continue;
                n.replaceChild(fixVersionText, child);
                continue;
            }
            if (!"FixID".equals(nodeName) || (child = n.getFirstChild()) == null || 3 != child.getNodeType() || (index = (s = child.getNodeValue()).lastIndexOf(45)) == -1) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(s.substring(0, index + 1));
            buffer.append(version);
            n.replaceChild(doc.createTextNode(buffer.toString()), child);
        }
        LicenseSelfExtractor.toFile(doc, fxtagFile);
    }

    private static void updateFixpackVersionInISOTagFile(File fxtagFile, String version) throws IOException {
        Document doc = LicenseSelfExtractor.toDOM(fxtagFile);
        Node n = doc.getDocumentElement().getOwnerDocument().getFirstChild();
        while (n != null) {
            Element e;
            if ("SoftwareIdentity".equals(n.getNodeName())) {
                e = (Element)n;
                e.setAttribute("version", version);
                String tagId = e.getAttribute("tagId");
                tagId = tagId.replaceFirst("\\d+\\.\\d+\\.\\d+\\.\\d+", version);
                e.setAttribute("tagId", tagId);
                n = n.getFirstChild();
                continue;
            }
            if ("Meta".equals(n.getNodeName()) && (e = (Element)n).getAttribute("fixId") != null && !e.getAttribute("fixId").isEmpty()) {
                e.setAttribute("fixId", version);
            }
            n = n.getNextSibling();
        }
        if (!fxtagFile.getName().contains(version)) {
            File fxtagFileNew = new File(fxtagFile.getParentFile(), fxtagFile.getName().replaceAll("\\d+\\.\\d+\\.\\d+\\.\\d+", version));
            fxtagFile.delete();
            LicenseSelfExtractor.toFile(doc, fxtagFileNew);
        } else {
            LicenseSelfExtractor.toFile(doc, fxtagFile);
        }
    }

    private static File findFxtagFile(File libertyTagsDir) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                Pattern pattern = Pattern.compile("ibm.com_WebSphere_Application_Server_Liberty(.*?)-\\d+\\.\\d+\\.\\d+\\.\\d+\\.swidtag");
                return name.endsWith(".fxtag") || pattern.matcher(new File(name).getName()).matches();
            }
        };
        File[] fxtagFiles = libertyTagsDir.listFiles(filter);
        if (fxtagFiles != null && fxtagFiles.length > 0) {
            return fxtagFiles[0];
        }
        return null;
    }

    private static Document toDOM(File file) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            dbf.setCoalescing(true);
            dbf.setExpandEntityReferences(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                }

                public void error(SAXParseException exception) throws SAXException {
                }
            });
            return db.parse(file);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce);
        }
        catch (SAXException spe) {
            throw new IOException(spe);
        }
    }

    private static void toFile(Document doc, File file) throws IOException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(doc), new StreamResult(file));
        }
        catch (TransformerConfigurationException tce) {
            throw new IOException(tce);
        }
        catch (TransformerException te) {
            throw new IOException(te);
        }
    }

    public static final void cleanDirectory(File dir, ChangeHistory history) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            File file;
            int i;
            for (i = 0; i < files.length; ++i) {
                file = files[i];
                if (file.isDirectory() || file.canWrite() || file.setWritable(true)) continue;
                throw new IOException("java.io.File.canWrite()");
            }
            for (i = 0; i < files.length; ++i) {
                file = files[i];
                if (file.isDirectory()) continue;
                if (!file.canRead()) {
                    throw new IOException("java.io.File.canRead()");
                }
                byte[] bytes = LicenseSelfExtractor.writeFileToMemory(file);
                if (!file.delete()) {
                    throw new IOException("java.io.File.delete()");
                }
                history.deletedFile(file.getAbsolutePath(), bytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] writeFileToMemory(File file) throws IOException {
        byte[] byArray;
        byte[] buffer = new byte[2048];
        FileInputStream fis = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            while ((len = fis.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            SelfExtractUtils.tryToClose(fis);
            SelfExtractUtils.tryToClose(baos);
            throw throwable;
        }
        SelfExtractUtils.tryToClose(fis);
        SelfExtractUtils.tryToClose(baos);
        return byArray;
    }

    public void writeLicenseFiles(LicenseArchive archive, File toDir, ChangeHistory history, ExtractProgress ep) throws IOException {
        this.writeArchiveFiles(archive.getLicenseFiles(), toDir, history, ep);
    }

    public void writeTagFiles(LicenseArchive archive, File toDir, ChangeHistory history, ExtractProgress ep, boolean is855Tags) throws IOException {
        this.writeArchiveFiles(archive.getTagFiles(is855Tags), toDir, history, ep);
    }

    private void writeArchiveFiles(Iterator files, File toDir, ChangeHistory history, ExtractProgress ep) throws IOException {
        while (files.hasNext()) {
            LicenseArchive.Entry fileEntry = (LicenseArchive.Entry)files.next();
            File toFile = new File(toDir, fileEntry.getFileName());
            byte[] buffer = new byte[2048];
            InputStream is = null;
            FileOutputStream os = null;
            try {
                int len;
                is = fileEntry.getInputStream();
                os = new FileOutputStream(toFile);
                while ((len = is.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, len);
                }
                os.flush();
            }
            catch (IOException ioe) {
                try {
                    if (toFile.exists()) {
                        history.createdFile(toFile.getAbsolutePath());
                    }
                    throw ioe;
                }
                catch (Throwable throwable) {
                    SelfExtractUtils.tryToClose(is);
                    SelfExtractUtils.tryToClose(os);
                    throw throwable;
                }
            }
            SelfExtractUtils.tryToClose(is);
            SelfExtractUtils.tryToClose(os);
            history.createdFile(toFile.getAbsolutePath());
            ep.extractedFile(fileEntry.getPath());
        }
    }

    public ReturnCode validate(File outputDir) {
        ReturnCode result = LicenseSelfExtractor.validateProductMatches(outputDir, this.productMatches);
        if (result.getCode() == 0) {
            File libertyLicenseDir = new File(outputDir, LA_FILES_PREFIX);
            if (!libertyLicenseDir.exists()) {
                return new ReturnCode(4, "invalidInstall", libertyLicenseDir.getAbsolutePath());
            }
            File libertyTagsDir = new File(outputDir, TAG_FILES_PREFIX);
            if (!libertyTagsDir.exists()) {
                return new ReturnCode(4, "invalidInstall", libertyTagsDir.getAbsolutePath());
            }
            File libertyPropsFile = new File(outputDir, WAS_PROPERTIES_FILE);
            if (!libertyPropsFile.exists()) {
                return new ReturnCode(4, "invalidInstall", libertyPropsFile.getAbsolutePath());
            }
            try {
                return LicenseSelfExtractor.validateInstalledFeatures(outputDir, this.licenseArchive.getWASProperties());
            }
            catch (SelfExtractor.SelfExtractorFileException sefe) {
                return new ReturnCode(1, "fileProcessingException", new Object[]{sefe.getFileName(), sefe.getCause()});
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private static ReturnCode validateInstalledFeatures(File outputDir, WASProperties props) throws SelfExtractor.SelfExtractorFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final class WASProperties {
        private final Properties props;
        private final File outputFile;
        private final ChangeHistory history;
        private final Map changedProps;

        public WASProperties(Properties props) {
            this(props, null, null);
        }

        public WASProperties(Properties props, File outputFile, ChangeHistory history) {
            this.props = props;
            this.outputFile = outputFile;
            this.history = history;
            this.changedProps = outputFile != null ? new HashMap() : null;
        }

        public String getProductVersion() {
            return this.props.getProperty("com.ibm.websphere.productVersion");
        }

        public void setProductVersion(String version) {
            if (this.outputFile == null) {
                throw new IllegalStateException("Read only");
            }
            this.setProperty("com.ibm.websphere.productVersion", version);
        }

        public String getProductInstallType() {
            return this.props.getProperty("com.ibm.websphere.productInstallType");
        }

        public void setProductInstallType(String installType) {
            if (this.outputFile == null) {
                throw new IllegalStateException("Read only");
            }
            this.setProperty("com.ibm.websphere.productInstallType", installType);
        }

        public String getProductEdition() {
            return this.props.getProperty("com.ibm.websphere.productEdition");
        }

        public void setProductEdition(String productEdition) {
            if (this.outputFile == null) {
                throw new IllegalStateException("Read only");
            }
            this.setProperty("com.ibm.websphere.productEdition", productEdition);
        }

        public String getProductLicenseType() {
            return this.props.getProperty("com.ibm.websphere.productLicenseType");
        }

        public void setProductLicenseType(String productLicenseType) {
            if (this.outputFile == null) {
                throw new IllegalStateException("Read only");
            }
            this.setProperty("com.ibm.websphere.productLicenseType", productLicenseType);
        }

        private void setProperty(String property, String value) {
            String[] oldNewValuePair = (String[])this.changedProps.get(property);
            if (oldNewValuePair == null) {
                oldNewValuePair = new String[2];
                oldNewValuePair[0] = this.props.getProperty(property);
                this.changedProps.put(property, oldNewValuePair);
            }
            this.props.setProperty(property, value);
            oldNewValuePair[1] = value;
        }

        public int matches(ProductMatch match) {
            return match.matches(this.props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store() throws IOException {
            if (this.outputFile == null) {
                throw new IllegalStateException("Read only");
            }
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(this.outputFile);
                this.props.store(os, null);
                this.history.changedProps(this.outputFile.getAbsolutePath(), new HashMap(this.changedProps));
                this.changedProps.clear();
            }
            catch (Throwable throwable) {
                SelfExtractUtils.tryToClose(os);
                throw throwable;
            }
            SelfExtractUtils.tryToClose(os);
        }
    }

    public final class LicenseArchive {
        private static final String WLP_ROOT = "wlp/";
        private static final String WLP_LA_FILES_PREFIX = "wlp/lafiles/";
        private static final String WLP_TAG_FILES_PREFIX = "wlp/lib/versions/tags/";
        private static final String WLP_WAS_PROPERTIES_FILE = "wlp/lib/versions/WebSphereApplicationServer.properties";
        private static final String WLP_ISO_TAG_SUFFIX = ".swidtag";
        private final List laFiles = new ArrayList();
        private final List isoTagFiles = new ArrayList();
        private final List tagFiles = new ArrayList();
        private final WASProperties properties;

        public LicenseArchive() throws IOException {
            int index;
            Enumeration<? extends ZipEntry> jarEntries = LicenseSelfExtractor.this.jarFile.entries();
            Properties props = new Properties();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)jarEntries.nextElement();
                String name = jarEntry.getName();
                if (name.startsWith(WLP_LA_FILES_PREFIX)) {
                    if (jarEntry.isDirectory() || name.substring(WLP_LA_FILES_PREFIX.length()).indexOf(47) != -1) continue;
                    this.laFiles.add(new Entry(jarEntry));
                    continue;
                }
                if (name.startsWith(WLP_TAG_FILES_PREFIX)) {
                    if (jarEntry.isDirectory() || name.substring(WLP_TAG_FILES_PREFIX.length()).indexOf(47) != -1) continue;
                    if (name.endsWith(WLP_ISO_TAG_SUFFIX)) {
                        this.isoTagFiles.add(new Entry(jarEntry));
                        continue;
                    }
                    this.tagFiles.add(new Entry(jarEntry));
                    continue;
                }
                if (!name.equals(WLP_WAS_PROPERTIES_FILE)) continue;
                props.load(LicenseSelfExtractor.this.jarFile.getInputStream(jarEntry));
            }
            this.properties = new WASProperties(props);
            String version = this.properties.getProductVersion();
            Matcher versionMatcher = validNumericVersion.matcher(version);
            if (versionMatcher.matches() && (index = version.lastIndexOf(46)) != -1) {
                this.properties.props.setProperty("com.ibm.websphere.productVersion", version.substring(0, index));
            }
        }

        public Iterator getLicenseFiles() {
            return this.laFiles.iterator();
        }

        public Iterator getTagFiles(boolean is855Tags) {
            if (is855Tags) {
                return this.tagFiles.iterator();
            }
            return this.isoTagFiles.iterator();
        }

        public WASProperties getWASProperties() {
            return this.properties;
        }

        public final class Entry {
            private final JarEntry jarEntry;

            public Entry(JarEntry jarEntry) {
                this.jarEntry = jarEntry;
            }

            public InputStream getInputStream() throws IOException {
                return ((LicenseArchive)LicenseArchive.this).LicenseSelfExtractor.this.jarFile.getInputStream(this.jarEntry);
            }

            public String getPath() {
                return this.jarEntry.getName();
            }

            public String getFileName() {
                String name = this.getPath();
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash != -1) {
                    name = name.substring(lastSlash + 1);
                }
                return name;
            }
        }
    }
}

