/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.generator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils;
import com.ibm.ws.kernel.feature.internal.generator.Indenter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FeatureListWriter {
    private final XMLStreamWriter writer;
    private final Indenter i;
    static final long serialVersionUID = -7046717230429741804L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FeatureListWriter(FeatureListUtils utils) throws XMLStreamException, UnsupportedEncodingException {
        this.writer = utils.getXMLStreamWriter();
        this.i = utils.getIndenter();
    }

    public void writeTextElement(String nodeName, String text) throws IOException, XMLStreamException {
        this.i.indent(2);
        this.writer.writeStartElement(nodeName);
        this.writer.writeCharacters(text);
        this.writer.writeEndElement();
    }

    public void writeTextElementWithAttributes(String nodeName, String text, Map<String, String> attrs) throws IOException, XMLStreamException {
        this.i.indent(2);
        this.writer.writeStartElement(nodeName);
        for (Map.Entry<String, String> attr : attrs.entrySet()) {
            this.writer.writeAttribute(attr.getKey(), attr.getValue());
        }
        this.writer.writeCharacters(text);
        this.writer.writeEndElement();
    }

    public void startFeature(String nodeName, String name) throws IOException, XMLStreamException {
        this.i.indent(1);
        this.writer.writeStartElement(nodeName);
        if (name != null) {
            this.writer.writeAttribute("name", name);
        }
    }

    public void endFeature() throws IOException, XMLStreamException {
        this.i.indent(1);
        this.writer.writeEndElement();
    }

    public void startFeature(String nodeName) throws IOException, XMLStreamException {
        this.startFeature(nodeName, null);
    }

    public void writeIncludeFeature(String preferred, List<String> tolerates, String shortName) throws IOException, XMLStreamException {
        this.i.indent(2);
        this.writer.writeStartElement("include");
        this.writer.writeAttribute("symbolicName", preferred);
        if (shortName != null) {
            this.writer.writeAttribute("shortName", shortName);
        }
        if (tolerates != null) {
            StringBuilder toleratesValue = new StringBuilder();
            for (String tolerate : tolerates) {
                if (toleratesValue.length() > 0) {
                    toleratesValue.append(',');
                }
                toleratesValue.append(tolerate);
            }
            this.writer.writeAttribute("tolerates", toleratesValue.toString());
        }
        this.writer.writeEndElement();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FeatureListWriter.class);
    }
}

