/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ShutdownHookManager
extends Thread {
    protected final CopyOnWriteArraySet<ShutdownHookListener> shutdownListeners = new CopyOnWriteArraySet();
    private final AtomicBoolean hookSet = new AtomicBoolean(false);
    private volatile boolean shutdownInvoked = false;
    static final long serialVersionUID = 6313948673319050596L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={IllegalStateException.class})
    public void addShutdownHook() {
        try {
            if (this.hookSet.compareAndSet(false, true)) {
                Runtime.getRuntime().addShutdownHook(this);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @FFDCIgnore(value={IllegalStateException.class})
    public synchronized void removeShutdownHook() {
        if (this.shutdownInvoked) {
            return;
        }
        try {
            if (this.hookSet.compareAndSet(true, false)) {
                Runtime.getRuntime().removeShutdownHook(this);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void addListener(ShutdownHookListener listener) {
        if (this.shutdownInvoked) {
            listener.shutdownHookInvoked();
            return;
        }
        this.shutdownListeners.add(listener);
    }

    public void removeListener(ShutdownHookListener listener) {
        this.shutdownListeners.remove(listener);
    }

    public boolean vmShutdown() {
        return this.shutdownInvoked;
    }

    @Override
    public void run() {
        this.shutdownInvoked = true;
        for (ShutdownHookListener listener : this.shutdownListeners) {
            listener.shutdownHookInvoked();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ShutdownHookManager.class);
    }

    static interface ShutdownHookListener {
        public void shutdownHookInvoked();
    }
}

