/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.FeatureDefinition;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener;
import com.ibm.ws.kernel.feature.internal.BundleInstallStatus;
import com.ibm.ws.kernel.feature.internal.BundleLifecycleStatus;
import com.ibm.ws.kernel.feature.internal.BundleList;
import com.ibm.ws.kernel.feature.internal.EEValue;
import com.ibm.ws.kernel.feature.internal.FeatureResolverImpl;
import com.ibm.ws.kernel.feature.internal.InitialProvisioningListener;
import com.ibm.ws.kernel.feature.internal.PackageInspectorImpl;
import com.ibm.ws.kernel.feature.internal.Provisioner;
import com.ibm.ws.kernel.feature.internal.RestrictedFeatureRespository;
import com.ibm.ws.kernel.feature.internal.ServerContentHelper;
import com.ibm.ws.kernel.feature.internal.ServerFeaturesHelper;
import com.ibm.ws.kernel.feature.internal.ShutdownHookManager;
import com.ibm.ws.kernel.feature.internal.StartLevelFrameworkListener;
import com.ibm.ws.kernel.feature.internal.VersionValue;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository;
import com.ibm.ws.kernel.feature.internal.subsystem.KernelFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.kernel.launch.service.FrameworkReady;
import com.ibm.ws.kernel.launch.service.ProductExtensionServiceFingerprint;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={FeatureProvisioner.class, FrameworkReady.class, ManagedService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.pid=com.ibm.ws.kernel.feature"})
public class FeatureManager
implements FeatureProvisioner,
FrameworkReady,
ManagedService {
    private static final String ME = FeatureManager.class.getName();
    private static final TraceComponent tc = Tr.register(FeatureManager.class);
    private static final String CFG_KEY_ACTIVE_FEATURES = "feature";
    static final String INSTALLED_BUNDLE_CACHE = "platform/feature.bundles.cache";
    static final String FEATURE_DEF_CACHE_FILE = "platform/feature.cache";
    static final String FEATURE_PRODUCT_EXTENSIONS_INSTALL = "com.ibm.websphere.productInstall";
    static final String FEATURE_PRODUCT_EXTENSIONS_FILE_EXTENSION = ".properties";
    static final FeatureResolver featureResolver = new FeatureResolverImpl();
    static final Collection<String> ALLOWED_ON_ALL_FEATURES = Arrays.asList("com.ibm.websphere.appserver.timedexit-1.0", "com.ibm.websphere.appserver.osgiConsole-1.0");
    static final Collection<String> ALL_ALLOWED_ON_CLIENT_FEATURES;
    static final String featureGroup = "feature";
    static final String featureGroupUsr = "feature:usr";
    static final String bundleGroup = "bundle";
    protected final ConcurrentLinkedQueue<FeatureChange> featureChanges;
    BundleContext bundleContext;
    protected volatile WsLocationAdmin locationService = null;
    protected ExecutorService executorService = null;
    protected VariableRegistry variableRegistry = null;
    protected RuntimeUpdateManager runtimeUpdateManager = null;
    protected EventAdmin eventAdminService = null;
    private RegionDigraph digraph = null;
    protected final ReentrantLock iAmUpdater;
    protected FrameworkStartLevel fwStartLevel;
    protected final InitialProvisioningListener initialProvisioningLatch = new InitialProvisioningListener();
    private static final AtomicLong featureUpdateNumber;
    protected OnErrorUtil.OnError onError;
    protected FeatureRepository featureRepository;
    protected BundleList bundleCache;
    protected volatile ProvisioningMode provisioningMode;
    protected final PackageInspectorImpl packageInspector;
    protected final ShutdownHookManager shutdownHook;
    private BundleListener bundleOriginsListener = null;
    private EnumSet<ProcessType> supportedProcessTypes = null;
    private String processTypeString = null;
    private volatile boolean deactivated;
    static final long serialVersionUID = 5271256024485052382L;

    public FeatureManager() {
        this.featureChanges = new ConcurrentLinkedQueue();
        this.iAmUpdater = new ReentrantLock();
        this.packageInspector = new PackageInspectorImpl();
        this.shutdownHook = new ShutdownHookManager();
        this.shutdownHook.addShutdownHook();
        this.shutdownHook.addListener(this.initialProvisioningLatch);
    }

    @Activate
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        this.setSupportedProcessTypes(componentContext);
        this.bundleContext = componentContext.getBundleContext();
        this.fwStartLevel = (FrameworkStartLevel)this.bundleContext.getBundle("System Bundle").adapt(FrameworkStartLevel.class);
        this.packageInspector.activate(this.bundleContext);
        this.variableRegistry.addVariable(featureGroupUsr, "${usr.extension.dir}/lib/features/");
        BundleRepositoryRegistry.initializeDefaults((String)this.locationService.getServerName(), (boolean)true);
        WsResource bundleCacheFile = this.locationService.getServerWorkareaResource(INSTALLED_BUNDLE_CACHE);
        WsResource featureCacheFile = this.locationService.getServerWorkareaResource(FEATURE_DEF_CACHE_FILE);
        this.processProductExtensionsPropertiesFiles();
        this.featureRepository = new FeatureRepository(featureCacheFile, this.bundleContext);
        this.bundleCache = new BundleList(bundleCacheFile, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Feature Manager activated", (Object[])new Object[0]);
        }
        this.provisioningMode = ServerContentHelper.isServerContentRequest(this.bundleContext) ? ProvisioningMode.CONTENT_REQUEST : (ServerFeaturesHelper.isServerFeaturesRequest(this.bundleContext) ? ProvisioningMode.FEATURES_REQUEST : ProvisioningMode.INITIAL_PROVISIONING);
        this.bundleOriginsListener = new BundleInstallOriginBundleListener(this.bundleContext);
        this.bundleContext.addBundleListener(this.bundleOriginsListener);
    }

    private void setSupportedProcessTypes(ComponentContext componentContext) {
        String processTypeProp = componentContext.getBundleContext().getProperty("wlp.process.type");
        this.supportedProcessTypes = ProcessType.fromString(processTypeProp);
        this.processTypeString = processTypeProp;
    }

    private void processProductExtensionsPropertiesFiles() {
        for (ProductExtensionInfo prodExt : ProductExtension.getProductExtensions()) {
            String featureType = prodExt.getName();
            String fileName = featureType + FEATURE_PRODUCT_EXTENSIONS_FILE_EXTENSION;
            if (0 == featureType.length()) continue;
            String featurePath = prodExt.getLocation();
            if (featurePath != null) {
                String installDir;
                WsResource location;
                String normalPath = PathUtils.normalize((String)(featurePath = featurePath + "/"));
                if (PathUtils.containsSymbol((String)normalPath)) {
                    Tr.error((TraceComponent)tc, (String)"PRODUCT_FEATURE_INSTALL_PATH_SYMBOL_ERROR", (Object[])new Object[]{fileName, PathUtils.getSymbol((String)normalPath)});
                    continue;
                }
                WsLocationAdmin wsLocationAdmin = this.locationService;
                if (PathUtils.pathIsAbsolute((String)normalPath)) {
                    location = wsLocationAdmin.resolveResource(featurePath + "lib/features/");
                } else {
                    location = wsLocationAdmin.resolveResource("${wlp.parent.dir}/" + featurePath + "lib/features/");
                    featurePath = "${wlp.parent.dir}/" + featurePath;
                }
                if (location != null && location.exists()) {
                    installDir = wsLocationAdmin.resolveString(featurePath);
                    if (installDir.equalsIgnoreCase(wsLocationAdmin.resolveString("${wlp.install.dir}/"))) {
                        Tr.error((TraceComponent)tc, (String)"PRODUCT_FEATURE_INSTALL_PATH_WLP_ERROR", (Object[])new Object[]{fileName});
                        continue;
                    }
                    this.variableRegistry.addVariable("feature:" + featureType, featurePath + "lib/features/");
                    wsLocationAdmin.addLocation(installDir, featureType + ".extension.dir");
                    ProductExtensionServiceFingerprint.putProductExtension((String)prodExt.getName(), (String)installDir);
                    BundleRepositoryRegistry.addBundleRepository((String)installDir, (String)featureType);
                    continue;
                }
                installDir = wsLocationAdmin.resolveString(featurePath);
                Tr.error((TraceComponent)tc, (String)"PRODUCT_FEATURE_INSTALL_PATH_ERROR", (Object[])new Object[]{installDir, fileName});
                continue;
            }
            Tr.error((TraceComponent)tc, (String)"PRODUCT_FEATURE_PROPERTIES_FILE_ERROR", (Object[])new Object[]{fileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    @FFDCIgnore(value={InterruptedException.class})
    protected void deactivate(int reason) {
        boolean lockObtained = false;
        try {
            lockObtained = this.iAmUpdater.tryLock(30L, TimeUnit.SECONDS);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Feature Manager deactivated, update lock obtained=" + lockObtained), (Object[])new Object[]{this});
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.deactivated = true;
            if (lockObtained) {
                this.iAmUpdater.unlock();
            }
        }
        this.bundleContext.removeBundleListener(this.bundleOriginsListener);
        this.notifyFrameworkReady();
        this.packageInspector.deactivate();
    }

    @Reference(name="locationService", service=WsLocationAdmin.class)
    protected void setLocationService(WsLocationAdmin locationService) {
        this.locationService = locationService;
    }

    protected void unsetLocationService(WsLocationAdmin locationService) {
    }

    public WsLocationAdmin getLocationService() {
        return this.locationService;
    }

    @Reference(name="runtimeUpdateManager", service=RuntimeUpdateManager.class)
    protected void setRuntimeUpdateManager(RuntimeUpdateManager runtimeUpdateManager) {
        this.runtimeUpdateManager = runtimeUpdateManager;
    }

    protected void unsetRuntimeUpdateManager(RuntimeUpdateManager runtimeUpdateManager) {
    }

    @Reference(name="eventAdminService", service=EventAdmin.class)
    protected void setEventAdminService(EventAdmin eventAdminService) {
        this.eventAdminService = eventAdminService;
    }

    protected void unsetEventAdminService(EventAdmin eventAdminService) {
    }

    @Reference(name="digraph", service=RegionDigraph.class)
    protected void setDigraph(RegionDigraph digraph) {
        this.digraph = digraph;
    }

    RegionDigraph getDigraph() {
        return this.digraph;
    }

    protected void unsetDigraph(RegionDigraph digraph) {
    }

    @Reference(name="executorService", service=ExecutorService.class)
    protected void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    protected void unsetExecutorService(ExecutorService executorService) {
    }

    @Reference(name="variableRegistry", service=VariableRegistry.class)
    protected void setVariableRegistry(VariableRegistry variableRegistry) {
        this.variableRegistry = variableRegistry;
    }

    protected void unsetVariableRegistry(VariableRegistry variableRegistry) {
    }

    public void updated(Dictionary<String, ?> configuration) throws ConfigurationException {
        ProvisioningMode mode = this.provisioningMode;
        this.provisioningMode = ProvisioningMode.UPDATE;
        if (configuration == null) {
            if (mode != ProvisioningMode.UPDATE) {
                this.notifyFrameworkReady();
            }
            return;
        }
        this.onError = (OnErrorUtil.OnError)configuration.get("onError");
        String[] features = (String[])configuration.get("feature");
        if (features == null) {
            features = new String[]{};
        }
        this.queueFeatureChange(mode, features);
    }

    private void queueFeatureChange(final ProvisioningMode mode, String[] features) {
        this.featureChanges.add(new FeatureChange(this.runtimeUpdateManager, mode, features));
        this.executorService.execute(new Runnable(){
            static final long serialVersionUID = 5741097686319075745L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    FeatureManager.this.processFeatureChanges();
                }
                finally {
                    if (mode != ProvisioningMode.UPDATE) {
                        FeatureManager.this.notifyFrameworkReady();
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    private void notifyFrameworkReady() {
        this.initialProvisioningLatch.countDown();
        this.shutdownHook.removeListener(this.initialProvisioningLatch);
    }

    public void waitForFrameworkReady() throws InterruptedException {
        this.initialProvisioningLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(FeatureChange featureChange) throws IllegalStateException {
        featureChange.createNotifications();
        Set<String> preInstalledFeatures = Collections.emptySet();
        HashSet<String> deletedAutoFeatures = new HashSet<String>();
        HashSet<String> deletedPublicAutoFeatures = new HashSet<String>();
        HashSet<String> preInstalledAutoFeatures = new HashSet<String>();
        HashSet<String> preInstalledPublicAutoFeatures = new HashSet<String>();
        try {
            switch (featureChange.provisioningMode) {
                case INITIAL_PROVISIONING: {
                    if (this.getStartLevel() >= 7) break;
                    BundleLifecycleStatus startStatus = this.setStartLevel(7);
                    this.checkBundleStatus(startStatus);
                    break;
                }
                case REFRESH: {
                    for (String featureName : this.featureRepository.getInstalledFeatures()) {
                        ProvisioningFeatureDefinition feature = this.featureRepository.getFeature(featureName);
                        if (feature == null || !feature.isAutoFeature()) continue;
                        preInstalledAutoFeatures.add(feature.getFeatureName());
                        if (feature.getVisibility() != Visibility.PUBLIC) continue;
                        preInstalledPublicAutoFeatures.add(feature.getFeatureName());
                    }
                    break;
                }
                case CONTENT_REQUEST: {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Liberty server being held in paused state for minify operation", (Object[])new Object[0]);
                    break;
                }
            }
            this.featureRepository.init();
            this.bundleCache.init();
            if (tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"STARTING_AUDIT", (Object[])new Object[0]);
            }
            preInstalledFeatures = this.featureRepository.getInstalledFeatures();
            String pkgs = this.bundleContext.getProperty("com.ibm.ws.kernel.classloading.apiPackagesToHide");
            HashSet<String> apiPkgsToIgnore = pkgs == null ? null : new HashSet<String>(Arrays.asList(pkgs.split(",")));
            Provisioner provisioner = new Provisioner(this, apiPkgsToIgnore);
            if (featureChange.provisioningMode == ProvisioningMode.REFRESH) {
                for (String featureName : preInstalledAutoFeatures) {
                    ProvisioningFeatureDefinition feature = this.featureRepository.getFeature(featureName);
                    if (feature != null) continue;
                    deletedAutoFeatures.add(featureName);
                    if (!preInstalledPublicAutoFeatures.contains(featureName)) continue;
                    deletedPublicAutoFeatures.add(featureName);
                }
                featureChange.features = this.getPublicFeatures(preInstalledFeatures, false).toArray(new String[0]);
            }
            this.updateFeatures(this.locationService, provisioner, preInstalledFeatures, featureChange, featureUpdateNumber.incrementAndGet());
            switch (featureChange.provisioningMode) {
                case CONTENT_REQUEST: {
                    new ServerContentHelper(this.bundleContext, this, this.locationService).processServerContentRequest();
                    return;
                }
                case INITIAL_PROVISIONING: {
                    BundleLifecycleStatus startStatus = this.setStartLevel(20);
                    this.checkBundleStatus(startStatus);
                    this.bundleContext.registerService(ServerStarted.class, (Object)new ServerStarted(){
                        static final long serialVersionUID = -4500943322592187549L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(2.class);
                        }
                    }, new Hashtable());
                    return;
                }
            }
            return;
        }
        finally {
            BundleRepositoryRegistry.disposeAll();
            KernelFeatureDefinitionImpl.dispose();
            this.bundleCache.dispose();
            this.featureRepository.dispose();
            this.writeUpdateMessages(featureChange.provisioningMode, preInstalledFeatures, deletedAutoFeatures, deletedPublicAutoFeatures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryServer(FeatureChange featureChange) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Liberty server being held in paused state for query operation", (Object[])new Object[0]);
        }
        try {
            this.featureRepository.init();
            this.bundleCache.init();
            if (tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"STARTING_AUDIT", (Object[])new Object[0]);
            }
            new ServerFeaturesHelper(this.bundleContext).processServerFeaturesRequest(this.resolveFeatures(featureChange));
            if (featureChange.featureUpdatesCompleted != null) {
                featureChange.featureUpdatesCompleted.setResult(true);
            }
            if (featureChange.appForceRestart != null) {
                featureChange.appForceRestart.setResult(true);
            }
            if (featureChange.featureBundlesResolved != null) {
                featureChange.featureBundlesResolved.setResult(true);
            }
        }
        finally {
            this.writeServiceMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void processFeatureChanges() {
        do {
            retry = false;
            if (!this.iAmUpdater.tryLock()) continue;
            if (this.deactivated) {
                this.featureChanges.clear();
                return;
            }
            startTime = System.nanoTime();
            featureChange = this.featureChanges.poll();
            if (featureChange == null) {
                return;
            }
            try {
                switch (3.$SwitchMap$com$ibm$ws$kernel$feature$internal$FeatureManager$ProvisioningMode[featureChange.provisioningMode.ordinal()]) {
                    case 4: {
                        this.queryServer(featureChange);
                        ** break;
lbl16:
                        // 1 sources

                        break;
                    }
                    default: {
                        this.update(featureChange);
                        break;
                    }
                }
            }
            catch (IllegalStateException var5_6) {
                FFDCFilter.processException((Throwable)var5_6, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"765", (Object)this, (Object[])new Object[0]);
                this.featureChanges.clear();
            }
            catch (Exception ies) {
                FFDCFilter.processException((Throwable)ies, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"769", (Object)this, (Object[])new Object[0]);
            }
            finally {
                try {
                    this.writeFeatureChangeMessages(startTime, featureChange.provisioningMode);
                }
                finally {
                    this.iAmUpdater.unlock();
                }
            }
            if (this.featureChanges.isEmpty()) continue;
            retry = true;
        } while (retry);
    }

    private void writeUpdateMessages(ProvisioningMode provisioningMode, Set<String> preInstalledFeatures, Set<String> deletedAutoFeatures, Set<String> deletedPublicAutoFeatures) {
        this.writeServiceMessages();
        Set<String> postInstalledFeatures = this.featureRepository.getInstalledFeatures();
        postInstalledFeatures.removeAll(preInstalledFeatures);
        Set<Object> installedPublicFeatures = Collections.emptySet();
        if (!postInstalledFeatures.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"added features", (Object[])new Object[]{postInstalledFeatures});
            }
            installedPublicFeatures = this.getPublicFeatures(postInstalledFeatures, true);
        } else if (provisioningMode == ProvisioningMode.INITIAL_PROVISIONING) {
            installedPublicFeatures = this.getPublicFeatures(preInstalledFeatures, true);
        }
        if (!installedPublicFeatures.isEmpty()) {
            if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                Tr.audit((TraceComponent)tc, (String)"FEATURES_ADDED_CLIENT", (Object[])new Object[]{installedPublicFeatures});
            } else {
                Tr.audit((TraceComponent)tc, (String)"FEATURES_ADDED", (Object[])new Object[]{installedPublicFeatures});
            }
        }
        this.featureRepository.copyInstalledFeaturesTo(postInstalledFeatures);
        preInstalledFeatures.removeAll(postInstalledFeatures);
        preInstalledFeatures.addAll(deletedAutoFeatures);
        if (!preInstalledFeatures.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"removed features", (Object[])new Object[]{preInstalledFeatures});
            }
            Set<String> publicFeatures = this.getPublicFeatures(preInstalledFeatures, true);
            publicFeatures.addAll(deletedPublicAutoFeatures);
            if (!publicFeatures.isEmpty()) {
                Tr.audit((TraceComponent)tc, (String)"FEATURES_REMOVED", (Object[])new Object[]{publicFeatures});
            }
        }
    }

    private void writeFeatureChangeMessages(long startTime, ProvisioningMode provisioningMode) {
        String time = TimestampUtils.getElapsedTimeNanos((long)startTime);
        if (provisioningMode == ProvisioningMode.UPDATE) {
            Tr.audit((TraceComponent)tc, (String)"COMPLETE_AUDIT", (Object[])new Object[]{time});
        } else {
            if (tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"COMPLETE_AUDIT", (Object[])new Object[]{time});
            }
            if (provisioningMode == ProvisioningMode.CONTENT_REQUEST) {
                Tr.audit((TraceComponent)tc, (String)"SERVER_MINIFY", (Object[])new Object[]{this.locationService.getServerName()});
            } else if (provisioningMode == ProvisioningMode.FEATURES_REQUEST) {
                Tr.audit((TraceComponent)tc, (String)"SERVER_GATHER_FEATURES", (Object[])new Object[]{this.locationService.getServerName()});
            } else if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                Tr.audit((TraceComponent)tc, (String)"CLIENT_STARTED", (Object[])new Object[]{this.locationService.getServerName()});
            } else {
                Tr.audit((TraceComponent)tc, (String)"SERVER_STARTED", (Object[])new Object[]{this.locationService.getServerName()});
            }
        }
    }

    @FFDCIgnore(value={IOException.class})
    public PrintStream getFixWriter(PrintStream out) {
        WsLocationAdmin locAdmin;
        if (out == null && (locAdmin = this.locationService) != null) {
            WsResource fixData = locAdmin.getServerWorkareaResource("platform/fix.data");
            try {
                out = new PrintStream(fixData.putStream());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return out;
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private void writeServiceMessages() {
        StringBuilder builder;
        PrintStream out = null;
        Bundle[] bundles = this.bundleContext.getBundles();
        HashSet<String> iFixSet = new HashSet<String>();
        HashSet<String> tFixSet = new HashSet<String>();
        for (Bundle b : bundles) {
            Dictionary headers;
            try {
                headers = b.getHeaders(null);
            }
            catch (IllegalStateException ise) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("writeServiceMessages - caught exception getting manifest headers for bundle " + b), (Object[])new Object[]{ise});
                continue;
            }
            String fixes = (String)headers.get("IBM-Test-Fixes");
            if (fixes != null) {
                out = this.getFixWriter(out);
                out.print("tFix: ");
                out.print(b.getLocation());
                out.print(": ");
                out.println(fixes);
                tFixSet.addAll(Arrays.asList(fixes.split("[,\\s]")));
            }
            if ((fixes = (String)headers.get("IBM-Interim-Fixes")) == null) continue;
            out = this.getFixWriter(out);
            out.print("iFix: ");
            out.print(b.getLocation());
            out.print(": ");
            out.println(fixes);
            iFixSet.addAll(Arrays.asList(fixes.split("[,\\s]")));
        }
        if (!iFixSet.isEmpty()) {
            builder = new StringBuilder();
            for (String fix : iFixSet) {
                if ("".equals(fix)) continue;
                builder.append(',');
                builder.append(fix);
            }
            builder.deleteCharAt(0);
            String fixes = builder.toString();
            Tr.audit((TraceComponent)tc, (String)"INTERIM_FIX_DETECTED", (Object[])new Object[]{fixes});
        }
        if (!tFixSet.isEmpty()) {
            builder = new StringBuilder();
            for (String fix : tFixSet) {
                if ("".equals(fix)) continue;
                builder.append(',');
                builder.append(fix);
            }
            builder.deleteCharAt(0);
            String fixes = builder.toString();
            Tr.warning((TraceComponent)tc, (String)"TEST_FIX_DETECTED", (Object[])new Object[]{fixes});
        }
        if (out != null) {
            out.flush();
            out.close();
        }
    }

    private Set<String> getPublicFeatures(Set<String> postInstalledFeatures, boolean includeAutoFeatures) {
        HashSet<String> publicFeatures = new HashSet<String>();
        for (String feature : postInstalledFeatures) {
            FeatureDefinition fd = this.getFeatureDefinition(feature);
            if (fd == null || fd.getVisibility() != Visibility.PUBLIC) continue;
            if (!includeAutoFeatures) {
                if (fd instanceof ProvisioningFeatureDefinition) {
                    if (((ProvisioningFeatureDefinition)fd).isAutoFeature()) continue;
                    publicFeatures.add(fd.getFeatureName());
                    continue;
                }
                publicFeatures.add(fd.getFeatureName());
                continue;
            }
            publicFeatures.add(fd.getFeatureName());
        }
        return publicFeatures;
    }

    private FeatureResolver.Result resolveFeatures(FeatureChange featureChange) {
        Set<String> newConfiguredFeatures = featureChange.getFeaturesWithLowerCaseName();
        return this.resolveFeatures(newConfiguredFeatures, new ArrayList<String>(), featureChange.provisioningMode);
    }

    private FeatureResolver.Result resolveFeatures(Set<String> rootFeatures, Collection<String> restrictedAccessAttempts, ProvisioningMode mode) {
        FeatureResolver.Repository restrictedRespository;
        if (rootFeatures.isEmpty() && this.featureRepository.emptyFeatures()) {
            Tr.warning((TraceComponent)tc, (String)"EMPTY_FEATURES_WARNING", (Object[])new Object[0]);
        }
        Collection<Object> restrictedRepoAccessAttempts = new ArrayList();
        boolean allowMultipleVersions = false;
        if (ProvisioningMode.CONTENT_REQUEST == mode || ProvisioningMode.FEATURES_REQUEST == mode) {
            allowMultipleVersions = true;
            restrictedRespository = this.featureRepository;
        } else if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
            restrictedRespository = this.featureRepository;
            Iterator<String> iRootFeatures = rootFeatures.iterator();
            while (iRootFeatures.hasNext()) {
                ProvisioningFeatureDefinition rootDef = this.featureRepository.getFeature(iRootFeatures.next());
                if (rootDef == null || ALL_ALLOWED_ON_CLIENT_FEATURES.contains(rootDef.getSymbolicName())) continue;
                restrictedRepoAccessAttempts.add(rootDef.getSymbolicName());
                iRootFeatures.remove();
            }
        } else {
            RestrictedFeatureRespository temp = new RestrictedFeatureRespository(this.featureRepository, FeatureDefinitionUtils.ALLOWED_ON_CLIENT_ONLY_FEATURES);
            restrictedRepoAccessAttempts = temp.getRestrictedFeatureAttempts();
            restrictedRespository = temp;
        }
        FeatureResolver.Result result = featureResolver.resolveFeatures(restrictedRespository, rootFeatures, Collections.<String>emptySet(), allowMultipleVersions);
        restrictedAccessAttempts.addAll(restrictedRepoAccessAttempts);
        return result;
    }

    @FFDCIgnore(value={Throwable.class})
    protected boolean updateFeatures(WsLocationAdmin locService, Provisioner provisioner, Set<String> preInstalledFeatures, FeatureChange featureChange, long sequenceNumber) {
        Set<String> goodFeatures;
        ArrayList<Bundle> installedBundles;
        BundleLifecycleStatus startStatus;
        BundleInstallStatus installStatus;
        block21: {
            BundleList newBundleList = null;
            Set<String> newConfiguredFeatures = featureChange.getFeaturesWithLowerCaseName();
            if (newConfiguredFeatures.isEmpty() && this.featureRepository.emptyFeatures()) {
                newBundleList = new BundleList(this);
            }
            installStatus = new BundleInstallStatus();
            startStatus = null;
            installedBundles = new ArrayList<Bundle>();
            boolean continueOnError = this.onError != OnErrorUtil.OnError.FAIL;
            goodFeatures = null;
            boolean featuresHaveChanges = true;
            boolean appForceRestartSet = false;
            try {
                if (this.areConfiguredFeaturesGood(newConfiguredFeatures)) {
                    featuresHaveChanges = false;
                    goodFeatures = preInstalledFeatures;
                } else {
                    ArrayList<String> restrictedAccessAttempts = new ArrayList<String>();
                    FeatureResolver.Result result = this.resolveFeatures(newConfiguredFeatures, restrictedAccessAttempts, featureChange.provisioningMode);
                    boolean reportedConfigurationErrors = this.reportErrors(result, restrictedAccessAttempts, newConfiguredFeatures, installStatus);
                    goodFeatures = result.getResolvedFeatures();
                    if (!this.featureRepository.featureSetEquals(goodFeatures) && installStatus.canContinue(continueOnError)) {
                        if (newBundleList == null) {
                            newBundleList = new BundleList(this);
                        }
                        for (String featureName : goodFeatures) {
                            ProvisioningFeatureDefinition fdefinition = this.featureRepository.getFeature(featureName);
                            if (fdefinition == null) continue;
                            newBundleList.addAll(fdefinition, this);
                        }
                        this.bundleCache.addAllNoReplace(newBundleList);
                        this.featureRepository.setInstalledFeatures(goodFeatures, newConfiguredFeatures, reportedConfigurationErrors);
                    }
                }
                if (featureChange.appForceRestart != null) {
                    Set<String> featureSet = this.featureRepository.getInstalledFeatures();
                    if (this.featureChangesRequireRestart(preInstalledFeatures, featureSet)) {
                        featureChange.appForceRestart.setResult(true);
                        appForceRestartSet = true;
                        RuntimeUpdateNotification applicationsStopped = this.runtimeUpdateManager.getNotification("ApplicationsStopped");
                        if (applicationsStopped != null) {
                            applicationsStopped.waitForCompletion();
                        }
                    } else {
                        featureChange.appForceRestart.setResult(false);
                        appForceRestartSet = true;
                    }
                }
                if (installStatus.canContinue(continueOnError)) {
                    Set<String> regionsToRemove = Collections.emptySet();
                    if (featuresHaveChanges) {
                        this.packageInspector.populateSPIInfo(this.bundleContext, this);
                        regionsToRemove = provisioner.createAndUpdateProductRegions();
                    }
                    provisioner.installBundles(this.bundleContext, this.bundleCache, installStatus, 8, 12, this.fwStartLevel.getInitialBundleStartLevel(), locService);
                    this.featureRepository.updateServices();
                    if (featuresHaveChanges) {
                        BundleList remove;
                        if (installStatus.contextIsValid() && newBundleList != null && (remove = this.bundleCache.findExtraBundles(newBundleList, this)) != null && !remove.isEmpty()) {
                            provisioner.uninstallBundles(this.bundleContext, remove, installStatus, this.shutdownHook);
                        }
                        provisioner.refreshFeatureBundles(this.packageInspector, this.bundleContext, this.shutdownHook);
                        provisioner.removeStaleProductRegions(regionsToRemove);
                        provisioner.refreshGatewayBundles(this.shutdownHook);
                        if (installStatus.contextIsValid() && installStatus.bundlesToStart()) {
                            installedBundles.addAll(installStatus.getBundlesToStart());
                        }
                    }
                }
            }
            catch (Throwable t) {
                installStatus.addOtherException(t);
                if (appForceRestartSet || featureChange.appForceRestart == null) break block21;
                featureChange.appForceRestart.setResult(t);
            }
        }
        boolean status = this.checkInstallStatus(installStatus);
        provisioner.resolveBundles(this.bundleContext, installedBundles);
        if (featureChange.featureBundlesResolved != null) {
            featureChange.featureBundlesResolved.setResult(true);
            RuntimeUpdateNotification featureBundlesProcessed = this.runtimeUpdateManager.getNotification("FeatureBundlesProcessed");
            if (featureBundlesProcessed != null) {
                featureBundlesProcessed.waitForCompletion();
            }
        }
        this.analyzeUnresolvedBundles(installedBundles, goodFeatures);
        startStatus = provisioner.preStartBundles(installedBundles);
        status &= this.checkBundleStatus(startStatus);
        if (featureChange.featureUpdatesCompleted != null) {
            featureChange.featureUpdatesCompleted.setResult(true);
        }
        if (this.eventAdminService != null) {
            HashMap<String, Object> eventProps = new HashMap<String, Object>(2);
            Set<String> featureSet = this.featureRepository.getInstalledFeatures();
            eventProps.put("features", featureSet.toArray(new String[featureSet.size()]));
            eventProps.put("sequenceNumber", sequenceNumber);
            Event e = new Event("com/ibm/ws/kernel/feature/internal/FeatureManager/FEATURE_CHANGE", eventProps);
            this.eventAdminService.postEvent(e);
        }
        return status;
    }

    private boolean areConfiguredFeaturesGood(Set<String> newConfiguredFeatures) {
        if (!this.featureRepository.isDirty() && !this.featureRepository.hasConfigurationError() && this.featureRepository.getConfiguredFeatures().equals(newConfiguredFeatures)) {
            for (String installedFeature : this.featureRepository.getInstalledFeatures()) {
                if (this.featureRepository.getFeature(installedFeature) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void analyzeUnresolvedBundles(List<Bundle> installedBundles, Set<String> features) {
        String m = "analyzeUnresolvedBundles";
        Set<Bundle> unresolvedBundles = this.getUnresolvedBundles(installedBundles);
        if (unresolvedBundles.isEmpty()) {
            return;
        }
        HashMap<String, Set<String>> javaVersiontoFeatureMap = new HashMap<String, Set<String>>();
        FrameworkWiring frameworkWiring = (FrameworkWiring)this.bundleContext.getBundle("System Bundle").adapt(FrameworkWiring.class);
        for (Bundle bundle : unresolvedBundles) {
            BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (revision == null) continue;
            List eeReqs = revision.getDeclaredRequirements("osgi.ee");
            for (BundleRequirement eeReq : eeReqs) {
                Collection eeCaps = frameworkWiring.findProviders((Requirement)eeReq);
                if (!eeCaps.isEmpty()) continue;
                String javaSEVersion = this.getJavaSEValue((Requirement)eeReq);
                Bundle b = eeReq.getResource().getBundle();
                if (javaSEVersion == null) continue;
                Set<String> foundInFeatures = this.findIncludingFeatures(features, b);
                if (javaVersiontoFeatureMap.containsKey(javaSEVersion)) {
                    ((Set)javaVersiontoFeatureMap.get(javaSEVersion)).addAll(foundInFeatures);
                    continue;
                }
                javaVersiontoFeatureMap.put(javaSEVersion, foundInFeatures);
            }
        }
        for (Map.Entry entry : javaVersiontoFeatureMap.entrySet()) {
            for (String feature : (Set)entry.getValue()) {
                Tr.error((TraceComponent)tc, (String)"FEATURE_JAVA_LEVEL_NOT_MET_ERROR", (Object[])new Object[]{feature, entry.getKey()});
            }
        }
        if (!javaVersiontoFeatureMap.isEmpty() && this.onError.equals((Object)OnErrorUtil.OnError.FAIL)) {
            IllegalArgumentException t = new IllegalArgumentException("Unresolved feature java dependencies: " + javaVersiontoFeatureMap);
            FFDCFilter.processException((Throwable)t, (String)ME, (String)"analyzeUnresolvedBundles");
            this.shutdownFramework();
        }
    }

    private Set<Bundle> getUnresolvedBundles(List<Bundle> installedBundles) {
        HashSet<Bundle> unresolvedBundles = new HashSet<Bundle>();
        if (installedBundles == null || installedBundles.isEmpty()) {
            return Collections.emptySet();
        }
        for (Bundle b : installedBundles) {
            if (b.getState() != 2) continue;
            unresolvedBundles.add(b);
        }
        return unresolvedBundles;
    }

    private String getJavaSEValue(Requirement req) {
        String javaSEValue = null;
        String filterString = (String)req.getDirectives().get("filter");
        Filter filter = null;
        try {
            filter = FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1356", (Object)this, (Object[])new Object[]{req});
            return null;
        }
        HashMap<String, Object> matchAttrs = new HashMap<String, Object>();
        EEValue eeValue = EEValue.getInstance();
        VersionValue versionValue = VersionValue.getInstance();
        matchAttrs.put("osgi.ee", eeValue);
        matchAttrs.put("version", versionValue);
        if (filter.matches(matchAttrs)) {
            List<String> eeValueStr = EEValue.getValues();
            List<String> versionValueStr = VersionValue.getValues();
            if (eeValueStr.isEmpty() || versionValueStr.isEmpty()) {
                return filterString;
            }
            String java = eeValueStr.iterator().next();
            String version = versionValueStr.iterator().next();
            javaSEValue = java + " " + version;
        }
        return javaSEValue;
    }

    public Set<String> findIncludingFeatures(Set<String> features, Bundle b1) {
        HashSet<String> foundInFeatures = new HashSet<String>();
        for (String feature : features) {
            ProvisioningFeatureDefinition fdefinition = this.featureRepository.getFeature(feature);
            for (FeatureResource fr : fdefinition.getConstituents(SubsystemContentType.BUNDLE_TYPE)) {
                try {
                    Bundle rfr = this.bundleCache.getBundle(this.bundleContext, fr);
                    if (!b1.equals(rfr)) continue;
                    foundInFeatures.add(feature);
                }
                catch (MalformedURLException rfr) {
                    FFDCFilter.processException((Throwable)rfr, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1404", (Object)this, (Object[])new Object[]{features, b1});
                }
            }
        }
        return foundInFeatures;
    }

    boolean reportErrors(FeatureResolver.Result result, Collection<String> restrictedAccessAttempts, Collection<String> rootFeatures, BundleInstallStatus installStatus) {
        boolean reportedErrors = false;
        for (String string : result.getNonPublicRoots()) {
            reportedErrors = true;
            if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_NOT_PUBLIC_FEATURE_CLIENT_ERROR", (Object[])new Object[]{string});
                continue;
            }
            Tr.error((TraceComponent)tc, (String)"UPDATE_NOT_PUBLIC_FEATURE_ERROR", (Object[])new Object[]{string});
        }
        for (String string : result.getMissing()) {
            reportedErrors = true;
            if (rootFeatures.contains(string) && string.indexOf(":") < 0) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_MISSING_CORE_FEATURE_ERROR", (Object[])new Object[]{string, this.locationService.getServerName()});
            } else {
                Tr.error((TraceComponent)tc, (String)"UPDATE_MISSING_FEATURE_ERROR", (Object[])new Object[]{string});
            }
            installStatus.addMissingFeature(string);
        }
        for (Map.Entry entry : result.getWrongProcessTypes().entrySet()) {
            reportedErrors = true;
            List<String> chain = ((FeatureResolver.Chain)entry.getValue()).getChain();
            if (chain.isEmpty()) {
                if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                    Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_CONFIGURED_CLIENT_ERROR", (Object[])new Object[]{this.getFeatureName((String)entry.getKey()), this.processTypeString + ".xml"});
                } else {
                    Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_CONFIGURED_ERROR", (Object[])new Object[]{this.getFeatureName((String)entry.getKey()), this.processTypeString + ".xml"});
                }
            } else if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_DEPENDENCY_CLIENT_ERROR", (Object[])new Object[]{this.getFeatureName((String)entry.getKey()), this.getFeatureName(chain.get(0)), this.processTypeString + ".xml"});
            } else {
                Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_DEPENDENCY_ERROR", (Object[])new Object[]{this.getFeatureName((String)entry.getKey()), this.getFeatureName(chain.get(0)), this.processTypeString + ".xml"});
            }
            String wrongProcessTypeMsg = "Unable to load feature \"" + (String)entry.getKey() + "\" because it does not support the correct container type.  The feature dependency chain that led to the feature is: " + this.buildChainString(chain, (String)entry.getKey());
            IllegalArgumentException ffdcError = new IllegalArgumentException(wrongProcessTypeMsg);
            FFDCFilter.processException((Throwable)ffdcError, (String)ME, (String)"reportErrors", (Object[])new Object[]{entry.getKey(), ((FeatureResolver.Chain)entry.getValue()).toString()});
        }
        for (String string : restrictedAccessAttempts) {
            if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_CONFIGURED_CLIENT_ERROR", (Object[])new Object[]{this.getFeatureName(string), this.processTypeString + ".xml"});
                continue;
            }
            Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_CONFIGURED_ERROR", (Object[])new Object[]{this.getFeatureName(string), this.processTypeString + ".xml"});
        }
        for (Map.Entry entry : result.getConflicts().entrySet()) {
            reportedErrors = true;
            String conflict1 = null;
            String configured1 = null;
            String chain1 = null;
            String conflict2 = null;
            String configured2 = null;
            String chain2 = null;
            for (FeatureResolver.Chain chain : (Collection)entry.getValue()) {
                List<String> candidates = chain.getCandidates();
                if (conflict1 == null) {
                    conflict1 = candidates.get(0);
                    if (chain.getChain().isEmpty()) {
                        configured1 = conflict1;
                        chain1 = conflict1;
                        continue;
                    }
                    configured1 = chain.getChain().get(0);
                    chain1 = this.buildChainString(chain.getChain(), conflict1);
                    continue;
                }
                if (conflict1.equals(candidates.get(0))) continue;
                conflict2 = candidates.get(0);
                if (chain.getChain().isEmpty()) {
                    configured2 = conflict2;
                    chain2 = conflict2;
                    break;
                }
                configured2 = chain.getChain().get(0);
                chain2 = this.buildChainString(chain.getChain(), conflict2);
                break;
            }
            Tr.error((TraceComponent)tc, (String)"UPDATE_CONFLICT_FEATURE_ERROR", (Object[])new Object[]{this.getFeatureName(conflict1), this.getFeatureName(conflict2), this.getFeatureName(configured1), this.getFeatureName(configured2)});
            String conflictMsg = "Unable to load conflicting versions of features \"" + conflict1 + "\" and \"" + conflict2 + "\".  The feature dependency chains that led to the conflict are: " + chain1 + " and " + chain2;
            IllegalArgumentException ffdcError = new IllegalArgumentException(conflictMsg);
            FFDCFilter.processException((Throwable)ffdcError, (String)ME, (String)"reportErrors", (Object[])new Object[]{entry.getKey(), ((Collection)entry.getValue()).toString()});
            for (FeatureResolver.Chain chain : (Collection)entry.getValue()) {
                installStatus.addConflictFeature(chain.getFeatureRequirement());
            }
        }
        return reportedErrors;
    }

    private Object getWrongProcessType() {
        return ((ProcessType)((Object)EnumSet.complementOf(this.supportedProcessTypes).iterator().next())).toString().toLowerCase();
    }

    private String getFeatureName(String symbolicName) {
        ProvisioningFeatureDefinition fd = this.featureRepository.getFeature(symbolicName);
        if (fd == null) {
            return symbolicName;
        }
        return fd.getFeatureName();
    }

    private String buildChainString(List<String> chain, String theConflictFeature) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iChain = chain.iterator();
        while (iChain.hasNext()) {
            String chainFeature = iChain.next();
            if (!chainFeature.equals(theConflictFeature)) {
                builder.append(chainFeature);
            }
            if (!iChain.hasNext()) continue;
            builder.append(" -> ");
        }
        if (builder.length() != 0) {
            builder.append(" -> ");
        }
        builder.append(theConflictFeature);
        return builder.toString();
    }

    private boolean featureChangesRequireRestart(Set<String> oldFeatureSet, Set<String> newFeatureSet) {
        if (oldFeatureSet == null) {
            return false;
        }
        ArrayList<String> existingFeatures = new ArrayList<String>(oldFeatureSet);
        List<String> currentFeatures = Arrays.asList(newFeatureSet.toArray(new String[0]));
        ArrayList<String> newFeatures = new ArrayList<String>(currentFeatures);
        newFeatures.removeAll(existingFeatures);
        ArrayList<String> deletedFeatures = existingFeatures;
        deletedFeatures.removeAll(currentFeatures);
        boolean restartApps = this.shouldRestart(AppForceRestart.INSTALL, newFeatures) ? true : this.shouldRestart(AppForceRestart.UNINSTALL, deletedFeatures);
        return restartApps;
    }

    private boolean shouldRestart(AppForceRestart expectedValue, Collection<String> features) {
        for (String feature : features) {
            AppForceRestart restart;
            ProvisioningFeatureDefinition fd = this.featureRepository.getFeature(feature);
            if (fd == null || !(restart = fd.getAppForceRestart()).matches(expectedValue)) continue;
            return true;
        }
        return false;
    }

    public BundleRepositoryRegistry.BundleRepositoryHolder getBundleRepositoryHolder(String bundleRepositoryType) {
        return BundleRepositoryRegistry.getRepositoryHolder((String)bundleRepositoryType);
    }

    protected boolean checkInstallStatus(BundleInstallStatus installStatus) throws IllegalStateException {
        String m = "checkInstallStatus";
        boolean shutdownFramework = false;
        boolean noExceptions = true;
        if (installStatus == null) {
            return true;
        }
        boolean continueOnError = true;
        if (this.onError.equals((Object)OnErrorUtil.OnError.FAIL)) {
            continueOnError = false;
        }
        if (installStatus.bundlesMissing()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
            IllegalArgumentException t = new IllegalArgumentException("Missing bundles: " + installStatus.getMissingBundles());
            FFDCFilter.processException((Throwable)t, (String)ME, (String)"checkInstallStatus", (Object)this, (Object[])new Object[]{installStatus, this.bundleCache});
        }
        if (installStatus.featuresMissing()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
        }
        if (installStatus.featuresConflict()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
        }
        if (installStatus.otherExceptions()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
            List<Throwable> otherExceptions = installStatus.getOtherExceptions();
            for (Throwable throwable : otherExceptions) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_OTHER_EXCEPTION_ERROR", (Object[])new Object[]{throwable});
                FFDCFilter.processException((Throwable)throwable, (String)ME, (String)"checkInstallStatus", (Object)this, (Object[])new Object[]{installStatus, this.featureRepository, this.bundleCache});
            }
        }
        if (!installStatus.contextIsValid()) {
            installStatus.rethrowInvalidContextException();
        }
        if (installStatus.installExceptions()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
            Map<String, Throwable> installExceptions = installStatus.getInstallExceptions();
            for (Map.Entry entry : installExceptions.entrySet()) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_INSTALL_EXCEPTIONS_ERROR", (Object[])new Object[]{entry.getKey(), entry.getValue()});
                FFDCFilter.processException((Throwable)((Throwable)entry.getValue()), (String)ME, (String)"checkInstallStatus", (Object)this, (Object[])new Object[]{entry.getKey()});
            }
        }
        if (shutdownFramework) {
            this.shutdownFramework();
        }
        return noExceptions;
    }

    protected boolean checkBundleStatus(BundleLifecycleStatus bundleStatus) {
        boolean shutdownFramework = false;
        boolean noExceptions = true;
        boolean continueOnError = true;
        if (this.onError.equals((Object)OnErrorUtil.OnError.FAIL)) {
            continueOnError = false;
        }
        if (bundleStatus.startExceptions()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
            Map<Bundle, Throwable> bundleExceptions = bundleStatus.getStartExceptions();
            for (Map.Entry<Bundle, Throwable> entry : bundleExceptions.entrySet()) {
                if (entry.getValue() instanceof BundleException) {
                    StringBuilder exceptionMessages = new StringBuilder();
                    for (Throwable e = entry.getValue(); e != null; e = e.getCause()) {
                        exceptionMessages.append(e.getMessage() + "\n");
                    }
                    Tr.error((TraceComponent)tc, (String)"BUNDLE_EXCEPTION_ERROR", (Object[])new Object[]{exceptionMessages.toString()});
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)"UPDATE_LIFECYCLE_EXCEPTIONS_ERROR", (Object[])new Object[]{entry.getKey(), entry.getValue()});
                FFDCFilter.processException((Throwable)entry.getValue(), (String)ME, (String)"checkBundleStatus", (Object)this, (Object[])new Object[]{entry.getKey()});
            }
        }
        if (!bundleStatus.contextIsValid()) {
            throw new IllegalStateException("Framework/VM shutting down");
        }
        if (shutdownFramework) {
            this.shutdownFramework();
        }
        return noExceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IllegalStateException.class})
    public BundleLifecycleStatus setStartLevel(int level) {
        StartLevelFrameworkListener slfw = new StartLevelFrameworkListener(this.shutdownHook);
        if (ServerContentHelper.isServerContentRequest(this.bundleContext)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Liberty server being held in paused state for minify operation", (Object[])new Object[0]);
            }
        } else {
            try {
                FeatureManager featureManager = this;
                synchronized (featureManager) {
                    this.fwStartLevel.setStartLevel(level, new FrameworkListener[]{slfw});
                    slfw.waitForLevel();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return slfw.getStatus();
    }

    public int getStartLevel() {
        return this.fwStartLevel.getStartLevel();
    }

    private final void shutdownFramework() {
        try {
            Bundle bundle = this.bundleContext.getBundle(0L);
            if (bundle != null) {
                bundle.stop();
            }
        }
        catch (Exception bundle) {
            FFDCFilter.processException((Throwable)bundle, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1795", (Object)this, (Object[])new Object[0]);
        }
        throw new IllegalStateException("Shutting down framework due to startup problems");
    }

    @Override
    public Set<String> getInstalledFeatures() {
        return this.featureRepository.getInstalledFeatures();
    }

    public Collection<ProvisioningFeatureDefinition> getInstalledFeatureDefinitions() {
        ArrayList<ProvisioningFeatureDefinition> result = new ArrayList<ProvisioningFeatureDefinition>();
        for (String s : this.getInstalledFeatures()) {
            result.add(this.featureRepository.getFeature(s));
        }
        return result;
    }

    @Override
    public FeatureDefinition getFeatureDefinition(String featureName) {
        return this.featureRepository.getFeature(featureName);
    }

    @Override
    public String getKernelApiServices() {
        return KernelFeatureDefinitionImpl.getKernelApiServices();
    }

    @Override
    public void refreshFeatures() {
        this.queueFeatureChange(ProvisioningMode.REFRESH, null);
    }

    @Override
    public void refreshFeatures(Filter filter) {
        this.refreshFeatures();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        ArrayList<String> temp = new ArrayList<String>();
        temp.addAll(FeatureDefinitionUtils.ALLOWED_ON_CLIENT_ONLY_FEATURES);
        temp.addAll(ALLOWED_ON_ALL_FEATURES);
        ALL_ALLOWED_ON_CLIENT_FEATURES = Collections.unmodifiableCollection(temp);
        featureUpdateNumber = new AtomicLong(0L);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class FeatureChange {
        final RuntimeUpdateManager runtimeUpdateManager;
        final ProvisioningMode provisioningMode;
        String[] features;
        RuntimeUpdateNotification appForceRestart = null;
        RuntimeUpdateNotification featureBundlesResolved = null;
        RuntimeUpdateNotification featureUpdatesCompleted = null;
        static final long serialVersionUID = 7216466516768323040L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        FeatureChange(RuntimeUpdateManager runtimeUpdateManager, ProvisioningMode provisioningMode, String[] features) {
            this.runtimeUpdateManager = runtimeUpdateManager;
            this.provisioningMode = provisioningMode;
            this.features = features;
            if (provisioningMode == ProvisioningMode.UPDATE) {
                this.featureUpdatesCompleted = runtimeUpdateManager.createNotification("FeatureUpdatesCompleted");
            }
        }

        void createNotifications() {
            this.appForceRestart = this.runtimeUpdateManager.createNotification("AppForceRestart");
            this.featureBundlesResolved = this.runtimeUpdateManager.createNotification("FeatureBundlesResolved");
        }

        Set<String> getFeaturesWithLowerCaseName() {
            HashSet<String> lcnFeatures = new HashSet<String>();
            for (String feature : this.features) {
                lcnFeatures.add(FeatureRepository.lowerFeature(feature));
            }
            return lcnFeatures;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FeatureChange.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class ProvisioningMode
    extends Enum<ProvisioningMode> {
        public static final /* enum */ ProvisioningMode CONTENT_REQUEST;
        public static final /* enum */ ProvisioningMode FEATURES_REQUEST;
        public static final /* enum */ ProvisioningMode INITIAL_PROVISIONING;
        public static final /* enum */ ProvisioningMode UPDATE;
        public static final /* enum */ ProvisioningMode REFRESH;
        private static final /* synthetic */ ProvisioningMode[] $VALUES;
        static final long serialVersionUID = 8751241788191311816L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static ProvisioningMode[] values() {
            return (ProvisioningMode[])$VALUES.clone();
        }

        public static ProvisioningMode valueOf(String name) {
            return Enum.valueOf(ProvisioningMode.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ProvisioningMode.class);
            CONTENT_REQUEST = new ProvisioningMode();
            FEATURES_REQUEST = new ProvisioningMode();
            INITIAL_PROVISIONING = new ProvisioningMode();
            UPDATE = new ProvisioningMode();
            REFRESH = new ProvisioningMode();
            $VALUES = new ProvisioningMode[]{CONTENT_REQUEST, FEATURES_REQUEST, INITIAL_PROVISIONING, UPDATE, REFRESH};
        }
    }
}

