/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.Callable;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.BundleException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public enum ApiRegion {
    USER("api", "liberty.user.defined.api", true),
    IBM("ibm-api", "liberty.ibm.api", true),
    SPEC("spec", "liberty.spec.api", true),
    THIRD_PARTY("third-party", "liberty.third.party.api", true),
    INTERNAL("internal", "liberty.internal.api", false),
    ALL("all", "liberty.all.api", false),
    THREAD_CONTEXT("thread-context", "liberty.thread.context.api", false);

    private static final TraceComponent tc;
    private static final ApiRegion[] values;
    private final String apiType;
    private final String regionName;
    private final boolean delegateInternal;
    static final long serialVersionUID = 3651654773195853625L;

    private ApiRegion(String apiType, String regionName, boolean delegateInternal) {
        this.apiType = apiType;
        this.regionName = regionName;
        this.delegateInternal = delegateInternal;
    }

    public String getApiType() {
        return this.apiType;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public boolean delegateInternal() {
        return this.delegateInternal;
    }

    public static ApiRegion valueFromApiType(String apiType) {
        for (ApiRegion apiRegion : values) {
            if (!apiRegion.apiType.equals(apiType)) continue;
            return apiRegion;
        }
        throw new IllegalArgumentException(apiType);
    }

    @FFDCIgnore(value={BundleException.class, InterruptedException.class})
    public static void update(RegionDigraph digraph, Callable<RegionDigraph> updateTo) throws BundleException {
        int numRetries = 10;
        for (int i = 0; i < numRetries; ++i) {
            RegionDigraph copy;
            try {
                copy = updateTo.call();
            }
            catch (BundleException e) {
                throw e;
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.feature.ApiRegion", (String)"164", null, (Object[])new Object[]{digraph, updateTo});
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.feature.ApiRegion", (String)"167", null, (Object[])new Object[]{digraph, updateTo});
                throw new RuntimeException(e);
            }
            try {
                if (copy != null) {
                    digraph.replace(copy);
                }
                return;
            }
            catch (BundleException e) {
                if (i == numRetries - 1) {
                    throw e;
                }
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"RegionDigraph replace contention: Delay", (Object[])new Object[0]);
                    }
                    Thread.sleep(200L);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"RegionDigraph replace contention: Continue", (Object[])new Object[0]);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                    throw e;
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        tc = Tr.register(ApiRegion.class);
        values = ApiRegion.values();
    }
}

