/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.logging.internal.impl.DateFormatProvider;
import com.ibm.ws.logging.internal.impl.IncidentImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public final class IncidentLogger {
    public void logIncident(IncidentStream iStream, IncidentImpl incident, Throwable th, Object callerThis, Object[] objectArray) {
        this.logIncident(iStream, incident, th, callerThis, objectArray, false);
    }

    public void logIncident(IncidentStream iStream, IncidentImpl incident, Throwable th, Object callerThis, Object[] objectArray, boolean callerDumpOnly) {
        String time = IncidentLogger.formatTime();
        if (!callerDumpOnly) {
            iStream.writeLine("------Start of DE processing------", time);
            iStream.writeLine("Exception", incident.getExceptionName());
            iStream.writeLine("Source", incident.getSourceId());
            iStream.writeLine("probeid", incident.getProbeId());
            iStream.writeLine("Stack Dump", IncidentLogger.getStackTrace(th));
        }
        StackTraceElement[] exceptionCallStack = th.getStackTrace();
        int commonIndex = IncidentLogger.compare(exceptionCallStack);
        Map<String, DiagnosticModule> modules = FFDC.getDiagnosticModuleMap();
        boolean foundAnyDM = false;
        if (commonIndex != -1) {
            boolean tryNextDM = true;
            Set calledModules = null;
            String[] dmsCallStack = null;
            for (int i = commonIndex; i < exceptionCallStack.length && tryNextDM; ++i) {
                String packageName = IncidentLogger.getPackageName(exceptionCallStack[i].getClassName());
                while (packageName.length() != 0 && tryNextDM) {
                    int lastDot;
                    DiagnosticModule module = modules.get(packageName);
                    if (module != null && (calledModules == null || calledModules.add(module))) {
                        if (calledModules == null) {
                            calledModules = Collections.newSetFromMap(new IdentityHashMap());
                            calledModules.add(module);
                        }
                        if (!foundAnyDM) {
                            iStream.introspectAndWriteLine("Dump of callerThis", callerThis, 0);
                        }
                        foundAnyDM = true;
                        if (dmsCallStack == null) {
                            dmsCallStack = IncidentLogger.getCallStackFromStackTraceElement(exceptionCallStack);
                        }
                        tryNextDM = module.dumpComponentData(new String[0], th, iStream, callerThis, objectArray, incident.getSourceId(), dmsCallStack);
                    }
                    if ((lastDot = packageName.lastIndexOf(46)) == -1) {
                        packageName = "";
                        continue;
                    }
                    packageName = packageName.substring(0, lastDot);
                }
            }
        }
        if (!foundAnyDM) {
            iStream.introspectAndWriteLine("Dump of callerThis", callerThis, 3);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    iStream.introspectAndWriteLine("Dump of objectArray[" + i + "]", objectArray[i], 3);
                }
            }
        }
    }

    static String formatTime() {
        Date date = new Date();
        DateFormat formatter = DateFormatProvider.getDateFormat();
        StringBuffer answer = new StringBuffer();
        answer.append('[');
        formatter.format(date, answer, new FieldPosition(0));
        answer.append(']');
        return answer.toString();
    }

    private static int compare(StackTraceElement[] exceptionCallStack) {
        if (exceptionCallStack == null || exceptionCallStack.length == 0) {
            return -1;
        }
        StackTraceElement[] currentCallStack = Thread.currentThread().getStackTrace();
        if (currentCallStack == null || currentCallStack.length == 0) {
            return -1;
        }
        int proposedExceptionIndex = exceptionCallStack.length - 1;
        for (int proposedCurrentIndex = currentCallStack.length - 1; proposedExceptionIndex >= 0 && proposedCurrentIndex >= 0 && exceptionCallStack[proposedExceptionIndex] != null && exceptionCallStack[proposedExceptionIndex].getClassName().equals(currentCallStack[proposedCurrentIndex].getClassName()); --proposedExceptionIndex, --proposedCurrentIndex) {
        }
        if (++proposedExceptionIndex > exceptionCallStack.length) {
            return -1;
        }
        return proposedExceptionIndex;
    }

    private static String[] getCallStackFromStackTraceElement(StackTraceElement[] exceptionCallStack) {
        if (exceptionCallStack == null) {
            return null;
        }
        String[] answer = new String[exceptionCallStack.length];
        for (int i = 0; i < exceptionCallStack.length; ++i) {
            answer[exceptionCallStack.length - 1 - i] = exceptionCallStack[i].getClassName();
        }
        return answer;
    }

    private static String getPackageName(String className) {
        int end = className.lastIndexOf(46);
        return end > 0 ? className.substring(0, end) : "";
    }

    static String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

