/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.ws.logging.internal.TraceSpecification;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.LoggingFileUtils;
import com.ibm.ws.logging.internal.impl.NaturalComparator;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileLogSet {
    private final boolean rolling;
    private File directory;
    private String fileName;
    private String fileExtension;
    private int maxFiles;
    private Pattern filePattern;
    private ArrayList<String> files;
    private String lastDateString;
    private int lastCounter;

    public FileLogSet(boolean rolling) {
        this.rolling = rolling;
    }

    public File getDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public Pattern getFilePattern() {
        return this.filePattern;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    private int getMaxDateFiles() {
        return this.rolling ? this.maxFiles - 1 : this.maxFiles;
    }

    public boolean update(File directory, String fileName, String fileExtension, int maxFiles) {
        boolean updateLocation;
        this.maxFiles = maxFiles;
        boolean bl = updateLocation = !directory.equals(this.directory) || !fileName.equals(this.fileName) || !fileExtension.equals(this.fileExtension);
        if (updateLocation) {
            this.directory = directory;
            this.fileName = fileName;
            this.fileExtension = fileExtension;
            this.filePattern = LoggingFileUtils.compileLogFileRegex(fileName, fileExtension);
            this.files = null;
        }
        if (maxFiles <= 0) {
            this.files = null;
        } else {
            if (this.files == null) {
                this.files = new ArrayList();
                String[] existing = LoggingFileUtils.safelyFindFiles(directory, this.filePattern);
                if (existing != null) {
                    Arrays.sort(existing, NaturalComparator.instance);
                    this.files.addAll(Arrays.asList(existing));
                }
            }
            int maxTrackedFiles = this.getMaxDateFiles();
            while (this.files.size() > maxTrackedFiles) {
                this.removeFile(0);
            }
            if (updateLocation) {
                if (this.files.isEmpty()) {
                    this.lastDateString = null;
                } else {
                    Matcher matcher = this.filePattern.matcher(this.files.get(this.files.size() - 1));
                    if (!matcher.matches()) {
                        throw new IllegalStateException();
                    }
                    this.lastDateString = matcher.group(1);
                    this.lastCounter = Integer.parseInt(matcher.group(2));
                }
            }
        }
        return updateLocation;
    }

    public File createNewFile() throws IOException {
        if (LoggingFileUtils.validateDirectory(this.directory) == null) {
            return null;
        }
        return this.rolling ? this.rollFile() : this.createNewUniqueFile(null);
    }

    private File rollFile() throws IOException {
        File file = new File(this.directory, this.fileName + this.fileExtension);
        if (file.isFile()) {
            if (file.length() == 0L) {
                return file;
            }
            if (this.maxFiles == 1 ? !LoggingFileUtils.deleteFile(file) : this.createNewUniqueFile(file) == null) {
                return file;
            }
        }
        if (!file.createNewFile()) {
            String msg = Tr.formatMessage(TraceSpecification.getTc(), "UNABLE_TO_CREATE_RESOURCE_NOEX", file);
            BaseTraceService.rawSystemErr.println(msg);
        }
        return file;
    }

    private File createNewUniqueFile(File srcFile) throws IOException {
        String destFileName;
        File destFile;
        String dateString = this.getDateString();
        int index = this.findFileIndexAndUpdateCounter(dateString);
        do {
            int counter;
            ++this.lastCounter;
            destFileName = this.fileName + dateString + '.' + counter + this.fileExtension;
            destFile = new File(this.directory, destFileName);
            boolean success = srcFile == null ? destFile.createNewFile() : (!destFile.exists() ? srcFile.renameTo(destFile) : false);
            if (!success) continue;
            this.addFile(index, destFileName);
            return destFile;
        } while (destFile.isFile());
        if (srcFile != null && this.copyFileTo(srcFile, destFile)) {
            this.addFile(index, destFileName);
            return LoggingFileUtils.deleteFile(srcFile) ? destFile : null;
        }
        String msg = Tr.formatMessage(TraceSpecification.getTc(), "UNABLE_TO_CREATE_RESOURCE_NOEX", destFile);
        BaseTraceService.rawSystemErr.println(msg);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDateString() {
        SimpleDateFormat simpleDateFormat = LoggingFileUtils.FILE_DATE;
        synchronized (simpleDateFormat) {
            return LoggingFileUtils.FILE_DATE.format(new Date());
        }
    }

    private int findFileIndexAndUpdateCounter(String dateString) {
        if (dateString.equals(this.lastDateString)) {
            if (this.maxFiles <= 0) {
                return -1;
            }
            return this.files.size();
        }
        this.lastDateString = dateString;
        this.lastCounter = 0;
        if (this.maxFiles <= 0) {
            return -1;
        }
        if (this.files.isEmpty() || dateString.compareTo(this.lastDateString) > 0) {
            return this.files.size();
        }
        String partialFileName = this.fileName + dateString + '.';
        return -Collections.binarySearch(this.files, partialFileName, NaturalComparator.instance) - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean copyFileTo(File srcFile, File destFile) throws IOException {
        if (!destFile.createNewFile()) {
            return false;
        }
        FileChannel target = null;
        FileChannel source = null;
        boolean success = false;
        try {
            TextFileOutputStreamFactory fileStreamFactory = TrConfigurator.getFileOutputStreamFactory();
            target = fileStreamFactory.createOutputStream(destFile).getChannel();
            source = new FileInputStream(srcFile).getChannel();
            source.transferTo(0L, source.size(), target);
            success = true;
        }
        catch (IOException ioe) {
            LoggingFileUtils.tryToClose(target);
            LoggingFileUtils.tryToClose(source);
            if (!success) {
                LoggingFileUtils.deleteFile(destFile);
                return false;
            }
            catch (Throwable throwable) {
                LoggingFileUtils.tryToClose(target);
                LoggingFileUtils.tryToClose(source);
                if (!success) {
                    LoggingFileUtils.deleteFile(destFile);
                    return false;
                }
                throw throwable;
            }
        }
        LoggingFileUtils.tryToClose(target);
        LoggingFileUtils.tryToClose(source);
        if (!success) {
            LoggingFileUtils.deleteFile(destFile);
            return false;
        }
        return true;
    }

    private void addFile(int index, String file) {
        if (this.maxFiles > 0) {
            int numFiles = this.files.size();
            int maxDateFiles = this.getMaxDateFiles();
            if (maxDateFiles <= 0 || numFiles < maxDateFiles) {
                this.files.add(index, file);
            } else {
                while (this.files.size() > index) {
                    this.removeFile(this.files.size() - 1);
                }
                while (this.files.size() >= maxDateFiles) {
                    this.removeFile(0);
                }
                this.files.add(file);
            }
        }
    }

    private void removeFile(int index) {
        String file = this.files.remove(index);
        LoggingFileUtils.deleteFile(this.directory, file);
    }
}

