/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.processing.internal.OSGiCommands;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.command.processing.CommandHandler;
import com.ibm.ws.zos.core.command.processing.ModifyResults;
import com.ibm.ws.zos.processing.internal.OSGiCommands.OSGiConsole;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.console.ConsoleSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OSGiCommandHandler
implements CommandHandler {
    static final String OSGICOMMANDHANDLERNAME = "OSGiCommandHandler";
    protected BundleContext bundleContext = null;
    static final long serialVersionUID = -781590065602024103L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    void deactivate(BundleContext bundleContext) {
        this.bundleContext = null;
    }

    public void handleModify(String commandString, ModifyResults results) {
        List<String> responses = null;
        String[] osgiCmd = commandString.split("((?i)(osgi,))", 2);
        if (osgiCmd.length > 1 && osgiCmd[1] != null) {
            try {
                OSGiConsole oConsole = this.getNewConsole(osgiCmd[1]);
                this.registerConsole(oConsole);
                responses = oConsole.getResults();
                Iterator<String> it = responses.iterator();
                ArrayList<String> messagesToRemove = new ArrayList<String>();
                while (it.hasNext()) {
                    String currentMsg = it.next();
                    if (!currentMsg.contains("osgi> Disconnect from console?")) continue;
                    messagesToRemove.add(currentMsg);
                }
                responses.removeAll(messagesToRemove);
                results.setCompletionStatus(1);
            }
            catch (UnsupportedEncodingException oConsole) {
                FFDCFilter.processException((Throwable)oConsole, (String)"com.ibm.ws.zos.processing.internal.OSGiCommands.OSGiCommandHandler", (String)"101", (Object)this, (Object[])new Object[]{commandString, results});
                results.setCompletionStatus(3);
            }
        } else {
            results.setCompletionStatus(2);
        }
        results.setResponsesContainMSGIDs(false);
        results.setResponses(responses);
    }

    protected OSGiConsole getNewConsole(String osgiCmd) throws UnsupportedEncodingException {
        String osgiCmdModified = osgiCmd + "\ndisconnect\ny\n";
        return new OSGiConsole(osgiCmdModified);
    }

    protected ServiceRegistration<?> registerConsole(OSGiConsole oConsole) {
        return this.bundleContext.registerService(ConsoleSession.class.getName(), (Object)oConsole, null);
    }

    public String getName() {
        return OSGICOMMANDHANDLERNAME;
    }

    public List<String> getHelp() {
        ArrayList<String> responses = new ArrayList<String>();
        responses.add("Issue \"MODIFY <jobname.>identifier,'osgi,osgicmd'\"");
        responses.add("  where osgicmd is a valid OSGI console command");
        return responses;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(OSGiCommandHandler.class);
    }
}

