/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.command.processing.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConsoleCommand {
    private int _commandType = 0;
    private int _errorCode = 0;
    private int _consoleID = 0;
    private String _consoleName = null;
    private long _cart = 0L;
    private int _restOfCommandLength = 0;
    private String _restOfCommand = null;
    protected static final int I_cia_commandType = 0;
    protected static final int I_cia_errorCode = 4;
    protected static final int I_cia_consoleID = 8;
    protected static final int I_cia_consoleName = 12;
    protected static final int I_cia_commandCART = 20;
    protected static final int I_cia_commandRestOfCommandLength = 28;
    protected static final int I_cia_commandRestOfCommand = 32;
    static final long serialVersionUID = 526302100620464351L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ConsoleCommand(byte[] nativeCIA) throws UnsupportedEncodingException {
        byte[] temp = null;
        byte[] commandAttrs = nativeCIA;
        if (nativeCIA == null) {
            return;
        }
        ByteBuffer buf = ByteBuffer.wrap(commandAttrs);
        this._commandType = buf.getInt(0);
        this._errorCode = buf.getInt(4);
        this._consoleID = buf.getInt(8);
        temp = new byte[8];
        buf.position(12);
        buf.get(temp, 0, 8);
        this._consoleName = new String(temp, "Cp1047");
        this._cart = buf.getLong(20);
        this._restOfCommandLength = buf.getInt(28);
        temp = new byte[this._restOfCommandLength];
        buf.position(32);
        buf.get(temp, 0, this._restOfCommandLength);
        this._restOfCommand = new String(temp, "Cp1047");
        this._restOfCommand = ConsoleCommand.stripQuotes(this._restOfCommand);
    }

    int getCommandType() {
        return this._commandType;
    }

    int getErrorCode() {
        return this._errorCode;
    }

    int getConsoleID() {
        return this._consoleID;
    }

    String getConsoleName() {
        return this._consoleName;
    }

    String getCommandString() {
        return this._restOfCommand;
    }

    long getCart() {
        return this._cart;
    }

    private static String stripQuotes(String value) {
        if (value == null) {
            return value;
        }
        if ((value = value.trim()).startsWith("'") && value.endsWith("'") && value.length() > 1) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ConsoleCommand: commandType = ");
        sb.append(Integer.toHexString(this._commandType));
        sb.append(", errorCode = ");
        sb.append(Integer.toHexString(this._errorCode));
        sb.append(", consoleID = ");
        sb.append(Integer.toHexString(this._consoleID));
        sb.append(", consoleName = ");
        sb.append(this._consoleName);
        sb.append(", CART = ");
        sb.append(Long.toHexString(this._cart));
        sb.append(", rest of command length = ");
        sb.append(Integer.toHexString(this._restOfCommandLength));
        sb.append(", rest of command text = ");
        sb.append(this._restOfCommand);
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConsoleCommand.class);
    }
}

