/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.command.processing.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.command.processing.internal.CommandHandlerHolder;
import com.ibm.ws.zos.command.processing.internal.ConsoleCommand;
import com.ibm.ws.zos.command.processing.internal.ModifyResultsImpl;
import com.ibm.ws.zos.core.command.processing.CommandHandler;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CommandProcessor {
    private static final TraceComponent tc = Tr.register(CommandProcessor.class);
    protected static final String WS_COMMAND_HANDLER_REFERENCE_NAME = "wsCommandHandler";
    private String FAILED_TO_TRANSLATE_TO_EBCDIC = null;
    private CommandListenerThread thread = null;
    protected LibertyProcess cmdLine = null;
    protected NativeMethodManager nativeMethodManager = null;
    private WsLocationAdmin locationAdmin = null;
    private ComponentContext componentContext;
    private BundleContext bundleContext;
    final Map<ServiceReference<CommandHandler>, CommandHandlerHolder> serviceReferenceMap = new HashMap<ServiceReference<CommandHandler>, CommandHandlerHolder>();
    public static final int CIA_COMMANDTYPE_STOP = 1;
    public static final int CIA_COMMANDTYPE_MODIFY = 2;
    public static final int CIA_COMMANDTYPE_UNKNOWN = 3;
    public static final int CIA_COMMANDTYPE_ENDING = 4;
    public static final int CIA_COMMANDTYPE_ERROR = 5;
    static final long serialVersionUID = -3000581955260313643L;

    protected void activate(ComponentContext componentContext) {
        ResourceBundle resBundle = TraceNLS.getBaseResourceBundle(this.getClass(), (String)tc.getResourceBundleName());
        this.FAILED_TO_TRANSLATE_TO_EBCDIC = TraceNLS.getFormattedMessage(this.getClass(), (ResourceBundle)resBundle, (String)tc.getResourceBundleName(), (String)"MESSAGE_TRANSLATE_ERROR", (Object[])null, (String)"CWWKB0008E: CWWKB0009E: A COMMAND RESPONSE COULD NOT BE TRANSLATED TO NATIVE ENCODING", (Locale)Locale.ENGLISH, (boolean)false);
        this.componentContext = componentContext;
        this.bundleContext = componentContext.getBundleContext();
        this.nativeMethodManager.registerNatives(CommandProcessor.class);
        final CommandProcessor temp = this;
        this.thread = AccessController.doPrivileged(new PrivilegedAction<CommandListenerThread>(){
            static final long serialVersionUID = 3432526293868314138L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public CommandListenerThread run() {
                CommandListenerThread thread = new CommandListenerThread(temp);
                return thread;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        this.thread.setName("zOS Command Listener Thread");
        this.thread.start();
    }

    void deactivate(ComponentContext componentContext) {
        this.thread.end();
        this.bundleContext = null;
        this.componentContext = null;
    }

    protected void setKernelCommandLine(LibertyProcess cmdLine) {
        this.cmdLine = cmdLine;
    }

    protected void unsetKernelCommandLine(LibertyProcess cmdLine) {
        if (this.cmdLine == cmdLine) {
            this.cmdLine = null;
        }
    }

    protected void setNativeMethodManager(NativeMethodManager nativeMethodManager) {
        this.nativeMethodManager = nativeMethodManager;
    }

    protected void unsetNativeMethodManager(NativeMethodManager nativeMethodManager) {
        if (this.nativeMethodManager == nativeMethodManager) {
            this.nativeMethodManager = null;
        }
    }

    protected synchronized void setWsCommandHandler(ServiceReference<CommandHandler> handlerReference) {
        CommandHandlerHolder holder = new CommandHandlerHolder(this, handlerReference);
        this.serviceReferenceMap.put(handlerReference, holder);
    }

    protected synchronized void unsetWsCommandHandler(ServiceReference<CommandHandler> handlerReference) {
        this.serviceReferenceMap.remove(handlerReference);
    }

    protected void setLocationAdmin(WsLocationAdmin locationAdmin) {
        this.locationAdmin = locationAdmin;
    }

    protected void unsetLocationAdmin(WsLocationAdmin locationAdmin) {
        this.locationAdmin = null;
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    ComponentContext getComponentContext() {
        return this.componentContext;
    }

    protected String getWsHandlerReferenceName() {
        return WS_COMMAND_HANDLER_REFERENCE_NAME;
    }

    protected void processCommand(byte[] inCmd) {
        ConsoleCommand consoleCmd;
        int commandType = 0;
        try {
            consoleCmd = new ConsoleCommand(inCmd);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.zos.command.processing.internal.CommandProcessor", (String)"227", (Object)this, (Object[])new Object[]{inCmd});
            Tr.error((TraceComponent)tc, (String)"COMMAND_TRANSLATE_ERROR", (Object[])new Object[0]);
            return;
        }
        commandType = consoleCmd.getCommandType();
        switch (commandType) {
            case 1: {
                Tr.audit((TraceComponent)tc, (String)"STOP_COMMAND_RECEIVED", (Object[])new Object[]{this.locationAdmin.getServerName()});
                if (this.cmdLine == null) break;
                String pidenv = System.getenv("X_PID_FILE");
                if (pidenv != null) {
                    File pidfile = new File(pidenv);
                    if (this.fileExists(pidfile) && !this.fileDelete(pidfile)) {
                        Tr.error((TraceComponent)tc, (String)"FILE_DELETE_UNSUCCESSFUL", (Object[])new Object[]{pidfile.getAbsolutePath()});
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"X_PID_FILE is NULL", (Object[])new Object[0]);
                }
                this.cmdLine.shutdown();
                break;
            }
            case 2: {
                this.deliverCommandToHandlers(consoleCmd);
                break;
            }
            case 3: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("CommandProcessor::processCommand, UNKNOWN case path,  commandType=" + commandType), (Object[])new Object[0]);
                break;
            }
            case 4: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("CommandProcessor::processCommand, ENDING case path,  commandType=" + commandType), (Object[])new Object[0]);
                break;
            }
            case 5: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CommandProcessor::processCommand, ERROR case path,  commandType=" + commandType), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"NATIVE_ERROR_COMMAND_RECEIVED", (Object[])new Object[]{consoleCmd.getErrorCode()});
                break;
            }
            default: {
                Tr.error((TraceComponent)tc, (String)"NATIVE_ERROR_COMMAND_RECEIVED", (Object[])new Object[]{consoleCmd.getErrorCode()});
                this.thread.end();
            }
        }
    }

    protected synchronized int deliverCommandToHandlers(ConsoleCommand consoleCommand) {
        String completionStatus;
        int rc = 2;
        ModifyResultsImpl commandResults = null;
        String currentHandlerName = "UNKNOWN";
        try {
            for (CommandHandlerHolder commandHandlerHolder : this.serviceReferenceMap.values()) {
                commandResults = (ModifyResultsImpl)commandHandlerHolder.deliverCommand(consoleCommand.getCommandString());
                currentHandlerName = commandHandlerHolder.getCommandHandlerName();
                if (commandResults == null) continue;
                int handlerRC = commandResults.getCompletionStatus();
                List<String> responseMsgs = commandResults.getResponses();
                if (responseMsgs != null && !responseMsgs.isEmpty()) {
                    for (String currentMsg : responseMsgs) {
                        if (!commandResults.responsesContainMSGIDs()) {
                            this.buildAndIssueCommandResponse(consoleCommand, "MODIFY_COMMAND_HANDLER_MSG", new Object[]{currentMsg}, "CWWKB0008E: " + currentMsg);
                            continue;
                        }
                        this.issueCommandResponse(consoleCommand, currentMsg);
                    }
                }
                if (handlerRC == 1) {
                    rc = handlerRC;
                    completionStatus = "SUCCESSFULLY";
                } else {
                    completionStatus = "UNSUCCESSFULLY";
                    if (handlerRC == 3) {
                        rc = handlerRC;
                    }
                }
                if (handlerRC == 2) continue;
                this.buildAndIssueCommandResponse(consoleCommand, "MODIFY_COMMAND_HANDLER_DONE", new Object[]{completionStatus, currentHandlerName}, "CWWKB0008E: CWWKB0005I: COMMAND RESPONSES COMPLETED " + completionStatus + " FROM " + currentHandlerName + ".");
            }
        }
        catch (Throwable i$) {
            FFDCFilter.processException((Throwable)i$, (String)"com.ibm.ws.zos.command.processing.internal.CommandProcessor", (String)"352", (Object)this, (Object[])new Object[]{consoleCommand});
            rc = 3;
            this.buildAndIssueCommandResponse(consoleCommand, "MODIFY_HANDLER_ERROR", new Object[]{currentHandlerName}, "CWWKB0008E: CWWKB0007E: ERROR RECEIVED FROM COMMAND HANDLER " + currentHandlerName + ".");
        }
        if (rc == 2) {
            if (!consoleCommand.getCommandString().equalsIgnoreCase("HELP")) {
                this.buildAndIssueCommandResponse(consoleCommand, "MODIFY_COMMAND_UNKNOWN", new Object[]{consoleCommand.getCommandString()}, "CWWKB0008E: CWWKB0006W: MODIFY COMMAND " + consoleCommand.getCommandString() + " WAS NOT KNOWN TO ANY ACTIVE COMMAND HANDLER.");
            }
            this.issueHelpFromRegisteredHandlers(consoleCommand);
        }
        completionStatus = rc == 3 ? "UNSUCCESSFULLY" : (rc == 2 && !consoleCommand.getCommandString().equalsIgnoreCase("HELP") ? "UNSUCCESSFULLY" : "SUCCESSFULLY");
        this.buildAndIssueCommandResponse(consoleCommand, "MODIFY_COMMAND_COMPLETED", new Object[]{consoleCommand.getCommandString(), completionStatus}, "CWWKB0008E: MODIFY COMMAND" + consoleCommand.getCommandString() + " COMPLETED " + completionStatus + ".");
        return rc;
    }

    private void issueHelpFromRegisteredHandlers(ConsoleCommand consoleCommand) {
        try {
            for (CommandHandlerHolder commandHandlerHolder : this.serviceReferenceMap.values()) {
                List<String> helpMsgs;
                if (!commandHandlerHolder.displayHelp() || (helpMsgs = commandHandlerHolder.getHelp()) == null || helpMsgs.isEmpty()) continue;
                String handlerName = commandHandlerHolder.getCommandHandlerName();
                this.buildAndIssueCommandResponse(consoleCommand, "MODIFY_COMMAND_HANDLER_HELP_HDR", new Object[]{handlerName}, "CWWKB0008E: CWWKB0011I: START OF HELP INFORMATION FROM COMMAND HANDLER " + handlerName + ".");
                for (String currentMsg : helpMsgs) {
                    this.buildAndIssueCommandResponse(consoleCommand, "MODIFY_COMMAND_HANDLER_HELP_TXT", new Object[]{currentMsg}, "CWWKB0008E: " + currentMsg + ".");
                }
                this.buildAndIssueCommandResponse(consoleCommand, "MODIFY_COMMAND_HANDLER_HELP_END", new Object[]{handlerName}, "CWWKB0008E: CWWKB0013I END OF HELP INFORMATION FROM COMMAND HANDLER " + handlerName + ".");
            }
        }
        catch (Throwable i$) {
            FFDCFilter.processException((Throwable)i$, (String)"com.ibm.ws.zos.command.processing.internal.CommandProcessor", (String)"429", (Object)this, (Object[])new Object[]{consoleCommand});
        }
    }

    protected void buildAndIssueCommandResponse(ConsoleCommand consoleCommand, String NLS_msgID, Object[] msgArgs, String defaultMsg) {
        ResourceBundle resBundle = TraceNLS.getBaseResourceBundle(this.getClass(), (String)tc.getResourceBundleName());
        String msg = TraceNLS.getFormattedMessage(this.getClass(), (ResourceBundle)resBundle, (String)tc.getResourceBundleName(), (String)NLS_msgID, (Object[])msgArgs, (String)defaultMsg, (Locale)Locale.ENGLISH, (boolean)false);
        this.issueCommandResponse(consoleCommand, msg);
    }

    protected void issueCommandResponse(ConsoleCommand consoleCommand, String msg) {
        long cart = consoleCommand.getCart();
        int consid = consoleCommand.getConsoleID();
        byte[] temp = null;
        try {
            temp = msg.getBytes("Cp1047");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.zos.command.processing.internal.CommandProcessor", (String)"482", (Object)this, (Object[])new Object[]{consoleCommand, msg});
            try {
                temp = this.FAILED_TO_TRANSLATE_TO_EBCDIC.getBytes("Cp1047");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException2, (String)"com.ibm.ws.zos.command.processing.internal.CommandProcessor", (String)"485", (Object)this, (Object[])new Object[]{consoleCommand, msg});
                Tr.error((TraceComponent)tc, (String)"MESSAGE_TRANSLATE_ERROR", (Object[])new Object[0]);
            }
        }
        this.ntv_issueCommandResponse(temp, cart, consid);
    }

    boolean fileExists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 7847197308976568880L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
    }

    boolean fileDelete(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 3326124270290200453L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.delete();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
    }

    protected native long ntv_getIEZCOMReference();

    protected native byte[] ntv_getCommand(long var1);

    protected native void ntv_stopListeningForCommands();

    protected native int ntv_issueCommandResponse(byte[] var1, long var2, int var4);

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class CommandListenerThread
    extends Thread {
        private final CommandProcessor cp;
        private boolean keepGoing = true;
        private long iezcom_area;
        static final long serialVersionUID = -8334916547441832964L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CommandListenerThread(CommandProcessor cp) {
            this.cp = cp;
        }

        @Override
        public void run() {
            this.iezcom_area = this.cp.ntv_getIEZCOMReference();
            while (this.keepGoing && this.iezcom_area != 0L) {
                try {
                    byte[] nativeCommandInfoArea;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"CommandListenerThread, waiting for command", (Object[])new Object[0]);
                    }
                    if ((nativeCommandInfoArea = this.cp.ntv_getCommand(this.iezcom_area)).length != 0) {
                        this.cp.processCommand(nativeCommandInfoArea);
                        continue;
                    }
                    this.keepGoing = false;
                }
                catch (Exception nativeCommandInfoArea) {
                    FFDCFilter.processException((Throwable)nativeCommandInfoArea, (String)"com.ibm.ws.zos.command.processing.internal.CommandProcessor$CommandListenerThread", (String)"524", (Object)this, (Object[])new Object[0]);
                }
            }
        }

        public void end() {
            this.keepGoing = false;
            this.cp.ntv_stopListeningForCommands();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CommandListenerThread.class);
        }
    }
}

