/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.embeddable.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.embeddable.impl.EmbeddableTransactionImpl;
import com.ibm.tx.jta.impl.TranManagerImpl;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionRolledbackException;

public class EmbeddableTranManagerImpl
extends TranManagerImpl {
    private static final TraceComponent tc = Tr.register(EmbeddableTranManagerImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");

    public void begin() throws NotSupportedException, SystemException {
        int timeout;
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"begin (SPI)");
        }
        if (this.tx != null) {
            if (this.tx.getTxType() != 2) {
                Tr.error((TraceComponent)tc, (String)"WTRN0017_UNABLE_TO_BEGIN_NESTED_TRANSACTION");
                NotSupportedException nse = new NotSupportedException("Nested transactions are not supported.");
                FFDCFilter.processException((Throwable)nse, (String)"com.ibm.tx.jta.embeddable.impl.EmbeddableTranManagerImpl.begin", (String)"63", (Object)((Object)this));
                if (traceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"begin (SPI)", (Object)nse);
                }
                throw nse;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"the tx is NONINTEROP_GLOBAL it may safely be treated as null");
            }
        }
        if ((timeout = ConfigurationProviderManager.getConfigurationProvider().getRuntimeMetaDataProvider().getTransactionTimeout()) == -1) {
            timeout = this.txTimeout;
        }
        if (timeout == 0) {
            timeout = ConfigurationProviderManager.getConfigurationProvider().getTotalTransactionLifetimeTimeout();
        }
        this.tx = this.createNewTransaction(timeout);
        this.invokeEventListener((UOWCoordinator)this.tx, 1, null);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"begin (SPI)");
        }
    }

    protected EmbeddableTransactionImpl createNewTransaction(int timeout) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"createNewTransaction", (Object)timeout);
        }
        EmbeddableTransactionImpl tx = new EmbeddableTransactionImpl(timeout);
        tx.setMostRecentThread(Thread.currentThread());
        return tx;
    }

    public void completeTxTimeout() throws TransactionRolledbackException {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"completeTxTimeout");
        }
        if (this.tx != null && this.tx.isTimedOut()) {
            if (traceOn && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Transaction has timed out. The transaction will be rolled back now");
            }
            Tr.info((TraceComponent)tc, (String)"WTRN0041_TXN_ROLLED_BACK", (Object)this.tx.getTranName());
            ((EmbeddableTransactionImpl)this.tx).rollbackResources();
            TransactionRolledbackException rbe = new TransactionRolledbackException("Transaction is ended due to timeout");
            FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.tx.jta.embeddable.impl.EmbeddableTranManagerImpl.completeTxTimeout", (String)"100", (Object)((Object)this));
            if (traceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"completeTxTimeout", (Object)rbe);
            }
            throw rbe;
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"completeTxTimeout");
        }
    }
}

