/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.adaptor;

import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ChecksumsManager;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.Product;
import com.ibm.ws.install.internal.adaptor.ArchiveAdaptor;
import com.ibm.ws.install.internal.adaptor.FixAdaptor;
import com.ibm.ws.install.internal.asset.ESAAsset;
import com.ibm.ws.install.internal.platform.InstallPlatformUtils;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.HashUtils;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.apache.aries.util.manifest.ManifestProcessor;
import org.osgi.framework.Version;
import org.xml.sax.SAXException;
import wlp.lib.extract.platform.Platform;

public class ESAAdaptor
extends ArchiveAdaptor {
    private static final String EBCDIC = "ebcdic";

    public static void install(Product product, ESAAsset featureAsset, List<File> filesInstalled, Collection<String> featuresToBeInstalled, InstallConstants.ExistsAction existsAction, Set<String> executableFiles, Map<String, Set<String>> extattrFiles, ChecksumsManager checksumsManager) throws IOException, InstallException {
        ProvisioningFeatureDefinition featureDefinition = featureAsset.getProvisioningFeatureDefinition();
        if (featureDefinition == null) {
            return;
        }
        try {
            ESAAdaptor.install(product, featureAsset, featureDefinition, filesInstalled, featuresToBeInstalled, existsAction, executableFiles, extattrFiles, checksumsManager);
        }
        catch (IOException e) {
            InstallUtils.delete(filesInstalled);
            throw e;
        }
        catch (InstallException e) {
            InstallUtils.delete(filesInstalled);
            throw e;
        }
    }

    private static void install(Product product, ESAAsset featureAsset, ProvisioningFeatureDefinition featureDefinition, List<File> filesInstalled, Collection<String> featuresToBeInstalled, InstallConstants.ExistsAction existsAction, Set<String> executableFiles, Map<String, Set<String>> extattrFiles, ChecksumsManager checksumsManager) throws IOException, InstallException {
        String repoType = featureAsset.getRepoType();
        File baseDir = repoType == null || "usr".equalsIgnoreCase(repoType) ? product.getUserExtensionDir() : ("core".equals(repoType) ? product.getInstallDir() : product.getUserDirExternal(repoType));
        boolean installToCore = "core".equals(featureDefinition.getHeader("IBM-InstallTo"));
        if (installToCore) {
            baseDir = Utils.getInstallDir();
        }
        String manifestName = featureDefinition.getSymbolicName() + ".mf";
        ZipEntry checksumEntry = featureAsset.getEntry("OSGI-INF/checksums.cs");
        Properties checksumInput = null;
        Properties checksumOutput = null;
        if (checksumEntry != null) {
            checksumInput = new Properties();
            checksumInput.load(featureAsset.getInputStream(checksumEntry));
            checksumOutput = new Properties();
        }
        String manifestDirectoryPath = featureDefinition.getVisibility() == Visibility.INSTALL ? "lib/assets" : "lib/features";
        File featureDir = new File(baseDir, manifestDirectoryPath);
        String checksumManifestValue = null;
        if (checksumInput != null && (checksumManifestValue = checksumInput.getProperty(featureAsset.getSubsystemEntryName())) != null) {
            checksumOutput.put(manifestDirectoryPath + "/" + manifestName, checksumManifestValue);
        }
        ESAAdaptor.write(false, filesInstalled, new File(featureDir, manifestName), featureAsset.getInputStream(featureAsset.getSubsystemEntry()), InstallConstants.ExistsAction.fail, checksumManifestValue);
        boolean ibmFeature = featureDefinition.getIbmFeatureVersion() > 0;
        HashMap<String, FeatureResource> bundleConstituents = new HashMap<String, FeatureResource>();
        HashMap<String, FeatureResource> jarConstituents = new HashMap<String, FeatureResource>();
        HashSet<String> processedEntries = new HashSet<String>();
        for (FeatureResource fr : featureDefinition.getConstituents(null)) {
            String resourceLoc;
            SubsystemContentType type = fr.getType();
            if (SubsystemContentType.BUNDLE_TYPE == type) {
                bundleConstituents.put(fr.getSymbolicName(), fr);
                continue;
            }
            if (SubsystemContentType.JAR_TYPE == type && ibmFeature) {
                resourceLoc = fr.getLocation();
                if (resourceLoc == null || resourceLoc.contains(",") || !resourceLoc.endsWith(".jar")) {
                    jarConstituents.put(fr.getSymbolicName(), fr);
                    continue;
                }
                ESAAdaptor.extractFileType(resourceLoc, baseDir, featureDir, existsAction, filesInstalled, featureAsset.getZip(), featureDefinition, fr, processedEntries, checksumInput, checksumOutput, executableFiles, extattrFiles, checksumsManager);
                continue;
            }
            if (SubsystemContentType.FEATURE_TYPE == type) {
                String symName = fr.getSymbolicName();
                if (product.containsFeature(symName) || product.containsFeatureCollection(symName) || featuresToBeInstalled.contains(symName)) continue;
                throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.missing.feature", featureDefinition.getSymbolicName(), symName));
            }
            if (!ibmFeature) continue;
            resourceLoc = fr.getLocation();
            if (resourceLoc == null || resourceLoc.contains(",")) {
                throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.missing.content", fr.getSymbolicName(), null), 23);
            }
            ESAAdaptor.extractFileType(resourceLoc, baseDir, featureDir, existsAction, filesInstalled, featureAsset.getZip(), featureDefinition, fr, processedEntries, checksumInput, checksumOutput, executableFiles, extattrFiles, checksumsManager);
        }
        String licenseAgreementPrefix = featureDefinition.getHeader("IBM-License-Agreement");
        String licenseInformationPrefix = featureDefinition.getHeader("IBM-License-Information");
        boolean hasLicenseAgreements = licenseAgreementPrefix != null && !licenseAgreementPrefix.isEmpty();
        boolean hasLicenseInformation = licenseInformationPrefix != null && !licenseInformationPrefix.isEmpty();
        File licenseDir = null;
        if (hasLicenseAgreements || hasLicenseInformation) {
            licenseDir = new File(baseDir, "lafiles" + File.separator + featureDefinition.getSymbolicName());
        }
        String loc = featureDefinition.getHeader("Subsystem-Localization");
        File l10nDir = new File(featureDir, "l10n");
        Collection icons = featureDefinition.getIcons();
        File iconDir = new File(featureDir, "icons/" + featureDefinition.getSymbolicName());
        Enumeration<? extends ZipEntry> entries = featureAsset.getZipEntries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            if (ze.isDirectory()) continue;
            String entryName = ze.getName();
            String entryChecksum = null;
            if (checksumInput != null) {
                entryChecksum = checksumInput.getProperty(entryName);
            }
            if (icons != null && icons.contains(entryName)) {
                File iconFile = new File(iconDir, entryName);
                ESAAdaptor.write(false, filesInstalled, iconFile, featureAsset.getInputStream(ze), existsAction, entryChecksum);
                continue;
            }
            if (entryName.startsWith("OSGI-INF/")) {
                if (loc == null || !entryName.startsWith(loc) || entryName.indexOf(47, loc.length()) != -1) continue;
                File locFile = new File(l10nDir, featureDefinition.getSymbolicName() + entryName.substring(loc.length()));
                ESAAdaptor.write(false, filesInstalled, locFile, featureAsset.getInputStream(ze), existsAction, entryChecksum);
                continue;
            }
            if (entryName.indexOf(47, 1) == -1) {
                ESAAdaptor.extractBundleType(ze, featureAsset.getZip(), existsAction, bundleConstituents, featureDefinition, filesInstalled, baseDir, featureDir, false, checksumInput, checksumOutput, checksumsManager);
                continue;
            }
            if (!processedEntries.contains(entryName) && entryName.startsWith("wlp") && entryName.endsWith(".jar")) {
                ESAAdaptor.extractBundleType(ze, featureAsset.getZip(), existsAction, jarConstituents, featureDefinition, filesInstalled, baseDir, featureDir, true, checksumInput, checksumOutput, checksumsManager);
                continue;
            }
            if ((!hasLicenseAgreements || !entryName.startsWith(licenseAgreementPrefix)) && (!hasLicenseInformation || !entryName.startsWith(licenseInformationPrefix))) continue;
            File licenseFile = new File(licenseDir, entryName);
            ESAAdaptor.write(false, filesInstalled, licenseFile, featureAsset.getInputStream(ze), existsAction, entryChecksum);
        }
        if (!bundleConstituents.isEmpty()) {
            throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.content.notfound", bundleConstituents), 24);
        }
        if (!jarConstituents.isEmpty()) {
            throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.content.notfound", jarConstituents), 24);
        }
        if (checksumOutput != null) {
            File checksumFile = new File(featureDir, "checksums/" + featureDefinition.getSymbolicName() + ".cs");
            ESAAdaptor.write(false, filesInstalled, checksumFile, null, new PropertiesFileWriter(checksumOutput), existsAction, null);
        }
        if (featureDefinition.getVisibility() == Visibility.INSTALL) {
            product.addFeatureCollection(featureAsset.getFeatureName(), featureDefinition);
        } else {
            product.addFeature(featureAsset.getFeatureName(), featureDefinition);
        }
    }

    private static String getFeaturePath(ProvisioningFeatureDefinition targetFd, File baseDir) {
        if (targetFd.getVisibility() == Visibility.INSTALL) {
            return "lib/assets/";
        }
        File mf = targetFd.getFeatureDefinitionFile();
        if (mf != null) {
            return mf.getAbsolutePath().contains("platform") ? "lib/platform/" : "lib/features/";
        }
        File featurePath = new File(baseDir, "lib/features/");
        mf = new File(featurePath, InstallUtils.getShortName(targetFd) + ".mf");
        if (mf.exists()) {
            return "lib/features/";
        }
        mf = new File(featurePath, targetFd.getSymbolicName() + ".mf");
        return mf.exists() ? "lib/features/" : "lib/platform/";
    }

    private static List<File> determineFilesToBeDeleted(ProvisioningFeatureDefinition targetFd, Map<String, ProvisioningFeatureDefinition> features, File baseDir, String featurePath, boolean checkDependency, Set<IFixInfo> uninstallFixInfo) {
        Map<String, File> featureContents = ESAAdaptor.getUninstallFeatureContents(targetFd, features, baseDir, checkDependency);
        HashMap<String, File> uninstallFixBundleContents = FixAdaptor.getBundleFiles(baseDir, featureContents.keySet());
        ArrayList<File> filesToDelete = new ArrayList<File>();
        filesToDelete.addAll(featureContents.values());
        filesToDelete.addAll(uninstallFixBundleContents.values());
        File mf = targetFd.getFeatureDefinitionFile();
        if (mf == null && !(mf = new File(baseDir, featurePath + InstallUtils.getShortName(targetFd) + ".mf")).exists()) {
            mf = new File(baseDir, featurePath + targetFd.getSymbolicName() + ".mf");
        }
        filesToDelete.add(mf);
        InstallUtils.getAllFiles(new File(baseDir, "/lafiles/" + targetFd.getSymbolicName()), filesToDelete);
        Collection locFileList = targetFd.getLocalizationFiles();
        if (locFileList == null || locFileList.isEmpty()) {
            ArrayList<File> fileList = new ArrayList<File>();
            InstallUtils.getAllFiles(new File(baseDir, featurePath + "l10n"), fileList);
            for (File f : fileList) {
                if (!f.getName().equals(targetFd.getSymbolicName() + ".properties") && !f.getName().startsWith(targetFd.getSymbolicName() + "_")) continue;
                filesToDelete.add(f);
            }
        } else {
            filesToDelete.addAll(locFileList);
        }
        File csFile = targetFd.getFeatureChecksumFile();
        if (csFile == null) {
            csFile = new File(baseDir, featurePath + "checksums/" + targetFd.getSymbolicName() + ".cs");
        }
        filesToDelete.add(csFile);
        uninstallFixInfo.addAll(FixAdaptor.getUninstallFixInfo(baseDir, filesToDelete));
        return filesToDelete;
    }

    public static void uninstallFeature(ProvisioningFeatureDefinition targetFd, Map<String, ProvisioningFeatureDefinition> features, File baseDir, boolean checkDependency, List<File> filesRestored) throws ParserConfigurationException, IOException, SAXException {
        HashSet<IFixInfo> uninstallFixInfo = new HashSet<IFixInfo>();
        String featurePath = ESAAdaptor.getFeaturePath(targetFd, baseDir);
        List<File> filesToDelete = ESAAdaptor.determineFilesToBeDeleted(targetFd, features, baseDir, featurePath, checkDependency, uninstallFixInfo);
        for (IFixInfo fixInfo : uninstallFixInfo) {
            FixAdaptor.uninstallFix(fixInfo, baseDir, filesRestored);
        }
        FixAdaptor.removeFilesFromBackup(baseDir, filesToDelete);
        InstallUtils.delete(filesToDelete);
        InstallUtils.deleteDirectory(new File(baseDir, "/lafiles/" + targetFd.getSymbolicName()));
        InstallUtils.deleteDirectory(new File(baseDir, featurePath + "icons/" + targetFd.getSymbolicName()));
    }

    private static boolean requiredByOtherFeature(ContentBasedLocalBundleRepository br, Map<String, ProvisioningFeatureDefinition> features, File b) {
        for (ProvisioningFeatureDefinition fd : features.values()) {
            for (FeatureResource fr : fd.getConstituents(null)) {
                File bb;
                SubsystemContentType type = fr.getType();
                if (SubsystemContentType.BUNDLE_TYPE != type && SubsystemContentType.JAR_TYPE != type && SubsystemContentType.BOOT_JAR_TYPE != type || (bb = br.selectBundle(fr.getLocation(), fr.getSymbolicName(), fr.getVersionRange())) == null || !bb.exists() || !b.getAbsolutePath().equals(bb.getAbsolutePath())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean requiredByOtherFeature(Map<String, ProvisioningFeatureDefinition> features, File baseDir, File testFile) {
        for (ProvisioningFeatureDefinition fd : features.values()) {
            for (FeatureResource fr : fd.getConstituents(null)) {
                String[] locs;
                String[] stringArray;
                String locString;
                SubsystemContentType type = fr.getType();
                if (SubsystemContentType.FILE_TYPE != type || (locString = fr.getLocation()) == null) continue;
                if (locString.contains(",")) {
                    stringArray = locString.split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = locString;
                }
                for (String loc : locs = stringArray) {
                    File f = new File(loc);
                    if (!f.isAbsolute()) {
                        f = new File(baseDir, loc);
                    }
                    if (!f.getAbsolutePath().equals(testFile.getAbsolutePath())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Map<String, File> getUninstallFeatureContents(ProvisioningFeatureDefinition targetFd, Map<String, ProvisioningFeatureDefinition> features, File baseDir, boolean checkDependency) {
        HashMap<String, File> resourceMap = new HashMap<String, File>();
        BundleRepositoryRegistry.disposeAll();
        BundleRepositoryRegistry.initializeDefaults(null, (boolean)false);
        BundleRepositoryRegistry.addBundleRepository((String)baseDir.getAbsolutePath(), (String)targetFd.getBundleRepositoryType());
        BundleRepositoryRegistry.BundleRepositoryHolder brh = BundleRepositoryRegistry.getRepositoryHolder((String)targetFd.getBundleRepositoryType());
        ContentBasedLocalBundleRepository br = brh.getBundleRepository();
        Collection resources = targetFd.getConstituents(null);
        features.remove(targetFd.getSymbolicName());
        block5: for (FeatureResource fr : resources) {
            switch (fr.getType()) {
                case FEATURE_TYPE: {
                    break;
                }
                case BUNDLE_TYPE: 
                case JAR_TYPE: 
                case BOOT_JAR_TYPE: {
                    String[] locs;
                    String[] stringArray;
                    String locString = fr.getLocation();
                    if (locString == null) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = null;
                    } else if (locString.contains(",")) {
                        stringArray = locString.split(",");
                    } else {
                        String[] stringArray3 = new String[1];
                        stringArray = stringArray3;
                        stringArray3[0] = locString;
                    }
                    for (String loc : locs = stringArray) {
                        File b = br.selectBundle(loc, fr.getSymbolicName(), fr.getVersionRange());
                        if (b == null || !b.exists() || checkDependency && ESAAdaptor.requiredByOtherFeature(br, features, b)) continue;
                        resourceMap.put(fr.getSymbolicName(), b);
                    }
                    continue block5;
                }
                case FILE_TYPE: {
                    String[] stringArray;
                    String[] locs;
                    String locString = fr.getLocation();
                    if (locString == null) break;
                    if (locString.contains(",")) {
                        stringArray = locString.split(",");
                    } else {
                        String[] stringArray4 = new String[1];
                        stringArray = stringArray4;
                        stringArray4[0] = locString;
                    }
                    for (String loc : locs = stringArray) {
                        File testFile = new File(loc);
                        if (!testFile.isAbsolute()) {
                            testFile = new File(baseDir, loc);
                        }
                        if (!testFile.exists() || checkDependency && ESAAdaptor.requiredByOtherFeature(features, baseDir, testFile)) continue;
                        resourceMap.put(fr.getSymbolicName(), testFile);
                    }
                    continue block5;
                }
            }
        }
        return resourceMap;
    }

    private static boolean write(boolean tmpFile, List<File> installedFiles, File fileToWrite, String toFileEncoding, InputStream inputStream, String fromFileEncoding, InstallConstants.ExistsAction existsAction, String fileToWriteChecksum) throws IOException, InstallException {
        return ESAAdaptor.write(tmpFile, installedFiles, fileToWrite, toFileEncoding, new InstallUtils.InputStreamFileWriter(inputStream, fromFileEncoding), existsAction, fileToWriteChecksum);
    }

    private static File extractFileType(String resourceLoc, File baseDir, File featureDir, InstallConstants.ExistsAction existsAction, List<File> filesInstalled, ZipFile zip, ProvisioningFeatureDefinition fd, FeatureResource fr, Set<String> processedEntries, Properties checksumInput, Properties checksumOutput, Set<String> executableFiles, Map<String, Set<String>> extattrFiles, ChecksumsManager checksumsManager) throws IOException, InstallException {
        ZipEntry ze;
        String fileName = resourceLoc + (resourceLoc.endsWith("/") ? fr.getSymbolicName() : "");
        String entryName = "wlp/" + fileName;
        processedEntries.add(entryName);
        String checksumEntry = null;
        if (checksumInput != null && (checksumEntry = checksumInput.getProperty(entryName)) != null) {
            checksumOutput.put(fileName, checksumEntry);
            if (InstallConstants.ExistsAction.replace == existsAction) {
                checksumsManager.registerNewChecksums(featureDir, fileName, checksumEntry);
            } else if (InstallConstants.ExistsAction.ignore == existsAction) {
                checksumsManager.registerExistingChecksums(featureDir, fd.getSymbolicName(), fileName);
            }
        }
        if ((ze = zip.getEntry(entryName)) != null) {
            File fileToWrite = new File(baseDir, fileName);
            String asciiCharSet = null;
            String ebcdicCharSet = null;
            boolean replaceChecksum = false;
            if (Platform.isZOS() && EBCDIC.equalsIgnoreCase(fr.getFileEncoding())) {
                asciiCharSet = InstallPlatformUtils.getASCIISystemCharSet();
                ebcdicCharSet = InstallPlatformUtils.getEBCIDICSystemCharSet();
                replaceChecksum = true;
            }
            if (ESAAdaptor.write(false, filesInstalled, fileToWrite, ebcdicCharSet, zip.getInputStream(ze), asciiCharSet, existsAction, checksumEntry)) {
                String attr;
                if (replaceChecksum) {
                    String cs = HashUtils.getFileMD5String((File)fileToWrite);
                    checksumsManager.registerNewChecksums(featureDir, fileName, cs);
                }
                if (Boolean.parseBoolean(fr.setExecutablePermission())) {
                    executableFiles.add(fileToWrite.getAbsolutePath());
                }
                if (null != (attr = fr.getExtendedAttributes()) && !attr.equals("")) {
                    attr = attr.toLowerCase();
                    char[] charArr = attr.toCharArray();
                    Arrays.sort(charArr);
                    attr = new String(charArr);
                    Set<Object> files = extattrFiles.containsKey(attr) ? extattrFiles.get(attr) : new HashSet();
                    files.add(fileToWrite.getAbsolutePath());
                    extattrFiles.put(attr, files);
                }
            }
        } else {
            throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.missing.content", fr.getSymbolicName(), entryName), 23);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void extractBundleType(ZipEntry ze, ZipFile zip, InstallConstants.ExistsAction existsAction, Map<String, FeatureResource> constiuents, ProvisioningFeatureDefinition fd, List<File> filesInstalled, File baseDir, File featureDir, boolean checkPathInZip, Properties checksumInput, Properties checksumOutput, ChecksumsManager checksumsManager) throws IOException, InstallException {
        checksumEntry = checksumInput != null ? checksumInput.getProperty(ze.getName()) : null;
        tmp = File.createTempFile(fd.getSymbolicName(), ".jar");
        ESAAdaptor.write(true, null, tmp, zip.getInputStream(ze), InstallConstants.ExistsAction.fail, checksumEntry);
        jar = null;
        man = null;
        try {
            jar = new ZipFile(tmp);
            manEntry = jar.getEntry("META-INF/MANIFEST.MF");
            man = ManifestProcessor.parseManifest((InputStream)jar.getInputStream(manEntry));
        }
        catch (ZipException e) {
            try {
                throw ExceptionUtils.createByKey(e, "ERROR_INVALID_BUNDLE_IN_ESA", new Object[]{fd.getSymbolicName(), ze.getName()});
            }
            catch (Throwable var17_18) {
                InstallUtils.close(jar);
                throw var17_18;
            }
        }
        InstallUtils.close(jar);
        mainAttr = man.getMainAttributes();
        bundleSymbolicName = mainAttr.getValue("Bundle-SymbolicName");
        if (bundleSymbolicName == null) {
            InstallUtils.delete(tmp);
            return;
        }
        nvp = ManifestHeaderProcessor.parseBundleSymbolicName((String)bundleSymbolicName);
        symbolicName = nvp.getName();
        versionStr = mainAttr.getValue("Bundle-Version");
        version = Version.parseVersion((String)versionStr);
        fr = constiuents.get(symbolicName);
        deleteTmp = true;
        if (fr != null && (vr = fr.getVersionRange()) != null && vr.includes(version)) {
            location = fr.getLocation();
            if (location == null) {
                location = "lib/";
            } else if (location.contains(",")) {
                index = location.indexOf(44);
                location = location.substring(0, index);
            }
            if (checkPathInZip && !location.equals(pathInZip = (entryName = ze.getName()).substring(4, entryName.lastIndexOf("/") + 1))) {
                if (deleteTmp) {
                    InstallUtils.delete(tmp);
                }
                return;
            }
            if (location.endsWith(".jar")) {
                filePathInInstall = location;
                targetFile = new File(baseDir, location);
            } else {
                dir = new File(baseDir, location);
                InstallUtils.mkdirs(filesInstalled, dir);
                fileName = symbolicName + "_" + version.getMajor() + "." + version.getMinor() + "." + version.getMicro() + ".jar";
                filePathInInstall = location + fileName;
                targetFile = new File(dir, fileName);
            }
            if (!targetFile.exists()) {
                if (!tmp.renameTo(targetFile)) {
                    fis = null;
                    try {
                        fis = new FileInputStream(tmp);
                        ESAAdaptor.write(false, null, targetFile, fis, InstallConstants.ExistsAction.ignore, checksumEntry);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                } else {
                    deleteTmp = false;
                }
                if (targetFile.exists()) {
                    filesInstalled.add(targetFile);
                    constiuents.remove(symbolicName);
                    if (checksumEntry != null) {
                        checksumOutput.put(filePathInInstall, checksumEntry);
                    }
                }
            } else {
                if (existsAction == InstallConstants.ExistsAction.fail && !filesInstalled.contains(targetFile) && !InstallUtils.isFileSame(targetFile, symbolicName, version, checksumEntry)) {
                    if (deleteTmp) {
                        InstallUtils.delete(tmp);
                    }
                    throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.file.exists", new Object[]{targetFile}), 25);
                }
                if (existsAction == InstallConstants.ExistsAction.replace) {
                    fis = null;
                    try {
                        fis = new FileInputStream(tmp);
                        ESAAdaptor.write(false, null, targetFile, fis, InstallConstants.ExistsAction.replace, checksumEntry);
                        constiuents.remove(symbolicName);
                        if (checksumEntry == null) ** GOTO lbl102
                        checksumOutput.put(filePathInInstall, checksumEntry);
                        checksumsManager.registerNewChecksums(featureDir, filePathInInstall, checksumEntry);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                } else {
                    constiuents.remove(symbolicName);
                    if (checksumEntry != null) {
                        checksumOutput.put(filePathInInstall, checksumEntry);
                        checksumsManager.registerExistingChecksums(featureDir, fd.getSymbolicName(), filePathInInstall);
                    }
                }
            }
        }
lbl102:
        // 8 sources

        if (deleteTmp) {
            InstallUtils.delete(tmp);
        }
    }

    private static void isFileLocked(ProvisioningFeatureDefinition targetFd, File f) throws InstallException {
        InstallUtils.isFileLocked("ERROR_UNINSTALL_FEATURE_FILE_LOCKED", targetFd.getFeatureName(), f);
    }

    public static void preCheck(ProvisioningFeatureDefinition targetFd, Map<String, ProvisioningFeatureDefinition> features, File baseDir, boolean checkDependency) throws InstallException {
        HashSet<IFixInfo> uninstallFixInfo = new HashSet<IFixInfo>();
        String featurePath = ESAAdaptor.getFeaturePath(targetFd, baseDir);
        List<File> filesToDelete = ESAAdaptor.determineFilesToBeDeleted(targetFd, features, baseDir, featurePath, checkDependency, uninstallFixInfo);
        for (IFixInfo fixInfo : uninstallFixInfo) {
            FixAdaptor.preCheck(fixInfo, baseDir);
        }
        for (File f : filesToDelete) {
            ESAAdaptor.isFileLocked(targetFd, f);
        }
        ESAAdaptor.isFileLocked(targetFd, new File(baseDir, "/lafiles/" + targetFd.getSymbolicName()));
        ESAAdaptor.isFileLocked(targetFd, new File(baseDir, featurePath + "icons/" + targetFd.getSymbolicName()));
    }

    private static class PropertiesFileWriter
    implements InstallUtils.FileWriter {
        private final Properties properties;

        public PropertiesFileWriter(Properties properties) {
            this.properties = properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToFile(File fileToWrite) throws IOException {
            FileOutputStream fOut = null;
            try {
                fOut = new FileOutputStream(fileToWrite);
                this.properties.store(fOut, null);
            }
            catch (Throwable throwable) {
                InstallUtils.close(fOut);
                throw throwable;
            }
            InstallUtils.close(fOut);
        }

        @Override
        public void writeToFile(File fileToWrite, String charsetName) throws IOException {
            this.writeToFile(fileToWrite);
        }
    }
}

