/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.location.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.service.location.internal.InternalWsResource;
import com.ibm.ws.kernel.service.location.internal.LocalDirectoryResource;
import com.ibm.ws.kernel.service.location.internal.LocalFileResource;
import com.ibm.ws.kernel.service.location.internal.ResourceUtils;
import com.ibm.ws.kernel.service.location.internal.SymbolRegistry;
import com.ibm.ws.kernel.service.location.internal.UndeletableFile;
import com.ibm.ws.kernel.service.location.internal.VirtualRootResource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.SymbolException;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.net.URI;
import java.util.Iterator;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SymbolicRootResource
extends LocalDirectoryResource
implements InternalWsResource {
    private final File root;
    private final String symbolicName;
    private final String normalizedRoot;
    private String stringValue = null;
    private URI externalURI = null;
    private final VirtualRootResource parent;
    static final long serialVersionUID = 1911315018581065893L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SymbolicRootResource(String fileName, String symName, VirtualRootResource commonRoot) {
        if (fileName == null || symName == null) {
            throw new NullPointerException("Both a file name and a symbolic name are required to create a resource root (f=" + fileName + ",s=" + symName + ")");
        }
        File f = new File(fileName);
        if (f.exists() && f.isFile()) {
            throw new IllegalArgumentException("Resource root already exists as a file (fn=" + fileName + ")");
        }
        String nroot = PathUtils.normalize((String)f.getAbsolutePath());
        if (nroot.charAt(nroot.length() - 1) != '/') {
            nroot = nroot + "/";
        }
        this.parent = commonRoot;
        this.normalizedRoot = nroot;
        this.root = symName.startsWith("was") ? new UndeletableFile(nroot) : new File(nroot);
        this.symbolicName = "${" + symName + "}";
        boolean added = SymbolRegistry.getRegistry().addRootSymbol(symName, this);
        if (!added) {
            throw new SymbolException("Symbolic root could not be registered, variable already exists (variable=" + this.symbolicName + ",root=" + this.normalizedRoot + ")");
        }
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    @Override
    public boolean create() {
        if (!this.root.exists()) {
            return this.root.mkdirs();
        }
        return false;
    }

    public InternalWsResource createDescendantResource(String relativePath) {
        String path = PathUtils.normalizeDescendentPath((String)relativePath);
        if (path.length() == 0) {
            return this;
        }
        return LocalFileResource.newResource(this.normalizedRoot + path, this.symbolicName + '/' + path, this);
    }

    public WsResource getChild(String name) {
        return ResourceUtils.getChildResource(this, name);
    }

    public Iterator<String> getChildren() {
        if (!this.root.isDirectory()) {
            return ResourceUtils.EMPTY_STRING_LIST.iterator();
        }
        return ResourceUtils.getChildren(this, this.root);
    }

    public Iterator<String> getChildren(String regex) {
        if (!this.root.isDirectory()) {
            return ResourceUtils.EMPTY_STRING_LIST.iterator();
        }
        return ResourceUtils.getChildren(this, this.root, regex);
    }

    public WsResource resolveRelative(String relativeResourceURI) {
        if (relativeResourceURI == null) {
            return null;
        }
        if (relativeResourceURI.length() == 0) {
            return this;
        }
        if (relativeResourceURI.equals("${/}")) {
            return this.parent;
        }
        return ResourceUtils.getRelativeResource(this, relativeResourceURI);
    }

    public WsResource getParent() {
        return this.parent;
    }

    boolean contains(String normalizedPath) {
        if (normalizedPath == null) {
            return false;
        }
        if (normalizedPath.length() < this.normalizedRoot.length()) {
            return false;
        }
        return normalizedPath.regionMatches(0, this.normalizedRoot, 0, this.normalizedRoot.length());
    }

    @Override
    public boolean exists() {
        return this.root.exists();
    }

    @Override
    public SymbolicRootResource getSymbolicRoot() {
        return this;
    }

    @Override
    public String getNormalizedPath() {
        return this.normalizedRoot;
    }

    public String getName() {
        return this.root.getName() + '/';
    }

    @Override
    public String getRawRepositoryPath() {
        return this.symbolicName + '/';
    }

    public String toRepositoryPath() {
        return this.symbolicName + '/';
    }

    public URI toExternalURI() {
        URI local = this.externalURI;
        if (local == null) {
            this.externalURI = local = this.root.toURI();
        }
        return local;
    }

    @Trivial
    public File asFile() {
        return null;
    }

    public String toString() {
        String string = this.stringValue;
        if (string == null) {
            this.stringValue = string = this.getClass().getSimpleName() + "[" + this.symbolicName + "/=" + this.normalizedRoot + "]";
        }
        return string;
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + this.symbolicName.hashCode();
        result = 31 * result + this.normalizedRoot.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SymbolicRootResource)) {
            return false;
        }
        SymbolicRootResource other = (SymbolicRootResource)obj;
        if (!this.symbolicName.equals(other.symbolicName)) {
            return false;
        }
        return this.normalizedRoot.equals(other.normalizedRoot);
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SymbolicRootResource.class);
    }
}

