/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.cm;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;

public abstract class ConnectorService {
    private static final TraceComponent tc = Tr.register(ConnectorService.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.cm.internal.resources.J2CAMessages");
    private static final TraceNLS NLS = TraceNLS.getTraceNLS(ConnectorService.class, (String)"com.ibm.ws.jca.cm.internal.resources.J2CAMessages");

    public static final Object deserialize(byte[] bytes) throws Exception {
        Object o;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deserialize", (Object[])new Object[0]);
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream oin = new ObjectInputStream(bis);
            o = oin.readObject();
            oin.close();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)ConnectorService.class.getName(), (String)"151");
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deserialize", (Object)new Object[]{ConnectorService.toString(bytes), e});
            }
            throw e;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deserialize", o == null ? null : o.getClass());
        }
        return o;
    }

    public static final String getMessage(String key, Object ... args) {
        return NLS.getFormattedMessage(key, args, key);
    }

    public abstract ExecutorService getLibertyThreadPool();

    public abstract EmbeddableWebSphereTransactionManager getTransactionManager();

    public abstract VariableRegistry getVariableRegistry();

    public abstract <T extends Throwable> T ignoreWarnOrFail(TraceComponent var1, Throwable var2, Class<T> var3, String var4, Object ... var5);

    public static final void logMessage(Level level, String key, Object ... args) {
        if (WsLevel.AUDIT.equals(level)) {
            Tr.audit((TraceComponent)tc, (String)key, (Object[])args);
        } else if (WsLevel.ERROR.equals(level)) {
            Tr.error((TraceComponent)tc, (String)key, (Object[])args);
        } else if (Level.INFO.equals(level)) {
            Tr.info((TraceComponent)tc, (String)key, (Object[])args);
        } else if (Level.WARNING.equals(level)) {
            Tr.warning((TraceComponent)tc, (String)key, (Object[])args);
        } else {
            throw new UnsupportedOperationException(level.toString());
        }
    }

    private static final String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] < 0 ? 256 + bytes[i] : bytes[i];
            sb.append(Integer.toHexString(b / 16)).append(Integer.toHexString(b % 16)).append(' ');
        }
        return new String(sb);
    }
}

