/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.cm;

import com.ibm.ejs.j2c.CommonFunction;
import com.ibm.ejs.j2c.ConnectorServiceImpl;
import com.ibm.ejs.j2c.WSXAResourceImpl;
import com.ibm.tx.jta.DestroyXAResourceException;
import com.ibm.tx.jta.XAResourceFactory;
import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.adapter.WSXAResource;
import com.ibm.ws.jca.cm.ConnectionManagerService;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.jca.AuthDataService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.osgi.framework.ServiceReference;

public abstract class AbstractConnectionFactoryService
implements Observer,
ResourceFactory,
XAResourceFactory {
    private static final TraceComponent tc = Tr.register(AbstractConnectionFactoryService.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.cm.internal.resources.J2CAMessages");
    public static final String ID = "id";
    public static final String JNDI_NAME = "jndiName";
    private static final Pattern DEFAULT_NESTED_PATTERN = Pattern.compile(".*(\\[default-\\d*\\])$");
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("(default-\\d*)$");
    protected final Set<String> appsToRecycle = Collections.newSetFromMap(new ConcurrentHashMap());
    protected ConnectionManagerService conMgrSvc;
    private ServiceReference<?> containerAuthDataRef;
    protected String jaasLoginContextEntryName;
    protected final AtomicBoolean isInitialized = new AtomicBoolean();
    protected boolean isServerDefined;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private ServiceReference<?> recoveryAuthDataRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createResource(ResourceInfo resInfo) throws Exception {
        ComponentMetaData cData;
        Object connectionFactory;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createResource", (Object[])new Object[]{resInfo});
        }
        this.lock.readLock().lock();
        try {
            if (!this.isInitialized.get()) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    if (!this.isInitialized.get()) {
                        this.init();
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            this.checkAccess();
            ConnectionManager conMgr = this.conMgrSvc.getConnectionManager(resInfo, this);
            connectionFactory = this.getManagedConnectionFactory().createConnectionFactory(conMgr);
        }
        catch (Exception x) {
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createResource", (Object)x);
            }
            throw x;
        }
        catch (Error x) {
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createResource", (Object)x);
            }
            throw x;
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (this.isServerDefined && (cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData()) != null) {
            this.appsToRecycle.add(cData.getJ2EEName().getApplication());
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createResource", (Object)connectionFactory);
        }
        return connectionFactory;
    }

    public void destroyXAResource(XAResource xa) throws DestroyXAResourceException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"destroyXAResource", (Object[])new Object[]{xa});
        }
        ManagedConnection mc = ((WSXAResource)xa).getManagedConnection();
        try {
            mc.destroy();
        }
        catch (ResourceException x) {
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"destroyXAResource", (Object)((Object)x));
            }
            throw new DestroyXAResourceException((Exception)((Object)x));
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"destroyXAResource");
        }
    }

    public abstract String getConfigElementName();

    public abstract ConnectorService getConnectorService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContainerAuthDataID() {
        String authDataID = null;
        this.lock.readLock().lock();
        try {
            if (this.containerAuthDataRef != null && ((authDataID = (String)this.containerAuthDataRef.getProperty(ID)) == null || DEFAULT_PATTERN.matcher(authDataID).matches() || DEFAULT_NESTED_PATTERN.matcher(authDataID).matches())) {
                authDataID = (String)this.containerAuthDataRef.getProperty("config.displayId");
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"default container auth data", (Object[])new Object[]{authDataID});
        }
        return authDataID;
    }

    public String getJaasLoginContextEntryName() {
        return this.jaasLoginContextEntryName;
    }

    public abstract String getID();

    public abstract String getJNDIName();

    public abstract ManagedConnectionFactory getManagedConnectionFactory();

    public abstract boolean getReauthenticationSupport();

    private final Subject getSubjectForRecovery(ManagedConnectionFactory mcf, Serializable xaresinfo) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getSubjectForRecovery", (Object[])new Object[]{this.recoveryAuthDataRef});
        }
        String authDataID = null;
        if (this.recoveryAuthDataRef != null && ((authDataID = (String)this.recoveryAuthDataRef.getProperty(ID)) == null || DEFAULT_PATTERN.matcher(authDataID).matches() || DEFAULT_NESTED_PATTERN.matcher(authDataID).matches())) {
            authDataID = (String)this.recoveryAuthDataRef.getProperty("config.displayId");
        }
        if (authDataID == null && xaresinfo != null) {
            ArrayList byteList = (ArrayList)xaresinfo;
            byte[] bytes = new byte[byteList.size()];
            int i = 0;
            for (Byte b : byteList) {
                bytes[i++] = b;
            }
            ResourceInfo info = (ResourceInfo)ConnectorService.deserialize(bytes);
            if (info.getAuth() == 0) {
                for (ResourceInfo.Property loginConfigProp : info.getLoginPropertyList()) {
                    if (!"DefaultPrincipalMapping".equals(loginConfigProp.getName())) continue;
                    authDataID = loginConfigProp.getValue();
                }
                if (authDataID == null) {
                    authDataID = this.getContainerAuthDataID();
                }
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"container managed auth", (Object[])new Object[]{authDataID});
            }
        }
        Subject subject = null;
        if (authDataID != null) {
            AuthDataService authDataSvc = (AuthDataService)((ConnectorServiceImpl)this.getConnectorService()).authDataServiceRef.getServiceWithException();
            Map<String, String> loginData = Collections.singletonMap("com.ibm.mapping.authDataAlias", authDataID);
            subject = authDataSvc.getSubject(mcf, null, loginData);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getSubjectForRecovery", (Object)CommonFunction.toString(subject));
        }
        return subject;
    }

    public abstract TransactionSupport.TransactionSupportLevel getTransactionSupport();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource getXAResource(Serializable xaresinfo) throws XAResourceNotAvailableException {
        XAResource xa;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getXAResource", (Object[])new Object[]{this.getID(), xaresinfo});
        }
        ManagedConnection mc = null;
        this.lock.readLock().lock();
        try {
            Subject subject;
            ManagedConnectionFactory mcf;
            if (!this.isInitialized.get()) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized.get()) {
                        this.init();
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            xa = (xa = (mc = (mcf = this.getManagedConnectionFactory()).createManagedConnection(subject = this.getSubjectForRecovery(mcf, xaresinfo), null)).getXAResource()) instanceof WSXAResource ? xa : new WSXAResourceImpl(mc, xa);
        }
        catch (Throwable x) {
            if (mc != null) {
                try {
                    mc.destroy();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"328", (Object)this, (Object[])new Object[]{xaresinfo});
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getXAResource", (Object)x);
            }
            if (x instanceof Error) {
                throw (Error)x;
            }
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new XAResourceNotAvailableException(x);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getXAResource", (Object)xa);
        }
        return xa;
    }

    protected abstract void init() throws Exception;

    protected abstract void checkAccess() throws ResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContainerAuthData(ServiceReference<?> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setContainerAuthData", (Object[])new Object[]{ref});
        }
        this.lock.writeLock().lock();
        try {
            this.containerAuthDataRef = ref;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRecoveryAuthData(ServiceReference<?> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setRecoveryAuthData", (Object[])new Object[]{ref});
        }
        this.lock.writeLock().lock();
        try {
            this.recoveryAuthDataRef = ref;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetContainerAuthData(ServiceReference<?> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"unsetContainerAuthData", (Object[])new Object[]{ref});
        }
        this.lock.writeLock().lock();
        try {
            if (this.containerAuthDataRef == ref) {
                this.containerAuthDataRef = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetRecoveryAuthData(ServiceReference<?> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"unsetRecoveryAuthData", (Object[])new Object[]{ref});
        }
        this.lock.writeLock().lock();
        try {
            if (this.recoveryAuthDataRef == ref) {
                this.recoveryAuthDataRef = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

