/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;

public final class StuckTaskTimer
extends Thread {
    private long m_interval;
    private boolean m_exiled = false;
    private PoolManager _pm;
    private int collectorStuckCount = 0;
    private final Object stuckLockObject = new Object(){};
    private static final TraceComponent tc = Tr.register(StuckTaskTimer.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");

    protected StuckTaskTimer(long interval, PoolManager pm) {
        this.m_interval = interval * 1000L;
        this._pm = pm;
        final StuckTaskTimer finalThis = this;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                finalThis.setDaemon(true);
                return null;
            }
        });
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStuckTask() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeStuckTask", (Object[])new Object[0]);
        }
        ++this.collectorStuckCount;
        if (this.collectorStuckCount > 1) {
            --this.collectorStuckCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeStuckTask");
            }
            return;
        }
        this._pm.mcToMCWMapWrite.lock();
        try {
            Iterator<com.ibm.ws.j2c.MCWrapper> mcwIt = this._pm.mcToMCWMap.values().iterator();
            long currentTime = System.currentTimeMillis();
            int number_stuck = 0;
            while (mcwIt.hasNext()) {
                long diff;
                MCWrapper mcw = (MCWrapper)mcwIt.next();
                long stuckStartTime = mcw.getStuckTimeStart();
                if (stuckStartTime <= 0L || (diff = currentTime - stuckStartTime) <= (long)(this._pm.gConfigProps.getStuckTime() * 1000)) continue;
                ++number_stuck;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                mcw.amountOfStuckTime = (int)diff / 1000;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("This managed connection " + mcw + " is stuck for " + mcw.amountOfStuckTime + " seconds"), (Object[])new Object[0]);
            }
            this._pm.stuckConnections = this._pm.gConfigProps.getStuckThreshold() <= number_stuck;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Stuck mode is " + this._pm.stuckConnections + " with " + number_stuck + " connection stuck"), (Object[])new Object[0]);
            }
        }
        finally {
            this._pm.mcToMCWMapWrite.unlock();
        }
        --this.collectorStuckCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeStuckTask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getInterval() {
        Object object = this.stuckLockObject;
        synchronized (object) {
            return this.m_interval / 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.m_exiled) {
                Object object = this.stuckLockObject;
                synchronized (object) {
                    this.stuckLockObject.wait(this.m_interval);
                    if (!this.m_exiled) {
                        this.executeStuckTask();
                    }
                }
            }
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.poolmanager.StuckTaskTimer.run", (String)"112", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INTERUPTED_EXCEPTION_J2CA0091", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"TaskTimer exiting run()", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInterval(long interval) {
        Object object = this.stuckLockObject;
        synchronized (object) {
            this.m_interval = interval * 1000L;
        }
    }

    protected void exile() {
        this.m_exiled = true;
    }

    public final synchronized boolean isM_exiled() {
        return this.m_exiled;
    }
}

