/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.J2CGlobalConfigProperties;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import javax.resource.spi.ManagedConnection;

public final class MCWrapperPool {
    private static final TraceComponent tc = Tr.register(MCWrapperPool.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    private PoolManager pm;
    private final int initialSize;
    private final ArrayList<com.ibm.ws.j2c.MCWrapper> pool;
    private final J2CGlobalConfigProperties gConfigProps;
    private final ClassLoader raClassLoader;

    public MCWrapperPool(int newInitialSize, PoolManager newPm, J2CGlobalConfigProperties gcProps, ClassLoader raClassLoader) {
        this.initialSize = newInitialSize;
        this.pm = newPm;
        this.gConfigProps = gcProps;
        this.pool = this.initialSize > 500 ? new ArrayList(500) : (this.initialSize > 0 ? new ArrayList(this.initialSize) : new ArrayList(50));
        this.raClassLoader = raClassLoader;
    }

    public ClassLoader getRaClassLoader() {
        return this.raClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized com.ibm.ws.j2c.MCWrapper getInstance(ManagedConnection mc) {
        int poolSize;
        if (this.pm == null) {
            throw new IllegalStateException("MCWrapper pool is not intialized");
        }
        com.ibm.ws.j2c.MCWrapper mcw = null;
        ArrayList<com.ibm.ws.j2c.MCWrapper> arrayList = this.pool;
        synchronized (arrayList) {
            poolSize = this.pool.size();
            if (poolSize > 0) {
                mcw = this.pool.remove(poolSize - 1);
            }
        }
        if (mcw == null) {
            if (this.initialSize == 0 || poolSize < this.initialSize) {
                mcw = new MCWrapper(this.pm, this.gConfigProps);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"MCWrapper pool was asked to grow beyond its capacity", (Object[])new Object[0]);
                }
                throw new IllegalStateException("MCWrapperPool asked to grow beyond its capacity");
            }
        }
        if (mc != null) {
            try {
                mcw.setManagedConnection(mc);
            }
            catch (NullPointerException npe) {
                FFDCFilter.processException((Throwable)npe, (String)"com.ibm.ejs.j2c.MCWrapperPool.getInstance", (String)"207", (Object)this);
                Tr.error((TraceComponent)tc, (String)"MCWRAPPER_GETINSTANCE_ERROR_J2CA0096", (Object[])new Object[]{npe});
                throw new IllegalStateException("Cannot setManagedConnection on null wrapper");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Managed connection is not created or null", (Object[])new Object[0]);
        }
        return mcw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInstance(com.ibm.ws.j2c.MCWrapper mcw) throws IllegalStateException {
        int poolSize;
        if (this.pm == null) {
            throw new IllegalStateException("MCWrapper pool is not intialized");
        }
        String stateString = mcw.getStateString();
        if (stateString.equals("STATE_ACTIVE_FREE") || stateString.equals("STATE_INACTIVE")) {
            ArrayList<com.ibm.ws.j2c.MCWrapper> arrayList;
            if (((MCWrapper)mcw).do_not_reuse_mcw) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Releasing mcw and not reusing " + mcw + " from pool manager" + this.pm.hashCode()), (Object[])new Object[0]);
                }
                arrayList = this.pool;
                synchronized (arrayList) {
                    poolSize = this.pool.size();
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Adding mcw to reuse pool " + mcw + " in mcw pool from pool manager" + this.pm.hashCode()), (Object[])new Object[0]);
                }
                if (stateString.equals("STATE_ACTIVE_FREE")) {
                    mcw.setStateInActive();
                }
                arrayList = this.pool;
                synchronized (arrayList) {
                    this.pool.add(mcw);
                    poolSize = this.pool.size();
                }
            }
        } else {
            IllegalStateException e = new IllegalStateException("releaseInstance: illegal state exception. State = " + stateString);
            Tr.error((TraceComponent)tc, (String)"ILLEGAL_STATE_EXCEPTION_J2CA0079", (Object[])new Object[]{"releaseInstance", e});
            throw e;
        }
        if (this.initialSize != 0 && poolSize > this.initialSize && tc.isDebugEnabled()) {
            StringBuffer tempString = new StringBuffer();
            tempString.append("This pool was created with ");
            tempString.append(this.initialSize);
            tempString.append("but size now is ");
            tempString.append(poolSize);
            Tr.debug((Object)this, (TraceComponent)tc, (String)tempString.toString(), (Object[])new Object[0]);
        }
    }

    public void clearMCWrapperPool() {
        for (int i = this.pool.size(); i > 0; --i) {
            com.ibm.ws.j2c.MCWrapper mcw = this.pool.remove(i - 1);
            mcw.clearMCWrapper();
        }
        this.pm = null;
    }

    protected synchronized void clearPool() {
        if (this.pool.isEmpty()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"clearPool", (Object[])new Object[]{this.pool.size()});
        }
        this.pool.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"clearPool", (Object)this.pool.size());
        }
    }

    public String toString() {
        StringBuffer tempString = new StringBuffer();
        tempString.append("(");
        tempString.append(this.pm);
        tempString.append(" )");
        return tempString.toString();
    }
}

