/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.j2c.CommonXAResourceInfo;
import com.ibm.ejs.j2c.ConnectorProperties;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public abstract class CommonXAResourceInfoImpl
implements CommonXAResourceInfo {
    private static final long serialVersionUID = 6061555722882338966L;
    private static final String NL = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });

    CommonXAResourceInfoImpl() {
    }

    abstract String getBaseCFName();

    public String getRMName() {
        return this.getCfName();
    }

    public boolean commitInLastPhase() {
        return false;
    }

    public String toString() {
        StringBuilder rval = new StringBuilder(1024);
        rval.append(this.getClass().getSimpleName()).append(" : ");
        rval.append(NL);
        rval.append("cfName = ");
        rval.append(this.getCfName());
        rval.append(NL);
        rval.append("configProps = ");
        rval.append(this.getConfigProps());
        rval.append(NL);
        rval.append("dd = ");
        rval.append(this.getDd());
        rval.append(NL);
        rval.append("dsProps = ");
        rval.append(this.getDsProps());
        rval.append(NL);
        rval.append("mcfProps = ");
        rval.append(this.getMcfProps());
        rval.append(NL);
        rval.append("mmProps = ");
        rval.append(this.getMmProps());
        rval.append(NL);
        rval.append("mbeanProps = ");
        rval.append(this.getMbeanProps());
        rval.append(NL);
        rval.append("cmConfig = ");
        rval.append(this.getCmConfig());
        rval.append(NL);
        rval.append("recoveryClasspath = ");
        rval.append(this.getRecoveryClasspath());
        rval.append(NL);
        rval.append("raKey = ");
        rval.append(this.getRAKey());
        rval.append(NL);
        return rval.toString();
    }

    private static final boolean match(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 117;
    }

    public boolean equals(Object o) {
        boolean rVal = false;
        try {
            CMConfigData compCmConfig;
            CommonXAResourceInfoImpl comp = (CommonXAResourceInfoImpl)o;
            if (comp != null && CommonXAResourceInfoImpl.match(comp.getBaseCFName(), this.getBaseCFName()) && CommonXAResourceInfoImpl.match(comp.getDsProps(), this.getDsProps()) && CommonXAResourceInfoImpl.match(comp.getMcfProps(), this.getMcfProps()) && (compCmConfig = comp.getCmConfig()) != null && this.getCmConfig() != null) {
                String compXARecoveryAlias = comp.getConfigProps().findConnectorPropertyString("XA_RECOVERY_AUTH_ALIAS", null);
                String xaRecoveryAlias = this.getConfigProps().findConnectorPropertyString("XA_RECOVERY_AUTH_ALIAS", null);
                if (compXARecoveryAlias == null && xaRecoveryAlias == null) {
                    int auth;
                    int compareAuth = compCmConfig.getAuth();
                    if (compareAuth == (auth = this.getCmConfig().getAuth())) {
                        if (auth == 0) {
                            rVal = this.compareContainerAliases(comp.getMmProps());
                        } else if (auth == 1) {
                            rVal = this.compareComponentAliases(comp.getConfigProps());
                        }
                    }
                } else if (CommonXAResourceInfoImpl.match(compXARecoveryAlias, xaRecoveryAlias)) {
                    rVal = true;
                }
            }
        }
        catch (ClassCastException e) {
            rVal = false;
        }
        return rVal;
    }

    private boolean compareContainerAliases(Properties compareMmProps) {
        String containerAlias;
        String compContainerAlias;
        String mapConfig;
        boolean rVal = false;
        String compMapConfig = compareMmProps.getProperty("mappingConfigAlias");
        if (CommonXAResourceInfoImpl.match(compMapConfig, mapConfig = this.getMmProps().getProperty("mappingConfigAlias")) && CommonXAResourceInfoImpl.match(compContainerAlias = compareMmProps.getProperty("authDataAlias"), containerAlias = this.getMmProps().getProperty("authDataAlias"))) {
            rVal = true;
        }
        return rVal;
    }

    private boolean compareComponentAliases(ConnectorProperties compareConfigProps) {
        String componentAlias;
        String compComponentAlias;
        boolean rVal = false;
        if (compareConfigProps != null && this.getConfigProps() != null && ((compComponentAlias = compareConfigProps.findConnectorPropertyString("OptionC_authDataAlias", null)) == (componentAlias = this.getConfigProps().findConnectorPropertyString("OptionC_authDataAlias", null)) || compComponentAlias != null && compComponentAlias.equals(componentAlias))) {
            rVal = true;
        }
        return rVal;
    }

    public String getProviderId() {
        return this.getRAKey();
    }

    public boolean recoverWhenServerStarted() {
        return this.getRaWrapper() != null && this.getRaWrapper().isEmbedded();
    }

    public boolean isEmbedded() {
        return this.getRaWrapper().isEmbedded();
    }
}

