/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jndi.WSName;
import com.ibm.ws.jndi.internal.ContextNode;
import com.ibm.ws.jndi.internal.WSContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JNDIServiceBinder
implements AllServiceListener {
    private static final TraceComponent tc = Tr.register(JNDIServiceBinder.class);
    static final String OSGI_JNDI_SERVICE_NAME = "osgi.jndi.service.name";
    static final String OSGI_JNDI_SERVICE_ORIGIN = "osgi.jndi.service.origin";
    static final String OSGI_JNDI_SERVICE_ORIGIN_VALUE = "jndi";
    static final String OSGI_JNDI_SERVICE_CLASS = "osgi.jndi.service.class";
    static final String OSGI_JNDI_SERVICE_FILTER = "(&(osgi.jndi.service.name=*)(!(osgi.jndi.service.origin=jndi)))";
    final ContextNode root = new ContextNode();
    private final ConcurrentMap<ServiceReference<?>, WSName> serviceNames = new ConcurrentHashMap();
    static final long serialVersionUID = -494731019423359754L;

    static Hashtable<String, Object> createServiceProperties(WSName wsName, String className) {
        Hashtable<String, Object> localEnv = new Hashtable<String, Object>();
        localEnv.put(OSGI_JNDI_SERVICE_NAME, wsName.toString());
        localEnv.put(OSGI_JNDI_SERVICE_ORIGIN, OSGI_JNDI_SERVICE_ORIGIN_VALUE);
        if (className != null) {
            localEnv.put(OSGI_JNDI_SERVICE_CLASS, OSGI_JNDI_SERVICE_CLASS);
        }
        return localEnv;
    }

    protected void activate(BundleContext bundleContext) {
        try {
            bundleContext.addServiceListener((ServiceListener)this, OSGI_JNDI_SERVICE_FILTER);
            ServiceReference[] refs = bundleContext.getAllServiceReferences(null, OSGI_JNDI_SERVICE_FILTER);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    this.recordEntry(ref);
                }
            }
        }
        catch (InvalidSyntaxException refs) {
            FFDCFilter.processException((Throwable)refs, (String)"com.ibm.ws.jndi.internal.JNDIServiceBinder", (String)"70", (Object)this, (Object[])new Object[]{bundleContext});
        }
    }

    protected void deactivate(BundleContext bundleContext) {
        WSContext.scrubContents(this.root);
        bundleContext.removeServiceListener((ServiceListener)this);
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        switch (event.getType()) {
            case 1: {
                this.recordEntry(ref);
                break;
            }
            case 2: {
                this.moveEntry(ref);
                break;
            }
            case 4: 
            case 8: {
                this.removeEntry(ref);
                break;
            }
        }
    }

    @FFDCIgnore(value={ClassCastException.class, NamingException.class})
    private void recordEntry(ServiceReference<?> ref) {
        block5: {
            Object val = ref.getProperty(OSGI_JNDI_SERVICE_NAME);
            try {
                String name = (String)val;
                WSName wsname = new WSName(name);
                this.root.autoBind(wsname, ref);
                WSName existingName = this.serviceNames.putIfAbsent(ref, wsname);
                if (existingName != null) {
                    throw new NameAlreadyBoundException(name);
                }
            }
            catch (ClassCastException e) {
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"jndi.osgi.bind.failed", (Object[])new Object[]{val, e});
                }
            }
            catch (NamingException e) {
                if (!tc.isWarningEnabled()) break block5;
                Tr.warning((TraceComponent)tc, (String)"jndi.osgi.bind.failed", (Object[])new Object[]{val, e});
            }
        }
    }

    @FFDCIgnore(value={ClassCastException.class, NamingException.class})
    private void moveEntry(ServiceReference<?> ref) {
        block5: {
            Object val = ref.getProperty(OSGI_JNDI_SERVICE_NAME);
            try {
                WSName name = new WSName((String)val);
                WSName oldName = this.serviceNames.put(ref, name);
                if (oldName != null) {
                    this.root.ensureNotBound(oldName, ref);
                }
                this.root.autoBind(name, ref);
            }
            catch (ClassCastException e) {
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"jndi.osgi.bind.failed", (Object[])new Object[]{val, e});
                }
            }
            catch (NamingException e) {
                if (!tc.isWarningEnabled()) break block5;
                Tr.warning((TraceComponent)tc, (String)"jndi.osgi.bind.failed", (Object[])new Object[]{val, e});
            }
        }
    }

    private void removeEntry(ServiceReference<?> ref) {
        WSName name = (WSName)this.serviceNames.remove(ref);
        if (name != null) {
            this.root.ensureNotBound(name, ref);
        }
    }
}

