/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.library.Library;
import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.jndi.objectFactory"}, service={JNDIObjectFactory.class})
public class JNDIObjectFactory {
    private static final TraceComponent tc = Tr.register(JNDIObjectFactory.class);
    private static final String REFERENCE_LIBRARY = "library";
    private final AtomicServiceReference<Library> libraryRef = new AtomicServiceReference("library");
    private String className;
    private String objectClassName;
    private ServiceRegistration<?> registration;
    static final long serialVersionUID = -7509336781859611443L;

    public String toString() {
        return super.toString() + "[className=" + this.className + ", objectClassName=" + this.objectClassName + ", libraryRef=" + this.libraryRef + ']';
    }

    @Reference(name="library", service=Library.class)
    protected void setLibrary(ServiceReference<Library> ref) {
        this.libraryRef.setReference(ref);
    }

    protected void unsetLibrary(ServiceReference<Library> ref) {
        this.libraryRef.unsetReference(ref);
    }

    protected void activate(ComponentContext context, Map<String, Object> props) {
        this.libraryRef.activate(context);
        this.className = (String)props.get("className");
        this.objectClassName = (String)props.get("objectClassName");
        Hashtable<String, Boolean> properties = new Hashtable<String, Boolean>();
        ((Dictionary)properties).put("aries.object.factory.requires.reference", true);
        ObjectFactoryServiceFactoryImpl service = new ObjectFactoryServiceFactoryImpl((Library)this.libraryRef.getServiceWithException(), this.className);
        String[] classes = new String[]{ObjectFactory.class.getName(), this.className};
        this.registration = context.getBundleContext().registerService(classes, (Object)service, properties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("registration=" + this.registration), (Object[])new Object[0]);
        }
    }

    protected void deactivate(ComponentContext context) {
        this.libraryRef.deactivate(context);
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    @Trivial
    public String getClassName() {
        return this.className;
    }

    @Trivial
    public String getObjectClassName() {
        return this.objectClassName;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class ObjectFactoryServiceFactoryImpl
    implements ServiceFactory<ObjectFactory> {
        private final Library library;
        private final String className;
        private ObjectFactory factory;
        static final long serialVersionUID = 4748144731613281985L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        ObjectFactoryServiceFactoryImpl(Library library, String className) {
            this.library = library;
            this.className = className;
        }

        /*
         * WARNING - void declaration
         */
        public synchronized ObjectFactory getService(Bundle bundle, ServiceRegistration<ObjectFactory> registration) {
            if (this.factory == null) {
                try {
                    Class<ObjectFactory> klass = this.library.getClassLoader().loadClass(this.className).asSubclass(ObjectFactory.class);
                    this.factory = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception klass) {
                    void e;
                    FFDCFilter.processException((Throwable)klass, (String)"com.ibm.ws.jndi.internal.JNDIObjectFactory$ObjectFactoryServiceFactoryImpl", (String)"123", (Object)this, (Object[])new Object[]{bundle, registration});
                    void cause = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getCause() : e;
                    Tr.error((TraceComponent)tc, (String)"jndi.objectfactory.create.exception", (Object[])new Object[]{this.className, cause});
                }
            }
            return this.factory;
        }

        public void ungetService(Bundle bundle, ServiceRegistration<ObjectFactory> registration, ObjectFactory service) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ObjectFactoryServiceFactoryImpl.class);
        }
    }
}

