/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.metadata.extended.ModuleMetaDataExtender;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.java2sec.PermissionManager;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class DeployedAppInfoFactoryBase
implements DeployedAppInfoFactory {
    static final String SERVER_APPS_DIR = "${server.config.dir}/apps/";
    protected static final String EXPANDED_APPS_DIR = "${server.config.dir}/apps/expanded/";
    protected static final String XML_SUFFIX = ".xml";
    private BundleContext bundleContext;
    private ApplicationInfoFactory applicationInfoFactory;
    private FutureMonitor futureMonitor;
    private ClassLoadingService classLoadingService;
    private Library globalSharedLibrary;
    private String globalSharedLibraryPid;
    private ConfigurationAdmin configAdmin;
    private MetaDataService metaDataService;
    private StateChangeService stateChangeService;
    private final Map<String, ModuleMetaDataExtender> moduleMetaDataExtenders = new ConcurrentHashMap<String, ModuleMetaDataExtender>();
    private PermissionManager permissionManager;
    private WsLocationAdmin locAdmin;
    private ArtifactContainerFactory artifactFactory;
    private AdaptableModuleFactory moduleFactory;
    static final long serialVersionUID = 6858366976618874669L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public ApplicationInfoFactory getApplicationInfoFactory() {
        return this.applicationInfoFactory;
    }

    public FutureMonitor getFutureMonitor() {
        return this.futureMonitor;
    }

    public ClassLoadingService getClassLoadingService() {
        return this.classLoadingService;
    }

    public Library getGlobalSharedLibrary() {
        return this.globalSharedLibrary;
    }

    public String getGlobalSharedLibraryPid() {
        return this.globalSharedLibraryPid;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configAdmin;
    }

    public MetaDataService getMetaDataService() {
        return this.metaDataService;
    }

    public StateChangeService getStateChangeService() {
        return this.stateChangeService;
    }

    public Map<String, ModuleMetaDataExtender> getModuleMetaDataExtenders() {
        return this.moduleMetaDataExtenders;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public WsLocationAdmin getLocationAdmin() {
        return this.locAdmin;
    }

    public ArtifactContainerFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public AdaptableModuleFactory getModuleFactory() {
        return this.moduleFactory;
    }

    protected Container setupContainer(String pid, File locationFile) {
        if (!FileUtils.fileExists((File)locationFile)) {
            return null;
        }
        File cacheDir = new File(this.getCacheDir(), pid);
        if (!FileUtils.ensureDirExists((File)cacheDir)) {
            return null;
        }
        ArtifactContainer artifactContainer = this.getArtifactFactory().getContainer(cacheDir, (Object)locationFile);
        if (artifactContainer == null) {
            return null;
        }
        File cacheDirAdapt = new File(this.getCacheAdaptDir(), pid);
        if (!FileUtils.ensureDirExists((File)cacheDirAdapt)) {
            return null;
        }
        File cacheDirOverlay = new File(this.getCacheOverlayDir(), pid);
        if (!FileUtils.ensureDirExists((File)cacheDirOverlay)) {
            return null;
        }
        return this.getModuleFactory().getContainer(cacheDirAdapt, cacheDirOverlay, artifactContainer);
    }

    private File getCacheAdaptDir() {
        return this.getLocationAdmin().getBundleFile((Object)this, "cacheAdapt");
    }

    private File getCacheOverlayDir() {
        return this.getLocationAdmin().getBundleFile((Object)this, "cacheOverlay");
    }

    private File getCacheDir() {
        return this.getLocationAdmin().getBundleFile((Object)this, "cache");
    }

    @Reference
    protected void setApplicationInfoFactory(ApplicationInfoFactory applicationInfoFactory) {
        this.applicationInfoFactory = applicationInfoFactory;
    }

    protected void unsetApplicationInfoFactory(ApplicationInfoFactory applicationInfoFactory) {
    }

    @Reference
    protected void setFutureMonitor(FutureMonitor futureMonitor) {
        this.futureMonitor = futureMonitor;
    }

    protected void unsetFutureMonitor(FutureMonitor futureMonitor) {
    }

    @Reference
    protected void setClassLoadingService(ClassLoadingService service) {
        this.classLoadingService = service;
    }

    protected void unsetClassLoadingService(ClassLoadingService service) {
        this.classLoadingService = null;
    }

    @Reference(target="(id=global)")
    protected void setGlobalSharedLibrary(Library library, Map<String, ?> serviceProps) {
        this.globalSharedLibrary = library;
        this.globalSharedLibraryPid = (String)serviceProps.get("service.pid");
    }

    protected void unsetGlobalSharedLibrary(Library library) {
        this.globalSharedLibrary = null;
    }

    @Reference
    protected void setConfigAdmin(ConfigurationAdmin admin) {
        this.configAdmin = admin;
    }

    protected void unsetConfigAdmin(ConfigurationAdmin admin) {
        this.configAdmin = null;
    }

    @Reference
    protected void setMetaDataService(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    protected void unsetMetaDataService(MetaDataService metaDataService) {
    }

    @Reference
    protected void setStateChangeService(StateChangeService stateChangeService) {
        this.stateChangeService = stateChangeService;
    }

    protected void unsetStateChangeService(StateChangeService stateChangeService) {
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setModuleMetaDataExtender(ModuleMetaDataExtender moduleMetaDataExtender, Map<String, ?> serviceProps) {
        Object o = serviceProps.get("type");
        if (o != null) {
            if (o instanceof String) {
                String moduleType = (String)o;
                this.moduleMetaDataExtenders.put(moduleType, moduleMetaDataExtender);
            } else if (o instanceof String[]) {
                for (String moduleType : (String[])o) {
                    this.moduleMetaDataExtenders.put(moduleType, moduleMetaDataExtender);
                }
            }
        }
    }

    protected void unsetModuleMetaDataExtender(ModuleMetaDataExtender moduleMetaDataExtender, Map<String, ?> serviceProps) {
        Object o = serviceProps.get("type");
        if (o != null) {
            if (o instanceof String) {
                String moduleType = (String)o;
                this.moduleMetaDataExtenders.remove(moduleType);
            } else if (o instanceof String[]) {
                for (String moduleType : (String[])o) {
                    this.moduleMetaDataExtenders.remove(moduleType);
                }
            }
        }
    }

    @Reference(service=PermissionManager.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    protected void unsetPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = null;
    }

    @Reference
    protected void setLocationAdmin(WsLocationAdmin locAdmin) {
        this.locAdmin = locAdmin;
    }

    protected void unsetLocationAdmin(WsLocationAdmin locAdmin) {
        this.locAdmin = null;
    }

    @Reference
    protected void setArtifactFactory(ArtifactContainerFactory factory) {
        this.artifactFactory = factory;
    }

    protected void unsetArtifactFactory(ArtifactContainerFactory factory) {
        this.artifactFactory = null;
    }

    @Reference
    protected void setModuleFactory(AdaptableModuleFactory factory) {
        this.moduleFactory = factory;
    }

    protected void unsetModuleFactory(AdaptableModuleFactory factory) {
        this.moduleFactory = null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DeployedAppInfoFactoryBase.class);
    }
}

