/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.module.ApplicationNestedConfigHelper;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.internal.ClientModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ConnectorModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ContextRootUtil;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoFactoryBase;
import com.ibm.ws.app.manager.module.internal.DeployedModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.EJBModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.ModuleInfoUtils;
import com.ibm.ws.app.manager.module.internal.WebModuleInfoImpl;
import com.ibm.ws.classloading.ClassLoaderConfigHelper;
import com.ibm.ws.classloading.ClassLoadingButler;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.extended.AltDDEntryGetter;
import com.ibm.ws.container.service.app.deploy.extended.AppClassLoaderFactory;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.LibraryClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.LibraryContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleContainerInfo;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.metadata.extended.ModuleMetaDataExtender;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.ws.javaee.dd.common.ModuleDeploymentDescriptor;
import com.ibm.ws.javaee.dd.connector.Connector;
import com.ibm.ws.javaee.dd.ejb.EJBJar;
import com.ibm.ws.javaee.dd.permissions.PermissionsConfig;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.security.java2sec.PermissionManager;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class DeployedAppInfoBase
implements DeployedAppInfo,
ApplicationClassesContainerInfo,
AppClassLoaderFactory,
ModuleClassLoaderFactory {
    private static final TraceComponent _tc = Tr.register(DeployedAppInfoBase.class, (String)"app.manager", (String)"com.ibm.ws.app.manager.module.internal.resources.Messages");
    private static final String PERMISSION_XML = "permissions.xml";
    protected final ApplicationInformation<?> applicationInformation;
    public final String location;
    private ExtendedApplicationInfo appInfo;
    public final List<DeployedModuleInfoImpl> modulesDeployed = new ArrayList<DeployedModuleInfoImpl>();
    public boolean starting;
    public boolean started;
    protected final ApplicationInfoFactory appInfoFactory;
    protected final ClassLoadingService classLoadingService;
    protected final Library globalSharedLibrary;
    protected final SharedLibDeploymentInfo sharedLibDeploymentInfo;
    private final FutureMonitor futureMonitor;
    private final MetaDataService metaDataService;
    private final StateChangeService stateChangeService;
    private final ConfigurationAdmin configAdmin;
    private final ClassLoaderConfigHelper libraryConfigHelper;
    protected final boolean isDelegateLast;
    protected final ModuleClassesInfoProvider moduleClassesInfo;
    protected final Map<String, ModuleMetaDataExtender> moduleMetaDataExtenders;
    private final PermissionManager permissionManager;
    private final PermissionsConfig permissionsConfig;
    protected final List<ModuleContainerInfoBase> moduleContainerInfos = new ArrayList<ModuleContainerInfoBase>();
    static final long serialVersionUID = 4729155168217673314L;

    /*
     * WARNING - void declaration
     */
    protected DeployedAppInfoBase(ApplicationInformation<?> applicationInformation, DeployedAppInfoFactoryBase factory) throws UnableToAdaptException {
        this.applicationInformation = applicationInformation;
        this.location = applicationInformation.getLocation();
        this.starting = false;
        this.started = false;
        this.appInfoFactory = factory.getApplicationInfoFactory();
        this.classLoadingService = factory.getClassLoadingService();
        this.globalSharedLibrary = factory.getGlobalSharedLibrary();
        this.futureMonitor = factory.getFutureMonitor();
        this.metaDataService = factory.getMetaDataService();
        this.stateChangeService = factory.getStateChangeService();
        this.configAdmin = factory.getConfigurationAdmin();
        this.libraryConfigHelper = new ClassLoaderConfigHelper(this.getConfigHelper(), this.configAdmin);
        this.isDelegateLast = this.libraryConfigHelper.isDelegateLast();
        this.moduleClassesInfo = new ModuleClassesInfoProvider();
        this.moduleMetaDataExtenders = factory.getModuleMetaDataExtenders();
        this.permissionManager = factory.getPermissionManager();
        try {
            this.permissionsConfig = (PermissionsConfig)this.getContainer().adapt(PermissionsConfig.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"709", (Object)this, (Object[])new Object[]{applicationInformation, factory});
            Tr.error((TraceComponent)_tc, (String)"error.application.parse.descriptor", (Object[])new Object[]{this.getName(), "META-INF/permissions.xml", e});
            throw e;
        }
        String parentPid = (String)applicationInformation.getConfigProperty("service.pid");
        String sourcePid = (String)applicationInformation.getConfigProperty("ibm.extends.source.pid");
        if (sourcePid != null) {
            parentPid = sourcePid;
        }
        this.sharedLibDeploymentInfo = new SharedLibDeploymentInfo(factory, parentPid);
    }

    @Trivial
    public String getName() {
        return this.applicationInformation.getName();
    }

    @Trivial
    public Container getContainer() {
        return this.applicationInformation.getContainer();
    }

    @Trivial
    public NestedConfigHelper getConfigHelper() {
        return new ApplicationNestedConfigHelper(this.applicationInformation);
    }

    protected abstract ExtendedApplicationInfo createApplicationInfo();

    public List<ContainerInfo> getLibraryClassesContainerInfo() {
        if (this.sharedLibDeploymentInfo.getClassesContainerInfo() != null) {
            return Collections.unmodifiableList(this.sharedLibDeploymentInfo.getClassesContainerInfo());
        }
        return Collections.emptyList();
    }

    public ClassLoader createAppClassLoader() {
        return null;
    }

    protected void registerApplicationMBean() {
    }

    protected void deregisterApplicationMBean() {
    }

    /*
     * WARNING - void declaration
     */
    public boolean preDeployApp(Future<Boolean> result) {
        this.appInfo = this.createApplicationInfo();
        try {
            this.metaDataService.fireApplicationMetaDataCreated(this.appInfo.getMetaData(), this.appInfo.getContainer());
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"768", (Object)this, (Object[])new Object[]{result});
            this.uninstallApp();
            this.futureMonitor.setResult(result, (Throwable)ex);
            return false;
        }
        for (ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
            try {
                modInfo.createModuleMetaData((ApplicationInfo)this.appInfo, this);
            }
            catch (Throwable throwable) {
                void ex;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"777", (Object)this, (Object[])new Object[]{result});
                this.uninstallApp();
                this.futureMonitor.setResult(result, (Throwable)ex);
                return false;
            }
        }
        this.registerApplicationMBean();
        this.starting = true;
        try {
            this.stateChangeService.fireApplicationStarting((ApplicationInfo)this.appInfo);
        }
        catch (Throwable i$) {
            void ex;
            FFDCFilter.processException((Throwable)i$, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"789", (Object)this, (Object[])new Object[]{result});
            this.uninstallApp();
            this.futureMonitor.setResult(result, (Throwable)ex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean postDeployApp(Future<Boolean> result) {
        this.started = true;
        try {
            this.stateChangeService.fireApplicationStarted((ApplicationInfo)this.appInfo);
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"801", (Object)this, (Object[])new Object[]{result});
            this.uninstallApp();
            this.futureMonitor.setResult(result, (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean deployApp(Future<Boolean> result) {
        if (this.moduleContainerInfos.isEmpty()) {
            throw new IllegalStateException();
        }
        if (!this.preDeployApp(result)) {
            return false;
        }
        if (!this.deployModules(result)) {
            return false;
        }
        return this.postDeployApp(result);
    }

    private boolean deployModules(Future<Boolean> result) {
        DeployModulesListener listener = new DeployModulesListener(result);
        for (ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
            this.futureMonitor.onCompletion(this.deployModule(modInfo), (CompletionListener)listener);
            if (!listener.isFailed()) continue;
            this.uninstallApp();
            return false;
        }
        return true;
    }

    private Future<Boolean> deployModule(ModuleContainerInfoBase modInfo) {
        if (modInfo.moduleHandler != null) {
            if (modInfo.moduleInfo != null) {
                return modInfo.moduleHandler.deployModule(modInfo.moduleInfo, this);
            }
            return this.futureMonitor.createFutureWithResult(Boolean.class, (Throwable)new IllegalStateException(modInfo.getType().toString()));
        }
        return this.futureMonitor.createFutureWithResult((Object)true);
    }

    public DeployedModuleInfoImpl getDeployedModule(ModuleInfo moduleInfo) {
        List<DeployedModuleInfoImpl> deployedModules = this.modulesDeployed;
        for (DeployedModuleInfoImpl deployedModule : deployedModules) {
            if (deployedModule.info != moduleInfo) continue;
            return deployedModule;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean uninstallApp() {
        boolean success = true;
        if (this.started) {
            try {
                this.stateChangeService.fireApplicationStopping((ApplicationInfo)this.appInfo);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"895", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationStopping", (Object)this);
                success = false;
            }
        }
        List<DeployedModuleInfoImpl> deployedModules = this.modulesDeployed;
        for (DeployedModuleInfoImpl deployedModule : deployedModules) {
            success = deployedModule.uninstallModule();
        }
        if (this.starting) {
            try {
                this.stateChangeService.fireApplicationStopped((ApplicationInfo)this.appInfo);
            }
            catch (Throwable i$) {
                void t;
                FFDCFilter.processException((Throwable)i$, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"907", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationStopped", (Object)this);
                success = false;
            }
        }
        this.deregisterApplicationMBean();
        if (this.appInfo != null) {
            try {
                this.metaDataService.fireApplicationMetaDataDestroyed(this.appInfo.getMetaData());
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"918", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationMetaDataDestroyed", (Object)this);
                success = false;
            }
            try {
                this.appInfoFactory.destroyApplicationInfo((ApplicationInfo)this.appInfo);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"925", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"destroyApplicationInfo", (Object)this);
                success = false;
            }
        }
        return success;
    }

    protected ClassLoader createTopLevelClassLoader(List<Container> classPath, GatewayConfiguration gwConfig, ClassLoaderConfiguration config) {
        ClassLoader classLoader = this.libraryConfigHelper.createTopLevelClassLoader(classPath, gwConfig, config, this.classLoadingService, this.globalSharedLibrary);
        this.associateClassLoaderWithApp(classLoader);
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean associateClassLoaderWithApp(ClassLoader loader) {
        boolean success;
        block2: {
            try {
                ClassLoadingButler butler = (ClassLoadingButler)this.appInfo.getContainer().adapt(ClassLoadingButler.class);
                butler.addClassLoader(loader);
                success = true;
            }
            catch (Exception butler) {
                void ex;
                FFDCFilter.processException((Throwable)butler, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"947", (Object)this, (Object[])new Object[]{loader});
                success = false;
                if (!_tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)_tc, (String)"Failed to associate this app with a its loader via the ClassLoadingButler", (Object[])new Object[]{ex});
            }
        }
        return success;
    }

    @FFDCIgnore(value={MalformedURLException.class})
    protected ProtectionDomain getProtectionDomain() {
        CodeSource codesource;
        Permissions perms;
        block6: {
            perms = new Permissions();
            if (!this.java2SecurityEnabled()) {
                ((PermissionCollection)perms).add(new AllPermission());
            } else {
                if (this.permissionsConfig != null) {
                    List configuredPermissions = this.permissionsConfig.getPermissions();
                    this.addPermissions(configuredPermissions);
                }
                ArrayList mergedPermissions = this.permissionManager.getEffectivePermissions(this.applicationInformation.getLocation());
                int count = mergedPermissions.size();
                for (int i = 0; i < count; ++i) {
                    ((PermissionCollection)perms).add((Permission)mergedPermissions.get(i));
                }
            }
            try {
                String loc = this.applicationInformation.getLocation();
                codesource = new CodeSource(new URL("file://" + (loc.startsWith("/") ? "" : "/") + loc), (Certificate[])null);
            }
            catch (MalformedURLException e) {
                codesource = null;
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)_tc, (String)"Code Source could not be set. Setting it to null.", (Object[])new Object[]{e});
            }
        }
        ProtectionDomain protectionDomain = new ProtectionDomain(codesource, perms);
        return protectionDomain;
    }

    private void addPermissions(List<com.ibm.ws.javaee.dd.permissions.Permission> configuredPermissions) {
        Permission[] permissions = new Permission[configuredPermissions.size()];
        String codeBase = this.applicationInformation.getLocation();
        int count = 0;
        for (com.ibm.ws.javaee.dd.permissions.Permission permission : configuredPermissions) {
            Permission perm = this.permissionManager.createPermissionObject(permission.getClassName(), permission.getName(), permission.getActions(), null, null, null, PERMISSION_XML);
            if (perm == null) continue;
            permissions[count++] = perm;
            this.permissionManager.addPermissionsXMLPermission(codeBase, perm);
        }
    }

    private boolean java2SecurityEnabled() {
        SecurityManager sm = System.getSecurityManager();
        return sm != null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class DeployModulesListener
    implements CompletionListener<Boolean> {
        private final Future<Boolean> aggregateResultFuture;
        private int remaining;
        private volatile boolean aggregateResult;
        static final long serialVersionUID = -6934804456392138684L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DeployModulesListener(Future<Boolean> aggregateResultFuture) {
            this.remaining = DeployedAppInfoBase.this.moduleContainerInfos.size();
            this.aggregateResult = true;
            this.aggregateResultFuture = aggregateResultFuture;
        }

        public synchronized void successfulCompletion(Future<Boolean> future, Boolean result) {
            this.aggregateResult &= result.booleanValue();
            if (--this.remaining == 0) {
                DeployedAppInfoBase.this.futureMonitor.setResult(this.aggregateResultFuture, (Object)this.aggregateResult);
            }
        }

        public synchronized void failedCompletion(Future<Boolean> future, Throwable t) {
            DeployedAppInfoBase.this.futureMonitor.setResult(this.aggregateResultFuture, t);
            this.aggregateResult = false;
        }

        public boolean isFailed() {
            return !this.aggregateResult;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DeployModulesListener.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class SharedLibDeploymentInfo {
        private final BundleContext bundleContext;
        private final WsLocationAdmin locAdmin;
        private final ArtifactContainerFactory artifactFactory;
        private final AdaptableModuleFactory moduleFactory;
        private final List<ContainerInfo> classesContainerInfo = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = -9033256786848720484L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SharedLibDeploymentInfo(DeployedAppInfoFactoryBase factory, String parentPid) {
            this.bundleContext = factory.getBundleContext();
            this.locAdmin = factory.getLocationAdmin();
            this.artifactFactory = factory.getArtifactFactory();
            this.moduleFactory = factory.getModuleFactory();
            try {
                StringBuilder classloaderFilter = new StringBuilder(200);
                classloaderFilter.append("(&");
                classloaderFilter.append(FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)"com.ibm.ws.classloading.classloader"));
                classloaderFilter.append(FilterUtils.createPropertyFilter((String)"config.parentPID", (String)parentPid));
                classloaderFilter.append(')');
                Configuration[] classloaderConfigs = factory.getConfigurationAdmin().listConfigurations(classloaderFilter.toString());
                if (classloaderConfigs != null && classloaderConfigs.length == 1) {
                    Configuration cfg = classloaderConfigs[0];
                    Dictionary props = cfg.getProperties();
                    if (props != null) {
                        String[] libraryPIDs = (String[])props.get("privateLibraryRef");
                        this.processLibraryPIDs(this.classesContainerInfo, libraryPIDs, LibraryContainerInfo.LibraryType.PRIVATE_LIB);
                        libraryPIDs = (String[])props.get("commonLibraryRef");
                        this.processLibraryPIDs(this.classesContainerInfo, libraryPIDs, LibraryContainerInfo.LibraryType.COMMON_LIB);
                    } else {
                        cfg.delete();
                        return;
                    }
                }
                if (this.classesContainerInfo.isEmpty()) {
                    this.addLibraryContainers(this.classesContainerInfo, factory.getGlobalSharedLibraryPid(), LibraryContainerInfo.LibraryType.GLOBAL_LIB, factory.getGlobalSharedLibrary());
                }
            }
            catch (IOException classloaderFilter) {
                FFDCFilter.processException((Throwable)classloaderFilter, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$SharedLibDeploymentInfo", (String)"553", (Object)this, (Object[])new Object[]{factory, parentPid});
                return;
            }
            catch (InvalidSyntaxException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$SharedLibDeploymentInfo", (String)"556", (Object)this, (Object[])new Object[]{factory, parentPid});
                return;
            }
        }

        public List<ContainerInfo> getClassesContainerInfo() {
            return this.classesContainerInfo;
        }

        private void processLibraryPIDs(List<ContainerInfo> sharedLibContainers, String[] libraryPIDs, LibraryContainerInfo.LibraryType libType) throws InvalidSyntaxException {
            if (libraryPIDs != null) {
                for (String pid : libraryPIDs) {
                    String libraryFilter = FilterUtils.createPropertyFilter((String)"service.pid", (String)pid);
                    Collection libraryRefs = this.bundleContext.getServiceReferences(Library.class, libraryFilter);
                    for (ServiceReference libraryRef : libraryRefs) {
                        Library library = (Library)this.bundleContext.getService(libraryRef);
                        this.addLibraryContainers(sharedLibContainers, pid, libType, library);
                    }
                }
            }
        }

        private void addLibraryContainers(List<ContainerInfo> sharedLibContainers, String pid, LibraryContainerInfo.LibraryType libType, Library library) {
            if (library != null) {
                String libName = library.id();
                SharedLibClassesContainerInfo libClassesInfo = new SharedLibClassesContainerInfo(libType, library, "/" + libName);
                Collection files = library.getFiles();
                this.addContainers(libClassesInfo.getClassesContainerInfo(), pid, libName, files);
                Collection folders = library.getFolders();
                this.addContainers(libClassesInfo.getClassesContainerInfo(), pid, libName, folders);
                Collection filesets = library.getFilesets();
                for (Fileset fileset : filesets) {
                    this.addContainers(libClassesInfo.getClassesContainerInfo(), pid, libName, fileset.getFileset());
                }
                if (!libClassesInfo.getClassesContainerInfo().isEmpty()) {
                    sharedLibContainers.add((ContainerInfo)libClassesInfo);
                }
            }
        }

        private void addContainers(List<ContainerInfo> sharedLibContainers, String pid, String libName, Collection<File> files) {
            if (files != null) {
                for (File file : files) {
                    final Container container = this.setupContainer(pid, file);
                    if (container == null) continue;
                    final String name = "/" + libName + "/" + file.getName();
                    sharedLibContainers.add(new ContainerInfo(){
                        static final long serialVersionUID = -6809503652722008649L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public ContainerInfo.Type getType() {
                            return ContainerInfo.Type.SHARED_LIB;
                        }

                        public String getName() {
                            return name;
                        }

                        public Container getContainer() {
                            return container;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class);
                        }
                    });
                }
            }
        }

        private Container setupContainer(String pid, File locationFile) {
            if (!FileUtils.fileExists((File)locationFile)) {
                return null;
            }
            File cacheDir = new File(this.getCacheDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDir)) {
                return null;
            }
            ArtifactContainer artifactContainer = this.artifactFactory.getContainer(cacheDir, (Object)locationFile);
            if (artifactContainer == null) {
                return null;
            }
            File cacheDirAdapt = new File(this.getCacheAdaptDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDirAdapt)) {
                return null;
            }
            File cacheDirOverlay = new File(this.getCacheOverlayDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDirOverlay)) {
                return null;
            }
            return this.moduleFactory.getContainer(cacheDirAdapt, cacheDirOverlay, artifactContainer);
        }

        private File getCacheAdaptDir() {
            return this.locAdmin.getBundleFile((Object)this, "cacheAdapt");
        }

        private File getCacheOverlayDir() {
            return this.locAdmin.getBundleFile((Object)this, "cacheOverlay");
        }

        private File getCacheDir() {
            return this.locAdmin.getBundleFile((Object)this, "cache");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SharedLibDeploymentInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class SharedLibClassesContainerInfo
    implements LibraryClassesContainerInfo {
        private final LibraryContainerInfo.LibraryType libType;
        private final Library sharedLib;
        private final String libName;
        private final List<ContainerInfo> classesContainerInfo = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = 6112678435634051759L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SharedLibClassesContainerInfo(LibraryContainerInfo.LibraryType libType, Library sharedLib, String libName) {
            this.sharedLib = sharedLib;
            this.libName = libName;
            this.libType = libType;
        }

        public ContainerInfo.Type getType() {
            return ContainerInfo.Type.SHARED_LIB;
        }

        public String getName() {
            return this.libName;
        }

        public Container getContainer() {
            return null;
        }

        public LibraryContainerInfo.LibraryType getLibraryType() {
            return this.libType;
        }

        public ClassLoader getClassLoader() {
            return this.sharedLib.getClassLoader();
        }

        public List<ContainerInfo> getClassesContainerInfo() {
            return this.classesContainerInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SharedLibClassesContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class WebModuleContainerInfo
    extends ModuleContainerInfoBase {
        public final String contextRoot;
        public String defaultContextRoot;
        static final long serialVersionUID = 7482270300503470497L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WebModuleContainerInfo(ModuleHandler moduleHandler, ModuleMetaDataExtender moduleMetaDataExtender, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassesInfoProvider moduleClassesInfo, String contextRoot) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtender, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.WEB_MODULE, moduleClassesInfo, WebApp.class);
            this.getWebModuleClassesInfo(moduleContainer);
            this.contextRoot = contextRoot;
            this.defaultContextRoot = this.moduleName;
        }

        @Override
        public void setModuleName(String newModuleName) {
            super.setModuleName(newModuleName);
            this.defaultContextRoot = newModuleName;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ModuleMetaData createModuleMetaData(ApplicationInfo appInfo, DeployedAppInfoBase deployedApp) throws MetaDataException {
            WebModuleInfoImpl info;
            try {
                String contextRoot = this.contextRoot;
                if (contextRoot == null) {
                    contextRoot = ContextRootUtil.getContextRoot(this.defaultContextRoot);
                }
                info = new WebModuleInfoImpl(appInfo, this.moduleName, this.name, contextRoot, this.container, this.altDDEntry, this.classesContainerInfo, deployedApp);
                this.moduleInfo = info;
            }
            catch (UnableToAdaptException contextRoot) {
                void e;
                FFDCFilter.processException((Throwable)contextRoot, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$WebModuleContainerInfo", (String)"385", (Object)this, (Object[])new Object[]{appInfo, deployedApp});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
            if (this.moduleInfo == null || this.moduleHandler == null) {
                return null;
            }
            ModuleMetaData mmd = this.moduleHandler.createModuleMetaData(this.moduleInfo, deployedApp);
            if (mmd != null) {
                info.setMetaData(mmd);
                if (this.moduleMetaDataExtender != null) {
                    this.moduleMetaDataExtender.extendModuleMetaData(this.moduleInfo);
                }
                DeployedModuleInfoImpl deployedMod = new DeployedModuleInfoImpl(this.moduleHandler, this.moduleInfo);
                deployedApp.modulesDeployed.add(0, deployedMod);
            }
            return mmd;
        }

        private void getWebModuleClassesInfo(Container moduleContainer) throws UnableToAdaptException {
            Container libContainer;
            Entry libEntry;
            Container classesContainer;
            ArrayList resolved = new ArrayList();
            Entry classesEntry = moduleContainer.getEntry("WEB-INF/classes");
            if (classesEntry != null && (classesContainer = (Container)classesEntry.adapt(Container.class)) != null) {
                ContainerInfo containerInfo = new ContainerInfo(){
                    static final long serialVersionUID = 5863134402677568705L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public ContainerInfo.Type getType() {
                        return ContainerInfo.Type.WEB_INF_CLASSES;
                    }

                    public String getName() {
                        return "WEB-INF/classes";
                    }

                    public Container getContainer() {
                        return classesContainer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                };
                this.classesContainerInfo.add(containerInfo);
            }
            if ((libEntry = moduleContainer.getEntry("WEB-INF/lib")) != null && (libContainer = (Container)libEntry.adapt(Container.class)) != null) {
                for (Entry entry : libContainer) {
                    if (!entry.getName().toLowerCase().endsWith(".jar")) continue;
                    final String jarEntryName = entry.getName();
                    final Container jarContainer = (Container)entry.adapt(Container.class);
                    if (jarContainer == null) continue;
                    ContainerInfo containerInfo = new ContainerInfo(){
                        static final long serialVersionUID = -5834081848799253816L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public ContainerInfo.Type getType() {
                            return ContainerInfo.Type.WEB_INF_LIB;
                        }

                        public String getName() {
                            return "WEB-INF/lib/" + jarEntryName;
                        }

                        public Container getContainer() {
                            return jarContainer;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(2.class);
                        }
                    };
                    this.classesContainerInfo.add(containerInfo);
                    ManifestClassPathUtils.addCompleteJarEntryUrls((List)this.classesContainerInfo, (Entry)entry, resolved);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WebModuleContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class ClientModuleContainerInfo
    extends ModuleContainerInfoBase {
        final String mainClassName;
        static final long serialVersionUID = -8385143281254769872L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClientModuleContainerInfo(ModuleHandler moduleHandler, ModuleMetaDataExtender moduleMetaDataExtender, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassesInfoProvider moduleClassesInfo, String mainClass) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtender, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.CLIENT_MODULE, moduleClassesInfo, ApplicationClient.class);
            this.mainClassName = mainClass;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ModuleMetaData createModuleMetaData(ApplicationInfo appInfo, DeployedAppInfoBase deployedApp) throws MetaDataException {
            ClientModuleInfoImpl info;
            try {
                info = new ClientModuleInfoImpl(appInfo, this.moduleName, this.name, this.container, this.altDDEntry, this.classesContainerInfo, this.mainClassName, deployedApp);
                this.moduleInfo = info;
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$ClientModuleContainerInfo", (String)"333", (Object)this, (Object[])new Object[]{appInfo, deployedApp});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
            if (this.moduleInfo == null || this.moduleHandler == null) {
                return null;
            }
            ModuleMetaData mmd = this.moduleHandler.createModuleMetaData(this.moduleInfo, deployedApp);
            if (mmd != null) {
                info.setMetaData(mmd);
                if (this.moduleMetaDataExtender != null) {
                    this.moduleMetaDataExtender.extendModuleMetaData(this.moduleInfo);
                }
                DeployedModuleInfoImpl deployedMod = new DeployedModuleInfoImpl(this.moduleHandler, this.moduleInfo);
                deployedApp.modulesDeployed.add(0, deployedMod);
            }
            return mmd;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ClientModuleContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class EJBModuleContainerInfo
    extends ModuleContainerInfoBase {
        static final long serialVersionUID = -3520573065134314559L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EJBModuleContainerInfo(ModuleHandler moduleHandler, ModuleMetaDataExtender moduleMetaDataExtender, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassesInfoProvider moduleClassesInfo) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtender, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.EJB_MODULE, moduleClassesInfo, EJBJar.class);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ModuleMetaData createModuleMetaData(ApplicationInfo appInfo, DeployedAppInfoBase deployedApp) throws MetaDataException {
            EJBModuleInfoImpl info;
            try {
                info = new EJBModuleInfoImpl(appInfo, this.moduleName, this.name, this.container, this.altDDEntry, this.classesContainerInfo, deployedApp);
                this.moduleInfo = info;
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$EJBModuleContainerInfo", (String)"299", (Object)this, (Object[])new Object[]{appInfo, deployedApp});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
            if (this.moduleInfo == null || this.moduleHandler == null) {
                return null;
            }
            ModuleMetaData mmd = this.moduleHandler.createModuleMetaData(this.moduleInfo, deployedApp);
            if (mmd != null) {
                info.setMetaData(mmd);
                if (this.moduleMetaDataExtender != null) {
                    this.moduleMetaDataExtender.extendModuleMetaData(this.moduleInfo);
                }
                DeployedModuleInfoImpl deployedMod = new DeployedModuleInfoImpl(this.moduleHandler, this.moduleInfo);
                deployedApp.modulesDeployed.add(0, deployedMod);
            }
            return mmd;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EJBModuleContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class ConnectorModuleContainerInfo
    extends ModuleContainerInfoBase {
        static final long serialVersionUID = -1900716341704086330L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConnectorModuleContainerInfo(ModuleHandler moduleHandler, ModuleMetaDataExtender moduleMetaDataExtender, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassesInfoProvider moduleClassesInfo) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtender, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.RAR_MODULE, moduleClassesInfo, Connector.class);
            this.getConnectorModuleClassesInfo(moduleContainer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ModuleMetaData createModuleMetaData(ApplicationInfo appInfo, DeployedAppInfoBase deployedApp) throws MetaDataException {
            ConnectorModuleInfoImpl info;
            try {
                info = new ConnectorModuleInfoImpl(appInfo, this.moduleName, this.name, this.container, this.altDDEntry, this.classesContainerInfo, deployedApp);
                this.moduleInfo = info;
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$ConnectorModuleContainerInfo", (String)"232", (Object)this, (Object[])new Object[]{appInfo, deployedApp});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
            if (this.moduleInfo == null || this.moduleHandler == null) {
                return null;
            }
            ModuleMetaData mmd = this.moduleHandler.createModuleMetaData(this.moduleInfo, deployedApp);
            if (mmd != null) {
                info.setMetaData(mmd);
                if (this.moduleMetaDataExtender != null) {
                    this.moduleMetaDataExtender.extendModuleMetaData(this.moduleInfo);
                }
                DeployedModuleInfoImpl deployedMod = new DeployedModuleInfoImpl(this.moduleHandler, this.moduleInfo);
                deployedApp.modulesDeployed.add(0, deployedMod);
            }
            return mmd;
        }

        private void getConnectorModuleClassesInfo(Container moduleContainer) throws UnableToAdaptException {
            for (Entry entry : moduleContainer) {
                this.getEntryClassesInfo(entry);
            }
        }

        private void getEntryClassesInfo(Entry entry) throws UnableToAdaptException {
            if (entry.getName().toLowerCase().endsWith(".jar")) {
                final String jarEntryName = entry.getName();
                final Container jarContainer = (Container)entry.adapt(Container.class);
                ContainerInfo containerInfo = new ContainerInfo(){
                    static final long serialVersionUID = -4796163766814485530L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public ContainerInfo.Type getType() {
                        return ContainerInfo.Type.JAR_MODULE;
                    }

                    public String getName() {
                        return jarEntryName;
                    }

                    public Container getContainer() {
                        return jarContainer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                };
                this.classesContainerInfo.add(containerInfo);
                HashSet resolved = new HashSet();
                ManifestClassPathUtils.addCompleteJarEntryUrls((List)this.classesContainerInfo, (Entry)entry, resolved);
                for (Entry childEntry : jarContainer) {
                    this.getEntryClassesInfo(childEntry);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConnectorModuleContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static abstract class ModuleContainerInfoBase
    extends ExtendedContainerInfo
    implements ModuleClassesContainerInfo,
    ModuleContainerInfo {
        public final ModuleHandler moduleHandler;
        public final ModuleMetaDataExtender moduleMetaDataExtender;
        public String moduleName;
        public final ModuleDeploymentDescriptor moduleDD;
        public ModuleInfo moduleInfo;
        static final long serialVersionUID = -7501163864538745390L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public abstract ModuleMetaData createModuleMetaData(ApplicationInfo var1, DeployedAppInfoBase var2) throws MetaDataException;

        public ModuleContainerInfoBase(ModuleHandler moduleHandler, ModuleMetaDataExtender moduleMetaDataExtender, Container moduleContainer, Entry altDDEntry, String moduleURI, ContainerInfo.Type moduleContainerType, ModuleClassesInfoProvider moduleClassesInfo, Class<? extends ModuleDeploymentDescriptor> moduleDDClass) throws UnableToAdaptException {
            super(moduleContainerType, moduleURI, moduleContainer, altDDEntry);
            this.moduleHandler = moduleHandler;
            this.moduleMetaDataExtender = moduleMetaDataExtender;
            this.moduleDD = (ModuleDeploymentDescriptor)moduleContainer.adapt(moduleDDClass);
            this.moduleName = ModuleInfoUtils.getModuleName(this.moduleDD, moduleURI);
            this.classesContainerInfo.add(this);
            if (moduleClassesInfo != null) {
                this.classesContainerInfo.addAll(moduleClassesInfo.getClassesContainers(moduleContainer));
            }
        }

        public String getModuleURI() {
            return this.getName();
        }

        public void setModuleName(String newModuleName) {
            this.moduleName = newModuleName;
        }

        public ClassLoader getClassLoader() {
            return this.moduleInfo.getClassLoader();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleContainerInfoBase.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class ExtendedContainerInfo
    implements ContainerInfo {
        protected final ContainerInfo.Type type;
        protected final String name;
        protected final Container container;
        protected final Entry altDDEntry;
        protected final List<ContainerInfo> classesContainerInfo = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = -1742593872889722250L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected ExtendedContainerInfo(ContainerInfo.Type type, String name, Container container, Entry altDDEntry) {
            this.type = type;
            this.name = name;
            this.container = container;
            this.altDDEntry = altDDEntry;
            if (altDDEntry != null) {
                try {
                    NonPersistentCache cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
                    cache.addToCache(AltDDEntryGetter.class, (Object)new AltDDEntryGetter(){
                        static final long serialVersionUID = 5202876742955856585L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public Entry getAltDDEntry(ContainerInfo.Type type) {
                            if (ExtendedContainerInfo.this.type == type) {
                                return ExtendedContainerInfo.this.altDDEntry;
                            }
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class);
                        }
                    });
                }
                catch (UnableToAdaptException cache) {
                    FFDCFilter.processException((Throwable)cache, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$ExtendedContainerInfo", (String)"145", (Object)this, (Object[])new Object[]{type, name, container, altDDEntry});
                }
            }
        }

        public ContainerInfo.Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Container getContainer() {
            return this.container;
        }

        public List<ContainerInfo> getClassesContainerInfo() {
            return this.classesContainerInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ExtendedContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class ModuleClassesInfoProvider {
        private final Map<String, List<ContainerInfo>> entryContainerInfosMap = new HashMap<String, List<ContainerInfo>>();
        static final long serialVersionUID = 7553989638884300549L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected ModuleClassesInfoProvider() {
        }

        public List<ContainerInfo> getClassesContainers(Container moduleContainer) throws UnableToAdaptException {
            Entry moduleEntry = (Entry)moduleContainer.adapt(Entry.class);
            if (moduleEntry == null) {
                return Collections.emptyList();
            }
            String entryIdentity = ManifestClassPathUtils.createEntryIdentity((Entry)moduleEntry);
            List<ContainerInfo> containerInfos = this.entryContainerInfosMap.get(entryIdentity);
            if (containerInfos == null) {
                HashSet resolved = new HashSet();
                containerInfos = new ArrayList<ContainerInfo>();
                ManifestClassPathUtils.processMFClasspath((Entry)moduleEntry, containerInfos, resolved);
                this.entryContainerInfosMap.put(entryIdentity, containerInfos);
            }
            return containerInfos;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleClassesInfoProvider.class);
        }
    }
}

