/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.xml.internal.BaseConfiguration;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.FactoryElement;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.SingletonElement;
import com.ibm.ws.config.xml.internal.XMLConfigParser;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServerConfiguration
extends BaseConfiguration {
    private static final TraceComponent tc = Tr.register(ServerConfiguration.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    protected BaseConfiguration defaultConfiguration;
    static final long serialVersionUID = -3308124827149673640L;

    public void setDefaultConfiguration(BaseConfiguration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public BaseConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    @Override
    void getDefaultConfigurationNames(Set<String> names) {
        if (this.defaultConfiguration != null) {
            this.defaultConfiguration.getConfigurationNames(names);
        }
    }

    @Override
    boolean defaultConfigurationHasId(String pid) {
        if (this.defaultConfiguration == null) {
            return false;
        }
        return this.defaultConfiguration.hasId(pid);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDropinsEnabled() {
        String dropinsEnabledValue;
        SingletonElement configElement;
        boolean dropinsEnabled = true;
        try {
            configElement = this.getSingleton("applicationMonitor", null);
        }
        catch (ConfigMergeException configMergeException) {
            void e;
            FFDCFilter.processException((Throwable)configMergeException, (String)"com.ibm.ws.config.xml.internal.ServerConfiguration", (String)"71", (Object)this, (Object[])new Object[0]);
            e.getStackTrace();
            return false;
        }
        if (configElement != null && (dropinsEnabledValue = (String)configElement.getAttribute("dropinsEnabled")) != null && dropinsEnabledValue.equals("false")) {
            dropinsEnabled = false;
        }
        return dropinsEnabled;
    }

    public Set<String> getSingletonNames() {
        HashSet<String> singletons = new HashSet<String>();
        this.getSingletonNames(singletons);
        if (this.defaultConfiguration != null) {
            this.defaultConfiguration.getSingletonNames(singletons);
        }
        return singletons;
    }

    public Set<String> getFactoryNames() {
        HashSet<String> factories = new HashSet<String>();
        this.getFactoryNames(factories);
        if (this.defaultConfiguration != null) {
            this.defaultConfiguration.getFactoryNames(factories);
        }
        return factories;
    }

    @Override
    public SingletonElement getSingleton(String pid, String alias) throws ConfigMergeException {
        List<SimpleElement> elements = this.getSingletonElements(pid, alias);
        if (elements.isEmpty()) {
            if (this.defaultConfiguration == null) {
                return null;
            }
            return this.defaultConfiguration.getSingleton(pid, alias, false);
        }
        List<SimpleElement> defaults = Collections.emptyList();
        if (this.defaultConfiguration != null) {
            defaults = this.defaultConfiguration.getSingletonElements(pid, alias);
        }
        if (defaults.isEmpty()) {
            SingletonElement merged = new SingletonElement(elements, pid);
            return merged;
        }
        Iterator iter = defaults.iterator();
        while (iter.hasNext()) {
            if (((SimpleElement)iter.next()).mergeBehavior != XMLConfigParser.MergeBehavior.MERGE_WHEN_MISSING) continue;
            iter.remove();
        }
        SingletonElement merged = new SingletonElement(defaults, pid);
        merged.merge(elements);
        return merged;
    }

    @Override
    public FactoryElement getFactoryInstance(String pid, String alias, String id) throws ConfigMergeException {
        List<SimpleElement> elements = this.getFactoryElements(pid, alias, id);
        if (elements.isEmpty()) {
            if (this.defaultConfiguration == null) {
                return null;
            }
            return this.defaultConfiguration.getFactoryInstance(pid, alias, id, false);
        }
        if (this.defaultConfiguration != null) {
            List<SimpleElement> defaults = this.defaultConfiguration.getFactoryElements(pid, alias, id);
            if (defaults.isEmpty()) {
                return new FactoryElement(elements, pid, id);
            }
            FactoryElement merged = new FactoryElement(defaults, pid, id);
            merged.merge(elements);
            return merged;
        }
        return new FactoryElement(elements, pid, id);
    }

    @Override
    Map<ConfigID, List<SimpleElement>> defaultConfigurationFactories(String pid, String alias, String defaultId) {
        if (this.defaultConfiguration == null) {
            return Collections.emptyMap();
        }
        Map<ConfigID, List<SimpleElement>> retVal = this.defaultConfiguration.getAllFactoryElements(pid, alias, defaultId);
        return retVal == null ? Collections.emptyMap() : retVal;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("configurations: ").append(this.configurationMap);
        if (this.defaultConfiguration != null) {
            builder.append(" default configurations: ").append(this.defaultConfiguration);
        }
        return builder.toString();
    }

    public List<ConfigElement> getNestedInstances(MetaTypeRegistry.RegistryEntry re, MetaTypeRegistry registry) throws ConfigMergeException {
        String pid = re.getPid();
        ArrayList<ConfigElement> retVal = new ArrayList<ConfigElement>();
        for (MetaTypeRegistry.PidReference parentRef : re.getReferencingEntries()) {
            HashSet<ConfigElement> parentInstances = new HashSet<ConfigElement>();
            MetaTypeRegistry.RegistryEntry parentEntry = parentRef.getReferencingEntry();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Looking for instances of {0} nested under {1}", (Object[])new Object[]{pid, parentEntry});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Registry entry for parentPID {0} is {1}", (Object[])new Object[]{parentEntry, parentEntry});
            }
            if (parentEntry.isSingleton()) {
                SingletonElement element;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting singleton instances of {0} using alias {1}", (Object[])new Object[]{parentEntry, parentEntry.getAlias()});
                }
                if ((element = this.getSingleton(parentEntry.getPid(), parentEntry.getAlias())) != null) {
                    parentInstances.add(element);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting factory instances of {0} using alias {1}", (Object[])new Object[]{parentEntry, parentEntry.getAlias()});
                }
                Map parentFactoryInstances = this.getFactoryInstancesUsingDefaultId(parentEntry.getPid(), parentEntry.getAlias(), parentEntry.getDefaultId());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found {0} factory instances", (Object[])new Object[]{parentFactoryInstances.size()});
                }
                for (Map.Entry entry : parentFactoryInstances.entrySet()) {
                    parentInstances.add((ConfigElement)entry.getValue());
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"About to look for nested instances of parentPID {0}. Current parentInstances size: {1}", (Object[])new Object[]{parentEntry, parentInstances.size()});
            }
            parentInstances.addAll(this.getNestedInstances(parentEntry, registry));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Finished looking for nested instances of parentPID {0}. Current parentInstances size: {1}", (Object[])new Object[]{parentEntry, parentInstances.size()});
            }
            for (ConfigElement parent : parentInstances) {
                String alias;
                Object attr;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Examing parent instance {0}", (Object[])new Object[]{parent});
                }
                if ((attr = parent.getAttribute(pid)) != null && attr instanceof List) {
                    List children = (List)attr;
                    for (int i = 0; i < children.size(); ++i) {
                        Object o = children.get(i);
                        if (!(o instanceof ConfigElement)) continue;
                        ConfigElement child = (ConfigElement)o;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Found child {0} for parent {1} using pid {2}", (Object[])new Object[]{child, parent, pid});
                            Tr.debug((TraceComponent)tc, (String)"Creating NestedConfigElement with registry entry ", (Object[])new Object[]{parentEntry});
                        }
                        if (parent.isSimple()) {
                            parent = parentEntry.isFactory() ? new FactoryElement((SimpleElement)parent, -1, parentEntry) : new SingletonElement((SimpleElement)parent, parentEntry.getPid());
                        }
                        retVal.add(parent);
                    }
                }
                if (pid.equals(alias = parentRef.getAccessor(null)) || (attr = parent.getAttribute(alias)) == null || !(attr instanceof List)) continue;
                List children = (List)attr;
                for (int i = 0; i < children.size(); ++i) {
                    Object o = children.get(i);
                    if (!(o instanceof ConfigElement)) continue;
                    ConfigElement child = (ConfigElement)o;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found child {0} for parent {1} using alias {2}", (Object[])new Object[]{child, parent, alias});
                        Tr.debug((TraceComponent)tc, (String)"Creating NestedConfigElement with registry entry ", (Object[])new Object[]{parentEntry});
                    }
                    retVal.add(new NestedConfigElement(child, parent, parentEntry));
                }
            }
        }
        return retVal;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class NestedConfigElement
    extends ConfigElement {
        private final ConfigElement parent;
        private final MetaTypeRegistry.RegistryEntry parentRegistryEntry;
        private final String id;
        static final long serialVersionUID = 1629858790732220919L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NestedConfigElement(ConfigElement child, ConfigElement parent, MetaTypeRegistry.RegistryEntry parentEntry) {
            super(child);
            this.id = child.getId();
            this.parent = parent;
            this.parentRegistryEntry = parentEntry;
        }

        public NestedConfigElement(String nodeName, ConfigElement parent, MetaTypeRegistry.RegistryEntry parentEntry) {
            super(nodeName);
            this.id = null;
            this.parent = parent;
            this.parentRegistryEntry = parentEntry;
        }

        @Override
        public ConfigElement getParent() {
            return this.parent;
        }

        public MetaTypeRegistry.RegistryEntry getParentRegistryEntry() {
            return this.parentRegistryEntry;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isSimple() {
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NestedConfigElement.class);
        }
    }
}

