/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class MetaTypeIntrospection
implements Introspector {
    private static final String NAME = "MetaTypeIntrospection";
    private static final String DESC = "Introspect currently defined metatypes.";
    @Reference
    private MetaTypeRegistry metaTypeRegistry;
    static final long serialVersionUID = 2936931056121608938L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getIntrospectorName() {
        return NAME;
    }

    public String getIntrospectorDescription() {
        return DESC;
    }

    public void introspect(final PrintWriter ps) throws Exception {
        Collection<MetaTypeRegistry.RegistryEntry> collection = this.metaTypeRegistry.getAllRegistryEntries();
        MetaTypeRegistry.RegistryEntry[] entries = new MetaTypeRegistry.RegistryEntry[collection.size()];
        entries = collection.toArray(entries);
        Arrays.sort(entries, new Comparator<MetaTypeRegistry.RegistryEntry>(){
            static final long serialVersionUID = -9029830414792221805L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(MetaTypeRegistry.RegistryEntry arg0, MetaTypeRegistry.RegistryEntry arg1) {
                int retVal = Long.valueOf(arg0.getBundleId()).compareTo(arg1.getBundleId());
                if (retVal == 0) {
                    return arg0.getPid().compareTo(arg1.getPid());
                }
                return retVal;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        long currentBundleId = -1L;
        String currentPid = null;
        for (final MetaTypeRegistry.RegistryEntry re : entries) {
            if (re.getPid().equals(currentPid)) continue;
            currentPid = re.getPid();
            ExtendedObjectClassDefinition ocd = re.getObjectClassDefinition();
            if (re.getBundleId() != currentBundleId) {
                currentBundleId = re.getBundleId();
                ps.println("Bundle: " + re.getBundleName());
            }
            ps.println("\tID: " + ocd.getID());
            ps.println("\tName: " + ocd.getName());
            if (ocd.getDescription() != null) {
                ps.println("\tDescription: " + ocd.getDescription());
            }
            ps.println("\tPID: " + re.getPid());
            ps.println("\tIs Factory: " + re.isFactory());
            if (re.getAlias() != null) {
                ps.println("\tAlias: " + re.getAlias());
            }
            if (re.getChildAlias() != null) {
                ps.println("\tChild Alias: " + re.getChildAlias());
            }
            if (re.getExtends() != null) {
                ps.println("\tExtends: " + re.getExtends());
            }
            if (re.getObjectClassDefinition().getObjectClass() != null) {
                ps.println("\tObjectClass: " + re.getObjectClassDefinition().getObjectClass());
            }
            if (ocd.getParentPID() != null) {
                ps.println("\tParent PID: " + ocd.getParentPID());
            }
            if (re.getDefaultId() != null) {
                ps.println("\tDefault ID: " + re.getDefaultId());
            }
            if (ocd.getExcludedChildren() != null) {
                ps.println("\tExcluded Children: " + ocd.getExcludedChildren());
            }
            if (ocd.getLocalization() != null) {
                ps.println("\tLocalization: " + ocd.getLocalization());
            }
            if (ocd.getXsdAny() != 0) {
                ps.println("\tXSD Any Elements Allowed: " + ocd.getXsdAny());
            }
            this.printAttributes(ps, ocd);
            re.traverseHierarchyPreOrder(new MetaTypeRegistry.EntryAction<Void>(){
                private int depth;
                private String parentPid;
                static final long serialVersionUID = -9133852124438081305L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;
                {
                    this.parentPid = re.getPid();
                }

                @Override
                public boolean entry(MetaTypeRegistry.RegistryEntry registryEntry) {
                    if (this.depth == 0) {
                        ps.println("\tHierarchy:");
                        ++this.depth;
                    }
                    if (!this.parentPid.equals(registryEntry.getExtends())) {
                        if (this.parentPid.equals(registryEntry.getPid())) {
                            --this.depth;
                            this.parentPid = registryEntry.getExtends();
                        } else {
                            ++this.depth;
                            this.parentPid = registryEntry.getPid();
                        }
                    }
                    for (int i = -1; i < this.depth; ++i) {
                        ps.print("\t");
                    }
                    ps.println(registryEntry.getPid());
                    return true;
                }

                @Override
                public Void getResult() {
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
            ps.println("");
        }
    }

    private void printAttributes(PrintWriter ps, ExtendedObjectClassDefinition ocd) {
        ps.println("");
        ps.println("\tAttributes: ");
        for (ExtendedAttributeDefinition ad : ocd.getAttributeMap().values()) {
            ps.println("");
            ps.println("\t\tId: " + ad.getID());
            ps.println("\t\tName: " + ad.getName());
            ps.println("\t\tCardinality: " + ad.getCardinality());
            ps.println("\t\tDescription: " + ad.getDescription());
            ps.println("\t\tType: " + ad.getType());
            if (ad.getDefaultValue() != null && ad.getDefaultValue().length > 0) {
                ps.print("\t\tDefault Value: [");
                for (String value : ad.getDefaultValue()) {
                    ps.print(value + " ");
                }
                ps.println("]");
            }
            if (ad.getGroup() != null) {
                ps.println("\t\tUI Group: " + ad.getGroup());
            }
            if (ad.getReferencePid() != null) {
                ps.println("\t\tReference: " + ad.getReferencePid());
            }
            if (ad.getService() != null) {
                ps.println("\t\tService: " + ad.getService());
            }
            if (ad.getRename() != null) {
                ps.println("\t\tRename: " + ad.getRename());
            }
            if (ad.isUnique()) {
                ps.println("\t\tValue must be unique across: " + ad.getUniqueCategory());
            }
            if (ad.getVariable() != null) {
                ps.println("\t\tValue derived from variable: " + ad.getVariable());
            }
            if (ad.isFinal()) {
                ps.println("\t\tFinal = True, Value can not be specified from user input.");
            }
            if (ad.isFlat()) {
                ps.println("\t\tFlat: True");
            }
            if (ad.getCopyOf() != null) {
                ps.println("\t\tCopy of Attribute: " + ad.getCopyOf());
            }
            if (!ad.resolveVariables()) continue;
            ps.println("\t\tVariable Substitution: " + (ad.resolveVariables() ? "immediate" : "deferred"));
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MetaTypeIntrospection.class);
    }
}

