/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinition;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigurationInfo {
    private static final TraceComponent tc = Tr.register(ConfigurationInfo.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    final ConfigElement configElement;
    final ExtendedConfiguration config;
    final Map<String, ExtendedAttributeDefinition> metaTypeAttributes;
    final boolean deleted;
    final ExtendedObjectClassDefinition ocd;
    final List<ExtendedConfiguration> superTypeConfigs = new ArrayList<ExtendedConfiguration>();
    static final long serialVersionUID = -2724248819911187301L;

    ConfigurationInfo(ConfigElement configElement, ExtendedConfiguration config, ExtendedObjectClassDefinition ocd, boolean deleted) {
        this.configElement = configElement;
        this.config = config;
        this.ocd = ocd;
        this.metaTypeAttributes = ocd != null ? ocd.getAttributeMap() : null;
        this.deleted = deleted;
    }

    void addSuperTypeConfig(ExtendedConfiguration superTypeConfig) {
        this.superTypeConfigs.add(superTypeConfig);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.configElement.getFullId());
        builder.append(this.deleted ? ":d" : ":m");
        return builder.toString();
    }

    public boolean matches(ConfigurationInfo other) {
        boolean b = false;
        if (other != null) {
            b = this.config == other.config && this.configElement.equalsIgnoreIdAttr(other.configElement) && this.deleted == other.deleted && (this.metaTypeAttributes == null && other.metaTypeAttributes == null || this.metaTypeAttributes != null && this.metaTypeAttributes.equals(other.metaTypeAttributes)) && (this.ocd == null && other.ocd == null || this.ocd != null && this.ocd.equals(other.ocd));
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void fireEvents(Collection<Future<?>> futures) {
        this.config.lock();
        try {
            if (this.deleted) {
                this.config.fireConfigurationDeleted(futures);
            } else {
                this.config.fireConfigurationUpdated(futures);
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.config.xml.internal.ConfigurationInfo", (String)"78", (Object)this, (Object[])new Object[]{futures});
            String fullId = this.configElement.getFullId();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while trying to fire configuration update events for " + fullId + ". Exception message = " + e.getMessage()), (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"error.config.update.event", (Object[])new Object[]{fullId, e.getMessage()});
        }
        finally {
            this.config.unlock();
        }
        for (ExtendedConfiguration superTypeConfig : this.superTypeConfigs) {
            superTypeConfig.lock();
            try {
                superTypeConfig.fireConfigurationUpdated(futures);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.config.xml.internal.ConfigurationInfo", (String)"93", (Object)this, (Object[])new Object[]{futures});
                String fullId = superTypeConfig.getFullId().toString();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception while trying to fire configuration update events for " + fullId + ". Exception message = " + e.getMessage()), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"error.config.update.event", (Object[])new Object[]{fullId, e.getMessage()});
            }
            finally {
                superTypeConfig.unlock();
            }
        }
    }
}

