/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigUtil;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.ServerXMLConfiguration;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigValidator {
    private static final String LINE_SEPARATOR = ConfigUtil.getSystemProperty("line.separator");
    private static final String SECURE_VALUE = "*****";
    private static final TraceNLS nls = TraceNLS.getTraceNLS(ConfigValidator.class, (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private static final TraceComponent tc = Tr.register(ConfigValidator.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final MetaTypeRegistry metatypeRegistry;
    private ServerXMLConfiguration configuration;
    static final long serialVersionUID = 2714475408969174618L;

    ConfigValidator(MetaTypeRegistry metatypeRegistry) {
        this.metatypeRegistry = metatypeRegistry;
    }

    public void setConfiguration(ServerXMLConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean validateSingleton(String pid, String alias) {
        String name = alias == null ? pid : alias;
        return this.validate(name, null, this.configuration.getConfiguration().getSingletonElements(pid, alias));
    }

    public boolean validateFactoryInstance(String pid, String alias, ConfigID id) {
        String name = alias == null ? pid : alias;
        return this.validate(name, id, this.configuration.getConfiguration().getFactoryElements(pid, alias, id.getId()));
    }

    public void validate(Set<MetaTypeRegistry.RegistryEntry> entries) {
        for (MetaTypeRegistry.RegistryEntry registry : entries) {
            String name;
            String alias;
            if (registry.isSingleton()) {
                alias = registry.getAlias() == null ? registry.getChildAlias() : registry.getAlias();
                name = alias == null ? registry.getPid() : alias;
                this.validate(registry, name, null, this.configuration.getConfiguration().getSingletonElements(registry.getPid(), alias));
                continue;
            }
            alias = registry.getAlias() == null ? registry.getChildAlias() : registry.getAlias();
            name = alias == null ? registry.getPid() : alias;
            String defaultId = registry.getDefaultId();
            Map<ConfigID, List<SimpleElement>> instances = this.configuration.getConfiguration().getAllFactoryElements(registry.getPid(), alias, defaultId);
            for (Map.Entry<ConfigID, List<SimpleElement>> entry : instances.entrySet()) {
                this.validate(registry, name, entry.getKey(), entry.getValue());
            }
        }
    }

    private ExtendedAttributeDefinition getAttributeDefinition(MetaTypeRegistry.RegistryEntry registryEntry, String attributeName) {
        if (registryEntry == null) {
            return null;
        }
        ExtendedObjectClassDefinition definition = registryEntry.getObjectClassDefinition();
        if (definition == null) {
            return null;
        }
        Map<String, ExtendedAttributeDefinition> attributeMap = definition.getAttributeMap();
        ExtendedAttributeDefinition attributeDefinition = attributeMap.get(attributeName);
        return attributeDefinition;
    }

    private boolean isSecureAttribute(MetaTypeRegistry.RegistryEntry registryEntry, String attributeName) {
        ExtendedAttributeDefinition attributeDefinition = this.getAttributeDefinition(registryEntry, attributeName);
        if (attributeDefinition == null) {
            return false;
        }
        int attributeType = attributeDefinition.getType();
        return attributeType == 1003 || attributeType == 1008;
    }

    private void logRegistryEntry(MetaTypeRegistry.RegistryEntry registryEntry) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        if (registryEntry == null) {
            Tr.debug((TraceComponent)tc, (String)"Registry Entry [ null ]", (Object[])new Object[0]);
            return;
        }
        Tr.debug((TraceComponent)tc, (String)("Registry Entry [ " + registryEntry.getPid() + " ]"), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("  Bundle [ " + registryEntry.getBundleId() + " : " + registryEntry.getBundleName() + " ]"), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("  Alias [ " + registryEntry.getAlias() + " ]"), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("  Child Alias [ " + registryEntry.getChildAlias() + " ]"), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("  Extends : [ " + registryEntry.getExtends() + " ]"), (Object[])new Object[0]);
        ExtendedObjectClassDefinition definition = registryEntry.getObjectClassDefinition();
        Tr.debug((TraceComponent)tc, (String)("  Definition: [ " + definition + " ]"), (Object[])new Object[0]);
        if (definition == null) {
            return;
        }
        Map<String, ExtendedAttributeDefinition> attributeMap = definition.getAttributeMap();
        for (Map.Entry<String, ExtendedAttributeDefinition> attributeEntry : attributeMap.entrySet()) {
            String attributeName = attributeEntry.getKey();
            ExtendedAttributeDefinition attributeDefinition = attributeEntry.getValue();
            Tr.debug((TraceComponent)tc, (String)("    [ " + attributeName + " ] [ " + attributeDefinition + " ]"), (Object[])new Object[0]);
            if (attributeDefinition == null) continue;
            Tr.debug((TraceComponent)tc, (String)("      Type [ " + attributeDefinition.getType() + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("      Card [ " + attributeDefinition.getCardinality() + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("      Desc [ " + attributeDefinition.getDescription() + " ]"), (Object[])new Object[0]);
        }
    }

    public boolean validate(String pid, ConfigID id, List<? extends ConfigElement> elements) {
        MetaTypeRegistry.RegistryEntry registryEntry = this.metatypeRegistry.getRegistryEntryByPidOrAlias(pid);
        return this.validate(registryEntry, pid, id, elements);
    }

    public boolean validate(MetaTypeRegistry.RegistryEntry registryEntry, String pid, ConfigID id, List<? extends ConfigElement> elements) {
        Map<String, ConfigElementList> conflictedElementLists = this.generateConflictMap(registryEntry, elements);
        if (conflictedElementLists.isEmpty()) {
            return true;
        }
        this.logRegistryEntry(registryEntry);
        String validationMessage = this.generateCollisionMessage(pid, id, registryEntry, conflictedElementLists);
        Tr.warning((TraceComponent)tc, (String)"warn.config.validate.failed", (Object[])new Object[]{validationMessage});
        return false;
    }

    protected Map<String, ConfigElementList> generateConflictMap(List<? extends ConfigElement> list) {
        return this.generateConflictMap(null, list);
    }

    protected Map<String, ConfigElementList> generateConflictMap(MetaTypeRegistry.RegistryEntry registryEntry, List<? extends ConfigElement> list) {
        if (list.size() <= 1) {
            return Collections.emptyMap();
        }
        boolean foundConflict = false;
        HashMap<String, ConfigElementList> conflictMap = new HashMap<String, ConfigElementList>();
        for (ConfigElement configElement : list) {
            for (Map.Entry<String, Object> entry : configElement.getAttributes().entrySet()) {
                String attributeName = entry.getKey();
                Object attributeValue = entry.getValue();
                if (!(attributeValue instanceof String)) continue;
                ConfigElementList configList = (ConfigElementList)conflictMap.get(attributeName);
                if (configList == null) {
                    configList = new ConfigElementList(attributeName);
                    conflictMap.put(attributeName, configList);
                }
                if (!configList.add(configElement)) continue;
                foundConflict = true;
            }
        }
        if (!foundConflict) {
            return Collections.emptyMap();
        }
        return conflictMap;
    }

    private String generateCollisionMessage(String pid, ConfigID id, MetaTypeRegistry.RegistryEntry registryEntry, Map<String, ConfigElementList> conflictMap) {
        StringBuilder builder = new StringBuilder();
        if (id == null) {
            builder.append(nls.getFormattedMessage("config.validator.foundConflictSingleton", new Object[]{pid}, null));
        } else {
            builder.append(nls.getFormattedMessage("config.validator.foundConflictInstance", new Object[]{pid, id.getId()}, null));
        }
        builder.append(LINE_SEPARATOR);
        for (Map.Entry<String, ConfigElementList> entry : conflictMap.entrySet()) {
            String attributeName = entry.getKey();
            ConfigElementList configList = entry.getValue();
            boolean secureAttribute = this.isSecureAttribute(registryEntry, attributeName);
            if (!configList.hasConflict()) continue;
            builder.append("  ");
            builder.append(nls.getFormattedMessage("config.validator.attributeConflict", new Object[]{attributeName}, null));
            builder.append(LINE_SEPARATOR);
            for (ConfigElement element : configList) {
                Object value = element.getAttribute(attributeName);
                String docLocation = element.getDocumentLocation();
                builder.append("    ");
                if (secureAttribute) {
                    builder.append(nls.getFormattedMessage("config.validator.valueConflictSecure", new Object[]{docLocation}, null));
                } else if (value == null || value.equals("")) {
                    builder.append(nls.getFormattedMessage("config.validator.valueConflictNull", new Object[]{docLocation}, null));
                } else {
                    builder.append(nls.getFormattedMessage("config.validator.valueConflict", new Object[]{value, docLocation}, null));
                }
                builder.append(LINE_SEPARATOR);
            }
            builder.append("  ");
            Object activeValue = configList.getActiveValue();
            if (secureAttribute) {
                String activeLoc = configList.getActiveElement().getMergedLocation();
                builder.append(nls.getFormattedMessage("config.validator.activeValueSecure", new Object[]{attributeName, activeLoc}, null));
            } else if (activeValue == null || activeValue.equals("")) {
                builder.append(nls.getFormattedMessage("config.validator.activeValueNull", new Object[]{attributeName}, null));
            } else {
                builder.append(nls.getFormattedMessage("config.validator.activeValue", new Object[]{attributeName, activeValue}, null));
            }
            builder.append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class ConfigElementList
    extends ArrayList<ConfigElement> {
        private static final long serialVersionUID = -8472291303190806069L;
        private final String attribute;
        private boolean hasConflict;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConfigElementList(String attribute) {
            this.attribute = attribute;
            this.hasConflict = false;
        }

        @Override
        public boolean add(ConfigElement element) {
            if (!this.hasConflict && !this.isEmpty()) {
                Object lastValue = this.getLastValue();
                Object currentValue = element.getAttribute(this.attribute);
                this.hasConflict = lastValue == null ? currentValue != null : !lastValue.equals(currentValue);
            }
            super.add(element);
            return this.hasConflict;
        }

        public boolean hasConflict() {
            return this.hasConflict;
        }

        public Object getLastValue() {
            ConfigElement lastConfigElement = (ConfigElement)this.get(this.size() - 1);
            return lastConfigElement.getAttribute(this.attribute);
        }

        protected ConfigElement getActiveElement() {
            ArrayList<ConfigElement> list = new ArrayList<ConfigElement>(this);
            SimpleElement merged = new SimpleElement(list.get(0));
            merged.merge(list);
            return merged;
        }

        public Object getActiveValue() {
            return this.getActiveElement().getAttribute(this.attribute);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConfigElementList.class);
        }
    }
}

