/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.schemagen.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.metatype.OutputVersion;
import com.ibm.websphere.metatype.SchemaVersion;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.schemagen.internal.AppInfoEntry;
import com.ibm.ws.config.schemagen.internal.DocumentationWriter;
import com.ibm.ws.config.schemagen.internal.Type;
import com.ibm.ws.config.schemagen.internal.TypeBuilder;
import com.ibm.ws.config.schemagen.internal.TypeMember;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinitionImpl;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinition;
import com.ibm.ws.config.xml.internal.schema.AttributeDefinitionSpecification;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.equinox.metatype.impl.ExtendableHelper;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class SchemaWriter {
    public static final String XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String IBM_EXT_NS = "http://www.ibm.com/xmlns/dde/schema/annotation/ext";
    private static final String INCLUDE_TYPE = "includeType";
    private static final String SERVER_TYPE = "serverType";
    private static final String FACTORY_ID_TYPE = "factoryIdType";
    private static final String INTERNAL_PROPERTIES = "internal.properties";
    private static final String INTERNAL_PROPERTIES_TYPE = "internalPropertiesType";
    private static final String VARIABLE_DEFINITION_TYPE = "variableDefinitionType";
    private static final String GENERATE_SCHEMA_ACTION = "generateSchema";
    private static final ResourceBundle _msgs;
    private final XMLStreamWriter writer;
    private final List<MetaTypeInformation> definitions;
    private String encoding;
    private boolean generateDocumentation;
    private boolean generateWildcards;
    private Locale locale;
    private boolean ignoreErrors;
    private Set<String> ignoredPids;
    private boolean preferShortNames;
    private ResourceBundle resourceBundle;
    private AttributeDefinition onErrorDefinition;
    private final Set<Type> hasType;
    private final Set<String> restrictedTypes;
    private boolean isRuntime;
    private SchemaVersion schemaVersion;
    private OutputVersion outputVersion;
    static final long serialVersionUID = -3580314744901083322L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SchemaWriter(XMLStreamWriter writer) {
        this.writer = writer;
        this.definitions = new ArrayList<MetaTypeInformation>();
        this.generateDocumentation = true;
        this.generateWildcards = true;
        this.ignoreErrors = true;
        this.preferShortNames = true;
        this.hasType = new LinkedHashSet<Type>();
        this.hasType.add(Type.VARIABLE);
        this.hasType.add(Type.LOCATION);
        this.restrictedTypes = new LinkedHashSet<String>();
        this.isRuntime = false;
    }

    public void setIsRuntime(boolean value) {
        this.isRuntime = value;
    }

    public void setGenerateDocumentation(boolean generateDocumentation) {
        this.generateDocumentation = generateDocumentation;
    }

    public boolean getGenerateDocumentation() {
        return this.generateDocumentation;
    }

    public void setGenerateWildcards(boolean generateWildcards) {
        this.generateWildcards = generateWildcards;
    }

    public boolean getGenerateWildcards() {
        return this.generateWildcards;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean getIgnoreErrors() {
        return this.ignoreErrors;
    }

    public boolean isPreferShortNames() {
        return this.preferShortNames;
    }

    public void setPreferShortNames(boolean preferShortNames) {
        this.preferShortNames = preferShortNames;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setIgnoredPids(Set<String> ignoredPids) {
        this.ignoredPids = ignoredPids;
    }

    public Set<String> getIgnoredPids() {
        return this.ignoredPids;
    }

    public void add(MetaTypeInformation metatype) {
        this.definitions.add(metatype);
    }

    public void generate(boolean full) throws XMLStreamException {
        Object type;
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.resourceBundle = TraceNLS.getResourceBundle(SchemaWriter.class, (String)"com.ibm.ws.config.internal.resources.SchemaData", (Locale)this.locale);
        this.writer.writeStartDocument(this.encoding == null ? "UTF-8" : this.encoding, "1.0");
        this.writer.writeStartElement("xsd", "schema", XSD);
        this.writer.writeNamespace("xsd", XSD);
        this.writer.writeNamespace("ext", IBM_EXT_NS);
        TypeBuilder builder = new TypeBuilder(this.ignoreErrors, this.ignoredPids, this.locale, this.isRuntime);
        builder.buildStart();
        for (MetaTypeInformation metatype : this.definitions) {
            builder.build(metatype);
        }
        builder.buildComplete();
        Collection<TypeBuilder.OCDType> types = builder.getTypes();
        for (TypeBuilder.OCDType oCDType : types) {
            if (!"com.ibm.ws.config".equals(oCDType.getTypeName())) continue;
            ExtendedObjectClassDefinition ocd = oCDType.getObjectClassDefinition();
            this.onErrorDefinition = ocd.getAttributeMap().get("onError");
            break;
        }
        for (TypeBuilder.OCDType oCDType : types) {
            if (oCDType.isInternal()) continue;
            this.writeObjectClassType(builder, oCDType);
        }
        this.writeTypes();
        if (full) {
            this.writeIncludeType();
            this.writeVariableDefinitionType();
            this.writer.writeStartElement(XSD, "complexType");
            this.writer.writeAttribute("name", SERVER_TYPE);
            this.writer.writeStartElement(XSD, "choice");
            this.writer.writeAttribute("minOccurs", "0");
            this.writer.writeAttribute("maxOccurs", "unbounded");
            this.writeElement("include", INCLUDE_TYPE);
            this.writeElement("variable", VARIABLE_DEFINITION_TYPE);
        }
        for (Map.Entry entry : builder.getPidTypeMap().entrySet()) {
            String pid = (String)entry.getKey();
            type = (TypeBuilder.OCDTypeReference)entry.getValue();
            TypeBuilder.OCDType ocdType = ((TypeBuilder.OCDTypeReference)type).getOCDType();
            if (ocdType.isInternal() || this.preferShortNames && (ocdType.getAliasName() != null || ocdType.getChildAliasName() != null) || ocdType.hasParentPids() || ocdType.isPidReferenced() && ocdType.getAliasName() == null) continue;
            String typeName = ((TypeBuilder.OCDTypeReference)type).getOcdTypeName();
            this.writeElement(pid, typeName);
        }
        block4: for (Map.Entry entry : builder.getAliasMap().entrySet()) {
            List typesList = (List)entry.getValue();
            if (typesList.size() == 0) continue;
            type = null;
            if (typesList.size() == 1) {
                type = (TypeBuilder.OCDType)typesList.get(0);
                if (((TypeBuilder.OCDType)type).hasParentPids()) {
                    continue;
                }
            } else {
                for (TypeBuilder.OCDType t : typesList) {
                    if (t.hasParentPids()) continue;
                    if (type != null && !((TypeBuilder.OCDType)type).isInternal()) {
                        this.writeElement((String)entry.getKey(), "xsd:anyType");
                        continue block4;
                    }
                    type = t;
                }
                if (type == null) continue;
            }
            if (((TypeBuilder.OCDType)type).isInternal()) continue;
            String typeName = ((TypeBuilder.OCDType)type).getTypeName();
            if (((TypeBuilder.OCDType)type).getHasFactoryReference()) {
                this.writeElement((String)entry.getKey(), typeName + "-factory");
                continue;
            }
            this.writeElement((String)entry.getKey(), typeName);
        }
        if (full) {
            this.writer.writeEndElement();
            this.writeAttribute("description", "xsd:string", false);
            if (this.generateWildcards) {
                this.writeAttributeWildcard();
            }
            this.writer.writeEndElement();
            this.writeElement("client", SERVER_TYPE);
            this.writeElement("server", SERVER_TYPE);
        }
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.flush();
    }

    private void writeAttributeWildcard() throws XMLStreamException {
        this.writer.writeStartElement(XSD, "anyAttribute");
        this.writer.writeAttribute("processContents", "skip");
        this.writer.writeEndElement();
    }

    private static String[] getReferenceAttributes(String name) {
        if (name.endsWith("Ref")) {
            return new String[]{name, name.substring(0, name.length() - "Ref".length())};
        }
        return new String[]{name + "Ref", name};
    }

    private static boolean isSingleCardinality(int cardinality) {
        return cardinality == 0 || cardinality == 1 || cardinality == -1;
    }

    private void buildTypeMembers(TypeBuilder builder, TypeBuilder.OCDType ocdType, Map<String, TypeMember> xmlAttributes, List<TypeMember> xmlElements) {
        ArrayList<ExtendedObjectClassDefinition> ocdDefs = new ArrayList<ExtendedObjectClassDefinition>();
        ExtendedObjectClassDefinition ocd = ocdType.getObjectClassDefinition();
        if (ocd.getExtends() != null) {
            ExtendedObjectClassDefinition currOcd = ocd;
            TypeBuilder.OCDType currOcdType = ocdType;
            boolean readExtensions = true;
            while (readExtensions) {
                String extension = currOcd.getExtends();
                if (extension != null && currOcdType.getHasFactoryReference()) {
                    ocdDefs.add(0, currOcd);
                    TypeBuilder.OCDTypeReference ocdSuperType = builder.getPidType(extension);
                    if (ocdSuperType != null) {
                        currOcdType = ocdSuperType.getOCDType();
                        currOcd = currOcdType.getObjectClassDefinition();
                        continue;
                    }
                    TypeBuilder.OCDTypeReference internalOcdSuperType = builder.getInternalPidType(extension);
                    if (internalOcdSuperType != null) {
                        currOcdType = internalOcdSuperType.getOCDType();
                        currOcd = currOcdType.getObjectClassDefinition();
                        continue;
                    }
                    this.error("schemagen.invalid.extension.pid", currOcd.getID(), extension);
                    readExtensions = false;
                    continue;
                }
                if (!currOcdType.getHasFactoryReference()) {
                    this.error("schemagen.non.factorypid.extension", currOcd.getID());
                } else {
                    ocdDefs.add(0, currOcd);
                }
                readExtensions = false;
            }
        } else {
            ocdDefs.add(ocd);
        }
        LinkedHashMap<String, AttributeDefinition> requiredAttributes = new LinkedHashMap<String, AttributeDefinition>();
        LinkedHashMap<String, AttributeDefinition> optionalAttributes = new LinkedHashMap<String, AttributeDefinition>();
        LinkedHashMap<String, ExtendedAttributeDefinition> attributeMap = new LinkedHashMap<String, ExtendedAttributeDefinition>();
        for (ExtendedObjectClassDefinition currDef : ocdDefs) {
            attributeMap.putAll(currDef.getAttributeMap());
            this.processOCDAttributes(currDef.getID(), currDef.getAttributeDefinitions(1), requiredAttributes, optionalAttributes, attributeMap, true);
            this.processOCDAttributes(currDef.getID(), currDef.getAttributeDefinitions(2), requiredAttributes, optionalAttributes, attributeMap, false);
        }
        this.buildTypeMembers(builder, ocdType, requiredAttributes.values().toArray(new AttributeDefinition[0]), true, xmlAttributes, xmlElements);
        this.buildTypeMembers(builder, ocdType, optionalAttributes.values().toArray(new AttributeDefinition[0]), false, xmlAttributes, xmlElements);
    }

    private void processOCDAttributes(String currDefId, AttributeDefinition[] attrDefs, Map<String, AttributeDefinition> requiredAttributes, Map<String, AttributeDefinition> optionalAttributes, Map<String, ExtendedAttributeDefinition> attributeMap, boolean required) {
        Map<String, AttributeDefinition> alternateAttributes;
        Map<String, AttributeDefinition> currentAttributes;
        if (required) {
            currentAttributes = requiredAttributes;
            alternateAttributes = optionalAttributes;
        } else {
            currentAttributes = optionalAttributes;
            alternateAttributes = requiredAttributes;
        }
        for (AttributeDefinition attrDef : attrDefs) {
            String attrId = attrDef.getID();
            ExtendedAttributeDefinition extendedAttr = attributeMap.get(attrId);
            if (extendedAttr == null) continue;
            if (extendedAttr.isFinal()) {
                if (!currentAttributes.containsKey(attrId)) continue;
                currentAttributes.remove(attrId);
                continue;
            }
            String rename = extendedAttr.getRename();
            if (rename != null) {
                boolean alternativeAttr = false;
                AttributeDefinition attrToRename = currentAttributes.get(rename);
                if (attrToRename == null) {
                    attrToRename = alternateAttributes.get(rename);
                    alternativeAttr = true;
                }
                if (attrToRename == null) {
                    this.error("schemagen.rename.attribute.missing", currDefId, rename, extendedAttr.getID());
                    continue;
                }
                currentAttributes.put(attrId, this.renameAttribute(currDefId, attributeMap.get(rename), extendedAttr, required));
                if (alternativeAttr) {
                    alternateAttributes.remove(rename);
                    continue;
                }
                currentAttributes.remove(rename);
                continue;
            }
            currentAttributes.put(attrId, attrDef);
        }
    }

    private AttributeDefinition renameAttribute(String currDefId, ExtendedAttributeDefinition oldAttribute, ExtendedAttributeDefinition newAttribute, boolean required) {
        AttributeDefinitionSpecification result = new AttributeDefinitionSpecification();
        result.setId(newAttribute.getID());
        result.setType(oldAttribute.getType());
        result.setRequired(required);
        if (result.getType() != newAttribute.getType()) {
            this.error("schemagen.invalid.type.override", newAttribute.getID(), currDefId, result.getType());
        }
        result.setName(newAttribute.getName() != null ? newAttribute.getName() : oldAttribute.getName());
        result.setDescription(newAttribute.getDescription() != null ? newAttribute.getDescription() : oldAttribute.getDescription());
        result.setDefaultValue(newAttribute.getDefaultValue() != null ? newAttribute.getDefaultValue() : oldAttribute.getDefaultValue());
        result.setCardinality(newAttribute.getCardinality() != 0 ? newAttribute.getCardinality() : oldAttribute.getCardinality());
        String[] optionLabels = newAttribute.getOptionLabels();
        String[] optionValues = newAttribute.getOptionValues();
        if (optionLabels == null || optionLabels.length == 0) {
            optionLabels = oldAttribute.getOptionLabels();
        }
        if (optionValues == null || optionValues.length == 0) {
            optionValues = oldAttribute.getOptionValues();
        }
        ArrayList<String[]> valueOptions = new ArrayList<String[]>();
        if (optionLabels != null) {
            for (int i = 0; i < optionLabels.length; ++i) {
                String[] newArray = new String[]{optionValues[i], optionLabels[i]};
                valueOptions.add(newArray);
            }
        }
        result.setValueOptions(valueOptions);
        LinkedHashMap<String, Map<String, String>> extensions = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashSet<String> extensionURIs = new LinkedHashSet<String>();
        Set<String> newExtensionURIs = newAttribute.getExtensionUris();
        extensionURIs.addAll(oldAttribute.getExtensionUris());
        extensionURIs.addAll(newExtensionURIs);
        for (String currUri : extensionURIs) {
            LinkedHashMap<String, String> currExtensions = new LinkedHashMap<String, String>();
            if (newExtensionURIs.contains(currUri)) {
                currExtensions.putAll(newAttribute.getExtensions(currUri));
            } else {
                currExtensions.putAll(oldAttribute.getExtensions(currUri));
            }
            if ("http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0".equals(currUri)) {
                currExtensions.remove("rename");
            }
            extensions.put(currUri, Collections.unmodifiableMap(currExtensions));
        }
        ExtendableHelper helper = new ExtendableHelper(extensions);
        result.setExtendedAttributes(helper);
        return result;
    }

    private void buildTypeMembers(TypeBuilder builder, TypeBuilder.OCDType ocdType, AttributeDefinition[] attributes, boolean required, Map<String, TypeMember> xmlAttributes, List<TypeMember> xmlElements) {
        String bundleId = "";
        Bundle b = ocdType.getMetaTypeInformation().getBundle();
        if (b != null) {
            bundleId = b.getSymbolicName() + '/' + b.getVersion();
        }
        if (attributes == null) {
            return;
        }
        for (AttributeDefinition attribute : attributes) {
            if (attribute.getID().startsWith("config.") || "internal".equals(attribute.getName())) continue;
            ExtendedAttributeDefinitionImpl attributeDef = new ExtendedAttributeDefinitionImpl(attribute);
            if (attributeDef.getType() == 1001 || attributeDef.getType() == 1 && attributeDef.getUIReference() != null) {
                ArrayList<String> referencePids = new ArrayList<String>();
                if (attributeDef.getUIReference() != null) {
                    referencePids.addAll(attributeDef.getUIReference());
                } else if (attributeDef.getReferencePid() != null) {
                    referencePids.add(attributeDef.getReferencePid());
                } else if (attributeDef.getService() != null) {
                    referencePids.addAll(builder.getServiceMatches(attributeDef.getService()));
                } else {
                    this.error("schemagen.bad.reference.extension", attributeDef.getID());
                    continue;
                }
                List<TypeBuilder.OCDTypeReference> ocdReferences = this.gatherOCDTypeReferences(builder, referencePids);
                boolean requiredForThisAttribute = required;
                String[] referenceAttributes = SchemaWriter.getReferenceAttributes(attributeDef.getID());
                LinkedHashSet<String> aliases = new LinkedHashSet<String>();
                for (TypeBuilder.OCDTypeReference ocdReference : ocdReferences) {
                    this.gatherAliases(ocdReference.getOCDType(), aliases);
                }
                if (!aliases.isEmpty()) {
                    TypeMember refAttribute = new TypeMember(attributeDef);
                    refAttribute.setID(referenceAttributes[0]);
                    Type type = SchemaWriter.isSingleCardinality(attributeDef.getCardinality()) ? Type.PID : Type.PID_LIST;
                    refAttribute.setType(type);
                    this.hasType.add(type);
                    refAttribute.setCardinality(0);
                    requiredForThisAttribute = false;
                    refAttribute.setRequired(requiredForThisAttribute);
                    refAttribute.setDefaultValue(attribute.getDefaultValue());
                    xmlAttributes.put(refAttribute.getID(), refAttribute);
                    this.processExtensions(ocdType, refAttribute, attributeDef);
                    for (String alias : aliases) {
                        refAttribute.addAppInfoEntry(AppInfoEntry.createReferenceTag(alias));
                    }
                }
                if (ocdReferences.size() != 1) continue;
                TypeBuilder.OCDTypeReference ocdReference = ocdReferences.get(0);
                if (!this.generateNested(attributeDef) || ocdReference.isInternal()) continue;
                TypeMember refElement = new TypeMember(attributeDef);
                refElement.setID(referenceAttributes[1]);
                refElement.setType((Type)null);
                refElement.setCardinality(attribute.getCardinality() == 0 ? 1 : attribute.getCardinality());
                String typeName = refElement.getCardinality() == 1 ? ocdReference.getOcdTypeName() : ocdReference.getOcdTypeName() + "-factory";
                refElement.setType(typeName);
                refElement.setRequired(requiredForThisAttribute);
                xmlElements.add(refElement);
                this.processExtensions(ocdType, refElement, attributeDef);
                continue;
            }
            String description = attribute.getDescription();
            String name = attribute.getName();
            if (description == null || description.length() == 0) {
                this.error("schemagen.no.attrib.desc", attribute.getID(), ocdType.getObjectClassDefinition().getID(), bundleId);
            } else if (description.charAt(0) == '%') {
                this.error("schemagen.unresolved.attrib.desc", attribute.getID(), ocdType.getObjectClassDefinition().getID(), bundleId);
            }
            if (name == null || name.length() == 0) {
                this.error("schemagen.no.attrib.name", attribute.getID(), ocdType.getObjectClassDefinition().getID(), bundleId);
            } else if (name.charAt(0) == '%') {
                this.error("schemagen.unresolved.attrib.name", attribute.getID(), ocdType.getObjectClassDefinition().getID(), bundleId);
            }
            TypeMember attr = new TypeMember(attributeDef);
            attr.setID(attributeDef.getID());
            attr.setCardinality(attribute.getCardinality());
            attr.setRequired(required);
            attr.setDefaultValue(attribute.getDefaultValue());
            this.processExtensions(ocdType, attr, attributeDef);
            if (attribute.getCardinality() == 0) {
                xmlAttributes.put(attr.getID(), attr);
                continue;
            }
            xmlElements.add(attr);
        }
    }

    private List<TypeBuilder.OCDTypeReference> gatherOCDTypeReferences(TypeBuilder builder, List<String> referencePids) {
        ArrayList<TypeBuilder.OCDTypeReference> references = new ArrayList<TypeBuilder.OCDTypeReference>();
        for (String referencePid : referencePids) {
            TypeBuilder.OCDTypeReference ocdReference = builder.getPidTypeMap().get(referencePid);
            if (ocdReference == null && (ocdReference = builder.getInternalPidTypeMap().get(referencePid)) == null) {
                this.error("schemagen.bad.reference.pid", referencePid);
                continue;
            }
            references.add(ocdReference);
        }
        return references;
    }

    private void gatherAliases(TypeBuilder.OCDType ocdType, Set<String> aliases) {
        String alias;
        if (!ocdType.isInternal() && (alias = ocdType.getAliasName()) != null) {
            aliases.add(alias);
        }
        for (TypeBuilder.OCDType child : ocdType.getExtensions()) {
            this.gatherAliases(child, aliases);
        }
    }

    private boolean generateNested(ExtendedAttributeDefinition attributeDef) {
        if ("loginModuleRef".equals(attributeDef.getID()) && "com.ibm.ws.security.authentication.internal.jaas.jaasLoginModuleConfig".equals(attributeDef.getReferencePid())) {
            return false;
        }
        if ("taskStoreRef".equals(attributeDef.getID()) && "com.ibm.ws.persistence.databaseStore".equals(attributeDef.getReferencePid())) {
            return false;
        }
        return attributeDef.getService() == null && attributeDef.getUIReference() == null;
    }

    private void processExtensions(TypeBuilder.OCDType ocdType, TypeMember attr, ExtendedAttributeDefinition attributeDef) {
        String unique;
        String variable;
        String group;
        String requiresTrue;
        String requiresFalse;
        int type = attributeDef.getType();
        String description = type == 1000 ? SchemaWriter.combineStrings(attributeDef.getDescription(), this.resourceBundle.getString("config.internal.metatype.duration.desc")) : (type == 1006 ? SchemaWriter.combineStrings(attributeDef.getDescription(), this.resourceBundle.getString("config.internal.metatype.duration-h.desc")) : (type == 1005 ? SchemaWriter.combineStrings(attributeDef.getDescription(), this.resourceBundle.getString("config.internal.metatype.duration-m.desc")) : (type == 1004 ? SchemaWriter.combineStrings(attributeDef.getDescription(), this.resourceBundle.getString("config.internal.metatype.duration-s.desc")) : attributeDef.getDescription())));
        attr.setDescription(description);
        String name = attributeDef.getName();
        if (name != null) {
            attr.addAppInfoEntry(AppInfoEntry.createLabelTag(name, attributeDef.getAttributeName()));
        }
        if ((requiresFalse = attributeDef.getRequiresFalse()) != null) {
            attr.addAppInfoEntry(AppInfoEntry.createRequiresTag(requiresFalse, false));
        }
        if ((requiresTrue = attributeDef.getRequiresTrue()) != null) {
            attr.addAppInfoEntry(AppInfoEntry.createRequiresTag(requiresTrue, true));
        }
        if ((group = attributeDef.getGroup()) != null) {
            attr.addAppInfoEntry(AppInfoEntry.createGroupTag(group));
            ocdType.addGroup(group);
        }
        if ((variable = attributeDef.getVariable()) != null) {
            attr.addAppInfoEntry(AppInfoEntry.createVariableTag(variable));
        }
        if ((unique = attributeDef.getUniqueCategory()) != null) {
            attr.addAppInfoEntry(AppInfoEntry.createUniqueTag(unique));
        }
    }

    private void writeObjectClassType(TypeBuilder builder, TypeBuilder.OCDType type) throws XMLStreamException {
        this.writer.writeStartElement(XSD, "complexType");
        this.writer.writeAttribute("name", type.getTypeName());
        LinkedHashMap<String, TypeMember> singleValued = new LinkedHashMap<String, TypeMember>();
        ArrayList<TypeMember> multiValued = new ArrayList<TypeMember>();
        this.buildTypeMembers(builder, type, singleValued, multiValued);
        this.writeDocumentation(type, type.getObjectClassDefinition().getDescription(), type.getAppInfoEntries());
        Collection<TypeBuilder.OCDType> children = type.getChildren();
        int numKnownChildren = multiValued.size() + children.size();
        int numAnyChildren = type.getXsdAny();
        int numChildren = numKnownChildren + numAnyChildren;
        if (numChildren != 0) {
            String writeAnyMaxOccurs;
            boolean writeAny;
            boolean singleton;
            boolean bl = singleton = numChildren == 1;
            if (singleton) {
                this.writer.writeStartElement(XSD, "sequence");
            } else {
                this.writer.writeStartElement(XSD, "choice");
                this.writer.writeAttribute("minOccurs", "0");
                this.writer.writeAttribute("maxOccurs", "unbounded");
            }
            boolean writeKnown = numKnownChildren != 0;
            boolean bl2 = writeAny = numAnyChildren != 0;
            if (this.schemaVersion == SchemaVersion.v1_0 && writeKnown && writeAny) {
                if (this.outputVersion == OutputVersion.v1) {
                    writeAny = false;
                    writeAnyMaxOccurs = null;
                } else {
                    writeKnown = false;
                    writeAnyMaxOccurs = "unbounded";
                }
            } else {
                String string = writeAnyMaxOccurs = writeAny ? Integer.toString(numAnyChildren) : null;
            }
            if (writeKnown) {
                for (TypeMember member : multiValued) {
                    this.writeTypeMember(member, singleton);
                }
                for (TypeBuilder.OCDType child : children) {
                    this.writeNestedElement(child, singleton);
                }
            }
            if (writeAny) {
                this.writer.writeEmptyElement(XSD, "any");
                this.writer.writeAttribute("processContents", "skip");
                this.writer.writeAttribute("minOccurs", "0");
                this.writer.writeAttribute("maxOccurs", writeAnyMaxOccurs);
            }
            this.writer.writeEndElement();
        } else {
            this.writer.writeComment("Idiom for \"empty element context\" (whitespace accepted and ignored)");
            this.writer.writeStartElement(XSD, "sequence");
            this.writer.writeEmptyElement(XSD, "sequence");
            this.writer.writeEndElement();
        }
        for (TypeMember member : singleValued.values()) {
            this.writeTypeMember(member, false);
        }
        if (type.getHasExtraProperties()) {
            this.writeInternalPropertiesType(type);
        }
        if (this.generateWildcards) {
            this.writeAttributeWildcard();
        }
        this.writer.writeEndElement();
        if (type.getHasFactoryReference()) {
            this.writer.writeStartElement(XSD, "complexType");
            this.writer.writeAttribute("name", type.getTypeName() + "-factory");
            this.writer.writeStartElement(XSD, "complexContent");
            this.writer.writeStartElement(XSD, "extension");
            this.writer.writeAttribute("base", type.getTypeName());
            TypeMember id = (TypeMember)singleValued.get("id");
            if (id == null) {
                this.writer.writeStartElement(XSD, "attribute");
                this.writer.writeAttribute("name", "id");
                this.writer.writeAttribute("type", FACTORY_ID_TYPE);
                this.writer.writeAttribute("use", "optional");
                String doc = this.resourceBundle.getString("config.internal.metatype.id.documentation");
                String label = this.resourceBundle.getString("config.internal.metatype.id.label");
                this.writeDocumentation(doc, label);
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.restrictedTypes.add(FACTORY_ID_TYPE);
        }
    }

    private void writeNestedElement(TypeBuilder.OCDType type, boolean addMinMax) throws XMLStreamException {
        this.writer.writeStartElement(XSD, "element");
        this.writer.writeAttribute("name", type.getAliasName() == null ? type.getChildAliasName() : type.getAliasName());
        if (addMinMax) {
            this.writer.writeAttribute("minOccurs", "0");
            this.writer.writeAttribute("maxOccurs", "unbounded");
        }
        this.writer.writeAttribute("type", type.getTypeName());
        this.writer.writeEndElement();
    }

    private void writeTypeMember(final TypeMember member, boolean addCardinalityMinMax) throws XMLStreamException {
        int cardinality;
        ExtendedAttributeDefinition attribute = member.getAttribute();
        boolean required = member.isRequired();
        boolean alternateLabel = false;
        String[] defaultValue = member.getDefaultValue();
        if (defaultValue != null && defaultValue.length > 0) {
            required = false;
        }
        if ((cardinality = member.getCardinality()) == 0) {
            this.writer.writeStartElement(XSD, "attribute");
            this.writer.writeAttribute("name", member.getID());
            if (required) {
                this.writer.writeAttribute("use", "required");
            } else {
                this.writer.writeAttribute("use", "optional");
            }
            alternateLabel = true;
        } else {
            this.writer.writeStartElement(XSD, "element");
            this.writer.writeAttribute("name", member.getID());
            if (addCardinalityMinMax) {
                this.writer.writeAttribute("minOccurs", required ? "1" : "0");
                String max = cardinality == Integer.MAX_VALUE || cardinality == Integer.MIN_VALUE ? "unbounded" : String.valueOf(Math.abs(cardinality));
                this.writer.writeAttribute("maxOccurs", max);
            }
        }
        if (defaultValue != null && defaultValue.length > 0) {
            if (cardinality != 0) {
                this.writer.writeAttribute("default", defaultValue[0]);
            } else {
                StringBuffer concatDefaultValue = new StringBuffer();
                for (int i = 0; i < defaultValue.length; ++i) {
                    concatDefaultValue.append("," + defaultValue[i]);
                }
                String multiDefaultValue = concatDefaultValue.substring(1);
                this.writer.writeAttribute("default", multiDefaultValue);
            }
        }
        ExtendedAttributeDefinition optionAD = attribute.getType() == 1007 ? this.onErrorDefinition : attribute;
        String[] optionValues = optionAD != null ? optionAD.getOptionValues() : null;
        final boolean altLabel = alternateLabel;
        DocumentationWriter docWriter = new DocumentationWriter(){
            static final long serialVersionUID = 2151874813140874059L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void writeDoc() throws XMLStreamException {
                SchemaWriter.this.writeDocumentation(altLabel, member.getDescription(), member.getAppInfoEntries());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        if (optionValues != null && optionValues.length > 0) {
            String[] optionLables = optionAD.getOptionLabels();
            this.writeDocumentation(member.getDescription(), member.getAppInfoEntries());
            this.writer.writeStartElement(XSD, "simpleType");
            if (this.outputVersion == OutputVersion.v2) {
                this.writer.writeStartElement(XSD, "union");
                this.writer.writeAttribute("memberTypes", "variableType");
                this.writer.writeStartElement(XSD, "simpleType");
            }
            this.writer.writeStartElement(XSD, "restriction");
            this.writer.writeAttribute("base", member.getType(true));
            this.hasType.add(member.getType());
            for (int i = 0; i < optionValues.length; ++i) {
                this.writer.writeStartElement(XSD, "enumeration");
                this.writer.writeAttribute("value", optionValues[i]);
                if (optionLables != null && i < optionLables.length) {
                    this.writeDocumentation(optionLables[i], new AppInfoEntry[0]);
                }
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            if (this.outputVersion == OutputVersion.v2) {
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        } else if (this.outputVersion == OutputVersion.v2 && member.isMinMaxSet()) {
            member.getType().writeType(this.writer, member.getMin(), member.getMax(), docWriter);
        } else {
            Type t = member.getType();
            if (t != null) {
                t.writeType(this.writer, docWriter);
                this.hasType.add(t);
            } else {
                this.writer.writeAttribute("type", member.getType(true));
                this.writeDocumentation(alternateLabel, member.getDescription(), member.getAppInfoEntries());
            }
        }
        this.writer.writeEndElement();
    }

    private void writeInternalPropertiesType(TypeBuilder.OCDType type) throws XMLStreamException {
        this.writer.writeStartElement(XSD, "attribute");
        this.writer.writeAttribute("name", INTERNAL_PROPERTIES);
        this.writer.writeAttribute("type", INTERNAL_PROPERTIES_TYPE);
        this.writer.writeAttribute("use", "optional");
        String doc = type.getTranslatedText(type.getDescriptionKeys("extraProperties"));
        String label = type.getTranslatedText(type.getLabelKeys("extraProperties"));
        this.writeDocumentation(doc, label);
        this.writer.writeEndElement();
        this.restrictedTypes.add(INTERNAL_PROPERTIES_TYPE);
    }

    private void writeTypes() throws XMLStreamException {
        for (Type t : this.hasType) {
            t.writeGlobalType(this.writer);
        }
        for (String type : this.restrictedTypes) {
            this.writeRestrictedType(type, "xsd:string");
        }
        this.writeRestrictedType("schemaPropertiesType", "xsd:string");
    }

    private void writeRestrictedType(String name, String type) throws XMLStreamException {
        this.writer.writeStartElement(XSD, "simpleType");
        this.writer.writeAttribute("name", name);
        this.writer.writeEmptyElement(XSD, "restriction");
        this.writer.writeAttribute("base", type);
        this.writer.writeEndElement();
    }

    private void writeIncludeType() throws XMLStreamException {
        this.writer.writeStartElement(XSD, "complexType");
        this.writer.writeAttribute("name", INCLUDE_TYPE);
        String doc = this.resourceBundle.getString("config.internal.metatype.includeType.documentation");
        String label = this.resourceBundle.getString("config.internal.metatype.includeType.label");
        this.writeDocumentation(doc, label);
        this.writer.writeStartElement(XSD, "attribute");
        this.writer.writeAttribute("name", "optional");
        this.writer.writeAttribute("type", "xsd:boolean");
        this.writer.writeAttribute("use", "optional");
        this.writer.writeAttribute("default", "false");
        doc = this.resourceBundle.getString("config.internal.metatype.includeType.attribute.optional.documentation");
        label = this.resourceBundle.getString("config.internal.metatype.includeType.attribute.optional.label");
        this.writeDocumentation(doc, label);
        this.writer.writeEndElement();
        this.writer.writeStartElement(XSD, "attribute");
        this.writer.writeAttribute("name", "location");
        this.writer.writeAttribute("type", "location");
        this.writer.writeAttribute("use", "required");
        doc = this.resourceBundle.getString("config.internal.metatype.includeType.attribute.location.documentation");
        label = this.resourceBundle.getString("config.internal.metatype.includeType.attribute.location.label");
        this.writeDocumentation(doc, label);
        this.writer.writeEndElement();
        this.writer.writeStartElement(XSD, "attribute");
        this.writer.writeAttribute("name", "onConflict");
        this.writer.writeAttribute("use", "optional");
        this.writer.writeAttribute("default", "MERGE");
        doc = this.resourceBundle.getString("config.internal.metatype.includeType.attribute.onConflict.documentation");
        label = this.resourceBundle.getString("config.internal.metatype.includeType.attribute.onConflict.label");
        this.writeDocumentation(doc, label);
        String[] optionValues = new String[]{"MERGE", "REPLACE", "IGNORE"};
        String[] optionLabels = new String[]{"config.internal.metatype.onConflictType.merge.label", "config.internal.metatype.onConflictType.replace.label", "config.internal.metatype.onConflictType.ignore.label"};
        this.writer.writeStartElement(XSD, "simpleType");
        if (this.outputVersion == OutputVersion.v2) {
            this.writer.writeStartElement(XSD, "union");
            this.writer.writeAttribute("memberTypes", "variableType");
            this.writer.writeStartElement(XSD, "simpleType");
        }
        this.writer.writeStartElement(XSD, "restriction");
        this.writer.writeAttribute("base", "xsd:string");
        for (int i = 0; i < optionValues.length; ++i) {
            this.writer.writeStartElement(XSD, "enumeration");
            this.writer.writeAttribute("value", optionValues[i]);
            this.writeDocumentation(this.resourceBundle.getString(optionLabels[i]), new AppInfoEntry[0]);
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        if (this.outputVersion == OutputVersion.v2) {
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private void writeVariableDefinitionType() throws XMLStreamException {
        this.writer.writeStartElement(XSD, "complexType");
        this.writer.writeAttribute("name", VARIABLE_DEFINITION_TYPE);
        String doc = this.resourceBundle.getString("config.internal.metatype.variableDefinitionType.documentation");
        String label = this.resourceBundle.getString("config.internal.metatype.variableDefinitionType.label");
        this.writeDocumentation(doc, label);
        this.writer.writeStartElement(XSD, "attribute");
        this.writer.writeAttribute("name", "name");
        this.writer.writeAttribute("type", "xsd:string");
        this.writer.writeAttribute("use", "required");
        doc = this.resourceBundle.getString("config.internal.metatype.variableDefinitionType.name.documentation");
        label = this.resourceBundle.getString("config.internal.metatype.variableDefinitionType.name.label");
        this.writeDocumentation(doc, label);
        this.writer.writeEndElement();
        this.writer.writeStartElement(XSD, "attribute");
        this.writer.writeAttribute("name", "value");
        this.writer.writeAttribute("type", "xsd:string");
        this.writer.writeAttribute("use", "required");
        doc = this.resourceBundle.getString("config.internal.metatype.variableDefinitionType.value.documentation");
        label = this.resourceBundle.getString("config.internal.metatype.variableDefinitionType.value.label");
        this.writeDocumentation(doc, label);
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private void writeDocumentation(String documentation, String label) throws XMLStreamException {
        if (!this.generateDocumentation) {
            return;
        }
        this.writeDocumentation(documentation, AppInfoEntry.createLabelTag(label, label));
    }

    private void writeDocumentation(TypeBuilder.OCDType type, String description, AppInfoEntry ... appInfoEntries) throws XMLStreamException {
        this.writeDocumentation(type, false, description, appInfoEntries);
    }

    private void writeDocumentation(String description, AppInfoEntry ... appInfoEntries) throws XMLStreamException {
        this.writeDocumentation(null, false, description, appInfoEntries);
    }

    private void writeDocumentation(boolean alternate, String description, AppInfoEntry ... appInfoEntries) throws XMLStreamException {
        this.writeDocumentation(null, alternate, description, appInfoEntries);
    }

    private void writeDocumentation(TypeBuilder.OCDType type, boolean alternate, String description, AppInfoEntry ... appInfoEntries) throws XMLStreamException {
        if (!this.generateDocumentation) {
            return;
        }
        if (description == null && (appInfoEntries == null || appInfoEntries.length == 0)) {
            return;
        }
        this.writer.writeStartElement(XSD, "annotation");
        if (description != null) {
            this.writer.writeStartElement(XSD, "documentation");
            this.writer.writeCharacters(description);
            this.writer.writeEndElement();
        }
        if (appInfoEntries != null && appInfoEntries.length > 0) {
            this.writer.writeStartElement(XSD, "appinfo");
            if (type != null && type.getAction() != null && type.getAction().equals(GENERATE_SCHEMA_ACTION)) {
                this.writeSchemaGenAnnotations(type, alternate);
            }
            for (AppInfoEntry appInfoEntry : appInfoEntries) {
                appInfoEntry.write(this.writer, alternate);
            }
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    private void writeElement(String name, String type) throws XMLStreamException {
        this.writer.writeEmptyElement(XSD, "element");
        this.writer.writeAttribute("name", name);
        this.writer.writeAttribute("type", type);
    }

    private void writeAttribute(String name, String type, boolean required) throws XMLStreamException {
        this.writer.writeEmptyElement(XSD, "attribute");
        this.writer.writeAttribute("name", name);
        this.writer.writeAttribute("type", type);
        this.writer.writeAttribute("use", required ? "required" : "optional");
    }

    private static String combineStrings(String one, String two) {
        one = SchemaWriter.trim(one);
        two = SchemaWriter.trim(two);
        if (SchemaWriter.isEmpty(one)) {
            return SchemaWriter.isEmpty(two) ? null : two;
        }
        if (SchemaWriter.isEmpty(two)) {
            return one;
        }
        if (!one.endsWith(".")) {
            return one + ". " + two;
        }
        return one + " " + two;
    }

    private static String trim(String str) {
        return str == null ? null : str.trim();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private void error(String message, Object ... args) {
        if (!this.isRuntime) {
            String msg = message;
            try {
                msg = _msgs.getString(message);
            }
            catch (MissingResourceException missingResourceException) {
                FFDCFilter.processException((Throwable)missingResourceException, (String)"com.ibm.ws.config.schemagen.internal.SchemaWriter", (String)"1269", (Object)this, (Object[])new Object[]{message, args});
            }
            if (args.length > 0) {
                msg = MessageFormat.format(msg, args);
            }
            System.err.println(msg);
        }
        if (!this.ignoreErrors) {
            throw new RuntimeException("Error during schema generation");
        }
    }

    public void setSchemaVersion(SchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setOutputVersion(OutputVersion outputVersion) {
        this.outputVersion = outputVersion;
    }

    private void writeSchemaGenAnnotations(TypeBuilder.OCDType type, boolean alternate) throws XMLStreamException {
        AppInfoEntry tag = null;
        if (type != null) {
            tag = new AppInfoEntry("action");
            tag.addAttribute("type", GENERATE_SCHEMA_ACTION);
            if ("resourceAdapter".equals(type.getChildAliasName())) {
                tag.addAttribute("elemPrefix", "properties.");
                tag.addAttribute("idAttr", "${parent.name}.${id}");
                tag.addAttribute("alternateIdAttr", "${parent.name}.${alias}");
            } else if ("resourceAdapter".equals(type.getAliasName())) {
                tag.addAttribute("elemPrefix", "properties.");
                tag.addAttribute("idAttr", "${id}");
                tag.addAttribute("alternateIdAttr", "${location}");
            }
            tag.write(this.writer, alternate);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SchemaWriter.class);
        _msgs = ResourceBundle.getBundle("com.ibm.ws.config.internal.resources.ConfigMessages");
    }
}

