/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class UpdateQueue<T> {
    private static final TraceComponent tc = Tr.register(UpdateQueue.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final ExecutorService threadPool;
    private final Queue<T>[] queues;
    static final long serialVersionUID = -2220987240531172166L;

    public UpdateQueue() {
        ThreadFactory threadFactory = new ThreadFactory(){
            static final long serialVersionUID = 7131334620153136566L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Thread newThread(final Runnable r) {
                return AccessController.doPrivileged(new PrivilegedAction<Thread>(){
                    static final long serialVersionUID = 5610576933024923628L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Thread run() {
                        Thread t = new Thread(r);
                        t.setDaemon(true);
                        t.setName("Config-" + t.getName());
                        return t;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        RejectedExecutionHandler rejectionHandler = new RejectedExecutionHandler(){
            static final long serialVersionUID = 5834977129964843326L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                String executorText;
                if (e.isTerminating()) {
                    executorText = "Terminating executor [ " + e + " ] rejected [ " + r + " ]";
                } else if (e.isTerminated()) {
                    executorText = "Terminated executor [ " + e + " ] rejected [ " + r + " ]";
                } else {
                    long coreSize = e.getCorePoolSize();
                    long maxSize = e.getMaximumPoolSize();
                    long active = e.getActiveCount();
                    long completed = e.getCompletedTaskCount();
                    executorText = "Running executor [ " + e + " ] rejected [ " + r + " ]" + ": State: Core Size [ " + coreSize + " ] Max Size [ " + maxSize + " ]" + " Active Count [ " + active + " ] Completed Count [ " + completed + " ]";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)executorText, (Object[])new Object[0]);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
        int maxSize = Runtime.getRuntime().availableProcessors();
        this.threadPool = new ThreadPoolExecutor(0, maxSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, rejectionHandler);
        Queue[] newQueues = new Queue[maxSize];
        this.queues = newQueues;
        for (int i = 0; i < this.queues.length; ++i) {
            this.queues[i] = new Queue();
        }
    }

    public Future<?> add(T key, Runnable runnable) {
        FutureTask<Object> future;
        Queue<T> queue = this.getQueue(key);
        boolean startQueueProcessor = queue.enqueue(key, future = new FutureTask<Object>(runnable, null));
        if (startQueueProcessor) {
            this.threadPool.execute(queue);
        }
        return future;
    }

    @FFDCIgnore(value={InterruptedException.class, ExecutionException.class, TimeoutException.class})
    public static boolean waitForAll(Collection<Future<?>> futureList, long timeout, TimeUnit timeUnit) {
        long timeoutNanos = timeUnit.toNanos(timeout);
        for (Future<?> future : futureList) {
            if (future == null || future.isDone()) continue;
            if (timeoutNanos <= 0L) {
                return false;
            }
            long startTime = System.nanoTime();
            try {
                future.get(timeoutNanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
            }
            catch (TimeoutException e) {
                return false;
            }
            long endTime = System.nanoTime();
            timeoutNanos -= endTime - startTime;
        }
        return true;
    }

    private Queue<T> getQueue(T key) {
        int hash = key.hashCode() & Integer.MAX_VALUE;
        return this.queues[hash % this.queues.length];
    }

    public void shutdown() {
        this.threadPool.shutdown();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class Queue<T>
    implements Runnable {
        private final LinkedList<Runnable> runOrder = new LinkedList();
        private boolean hasProcessor = false;
        static final long serialVersionUID = -6791705294330032672L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Queue() {
        }

        public synchronized boolean enqueue(T key, Runnable runnable) {
            this.runOrder.add(runnable);
            if (this.hasProcessor) {
                return false;
            }
            this.hasProcessor = true;
            return true;
        }

        public synchronized Runnable dequeue() {
            Runnable runner = this.runOrder.poll();
            if (runner == null) {
                this.hasProcessor = false;
            }
            return runner;
        }

        @Override
        @FFDCIgnore(value={Throwable.class})
        public void run() {
            Runnable runnable = null;
            while ((runnable = this.dequeue()) != null) {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {}
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Queue.class);
        }
    }
}

