/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.admin.internal.ConfigAdminServiceFactory;
import com.ibm.ws.config.admin.internal.ConfigUtil;
import com.ibm.ws.config.admin.internal.ExtendedConfigurationImpl;
import com.ibm.ws.config.admin.internal.PersistedConfigManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigurationStore {
    private static final TraceComponent tc = Tr.register(ConfigurationStore.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final ConfigAdminServiceFactory caFactory;
    protected PersistedConfigManager persistedConfig;
    private final Map<String, ExtendedConfigurationImpl> configurations = new HashMap<String, ExtendedConfigurationImpl>();
    protected boolean cachedConfigScanned = false;
    protected final Object cachedConfigScannedLock = new Object(){
        static final long serialVersionUID = -945624381174440198L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private long configCount = 0L;
    static final long serialVersionUID = 2395296793317701213L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ConfigurationStore(ConfigAdminServiceFactory configAdminServiceFactory, BundleContext bc) {
        this.caFactory = configAdminServiceFactory;
        this.persistedConfig = new PersistedConfigManager(bc.getDataFile("configs"));
        Object object = this.cachedConfigScannedLock;
        synchronized (object) {
            if (!this.cachedConfigScanned) {
                String[] pids;
                this.cachedConfigScanned = true;
                for (String pid : pids = this.persistedConfig.getCachedPids()) {
                    boolean deleteFile = false;
                    try {
                        ExtendedConfigurationImpl config = this.deserializeConfigurationData(pid);
                        if (config != null) {
                            this.configurations.put(config.getPid(), config);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("added persisted config " + config), (Object[])new Object[0]);
                            }
                        }
                    }
                    catch (IOException config) {
                        void e;
                        FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.config.admin.internal.ConfigurationStore", (String)"92", (Object)this, (Object[])new Object[]{configAdminServiceFactory, bc});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception while deserializing a ConfigurationImpl", (Object[])new Object[0]);
                        }
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"Exception while deserializing a ConfigurationImpl", (Object[])new Object[]{pid});
                        deleteFile = true;
                    }
                    if (!deleteFile) continue;
                    this.persistedConfig.deleteConfigFile(pid);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("config store pids are [" + this.configurations.keySet() + "]"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void saveConfiguration(String pid, final ExtendedConfigurationImpl config) throws IOException {
        config.checkLocked();
        final File configFile = this.persistedConfig.getConfigFile(pid);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = 4729066836139707885L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    ConfigurationStore.this.serializeConfigurationData(configFile, config);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.config.admin.internal.ConfigurationStore", (String)"127", (Object)this, (Object[])new Object[]{pid, config});
            throw (IOException)e.getException();
        }
    }

    public synchronized void removeConfiguration(final String pid) {
        this.configurations.remove(pid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removed configuration pid = " + pid + ", remaining pids are [" + this.configurations.keySet() + "]"), (Object[])new Object[0]);
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = -5974257217592909864L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                ConfigurationStore.this.persistedConfig.deleteConfigFile(pid);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
    }

    public synchronized ExtendedConfigurationImpl getConfiguration(String pid, String location) {
        ExtendedConfigurationImpl config = this.configurations.get(pid);
        if (config == null) {
            config = new ExtendedConfigurationImpl(this.caFactory, location, null, pid, null, null, null);
            this.configurations.put(pid, config);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("added config " + config), (Object[])new Object[0]);
            }
        }
        return config;
    }

    public synchronized ExtendedConfiguration createFactoryConfiguration(String factoryPid, String location) {
        String pid;
        while (this.configurations.containsKey(pid = factoryPid + "_" + this.configCount++)) {
        }
        ExtendedConfigurationImpl config = new ExtendedConfigurationImpl(this.caFactory, location, factoryPid, pid, null, null, null);
        this.configurations.put(pid, config);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("added created factory config " + config), (Object[])new Object[0]);
        }
        return config;
    }

    public synchronized ExtendedConfigurationImpl findConfiguration(String pid) {
        return this.configurations.get(pid);
    }

    public synchronized ExtendedConfigurationImpl[] getFactoryConfigurations(String factoryPid) {
        ArrayList<ExtendedConfigurationImpl> resultList = new ArrayList<ExtendedConfigurationImpl>();
        for (ExtendedConfigurationImpl config : this.configurations.values()) {
            String otherFactoryPid = config.getFactoryPid();
            if (otherFactoryPid == null || !otherFactoryPid.equals(factoryPid)) continue;
            resultList.add(config);
        }
        return resultList.toArray(new ExtendedConfigurationImpl[resultList.size()]);
    }

    public synchronized ExtendedConfiguration[] listConfigurations(Filter filter) {
        ArrayList<ExtendedConfigurationImpl> resultList = new ArrayList<ExtendedConfigurationImpl>();
        for (ExtendedConfigurationImpl config : this.configurations.values()) {
            if (!config.matchesFilter(filter)) continue;
            resultList.add(config);
        }
        int size = resultList.size();
        return size == 0 ? null : resultList.toArray(new ExtendedConfiguration[size]);
    }

    public synchronized void unbindConfigurations(Bundle bundle) {
        for (ExtendedConfigurationImpl config : this.configurations.values()) {
            config.unbind(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeConfigurationData(File configFile, ExtendedConfigurationImpl config) throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            Dictionary<String, Object> properties = config.getReadOnlyProperties();
            Set<ConfigID> references = config.getReferences();
            Set<String> uniqueVars = config.getUniqueVariables();
            String bundleLocation = config.getBundleLocation();
            fos = new FileOutputStream(configFile, false);
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
            oos.writeObject(properties);
            oos.writeObject(bundleLocation);
            oos.writeBoolean(Boolean.FALSE);
            oos.writeObject(references);
            oos.writeObject(uniqueVars);
        }
        catch (Throwable throwable) {
            ConfigUtil.closeIO(oos);
            ConfigUtil.closeIO(fos);
            throw throwable;
        }
        ConfigUtil.closeIO(oos);
        ConfigUtil.closeIO(fos);
    }

    /*
     * WARNING - void declaration
     */
    ExtendedConfigurationImpl deserializeConfigurationData(String pid) throws IOException {
        ExtendedConfigurationImpl config = null;
        File configFile = this.persistedConfig.getConfigFile(pid);
        if (configFile != null && configFile.length() > 0L) {
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                fis = new FileInputStream(configFile);
                ois = new ObjectInputStream(new BufferedInputStream(fis));
                Dictionary d = (Dictionary)ois.readObject();
                String location = (String)ois.readObject();
                ois.readBoolean();
                Set references = (Set)ois.readObject();
                Set uniqueVariables = (Set)ois.readObject();
                String factoryPid = (String)d.get("service.factoryPid");
                VariableRegistry variableRegistry = this.caFactory.getVariableRegistry();
                for (String variable : uniqueVariables) {
                    variableRegistry.addVariable(variable, "WLP_VAR_IN_USE");
                }
                config = new ExtendedConfigurationImpl(this.caFactory, location, factoryPid, pid, d, references, uniqueVariables);
            }
            catch (ClassNotFoundException d) {
                try {
                    void e;
                    FFDCFilter.processException((Throwable)d, (String)"com.ibm.ws.config.admin.internal.ConfigurationStore", (String)"267", (Object)this, (Object[])new Object[]{pid});
                    throw new IOException((Throwable)e);
                }
                catch (Throwable throwable) {
                    ConfigUtil.closeIO(ois);
                    ConfigUtil.closeIO(fis);
                    throw throwable;
                }
            }
            ConfigUtil.closeIO(ois);
            ConfigUtil.closeIO(fis);
        }
        return config;
    }
}

