/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ws.logging.hpel.LogRepositoryBrowser;
import com.ibm.ws.logging.hpel.MainLogRepositoryBrowser;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBaseImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBrowserImpl;
import com.ibm.ws.logging.object.hpel.RepositoryPointerImpl;
import java.io.File;
import java.io.FileFilter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MainLogRepositoryBrowserImpl
extends LogRepositoryBaseImpl
implements MainLogRepositoryBrowser {
    private static final String BUNDLE_NAME = "com.ibm.ws.logging.hpel.resources.HpelMessages";
    private static final String className = MainLogRepositoryBrowserImpl.class.getName();
    private static final Logger logger = Logger.getLogger(className, "com.ibm.ws.logging.hpel.resources.HpelMessages");

    public MainLogRepositoryBrowserImpl(File repositoryLocation) {
        super(repositoryLocation);
    }

    @Override
    public LogRepositoryBrowser find(RepositoryPointerImpl location, boolean ignoreTimestamp) {
        String[] instanceIds = location.getInstanceIds();
        if (instanceIds.length == 0) {
            logger.logp(Level.SEVERE, className, "find", "HPEL_NotRepositoryLocation");
            return null;
        }
        String locProcId = ignoreTimestamp ? MainLogRepositoryBrowserImpl.parsePIDandLabel(instanceIds[0]) : instanceIds[0];
        LogRepositoryBrowser result = null;
        File[] files = this.listFiles(this.instanceFilter);
        if (files == null) {
            return null;
        }
        for (File file : files) {
            String curProcId;
            String string = curProcId = ignoreTimestamp ? MainLogRepositoryBrowserImpl.parsePIDandLabel(file.getName()) : file.getName();
            if (!locProcId.equalsIgnoreCase(curProcId)) continue;
            result = new LogRepositoryBrowserImpl(file, new String[]{file.getName()});
            for (int i = 1; i < instanceIds.length && result != null; ++i) {
                Map<String, LogRepositoryBrowser> map = result.getSubProcesses();
                result = map.get(instanceIds[i]);
            }
        }
        return result;
    }

    @Override
    public LogRepositoryBrowser findNext(RepositoryPointerImpl location, long timelimit) {
        String[] instanceIds = location.getInstanceIds();
        if (instanceIds.length == 0) {
            logger.logp(Level.SEVERE, className, "findNext", "HPEL_NotRepositoryLocation");
            return null;
        }
        return this.findNext(MainLogRepositoryBrowserImpl.parseTimeStamp(instanceIds[0]), timelimit);
    }

    @Override
    public LogRepositoryBrowser findByMillis(long timestamp) {
        File[] files = this.listFiles(this.instanceFilter);
        if (files == null) {
            return null;
        }
        File result = null;
        long max = Long.MIN_VALUE;
        for (File file : files) {
            long time = MainLogRepositoryBrowserImpl.parseTimeStamp(file.getName());
            if (max >= time || timestamp >= 0L && time > timestamp) continue;
            max = time;
            result = file;
        }
        if (result == null) {
            return null;
        }
        return new LogRepositoryBrowserImpl(result, new String[]{result.getName()});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LogRepositoryBrowser findNext(LogRepositoryBrowser current, long timelimit) {
        long cur;
        if (current == null) {
            cur = Long.MIN_VALUE;
            return this.findNext(cur, timelimit);
        } else {
            if (!(current instanceof LogRepositoryBrowserImpl)) return null;
            if (((LogRepositoryBrowserImpl)current).getIds().length != 1) return null;
            cur = MainLogRepositoryBrowserImpl.parseTimeStamp(((LogRepositoryBrowserImpl)current).getLocation().getName());
        }
        return this.findNext(cur, timelimit);
    }

    private LogRepositoryBrowser findNext(long cur, long timelimit) {
        File[] files = this.listFiles(this.instanceFilter);
        if (files == null) {
            return null;
        }
        File result = null;
        long min = Long.MAX_VALUE;
        for (File file : files) {
            long time = MainLogRepositoryBrowserImpl.parseTimeStamp(file.getName());
            if (cur >= time || time >= min) continue;
            min = time;
            result = file;
        }
        if (result == null || timelimit > 0L && timelimit < min) {
            return null;
        }
        return new LogRepositoryBrowserImpl(result, new String[]{result.getName()});
    }

    private File[] listFiles(final FileFilter instanceFilter) {
        return AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return MainLogRepositoryBrowserImpl.this.getLocation().listFiles(instanceFilter);
            }
        });
    }
}

